/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.figure;

import java.util.Arrays;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.event.EventHandler;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.utils.LayoutType;

public class Figure
extends GraphicObject
implements AxesContainer {
    private FigureDimensions dimensions;
    private Canvas canvas;
    private FigureName figureName;
    private String infoMessage = "";
    private ColorMap colorMap;
    private RenderingMode renderingMode;
    private int background = 0;
    private EventHandler eventHandler;
    private String resizeFcn = "";
    private String closeRequestFcn = "";
    private RotationType rotation;
    private Boolean resize = true;
    private BarType toolbar;
    private Boolean toolbarVisible = true;
    private BarType menubar;
    private Boolean menubarVisible = true;
    private Boolean infobarVisible = true;
    private Boolean dockable = true;
    private LayoutType layout;
    private Integer[] gridOptGrid = new Integer[]{0, 0};
    private Integer[] gridOptPadding = new Integer[]{0, 0};
    private Integer[] borderOptPadding = new Integer[]{0, 0};
    private Boolean defaultAxes = true;
    private String icon = "";

    public Figure() {
        this.dimensions = new FigureDimensions();
        this.canvas = new Canvas();
        this.figureName = new FigureName();
        this.colorMap = new ColorMap();
        this.renderingMode = new RenderingMode();
        this.eventHandler = new EventHandler();
        this.rotation = RotationType.UNARY;
        this.toolbar = BarType.FIGURE;
        this.menubar = BarType.FIGURE;
        this.layout = LayoutType.NONE;
    }

    @Override
    public Figure clone() {
        Figure figure = null;
        figure = (Figure)super.clone();
        figure.dimensions = new FigureDimensions(this.dimensions);
        figure.canvas = new Canvas(this.canvas);
        figure.figureName = new FigureName(this.figureName);
        figure.colorMap = new ColorMap(this.colorMap);
        figure.renderingMode = new RenderingMode(this.renderingMode);
        figure.eventHandler = new EventHandler(this.eventHandler);
        figure.gridOptGrid = new Integer[]{0, 0};
        figure.gridOptPadding = new Integer[]{0, 0};
        figure.borderOptPadding = new Integer[]{0, 0};
        figure.setValid(true);
        return figure;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 80: {
                return FigureDimensionsProperty.POSITION;
            }
            case 81: {
                return FigureDimensionsProperty.SIZE;
            }
            case 83: {
                return CanvasProperty.AUTORESIZE;
            }
            case 84: {
                return CanvasProperty.VIEWPORT;
            }
            case 85: {
                return CanvasProperty.AXESSIZE;
            }
            case 87: {
                return FigureNameProperty.NAME;
            }
            case 88: {
                return FigureNameProperty.ID;
            }
            case 89: {
                return FigureProperty.INFOMESSAGE;
            }
            case 90: {
                return FigureProperty.COLORMAP;
            }
            case 91: {
                return FigureProperty.COLORMAPSIZE;
            }
            case 93: {
                return RenderingModeProperty.PIXELDRAWINGMODE;
            }
            case 94: {
                return RenderingModeProperty.ANTIALIASING;
            }
            case 95: {
                return RenderingModeProperty.IMMEDIATEDRAWING;
            }
            case 96: {
                return FigureProperty.BACKGROUND;
            }
            case 98: {
                return EventHandlerProperty.EVENTHANDLER;
            }
            case 99: {
                return EventHandlerProperty.EVENTHANDLERENABLE;
            }
            case 101: {
                return FigureProperty.ROTATIONTYPE;
            }
            case 102: {
                return FigureProperty.RESIZEFCN;
            }
            case 103: {
                return FigureProperty.CLOSEREQUESTFCN;
            }
            case 356: {
                return FigureProperty.RESIZE;
            }
            case 357: {
                return FigureProperty.TOOLBAR;
            }
            case 358: {
                return FigureProperty.TOOLBAR_VISIBLE;
            }
            case 359: {
                return FigureProperty.MENUBAR;
            }
            case 360: {
                return FigureProperty.MENUBAR_VISIBLE;
            }
            case 361: {
                return FigureProperty.INFOBAR_VISIBLE;
            }
            case 362: {
                return FigureProperty.DOCKABLE;
            }
            case 363: {
                return FigureProperty.LAYOUT;
            }
            case 364: {
                return FigureProperty.LAYOUT_SET;
            }
            case 376: {
                return FigureProperty.GRIDOPT_GRID;
            }
            case 377: {
                return FigureProperty.GRIDOPT_PADDING;
            }
            case 378: {
                return FigureProperty.BORDEROPT_PADDING;
            }
            case 104: {
                return FigureProperty.DEFAULT_AXES;
            }
            case 322: {
                return FigureProperty.ICON;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == FigureDimensionsProperty.POSITION) {
            return this.getPosition();
        }
        if (object == FigureDimensionsProperty.SIZE) {
            return this.getSize();
        }
        if (object == CanvasProperty.AUTORESIZE) {
            return this.getAutoResize();
        }
        if (object == CanvasProperty.VIEWPORT) {
            return this.getViewport();
        }
        if (object == CanvasProperty.AXESSIZE) {
            return this.getAxesSize();
        }
        if (object == FigureNameProperty.NAME) {
            return this.getName();
        }
        if (object == FigureNameProperty.ID) {
            return this.getId();
        }
        if (object == FigureProperty.INFOMESSAGE) {
            return this.getInfoMessage();
        }
        if (object == FigureProperty.COLORMAP) {
            return this.getColorMap().getData();
        }
        if (object == FigureProperty.COLORMAPSIZE) {
            return this.getColorMap().getSize();
        }
        if (object == RenderingModeProperty.PIXELDRAWINGMODE) {
            return this.getPixelDrawingMode();
        }
        if (object == RenderingModeProperty.ANTIALIASING) {
            return this.getAntialiasing();
        }
        if (object == RenderingModeProperty.IMMEDIATEDRAWING) {
            return this.getImmediateDrawing();
        }
        if (object == FigureProperty.BACKGROUND) {
            return this.getBackground();
        }
        if (object == EventHandlerProperty.EVENTHANDLER) {
            return this.getEventHandlerString();
        }
        if (object == EventHandlerProperty.EVENTHANDLERENABLE) {
            return this.getEventHandlerEnable();
        }
        if (object == FigureProperty.ROTATIONTYPE) {
            return this.getRotation();
        }
        if (object == FigureProperty.RESIZEFCN) {
            return this.getResizeFcn();
        }
        if (object == FigureProperty.CLOSEREQUESTFCN) {
            return this.getCloseRequestFcn();
        }
        if (object == FigureProperty.RESIZE) {
            return this.getResize();
        }
        if (object == FigureProperty.TOOLBAR) {
            return this.getToolbar();
        }
        if (object == FigureProperty.TOOLBAR_VISIBLE) {
            return this.getToolbarVisible();
        }
        if (object == FigureProperty.MENUBAR) {
            return this.getMenubar();
        }
        if (object == FigureProperty.MENUBAR_VISIBLE) {
            return this.getMenubarVisible();
        }
        if (object == FigureProperty.INFOBAR_VISIBLE) {
            return this.getInfobarVisible();
        }
        if (object == FigureProperty.DOCKABLE) {
            return this.getDockable();
        }
        if (object == FigureProperty.LAYOUT) {
            return this.getLayout();
        }
        if (object == FigureProperty.LAYOUT_SET) {
            return this.isLayoutSettable();
        }
        if (object == FigureProperty.GRIDOPT_GRID) {
            return this.getGridOptGrid();
        }
        if (object == FigureProperty.GRIDOPT_PADDING) {
            return this.getGridOptPadding();
        }
        if (object == FigureProperty.BORDEROPT_PADDING) {
            return this.getBorderOptPadding();
        }
        if (object == FigureProperty.DEFAULT_AXES) {
            return this.hasDefaultAxes();
        }
        if (object == FigureProperty.ICON) {
            return this.getIcon();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object instanceof FigureProperty) {
            switch ((FigureProperty)((Object)object)) {
                case BACKGROUND: {
                    return this.setBackground((Integer)object2);
                }
                case CLOSEREQUESTFCN: {
                    return this.setCloseRequestFcn((String)object2);
                }
                case COLORMAP: {
                    return this.getColorMap().setData((Double[])object2);
                }
                case COLORMAPSIZE: {
                    return GraphicObject.UpdateStatus.NoChange;
                }
                case INFOMESSAGE: {
                    return this.setInfoMessage((String)object2);
                }
                case RESIZEFCN: {
                    return this.setResizeFcn((String)object2);
                }
                case ROTATIONTYPE: {
                    return this.setRotation((Integer)object2);
                }
                case RESIZE: {
                    return this.setResize((Boolean)object2);
                }
                case TOOLBAR: {
                    return this.setToolbar((Integer)object2);
                }
                case TOOLBAR_VISIBLE: {
                    return this.setToolbarVisible((Boolean)object2);
                }
                case MENUBAR: {
                    return this.setMenubar((Integer)object2);
                }
                case MENUBAR_VISIBLE: {
                    return this.setMenubarVisible((Boolean)object2);
                }
                case INFOBAR_VISIBLE: {
                    return this.setInfobarVisible((Boolean)object2);
                }
                case DOCKABLE: {
                    return this.setDockable((Boolean)object2);
                }
                case LAYOUT: {
                    return this.setLayout((Integer)object2);
                }
                case GRIDOPT_GRID: {
                    return this.setGridOptGrid((Integer[])object2);
                }
                case GRIDOPT_PADDING: {
                    return this.setGridOptPadding((Integer[])object2);
                }
                case BORDEROPT_PADDING: {
                    return this.setBorderOptPadding((Integer[])object2);
                }
                case DEFAULT_AXES: {
                    return this.setDefaultAxes((Boolean)object2);
                }
                case ICON: {
                    return this.setIcon((String)object2);
                }
            }
        } else if (object instanceof CanvasProperty) {
            switch ((CanvasProperty)((Object)object)) {
                case AUTORESIZE: {
                    return this.setAutoResize((Boolean)object2);
                }
                case AXESSIZE: {
                    return this.setAxesSize((Integer[])object2);
                }
                case VIEWPORT: {
                    return this.setViewport((Integer[])object2);
                }
            }
        } else if (object instanceof FigureDimensionsProperty) {
            switch ((FigureDimensionsProperty)((Object)object)) {
                case POSITION: {
                    return this.setPosition((Integer[])object2);
                }
                case SIZE: {
                    return this.setSize((Integer[])object2);
                }
            }
        } else if (object instanceof FigureNameProperty) {
            switch ((FigureNameProperty)((Object)object)) {
                case ID: {
                    return this.setId((Integer)object2);
                }
                case NAME: {
                    return this.setName((String)object2);
                }
            }
        } else if (object instanceof RenderingModeProperty) {
            switch ((RenderingModeProperty)((Object)object)) {
                case ANTIALIASING: {
                    return this.setAntialiasing((Integer)object2);
                }
                case IMMEDIATEDRAWING: {
                    return this.setImmediateDrawing((Boolean)object2);
                }
                case PIXELDRAWINGMODE: {
                    return this.setPixelDrawingMode((Integer)object2);
                }
            }
        } else if (object instanceof EventHandlerProperty) {
            switch ((EventHandlerProperty)((Object)object)) {
                case EVENTHANDLER: {
                    return this.setEventHandlerString((String)object2);
                }
                case EVENTHANDLERENABLE: {
                    return this.setEventHandlerEnable((Boolean)object2);
                }
            }
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getBackground() {
        return this.background;
    }

    public GraphicObject.UpdateStatus setBackground(Integer n) {
        if (this.background == n) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.background = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GraphicObject.UpdateStatus setCanvas(Canvas canvas) {
        this.canvas = canvas;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getAutoResize() {
        return this.canvas.autoResize;
    }

    public GraphicObject.UpdateStatus setAutoResize(Boolean bl) {
        if (this.canvas.autoResize == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.canvas.autoResize = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getViewport() {
        Integer[] integerArray = new Integer[]{this.canvas.viewport[0], this.canvas.viewport[1]};
        return integerArray;
    }

    public GraphicObject.UpdateStatus setViewport(Integer[] integerArray) {
        if (Arrays.equals((Object[])this.canvas.viewport, (Object[])integerArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        ((Canvas)this.canvas).viewport[0] = integerArray[0];
        ((Canvas)this.canvas).viewport[1] = integerArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer[] getAxesSize() {
        Integer[] integerArray = new Integer[]{this.canvas.axesSize[0], this.canvas.axesSize[1]};
        return integerArray;
    }

    public GraphicObject.UpdateStatus setAxesSize(Integer[] integerArray) {
        if (Arrays.equals((Object[])this.canvas.axesSize, (Object[])integerArray)) {
            return GraphicObject.UpdateStatus.Success;
        }
        ((Canvas)this.canvas).axesSize[0] = integerArray[0];
        ((Canvas)this.canvas).axesSize[1] = integerArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public FigureDimensions getDimensions() {
        return this.dimensions;
    }

    public GraphicObject.UpdateStatus setDimensions(FigureDimensions figureDimensions) {
        if (this.dimensions == figureDimensions) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.dimensions = figureDimensions;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getPosition() {
        Integer[] integerArray = new Integer[]{this.dimensions.position[0], this.dimensions.position[1]};
        return integerArray;
    }

    public GraphicObject.UpdateStatus setPosition(Integer[] integerArray) {
        if (Arrays.equals((Object[])this.dimensions.position, (Object[])integerArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        ((FigureDimensions)this.dimensions).position[0] = integerArray[0];
        ((FigureDimensions)this.dimensions).position[1] = integerArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getSize() {
        Integer[] integerArray = new Integer[]{this.dimensions.size[0], this.dimensions.size[1]};
        return integerArray;
    }

    public GraphicObject.UpdateStatus setSize(Integer[] integerArray) {
        if (Arrays.equals((Object[])this.dimensions.size, (Object[])integerArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        ((FigureDimensions)this.dimensions).size[0] = integerArray[0];
        ((FigureDimensions)this.dimensions).size[1] = integerArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public GraphicObject.UpdateStatus setEventHandler(EventHandler eventHandler) {
        if (this.eventHandler.equals(eventHandler)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.eventHandler = eventHandler;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getEventHandlerString() {
        return this.eventHandler.getEventHandlerString();
    }

    public GraphicObject.UpdateStatus setEventHandlerString(String string) {
        if (this.eventHandler.getEventHandlerString().equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.eventHandler.setEventHandlerString(string);
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getEventHandlerEnable() {
        return this.eventHandler.getEventHandlerEnabled();
    }

    public GraphicObject.UpdateStatus setEventHandlerEnable(Boolean bl) {
        if (this.eventHandler.getEventHandlerEnabled() == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.eventHandler.setEventHandlerEnabled(bl);
        return GraphicObject.UpdateStatus.Success;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public GraphicObject.UpdateStatus setInfoMessage(String string) {
        if (this.infoMessage != null && this.infoMessage.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.infoMessage = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public FigureName getFigureName() {
        return this.figureName;
    }

    public GraphicObject.UpdateStatus setFigureName(FigureName figureName) {
        if (this.figureName.equals(figureName)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.figureName = figureName;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getName() {
        return this.figureName.name;
    }

    public GraphicObject.UpdateStatus setName(String string) {
        if (this.figureName.name.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.figureName.name = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getId() {
        return this.figureName.id;
    }

    public GraphicObject.UpdateStatus setId(Integer n) {
        this.figureName.id = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public GraphicObject.UpdateStatus setRenderingMode(RenderingMode renderingMode) {
        if (this.renderingMode.equals(renderingMode)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.renderingMode = renderingMode;
        return GraphicObject.UpdateStatus.Success;
    }

    public PixelDrawingMode getPixelDrawingModeAsEnum() {
        return this.renderingMode.pixelDrawingMode;
    }

    public Integer getPixelDrawingMode() {
        return this.getPixelDrawingModeAsEnum().ordinal();
    }

    public GraphicObject.UpdateStatus setPixelDrawingMode(PixelDrawingMode pixelDrawingMode) {
        if (this.renderingMode.pixelDrawingMode.equals((Object)pixelDrawingMode)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.renderingMode.pixelDrawingMode = pixelDrawingMode;
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setPixelDrawingMode(Integer n) {
        PixelDrawingMode pixelDrawingMode = PixelDrawingMode.intToEnum(n);
        if (this.renderingMode.pixelDrawingMode == pixelDrawingMode) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.renderingMode.pixelDrawingMode = pixelDrawingMode;
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getAntialiasing() {
        return this.renderingMode.antialiasing;
    }

    public GraphicObject.UpdateStatus setAntialiasing(Integer n) {
        if (this.renderingMode.antialiasing == n) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.renderingMode.antialiasing = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getImmediateDrawing() {
        return this.renderingMode.immediateDrawing;
    }

    public GraphicObject.UpdateStatus setImmediateDrawing(Boolean bl) {
        if (this.renderingMode.immediateDrawing == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.renderingMode.immediateDrawing = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public RotationType getRotationAsEnum() {
        return this.rotation;
    }

    public Integer getRotation() {
        return this.getRotationAsEnum().ordinal();
    }

    public GraphicObject.UpdateStatus setRotation(RotationType rotationType) {
        if (this.rotation.equals((Object)rotationType)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.rotation = rotationType;
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setRotation(Integer n) {
        RotationType rotationType = RotationType.intToEnum(n);
        if (rotationType == null || this.rotation == rotationType) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.rotation = rotationType;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getResizeFcn() {
        return this.resizeFcn;
    }

    public GraphicObject.UpdateStatus setResizeFcn(String string) {
        if (this.resizeFcn.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.resizeFcn = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getCloseRequestFcn() {
        return this.closeRequestFcn;
    }

    public GraphicObject.UpdateStatus setCloseRequestFcn(String string) {
        if (this.closeRequestFcn.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.closeRequestFcn = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getResize() {
        return this.resize;
    }

    public GraphicObject.UpdateStatus setResize(Boolean bl) {
        if (bl.equals(this.resize)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.resize = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getToolbarVisible() {
        return this.toolbarVisible;
    }

    public GraphicObject.UpdateStatus setToolbarVisible(Boolean bl) {
        if (bl.equals(this.toolbarVisible)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.toolbarVisible = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getToolbar() {
        return this.toolbar.ordinal();
    }

    public BarType getToolbarAsEnum() {
        return this.toolbar;
    }

    public GraphicObject.UpdateStatus setToolbar(Integer n) {
        return this.setToolbar(BarType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setToolbar(BarType barType) {
        if (barType == this.toolbar) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.toolbar = barType;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getMenubarVisible() {
        return this.menubarVisible;
    }

    public GraphicObject.UpdateStatus setMenubarVisible(Boolean bl) {
        if (bl.equals(this.menubarVisible)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.menubarVisible = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getMenubar() {
        return this.menubar.ordinal();
    }

    public BarType getMenubarAsEnum() {
        return this.menubar;
    }

    public GraphicObject.UpdateStatus setMenubar(Integer n) {
        return this.setMenubar(BarType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setMenubar(BarType barType) {
        if (barType == this.menubar) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.menubar = barType;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getInfobarVisible() {
        return this.infobarVisible;
    }

    public GraphicObject.UpdateStatus setInfobarVisible(Boolean bl) {
        if (bl.equals(this.infobarVisible)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.infobarVisible = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getDockable() {
        return this.dockable;
    }

    public GraphicObject.UpdateStatus setDockable(Boolean bl) {
        if (bl.equals(this.dockable)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.dockable = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getLayout() {
        return this.layout.ordinal();
    }

    public LayoutType getLayoutAsEnum() {
        return this.layout;
    }

    public boolean isLayoutSettable() {
        return this.layout == LayoutType.NONE;
    }

    public GraphicObject.UpdateStatus setLayout(Integer n) {
        return this.setLayout(LayoutType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setLayout(LayoutType layoutType) {
        if (this.layout == LayoutType.NONE) {
            if (layoutType == LayoutType.NONE) {
                return GraphicObject.UpdateStatus.NoChange;
            }
            this.layout = layoutType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.Fail;
    }

    public Integer[] getBorderOptPadding() {
        return this.borderOptPadding;
    }

    public GraphicObject.UpdateStatus setBorderOptPadding(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.borderOptPadding.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.borderOptPadding[i] == integerArray[i]) continue;
            this.borderOptPadding[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getGridOptPadding() {
        return this.gridOptPadding;
    }

    public GraphicObject.UpdateStatus setGridOptPadding(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridOptPadding.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.gridOptPadding[i] == integerArray[i]) continue;
            this.gridOptPadding[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getGridOptGrid() {
        return this.gridOptGrid;
    }

    public GraphicObject.UpdateStatus setGridOptGrid(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridOptGrid.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.gridOptGrid[i] == integerArray[i]) continue;
            this.gridOptGrid[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Boolean hasDefaultAxes() {
        return this.defaultAxes;
    }

    public GraphicObject.UpdateStatus setDefaultAxes(Boolean bl) {
        if (bl.equals(this.defaultAxes)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.defaultAxes = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getIcon() {
        return this.icon;
    }

    public GraphicObject.UpdateStatus setIcon(String string) {
        if (this.icon.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.icon = string;
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 8;
    }

    public static enum EventHandlerProperty {
        EVENTHANDLER,
        EVENTHANDLERENABLE;

    }

    private class RenderingMode {
        private PixelDrawingMode pixelDrawingMode;
        private int antialiasing;
        private boolean immediateDrawing;

        public RenderingMode() {
            this.pixelDrawingMode = PixelDrawingMode.COPY;
            this.antialiasing = 0;
            this.immediateDrawing = true;
        }

        public RenderingMode(RenderingMode renderingMode) {
            this.pixelDrawingMode = renderingMode.pixelDrawingMode;
            this.antialiasing = renderingMode.antialiasing;
            this.immediateDrawing = renderingMode.immediateDrawing;
        }
    }

    public static enum RenderingModeProperty {
        PIXELDRAWINGMODE,
        ANTIALIASING,
        IMMEDIATEDRAWING;

    }

    public class FigureName
    implements Cloneable {
        private String name;
        private int id;

        public FigureName clone() throws CloneNotSupportedException {
            FigureName figureName = (FigureName)super.clone();
            figureName.name = new String(this.name);
            figureName.id = this.id;
            return figureName;
        }

        public FigureName() {
            this.name = "";
            this.id = 0;
        }

        public FigureName(FigureName figureName) {
            this.name = new String(figureName.name);
            this.id = figureName.id;
        }
    }

    public static enum FigureNameProperty {
        NAME,
        ID;

    }

    private class Canvas {
        private boolean autoResize;
        private Integer[] viewport;
        private Integer[] axesSize;

        public Canvas() {
            this.autoResize = false;
            this.viewport = new Integer[2];
            this.axesSize = new Integer[2];
        }

        public Canvas(Canvas canvas) {
            this.autoResize = canvas.autoResize;
            this.viewport = new Integer[2];
            this.viewport[0] = canvas.viewport[0];
            this.viewport[1] = canvas.viewport[1];
            this.axesSize = new Integer[2];
            this.axesSize[0] = canvas.axesSize[0];
            this.axesSize[1] = canvas.axesSize[1];
        }
    }

    public static enum CanvasProperty {
        AUTORESIZE,
        VIEWPORT,
        AXESSIZE;

    }

    private class FigureDimensions {
        private Integer[] position;
        private Integer[] size;

        public FigureDimensions() {
            this.position = new Integer[]{0, 0};
            this.size = new Integer[]{0, 0};
        }

        public FigureDimensions(FigureDimensions figureDimensions) {
            this.position = new Integer[2];
            this.position[0] = figureDimensions.position[0];
            this.position[1] = figureDimensions.position[1];
            this.size = new Integer[2];
            this.size[0] = figureDimensions.size[0];
            this.size[1] = figureDimensions.size[1];
        }
    }

    public static enum FigureDimensionsProperty {
        POSITION,
        SIZE;

    }

    public static enum PixelDrawingMode {
        CLEAR,
        AND,
        ANDREVERSE,
        COPY,
        ANDINVERTED,
        NOOP,
        XOR,
        OR,
        NOR,
        EQUIV,
        INVERT,
        ORREVERSE,
        COPYINVERTED,
        ORINVERTED,
        NAND,
        SET;


        public static PixelDrawingMode intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return CLEAR;
                }
                case 1: {
                    return AND;
                }
                case 2: {
                    return ANDREVERSE;
                }
                case 3: {
                    return COPY;
                }
                case 4: {
                    return ANDINVERTED;
                }
                case 5: {
                    return NOOP;
                }
                case 6: {
                    return XOR;
                }
                case 7: {
                    return OR;
                }
                case 8: {
                    return NOR;
                }
                case 9: {
                    return EQUIV;
                }
                case 10: {
                    return INVERT;
                }
                case 11: {
                    return ORREVERSE;
                }
                case 12: {
                    return COPYINVERTED;
                }
                case 13: {
                    return ORINVERTED;
                }
                case 14: {
                    return NAND;
                }
                case 15: {
                    return SET;
                }
            }
            return null;
        }
    }

    public static enum BarType {
        NONE,
        FIGURE;


        public static BarType intToEnum(Integer n) {
            switch (n) {
                default: {
                    return NONE;
                }
                case 1: 
            }
            return FIGURE;
        }

        public static BarType stringToEnum(String string) {
            if (string.equals("figure")) {
                return FIGURE;
            }
            return NONE;
        }

        public static String enumToString(BarType barType) {
            switch (barType) {
                case FIGURE: {
                    return "figure";
                }
            }
            return "none";
        }
    }

    public static enum RotationType {
        UNARY,
        MULTIPLE;


        public static RotationType intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return UNARY;
                }
                case 1: {
                    return MULTIPLE;
                }
            }
            return null;
        }

        public static RotationType stringToEnum(String string) {
            if (string.equals("multiple")) {
                return MULTIPLE;
            }
            return UNARY;
        }

        public static String enumToString(RotationType rotationType) {
            switch (rotationType) {
                case MULTIPLE: {
                    return "multiple";
                }
            }
            return "unary";
        }
    }

    private static enum FigureProperty {
        INFOMESSAGE,
        COLORMAP,
        COLORMAPSIZE,
        BACKGROUND,
        ROTATIONTYPE,
        RESIZEFCN,
        CLOSEREQUESTFCN,
        RESIZE,
        TOOLBAR,
        TOOLBAR_VISIBLE,
        MENUBAR,
        MENUBAR_VISIBLE,
        INFOBAR_VISIBLE,
        DOCKABLE,
        LAYOUT,
        LAYOUT_SET,
        GRIDOPT_GRID,
        GRIDOPT_PADDING,
        BORDEROPT_PADDING,
        DEFAULT_AXES,
        ICON;

    }
}

