/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.figure;

import java.util.Arrays;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public class ColorMap {
    private static final int CHANNELS_NUMBER = 3;
    private static final float[] BLACK_COLOR = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] WHITE_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final float[] LIGHT_GRAY_COLOR = new float[]{0.7f, 0.7f, 0.7f};
    Double[] data = new Double[0];

    public ColorMap() {
    }

    public ColorMap(ColorMap colorMap) {
        this.setData(colorMap.data);
    }

    public Double[] getData() {
        return (Double[])this.data.clone();
    }

    public int getSize() {
        return this.data.length / 3;
    }

    public float[] getScilabColor(int n) {
        int n2 = this.getSize();
        if (n == 0) {
            n = -1;
        }
        if (n > n2) {
            n = n2 - n;
        }
        if (n == -3) {
            return LIGHT_GRAY_COLOR;
        }
        if (n == -1 || n < -2) {
            return BLACK_COLOR;
        }
        if (n == -2) {
            return WHITE_COLOR;
        }
        return new float[]{Math.min(1.0f, this.data[--n].floatValue()), Math.min(1.0f, this.data[n + this.getSize()].floatValue()), Math.min(1.0f, this.data[n + this.getSize() * 2].floatValue())};
    }

    GraphicObject.UpdateStatus setData(Double[] doubleArray) {
        if (Arrays.equals((Object[])doubleArray, (Object[])this.data)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        int n = doubleArray.length;
        n -= n % 3;
        this.data = new Double[n];
        System.arraycopy(doubleArray, 0, this.data, 0, n);
        return GraphicObject.UpdateStatus.Success;
    }
}

