/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.datatip;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.ClippableProperty;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.localization.Messages;

public class Datatip
extends Text {
    Boolean tipBoxMode;
    Boolean tipLabelMode;
    String displayComponents = "xy";
    Boolean interpMode;
    DecimalFormat tipTextFormat;
    String displayFnc;
    Boolean autoOrientation = true;
    Integer dataIndex;
    Double ratio;
    TipOrientation currentOrientation;
    Boolean detachedMode;
    Double[] detachedPosition;

    public Datatip() {
        this.setOrientationAsEnum(TipOrientation.TOP_RIGHT);
        this.tipTextFormat = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.US));
        this.detachedMode = false;
        this.detachedPosition = new Double[]{0.0, 0.0, 0.0};
        this.tipBoxMode = true;
        this.tipLabelMode = true;
        this.interpMode = true;
        this.displayFnc = "";
        this.ratio = 0.0;
        this.dataIndex = Integer.MIN_VALUE;
        this.setVisible(true);
        this.setBox(true);
        this.setLineMode(true);
        this.setLineStyle(3);
        this.setFillMode(true);
        this.setBackground(-2);
        this.setClipStateAsEnum(ClippableProperty.ClipStateType.OFF);
        this.setMarkMode(true);
        this.setMarkSize(8);
        this.setMarkBackground(-1);
        this.setMarkForeground(-1);
        this.setMarkStyle(11);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 332: {
                return DatatipObjectProperty.TIP_DATA;
            }
            case 338: {
                return DatatipObjectProperty.TIP_BOX_MODE;
            }
            case 339: {
                return DatatipObjectProperty.TIP_LABEL_MODE;
            }
            case 333: {
                return DatatipObjectProperty.TIP_ORIENTATION;
            }
            case 334: {
                return DatatipObjectProperty.TIP_DISPLAY_COMPONENTS;
            }
            case 335: {
                return DatatipObjectProperty.TIP_AUTOORIENTATION;
            }
            case 336: {
                return DatatipObjectProperty.TIP_INTERP_MODE;
            }
            case 337: {
                return DatatipObjectProperty.TIP_DISPLAY_FNC;
            }
            case 352: {
                return DatatipObjectProperty.TIP_INDEXES;
            }
            case 341: {
                return DatatipObjectProperty.TIP_DETACHED_MODE;
            }
            case 342: {
                return DatatipObjectProperty.TIP_DETACHED_POSITION;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object instanceof DatatipObjectProperty) {
            switch ((DatatipObjectProperty)((Object)object)) {
                case TIP_DATA: {
                    return this.getTipData();
                }
                case TIP_BOX_MODE: {
                    return this.getTipBoxMode();
                }
                case TIP_LABEL_MODE: {
                    return this.getTipLabelMode();
                }
                case TIP_ORIENTATION: {
                    return this.getOrientation();
                }
                case TIP_DISPLAY_COMPONENTS: {
                    return this.getDisplayComponents();
                }
                case TIP_AUTOORIENTATION: {
                    return this.isAutoOrientationEnabled();
                }
                case TIP_INTERP_MODE: {
                    return this.getInterpMode();
                }
                case TIP_DISPLAY_FNC: {
                    return this.getDisplayFunction();
                }
                case TIP_INDEXES: {
                    return this.getIndexes();
                }
                case TIP_DETACHED_MODE: {
                    return this.getDetachedMode();
                }
                case TIP_DETACHED_POSITION: {
                    return this.getDetachedPosition();
                }
            }
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object instanceof DatatipObjectProperty) {
            switch ((DatatipObjectProperty)((Object)object)) {
                case TIP_BOX_MODE: {
                    return this.setTipBoxMode((Boolean)object2);
                }
                case TIP_LABEL_MODE: {
                    return this.setTipLabelMode((Boolean)object2);
                }
                case TIP_ORIENTATION: {
                    return this.setOrientation((Integer)object2);
                }
                case TIP_DISPLAY_COMPONENTS: {
                    return this.setDisplayComponents((String)object2);
                }
                case TIP_AUTOORIENTATION: {
                    return this.setAutoOrientation((Boolean)object2);
                }
                case TIP_INTERP_MODE: {
                    return this.setInterpMode((Boolean)object2);
                }
                case TIP_DISPLAY_FNC: {
                    return this.setDisplayFunction((String)object2);
                }
                case TIP_INDEXES: {
                    return this.setIndexes((Double[])object2);
                }
                case TIP_DETACHED_MODE: {
                    return this.setDetachedMode((Boolean)object2);
                }
                case TIP_DETACHED_POSITION: {
                    return this.setDetachedPosition((Double[])object2);
                }
            }
        }
        return super.setProperty(object, object2);
    }

    private double calcTipData(double[] dArray) {
        if (dArray.length < this.dataIndex + 2) {
            if (dArray.length >= 1) {
                return dArray[dArray.length - 1];
            }
            return 0.0;
        }
        double d = dArray[this.dataIndex];
        double d2 = dArray[this.dataIndex + 1];
        return d + (d2 - d) * this.ratio;
    }

    public double getTipDataX() {
        double[] dArray = (double[])PolylineData.getDataX(this.getParent());
        return this.calcTipData(dArray);
    }

    public double getTipDataY() {
        double[] dArray = (double[])PolylineData.getDataY(this.getParent());
        return this.calcTipData(dArray);
    }

    public double getTipDataZ() {
        double[] dArray = (double[])PolylineData.getDataZ(this.getParent());
        return this.calcTipData(dArray);
    }

    public Double[] getTipData() {
        return new Double[]{this.getTipDataX(), this.getTipDataY(), this.getTipDataZ()};
    }

    public Integer getOrientation() {
        return this.getOrientationAsEnum().ordinal();
    }

    public TipOrientation getOrientationAsEnum() {
        return this.currentOrientation;
    }

    public GraphicObject.UpdateStatus setOrientation(Integer n) {
        this.currentOrientation = TipOrientation.intToEnum(n);
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setOrientationAsEnum(TipOrientation tipOrientation) {
        this.currentOrientation = tipOrientation;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getDisplayComponents() {
        return this.displayComponents;
    }

    private boolean isValidComponent(String string) {
        if (string.length() < 1 || string.length() > 3) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == 'x' && !bl) {
                bl = true;
                continue;
            }
            if (string.charAt(i) == 'y' && !bl2) {
                bl2 = true;
                continue;
            }
            if (string.charAt(i) == 'z' && !bl3) {
                bl3 = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public GraphicObject.UpdateStatus setDisplayComponents(String string) {
        if (string == null) {
            return GraphicObject.UpdateStatus.Fail;
        }
        if (!this.isValidComponent(string = string.toLowerCase())) {
            return GraphicObject.UpdateStatus.Fail;
        }
        this.displayComponents = string;
        this.updateText();
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean isAutoOrientationEnabled() {
        return this.autoOrientation;
    }

    public GraphicObject.UpdateStatus setAutoOrientation(Boolean bl) {
        this.autoOrientation = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    private String getComponentFormatedText(int n) {
        switch (this.displayComponents.charAt(n)) {
            case 'x': {
                return "X:" + this.tipTextFormat.format(this.getTipDataX());
            }
            case 'y': {
                return "Y:" + this.tipTextFormat.format(this.getTipDataY());
            }
            case 'z': {
                return "Z:" + this.tipTextFormat.format(this.getTipDataZ());
            }
        }
        return "";
    }

    public void updateText() {
        String string = this.getDisplayFunction();
        if ((string == null || string.equals("")) && ((string = (String)GraphicController.getController().getProperty(this.getParent(), 337)) == null || string.equals(""))) {
            int n = this.displayComponents.length();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.getComponentFormatedText(i);
            }
            Integer[] integerArray = new Integer[]{n, 1};
            this.setTextArrayDimensions(integerArray);
            this.setTextStrings(stringArray);
            return;
        }
        String string2 = Messages.gettext((String)"Wrong value for '%s' property: A valid function name expected.\n");
        string2 = string2.replace("'", "''");
        string2 = string2.replace("\n", "\\n");
        String string3 = "try;GDZa786XBSq7899SHKp=getcallbackobject(" + this.getIdentifier() + ");" + "set(GDZa786XBSq7899SHKp,\"text\"," + string + "(GDZa786XBSq7899SHKp));" + "clear(\"GDZa786XBSq7899SHKp\");" + "catch;" + "set(GDZa786XBSq7899SHKp,\"display_function\",\"\");" + "set(GDZa786XBSq7899SHKp.parent,\"display_function\",\"\");" + "clear(\"GDZa786XBSq7899SHKp\");" + "error(msprintf(\"" + string2 + "\", \"display_function\"));" + "end;";
        InterpreterManagement.requestScilabExec((String)string3);
    }

    public Boolean getTipBoxMode() {
        return this.tipBoxMode;
    }

    public Boolean getTipLabelMode() {
        return this.tipLabelMode;
    }

    public Boolean getInterpMode() {
        return this.interpMode;
    }

    public String getDisplayFunction() {
        return this.displayFnc;
    }

    public GraphicObject.UpdateStatus setTipBoxMode(Boolean bl) {
        this.tipBoxMode = bl;
        this.setBox(this.tipBoxMode);
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setTipLabelMode(Boolean bl) {
        this.tipLabelMode = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setInterpMode(Boolean bl) {
        this.interpMode = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setDisplayFunction(String string) {
        this.displayFnc = string;
        this.updateText();
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Double[] getPosition() {
        return this.getTipData();
    }

    public GraphicObject.UpdateStatus setIndexes(Double[] doubleArray) {
        if (doubleArray[0].intValue() != this.dataIndex.intValue() || !doubleArray[1].equals(this.ratio)) {
            this.dataIndex = doubleArray[0].intValue();
            this.ratio = new Double(doubleArray[1]);
            this.updateText();
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getIndexes() {
        return this.dataIndex;
    }

    public Boolean getDetachedMode() {
        return this.detachedMode;
    }

    public GraphicObject.UpdateStatus setDetachedMode(Boolean bl) {
        this.detachedMode = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getDetachedPosition() {
        return this.detachedPosition;
    }

    public GraphicObject.UpdateStatus setDetachedPosition(Double[] doubleArray) {
        if (doubleArray.length != 3) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < 3; ++i) {
            this.detachedPosition[i] = doubleArray[i];
        }
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 331;
    }

    static enum TipOrientation {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;


        public static TipOrientation intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return TOP_LEFT;
                }
                case 1: {
                    return TOP_RIGHT;
                }
                case 2: {
                    return BOTTOM_LEFT;
                }
                case 3: {
                    return BOTTOM_RIGHT;
                }
                case 4: {
                    return LEFT;
                }
                case 5: {
                    return RIGHT;
                }
                case 6: {
                    return TOP;
                }
                case 7: {
                    return BOTTOM;
                }
            }
            return TOP_RIGHT;
        }
    }

    static enum DatatipObjectProperty {
        TIP_DATA,
        TIP_BOX_MODE,
        TIP_LABEL_MODE,
        TIP_ORIENTATION,
        TIP_AUTOORIENTATION,
        TIP_DISPLAY_COMPONENTS,
        TIP_INTERP_MODE,
        TIP_DISPLAY_FNC,
        TIP_INDEXES,
        TIP_DETACHED_MODE,
        TIP_DETACHED_POSITION;

    }
}

