/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.contouredObject;

import org.scilab.modules.graphic_objects.contouredObject.Line;
import org.scilab.modules.graphic_objects.contouredObject.Mark;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public abstract class ContouredObject
extends GraphicObject {
    private Line line;
    private boolean fillMode = false;
    private int background = 0;
    private Mark mark;
    private int offset = 0;
    private int stride = 1;
    private boolean selected = false;
    private final Integer selectedColor = new Integer(-3);
    private Integer[] mark_sizes;
    private Integer[] mark_foregrounds;
    private Integer[] mark_backgrounds;

    public ContouredObject() {
        this.line = new Line();
        this.mark = new Mark();
        this.mark_sizes = new Integer[0];
        this.mark_foregrounds = new Integer[0];
        this.mark_backgrounds = new Integer[0];
    }

    @Override
    public ContouredObject clone() {
        ContouredObject contouredObject = (ContouredObject)super.clone();
        contouredObject.line = new Line(this.line);
        contouredObject.mark = new Mark(this.mark);
        contouredObject.mark_sizes = this.mark_sizes;
        contouredObject.mark_foregrounds = this.mark_foregrounds;
        contouredObject.mark_backgrounds = this.mark_backgrounds;
        return contouredObject;
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 188: {
                return ContouredObjectPropertyType.LINE;
            }
            case 189: {
                return Line.LinePropertyType.MODE;
            }
            case 190: {
                return Line.LinePropertyType.LINESTYLE;
            }
            case 191: {
                return Line.LinePropertyType.THICKNESS;
            }
            case 192: {
                return Line.LinePropertyType.COLOR;
            }
            case 193: {
                return ContouredObjectPropertyType.FILLMODE;
            }
            case 96: {
                return ContouredObjectPropertyType.BACKGROUND;
            }
            case 194: {
                return ContouredObjectPropertyType.MARK;
            }
            case 195: {
                return Mark.MarkPropertyType.MODE;
            }
            case 196: {
                return Mark.MarkPropertyType.STYLE;
            }
            case 197: {
                return Mark.MarkPropertyType.SIZEUNIT;
            }
            case 198: {
                return Mark.MarkPropertyType.SIZE;
            }
            case 398: {
                return ContouredObjectPropertyType.MARK_SIZES;
            }
            case 399: {
                return ContouredObjectPropertyType.NUM_MARK_SIZES;
            }
            case 199: {
                return Mark.MarkPropertyType.FOREGROUND;
            }
            case 400: {
                return ContouredObjectPropertyType.MARK_FOREGROUNDS;
            }
            case 401: {
                return ContouredObjectPropertyType.NUM_MARK_FOREGROUNDS;
            }
            case 200: {
                return Mark.MarkPropertyType.BACKGROUND;
            }
            case 402: {
                return ContouredObjectPropertyType.MARK_BACKGROUNDS;
            }
            case 403: {
                return ContouredObjectPropertyType.NUM_MARK_BACKGROUNDS;
            }
            case 201: {
                return ContouredObjectPropertyType.MARK_OFFSET;
            }
            case 202: {
                return ContouredObjectPropertyType.MARK_STRIDE;
            }
            case 203: {
                return ContouredObjectPropertyType.SELECTED;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == ContouredObjectPropertyType.LINE) {
            return this.getLine();
        }
        if (object == Line.LinePropertyType.MODE) {
            return this.getLineMode();
        }
        if (object == Line.LinePropertyType.LINESTYLE) {
            return this.getLineStyle();
        }
        if (object == Line.LinePropertyType.THICKNESS) {
            return this.getLineThickness();
        }
        if (object == Line.LinePropertyType.COLOR) {
            return this.getLineColor();
        }
        if (object == ContouredObjectPropertyType.FILLMODE) {
            return this.getFillMode();
        }
        if (object == ContouredObjectPropertyType.BACKGROUND) {
            return this.getBackground();
        }
        if (object == ContouredObjectPropertyType.MARK) {
            return this.getMark();
        }
        if (object == Mark.MarkPropertyType.MODE) {
            return this.getMarkMode();
        }
        if (object == Mark.MarkPropertyType.STYLE) {
            return this.getMarkStyle();
        }
        if (object == Mark.MarkPropertyType.SIZEUNIT) {
            return this.getMarkSizeUnit();
        }
        if (object == Mark.MarkPropertyType.SIZE) {
            return this.getMarkSize();
        }
        if (object == ContouredObjectPropertyType.MARK_SIZES) {
            return this.getMarkSizes();
        }
        if (object == ContouredObjectPropertyType.NUM_MARK_SIZES) {
            return this.getNumMarkSizes();
        }
        if (object == Mark.MarkPropertyType.FOREGROUND) {
            return this.getMarkForeground();
        }
        if (object == ContouredObjectPropertyType.MARK_FOREGROUNDS) {
            return this.getMarkForegrounds();
        }
        if (object == ContouredObjectPropertyType.NUM_MARK_FOREGROUNDS) {
            return this.getNumMarkForegrounds();
        }
        if (object == Mark.MarkPropertyType.BACKGROUND) {
            return this.getMarkBackground();
        }
        if (object == ContouredObjectPropertyType.MARK_BACKGROUNDS) {
            return this.getMarkBackgrounds();
        }
        if (object == ContouredObjectPropertyType.NUM_MARK_BACKGROUNDS) {
            return this.getNumMarkBackgrounds();
        }
        if (object == ContouredObjectPropertyType.MARK_OFFSET) {
            return this.getMarkOffset();
        }
        if (object == ContouredObjectPropertyType.MARK_STRIDE) {
            return this.getMarkStride();
        }
        if (object == ContouredObjectPropertyType.SELECTED) {
            return this.getSelected();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == ContouredObjectPropertyType.LINE) {
            this.setLine((Line)object2);
        } else {
            if (object == Line.LinePropertyType.MODE) {
                return this.setLineMode((Boolean)object2);
            }
            if (object == Line.LinePropertyType.LINESTYLE) {
                this.setLineStyle((Integer)object2);
            } else if (object == Line.LinePropertyType.THICKNESS) {
                this.setLineThickness((Double)object2);
            } else {
                if (object == Line.LinePropertyType.COLOR) {
                    return this.setLineColor((Integer)object2);
                }
                if (object == ContouredObjectPropertyType.FILLMODE) {
                    return this.setFillMode((Boolean)object2);
                }
                if (object == ContouredObjectPropertyType.BACKGROUND) {
                    this.setBackground((Integer)object2);
                } else if (object == ContouredObjectPropertyType.MARK) {
                    this.setMark((Mark)object2);
                } else {
                    if (object == Mark.MarkPropertyType.MODE) {
                        return this.setMarkMode((Boolean)object2);
                    }
                    if (object == Mark.MarkPropertyType.STYLE) {
                        return this.setMarkStyle((Integer)object2);
                    }
                    if (object == Mark.MarkPropertyType.SIZEUNIT) {
                        this.setMarkSizeUnit((Integer)object2);
                    } else {
                        if (object == Mark.MarkPropertyType.SIZE) {
                            return this.setMarkSize((Integer)object2);
                        }
                        if (object == ContouredObjectPropertyType.MARK_SIZES) {
                            return this.setMarkSizes((Integer[])object2);
                        }
                        if (object == Mark.MarkPropertyType.FOREGROUND) {
                            this.setMarkForeground((Integer)object2);
                        } else {
                            if (object == ContouredObjectPropertyType.MARK_FOREGROUNDS) {
                                return this.setMarkForegrounds((Integer[])object2);
                            }
                            if (object == Mark.MarkPropertyType.BACKGROUND) {
                                this.setMarkBackground((Integer)object2);
                            } else {
                                if (object == ContouredObjectPropertyType.MARK_BACKGROUNDS) {
                                    return this.setMarkBackgrounds((Integer[])object2);
                                }
                                if (object == ContouredObjectPropertyType.MARK_OFFSET) {
                                    this.setMarkOffset((Integer)object2);
                                } else if (object == ContouredObjectPropertyType.MARK_STRIDE) {
                                    this.setMarkStride((Integer)object2);
                                } else if (object == ContouredObjectPropertyType.SELECTED) {
                                    this.setSelected((Boolean)object2);
                                } else {
                                    return super.setProperty(object, object2);
                                }
                            }
                        }
                    }
                }
            }
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getSelectedColor() {
        return this.selectedColor;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public GraphicObject.UpdateStatus setSelected(Boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getMarkOffset() {
        return this.offset;
    }

    public GraphicObject.UpdateStatus setMarkOffset(Integer n) {
        if (this.offset != n) {
            this.offset = n < 0 ? 0 : n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getMarkStride() {
        return this.stride;
    }

    public GraphicObject.UpdateStatus setMarkStride(Integer n) {
        if (this.stride != n) {
            this.stride = n < 1 ? 1 : n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getBackground() {
        return this.background;
    }

    public GraphicObject.UpdateStatus setBackground(Integer n) {
        this.background = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getFillMode() {
        return this.fillMode;
    }

    public GraphicObject.UpdateStatus setFillMode(Boolean bl) {
        if (this.fillMode == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.fillMode = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Line getLine() {
        return this.line;
    }

    public GraphicObject.UpdateStatus setLine(Line line) {
        this.line = line;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getLineColor() {
        return this.line.getColor();
    }

    public GraphicObject.UpdateStatus setLineColor(Integer n) {
        return this.line.setColor(n);
    }

    public Integer getLineStyle() {
        return this.getLineStyleAsEnum().asScilabIndex();
    }

    public Line.LineType getLineStyleAsEnum() {
        return this.line.getLineStyle();
    }

    public GraphicObject.UpdateStatus setLineStyle(Integer n) {
        this.setLineStyleAsEnum(Line.LineType.fromScilabIndex(n));
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setLineStyleAsEnum(Line.LineType lineType) {
        this.line.setLineStyle(lineType);
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getLineMode() {
        return this.line.getMode();
    }

    public GraphicObject.UpdateStatus setLineMode(Boolean bl) {
        return this.line.setMode(bl);
    }

    public Double getLineThickness() {
        return this.line.getThickness();
    }

    public GraphicObject.UpdateStatus setLineThickness(Double d) {
        this.line.setThickness(d);
        return GraphicObject.UpdateStatus.Success;
    }

    public Mark getMark() {
        return this.mark;
    }

    public GraphicObject.UpdateStatus setMark(Mark mark) {
        this.mark_sizes = new Integer[0];
        this.mark_foregrounds = new Integer[0];
        this.mark_backgrounds = new Integer[0];
        this.mark = mark;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getMarkBackground() {
        return this.mark.getBackground();
    }

    public Integer[] getMarkBackgrounds() {
        return this.mark_backgrounds;
    }

    public int getNumMarkBackgrounds() {
        return this.mark_backgrounds.length;
    }

    public GraphicObject.UpdateStatus setMarkBackground(Integer n) {
        this.mark_backgrounds = new Integer[0];
        this.mark.setBackground(n);
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setMarkBackgrounds(Integer[] integerArray) {
        this.mark_backgrounds = integerArray;
        this.mark.setBackground(-3);
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getMarkForeground() {
        return this.mark.getForeground();
    }

    public Integer[] getMarkForegrounds() {
        return this.mark_foregrounds;
    }

    public int getNumMarkForegrounds() {
        return this.mark_foregrounds.length;
    }

    public GraphicObject.UpdateStatus setMarkForeground(Integer n) {
        this.mark_foregrounds = new Integer[0];
        this.mark.setForeground(n);
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setMarkForegrounds(Integer[] integerArray) {
        this.mark_foregrounds = integerArray;
        this.mark.setForeground(-3);
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getMarkSizeUnit() {
        return this.getMarkSizeUnitAsEnum().ordinal();
    }

    public Mark.MarkSizeUnitType getMarkSizeUnitAsEnum() {
        return this.mark.getMarkSizeUnit();
    }

    public GraphicObject.UpdateStatus setMarkSizeUnit(Integer n) {
        this.setMarkSizeUnitAsEnum(Mark.MarkSizeUnitType.intToEnum(n));
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setMarkSizeUnitAsEnum(Mark.MarkSizeUnitType markSizeUnitType) {
        this.mark.setMarkSizeUnit(markSizeUnitType);
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getMarkSize() {
        return this.mark.getSize();
    }

    public Integer[] getMarkSizes() {
        return this.mark_sizes;
    }

    public int getNumMarkSizes() {
        return this.mark_sizes.length;
    }

    public GraphicObject.UpdateStatus setMarkSize(Integer n) {
        this.mark_sizes = new Integer[0];
        return this.mark.setSize(n);
    }

    public GraphicObject.UpdateStatus setMarkSizes(Integer[] integerArray) {
        this.mark_sizes = integerArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getMarkMode() {
        return this.mark.getMode();
    }

    public GraphicObject.UpdateStatus setMarkMode(Boolean bl) {
        return this.mark.setMode(bl);
    }

    public Integer getMarkStyle() {
        return this.mark.getStyle();
    }

    public GraphicObject.UpdateStatus setMarkStyle(Integer n) {
        return this.mark.setStyle(n);
    }

    public static enum ContouredObjectPropertyType {
        LINE,
        FILLMODE,
        BACKGROUND,
        MARK,
        MARK_OFFSET,
        MARK_STRIDE,
        MARK_SIZES,
        NUM_MARK_SIZES,
        MARK_FOREGROUNDS,
        NUM_MARK_FOREGROUNDS,
        MARK_BACKGROUNDS,
        NUM_MARK_BACKGROUNDS,
        SELECTED;

    }
}

