/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.axes;

import java.util.ArrayList;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.textObject.Font;
import org.scilab.modules.graphic_objects.textObject.FormattedText;

public class TicksProperty {
    private static final int DEFAULT_NUMBER_OF_TICKS = 11;
    private boolean auto;
    private int subticks;
    private Font defaultFont;
    private String format = "";
    private Double[] st_factors = new Double[]{1.0, 0.0};
    TicksArrays automaticTicks;
    TicksArrays userTicks;

    public TicksProperty() {
        this.auto = false;
        this.subticks = 0;
        this.defaultFont = new Font();
        this.automaticTicks = new TicksArrays(11);
        this.userTicks = new TicksArrays(0);
    }

    public TicksProperty(TicksProperty ticksProperty) {
        this.auto = ticksProperty.auto;
        this.subticks = ticksProperty.subticks;
        this.format = ticksProperty.format;
        this.st_factors = ticksProperty.st_factors;
        this.defaultFont = new Font(ticksProperty.defaultFont);
        this.automaticTicks = new TicksArrays(0);
        this.userTicks = new TicksArrays(0);
        this.automaticTicks.setLocations(ticksProperty.automaticTicks.getLocations());
        this.userTicks.setLocations(ticksProperty.userTicks.getLocations());
        this.automaticTicks.setLabels(ticksProperty.automaticTicks.getLabels());
        this.userTicks.setLabels(ticksProperty.userTicks.getLabels());
    }

    public boolean equals(Object object) {
        if (object instanceof TicksProperty) {
            TicksProperty ticksProperty = (TicksProperty)object;
            if (ticksProperty.auto == this.auto && ticksProperty.subticks == this.subticks && ticksProperty.defaultFont.equals(this.defaultFont)) {
                if (this.auto) {
                    return this.automaticTicks.equals(ticksProperty.automaticTicks);
                }
                return this.userTicks.equals(ticksProperty.userTicks);
            }
        }
        return false;
    }

    public String getFormat() {
        return this.format;
    }

    public GraphicObject.UpdateStatus setFormat(String string) {
        if (!this.format.equals(string)) {
            this.format = string;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getSTFactors() {
        return this.st_factors;
    }

    public GraphicObject.UpdateStatus setSTFactors(Double[] doubleArray) {
        if (!this.st_factors[0].equals(doubleArray[0]) || !this.st_factors[1].equals(doubleArray[1])) {
            this.st_factors = doubleArray;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public GraphicObject.UpdateStatus setAuto(Boolean bl) {
        if (this.auto != bl) {
            this.auto = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public ArrayList<FormattedText> getLabels() {
        if (this.auto) {
            return this.automaticTicks.getLabels();
        }
        return this.userTicks.getLabels();
    }

    public GraphicObject.UpdateStatus setLabels(ArrayList<FormattedText> arrayList) {
        if (this.auto) {
            return this.automaticTicks.setLabels(arrayList);
        }
        return this.userTicks.setLabels(arrayList);
    }

    public String[] getLabelsStrings() {
        if (this.auto) {
            return this.automaticTicks.getLabelsStrings();
        }
        return this.userTicks.getLabelsStrings();
    }

    public GraphicObject.UpdateStatus setLabelsStrings(String[] stringArray) {
        if (this.auto) {
            return this.automaticTicks.setLabelsStrings(stringArray);
        }
        return this.userTicks.setLabelsStrings(stringArray);
    }

    public Integer getNumber() {
        if (this.auto) {
            return this.automaticTicks.getNumber();
        }
        return this.userTicks.getNumber();
    }

    public Double[] getLocations() {
        if (this.auto) {
            return this.automaticTicks.getLocations();
        }
        return this.userTicks.getLocations();
    }

    public GraphicObject.UpdateStatus setLocations(Double[] doubleArray) {
        if (this.auto) {
            return this.automaticTicks.setLocations(doubleArray);
        }
        return this.userTicks.setLocations(doubleArray);
    }

    public Integer getSubticks() {
        return this.subticks;
    }

    public GraphicObject.UpdateStatus setSubticks(Integer n) {
        if (this.subticks != n) {
            this.subticks = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getFontStyle() {
        return this.automaticTicks.getFontStyle();
    }

    public GraphicObject.UpdateStatus setFontStyle(Integer n) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (n != this.defaultFont.getStyle()) {
            this.defaultFont.setStyle(n);
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        GraphicObject.UpdateStatus updateStatus2 = this.automaticTicks.setFontStyle(n);
        GraphicObject.UpdateStatus updateStatus3 = this.userTicks.setFontStyle(n);
        if (updateStatus == GraphicObject.UpdateStatus.Success || updateStatus2 == GraphicObject.UpdateStatus.Success || updateStatus3 == GraphicObject.UpdateStatus.Success) {
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double getFontSize() {
        return this.automaticTicks.getFontSize();
    }

    public GraphicObject.UpdateStatus setFontSize(Double d) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (d != this.defaultFont.getSize()) {
            this.defaultFont.setSize(d);
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        GraphicObject.UpdateStatus updateStatus2 = this.automaticTicks.setFontSize(d);
        GraphicObject.UpdateStatus updateStatus3 = this.userTicks.setFontSize(d);
        if (updateStatus == GraphicObject.UpdateStatus.Success || updateStatus2 == GraphicObject.UpdateStatus.Success || updateStatus3 == GraphicObject.UpdateStatus.Success) {
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getFontColor() {
        return this.automaticTicks.getFontColor();
    }

    public GraphicObject.UpdateStatus setFontColor(Integer n) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (n != this.defaultFont.getColor()) {
            this.defaultFont.setColor(n);
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        GraphicObject.UpdateStatus updateStatus2 = this.automaticTicks.setFontColor(n);
        GraphicObject.UpdateStatus updateStatus3 = this.userTicks.setFontColor(n);
        if (updateStatus == GraphicObject.UpdateStatus.Success || updateStatus2 == GraphicObject.UpdateStatus.Success || updateStatus3 == GraphicObject.UpdateStatus.Success) {
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getFontFractional() {
        return this.automaticTicks.getFontFractional();
    }

    public GraphicObject.UpdateStatus setFontFractional(Boolean bl) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (bl != this.defaultFont.getFractional()) {
            this.defaultFont.setFractional(bl);
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        GraphicObject.UpdateStatus updateStatus2 = this.automaticTicks.setFontFractional(bl);
        GraphicObject.UpdateStatus updateStatus3 = this.userTicks.setFontFractional(bl);
        if (updateStatus == GraphicObject.UpdateStatus.Success || updateStatus2 == GraphicObject.UpdateStatus.Success || updateStatus3 == GraphicObject.UpdateStatus.Success) {
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    private class TicksArrays {
        private double[] locations;
        private ArrayList<FormattedText> labels;
        private int number;

        public TicksArrays(int n) {
            this.locations = new double[n];
            this.labels = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.labels.add(i, new FormattedText());
            }
            this.number = n;
        }

        public boolean equals(Object object) {
            if (object instanceof TicksArrays) {
                TicksArrays ticksArrays = (TicksArrays)object;
                if (ticksArrays.number == this.number) {
                    for (int i = 0; i < this.number; ++i) {
                        if (ticksArrays.locations[i] == this.locations[i] && ticksArrays.labels.get(i).equals(this.labels.get(i))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public Integer getNumber() {
            return this.number;
        }

        public ArrayList<FormattedText> getLabels() {
            return this.labels;
        }

        public GraphicObject.UpdateStatus setLabels(ArrayList<FormattedText> arrayList) {
            GraphicObject.UpdateStatus updateStatus;
            GraphicObject.UpdateStatus updateStatus2 = updateStatus = this.labels.equals(arrayList) ? GraphicObject.UpdateStatus.NoChange : GraphicObject.UpdateStatus.Success;
            if (updateStatus == GraphicObject.UpdateStatus.Success) {
                if (!this.labels.isEmpty()) {
                    this.labels.clear();
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.labels.add(i, new FormattedText(arrayList.get(i)));
                }
            }
            return updateStatus;
        }

        public String[] getLabelsStrings() {
            String[] stringArray = new String[this.number];
            for (int i = 0; i < this.number; ++i) {
                stringArray[i] = new String(this.labels.get(i).getText()).replaceAll("\u00a0", " ");
            }
            return stringArray;
        }

        public GraphicObject.UpdateStatus setLabelsStrings(String[] stringArray) {
            if (stringArray.length != this.number) {
                return GraphicObject.UpdateStatus.NoChange;
            }
            if (this.labels == null || this.labels.size() != stringArray.length) {
                this.labels = new ArrayList(0);
                Font font = new Font(TicksProperty.this.defaultFont);
                for (int i = 0; i < stringArray.length; ++i) {
                    FormattedText formattedText = new FormattedText(stringArray[i], font);
                    this.labels.add(formattedText);
                }
                return GraphicObject.UpdateStatus.Success;
            }
            GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
            for (int i = 0; i < this.number; ++i) {
                FormattedText formattedText = this.labels.get(i);
                if (formattedText.getText().equals(stringArray[i])) continue;
                this.labels.get(i).setText(stringArray[i]);
                updateStatus = GraphicObject.UpdateStatus.Success;
            }
            return updateStatus;
        }

        public Double[] getLocations() {
            Double[] doubleArray = new Double[this.number];
            for (int i = 0; i < this.number; ++i) {
                doubleArray[i] = this.locations[i];
            }
            return doubleArray;
        }

        public GraphicObject.UpdateStatus setLocations(Double[] doubleArray) {
            GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.Success;
            if (this.locations == null || this.number != doubleArray.length) {
                this.locations = new double[doubleArray.length];
                this.number = doubleArray.length;
            } else {
                updateStatus = GraphicObject.UpdateStatus.NoChange;
            }
            for (int i = 0; i < doubleArray.length; ++i) {
                if (updateStatus == GraphicObject.UpdateStatus.NoChange) {
                    if (this.locations[i] == doubleArray[i]) continue;
                    updateStatus = GraphicObject.UpdateStatus.Success;
                    this.locations[i] = doubleArray[i];
                    continue;
                }
                this.locations[i] = doubleArray[i];
            }
            return updateStatus;
        }

        public Integer getFontStyle() {
            if (!this.labels.isEmpty()) {
                return this.labels.get(0).getFont().getStyle();
            }
            return 0;
        }

        public GraphicObject.UpdateStatus setFontStyle(Integer n) {
            GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
            for (int i = 0; i < this.labels.size(); ++i) {
                Font font = this.labels.get(i).getFont();
                if (font.getStyle() == n) continue;
                font.setStyle(n);
                updateStatus = GraphicObject.UpdateStatus.Success;
            }
            return updateStatus;
        }

        public Double getFontSize() {
            if (!this.labels.isEmpty()) {
                return this.labels.get(0).getFont().getSize();
            }
            return 0.0;
        }

        public GraphicObject.UpdateStatus setFontSize(Double d) {
            GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
            for (int i = 0; i < this.labels.size(); ++i) {
                Font font = this.labels.get(i).getFont();
                if (font.getSize() == d) continue;
                font.setSize(d);
                updateStatus = GraphicObject.UpdateStatus.Success;
            }
            return updateStatus;
        }

        public Integer getFontColor() {
            if (!this.labels.isEmpty()) {
                return this.labels.get(0).getFont().getColor();
            }
            return 0;
        }

        public GraphicObject.UpdateStatus setFontColor(Integer n) {
            GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
            for (int i = 0; i < this.labels.size(); ++i) {
                Font font = this.labels.get(i).getFont();
                if (font.getColor().equals(n)) continue;
                font.setColor(n);
                updateStatus = GraphicObject.UpdateStatus.Success;
            }
            return updateStatus;
        }

        public Boolean getFontFractional() {
            if (!this.labels.isEmpty()) {
                return this.labels.get(0).getFont().getFractional();
            }
            return false;
        }

        public GraphicObject.UpdateStatus setFontFractional(Boolean bl) {
            GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
            for (int i = 0; i < this.labels.size(); ++i) {
                Font font = this.labels.get(i).getFont();
                if (font.getFractional() == bl) continue;
                font.setFractional(bl);
                updateStatus = GraphicObject.UpdateStatus.Success;
            }
            return updateStatus;
        }
    }

    public static enum TicksPropertyProperty {
        AUTO,
        LOCATIONS,
        LABELS,
        FONT_SIZE,
        FONT_STYLE,
        FONT_COLOR,
        SUBTICKS;

    }
}

