/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.axes;

import java.util.ArrayList;
import org.scilab.modules.graphic_objects.axes.TicksProperty;
import org.scilab.modules.graphic_objects.contouredObject.Line;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.textObject.FormattedText;

public class AxisProperty {
    private boolean visible;
    private boolean reverse;
    private int gridColor;
    private double gridThickness;
    private Line.LineType gridStyle;
    private Integer label;
    private AxisLocation axisLocation;
    private boolean logFlag;
    private TicksProperty ticks;

    public AxisProperty() {
        this.visible = false;
        this.reverse = false;
        this.gridColor = 0;
        this.gridThickness = -1.0;
        this.gridStyle = Line.LineType.DASH_DOT;
        this.label = 0;
        this.axisLocation = AxisLocation.ORIGIN;
        this.ticks = new TicksProperty();
        this.logFlag = false;
    }

    public AxisProperty(AxisProperty axisProperty) {
        this.visible = axisProperty.visible;
        this.reverse = axisProperty.reverse;
        this.gridColor = axisProperty.gridColor;
        this.gridThickness = axisProperty.gridThickness;
        this.gridStyle = axisProperty.gridStyle;
        this.label = 0;
        this.axisLocation = axisProperty.axisLocation;
        this.ticks = new TicksProperty(axisProperty.ticks);
        this.logFlag = axisProperty.logFlag;
    }

    public Object getPropertyFromName(String string) {
        if (string.equals("Visible")) {
            return AxisPropertyProperty.VISIBLE;
        }
        if (string.equals("Reverse")) {
            return AxisPropertyProperty.REVERSE;
        }
        if (string.equals("GridColor")) {
            return AxisPropertyProperty.GRIDCOLOR;
        }
        if (string.equals("GridThickness")) {
            return AxisPropertyProperty.GRIDTHICKNESS;
        }
        if (string.equals("GridStyle")) {
            return AxisPropertyProperty.GRIDSTYLE;
        }
        if (string.equals("Label")) {
            return AxisPropertyProperty.LABEL;
        }
        if (string.equals("AxisLocation")) {
            return AxisPropertyProperty.AXISLOCATION;
        }
        if (string.equals("LogFlag")) {
            return AxisPropertyProperty.LOGFLAG;
        }
        return AxisPropertyProperty.UNKNOWNPROPERTY;
    }

    public Object getProperty(Object object) {
        if (object == AxisPropertyProperty.VISIBLE) {
            return this.getVisible();
        }
        if (object == AxisPropertyProperty.REVERSE) {
            return this.getReverse();
        }
        if (object == AxisPropertyProperty.GRIDCOLOR) {
            return this.getGridColor();
        }
        if (object == AxisPropertyProperty.GRIDTHICKNESS) {
            return this.getGridThickness();
        }
        if (object == AxisPropertyProperty.GRIDSTYLE) {
            return this.getGridStyle();
        }
        if (object == AxisPropertyProperty.LABEL) {
            return this.getLabel();
        }
        if (object == AxisPropertyProperty.AXISLOCATION) {
            return this.getAxisLocation();
        }
        if (object == AxisPropertyProperty.LOGFLAG) {
            return this.getLogFlag();
        }
        return null;
    }

    public boolean setProperty(Object object, Object object2) {
        if (object == AxisPropertyProperty.VISIBLE) {
            this.setVisible((Boolean)object2);
        } else if (object == AxisPropertyProperty.REVERSE) {
            this.setReverse((Boolean)object2);
        } else if (object == AxisPropertyProperty.GRIDCOLOR) {
            this.setGridColor((Integer)object2);
        } else if (object == AxisPropertyProperty.GRIDTHICKNESS) {
            this.setGridThickness((Double)object2);
        } else if (object == AxisPropertyProperty.GRIDSTYLE) {
            this.setGridStyle((Integer)object2);
        } else if (object == AxisPropertyProperty.LABEL) {
            this.setLabel((Integer)object2);
        } else if (object == AxisPropertyProperty.AXISLOCATION) {
            this.setAxisLocation((AxisLocation)((Object)object2));
        } else if (object == AxisPropertyProperty.LOGFLAG) {
            this.setLogFlag((Boolean)object2);
        }
        return true;
    }

    public AxisLocation getAxisLocationAsEnum() {
        return this.axisLocation;
    }

    public AxisLocation getAxisLocation() {
        return this.axisLocation;
    }

    public GraphicObject.UpdateStatus setAxisLocation(AxisLocation axisLocation) {
        if (this.axisLocation != axisLocation) {
            this.axisLocation = axisLocation;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getGridColor() {
        return this.gridColor;
    }

    public GraphicObject.UpdateStatus setGridColor(Integer n) {
        if (this.gridColor != n) {
            this.gridColor = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double getGridThickness() {
        return this.gridThickness;
    }

    public GraphicObject.UpdateStatus setGridThickness(Double d) {
        if (this.gridThickness != d) {
            this.gridThickness = d;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getGridStyle() {
        return this.gridStyle.asScilabIndex();
    }

    public GraphicObject.UpdateStatus setGridStyle(Integer n) {
        Line.LineType lineType = Line.LineType.fromScilabIndex(n);
        if (this.gridStyle != lineType) {
            this.gridStyle = lineType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getLabel() {
        return this.label;
    }

    public GraphicObject.UpdateStatus setLabel(Integer n) {
        if (this.label != n) {
            this.label = n == null ? 0 : n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getLogFlag() {
        return this.logFlag;
    }

    public GraphicObject.UpdateStatus setLogFlag(Boolean bl) {
        if (this.logFlag != bl) {
            this.logFlag = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public GraphicObject.UpdateStatus setReverse(Boolean bl) {
        if (this.reverse != bl) {
            this.reverse = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public TicksProperty getTicks() {
        return this.ticks;
    }

    public GraphicObject.UpdateStatus setTicks(TicksProperty ticksProperty) {
        if (!this.ticks.equals(ticksProperty)) {
            this.ticks = ticksProperty;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public GraphicObject.UpdateStatus setVisible(Boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getAutoTicks() {
        return this.ticks.getAuto();
    }

    public GraphicObject.UpdateStatus setAutoTicks(Boolean bl) {
        return this.ticks.setAuto(bl);
    }

    public Integer getNumberOfTicks() {
        return this.ticks.getNumber();
    }

    public Double[] getTicksLocations() {
        return this.ticks.getLocations();
    }

    public GraphicObject.UpdateStatus setTicksLocations(Double[] doubleArray) {
        return this.ticks.setLocations(doubleArray);
    }

    public ArrayList<FormattedText> getTicksLabels() {
        return this.ticks.getLabels();
    }

    public GraphicObject.UpdateStatus setTicksLabels(ArrayList<FormattedText> arrayList) {
        return this.ticks.setLabels(arrayList);
    }

    public String[] getTicksLabelsStrings() {
        return this.ticks.getLabelsStrings();
    }

    public GraphicObject.UpdateStatus setTicksLabelsStrings(String[] stringArray) {
        return this.ticks.setLabelsStrings(stringArray);
    }

    public Integer getSubticks() {
        return this.ticks.getSubticks();
    }

    public GraphicObject.UpdateStatus setSubticks(Integer n) {
        return this.ticks.setSubticks(n);
    }

    public Integer getFontStyle() {
        return this.ticks.getFontStyle();
    }

    public GraphicObject.UpdateStatus setFontStyle(Integer n) {
        return this.ticks.setFontStyle(n);
    }

    public Double getFontSize() {
        return this.ticks.getFontSize();
    }

    public GraphicObject.UpdateStatus setFontSize(Double d) {
        return this.ticks.setFontSize(d);
    }

    public String getFormat() {
        return this.ticks.getFormat();
    }

    public GraphicObject.UpdateStatus setFormat(String string) {
        return this.ticks.setFormat(string);
    }

    public Double[] getSTFactors() {
        return this.ticks.getSTFactors();
    }

    public GraphicObject.UpdateStatus setSTFactors(Double[] doubleArray) {
        return this.ticks.setSTFactors(doubleArray);
    }

    public Integer getFontColor() {
        return this.ticks.getFontColor();
    }

    public GraphicObject.UpdateStatus setFontColor(Integer n) {
        return this.ticks.setFontColor(n);
    }

    public Boolean getFontFractional() {
        return this.ticks.getFontFractional();
    }

    public GraphicObject.UpdateStatus setFontFractional(Boolean bl) {
        return this.ticks.setFontFractional(bl);
    }

    public static enum AxisLocation {
        BOTTOM,
        TOP,
        MIDDLE,
        ORIGIN,
        LEFT,
        RIGHT;


        public static AxisLocation intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return BOTTOM;
                }
                case 1: {
                    return TOP;
                }
                case 2: {
                    return MIDDLE;
                }
                case 3: {
                    return ORIGIN;
                }
                case 4: {
                    return LEFT;
                }
                case 5: {
                    return RIGHT;
                }
            }
            return null;
        }
    }

    public static enum AxisPropertyProperty {
        VISIBLE,
        REVERSE,
        GRIDCOLOR,
        GRIDTHICKNESS,
        GRIDSTYLE,
        LABEL,
        AXISLOCATION,
        LOGFLAG,
        UNKNOWNPROPERTY;

    }
}

