/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.arc;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.utils.Utils;

public class ArcDecomposer {
    private static final int NB_SECTORS = 64;

    public static int getDataSize() {
        return 66;
    }

    public static int getIndicesSize() {
        return 192;
    }

    public static int getWireIndicesSize() {
        return 128;
    }

    public static void fillVertices(FloatBuffer floatBuffer, Integer n, int n2, int n3, double[] dArray, double[] dArray2, int n4) {
        int n5 = 0;
        float[] fArray = new float[3];
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 105);
        Double d = (Double)GraphicController.getController().getProperty(n, 106);
        Double d2 = (Double)GraphicController.getController().getProperty(n, 107);
        Double d3 = (Double)GraphicController.getController().getProperty(n, 108);
        Double d4 = (Double)GraphicController.getController().getProperty(n, 109);
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d5 = d / 2.0;
        double d6 = d2 / 2.0;
        dArray3[0] = doubleArray[0] + d5;
        dArray3[1] = doubleArray[1] - d6;
        dArray3[2] = doubleArray[2];
        if ((n3 & 1) != 0) {
            dArray4[0] = dArray3[0];
            if ((n4 & 1) != 0) {
                dArray4[0] = Math.log10(dArray4[0]);
            }
            fArray[0] = (float)(dArray4[0] * dArray[0] + dArray2[0]);
            floatBuffer.put(n5, fArray[0]);
        }
        if ((n3 & 2) != 0) {
            dArray4[1] = dArray3[1];
            if ((n4 & 2) != 0) {
                dArray4[1] = Math.log10(dArray4[1]);
            }
            fArray[1] = (float)(dArray4[1] * dArray[1] + dArray2[1]);
            floatBuffer.put(n5 + 1, fArray[1]);
        }
        if ((n3 & 4) != 0) {
            dArray4[2] = dArray3[2];
            if ((n4 & 4) != 0) {
                dArray4[2] = Math.log10(dArray4[2]);
            }
            fArray[2] = (float)(dArray4[2] * dArray[2] + dArray2[2]);
            floatBuffer.put(n5 + 2, fArray[2]);
        }
        if (n2 == 4 && (n3 & 8) != 0) {
            floatBuffer.put(n5 + 3, 1.0f);
        }
        n5 += n2;
        if (d4 > Math.PI * 2) {
            d4 = Math.PI * 2;
        } else if (d4 < Math.PI * -2) {
            d4 = Math.PI * -2;
        }
        d3 = d3 % (Math.PI * 2);
        for (int i = 0; i < 65; ++i) {
            double d7 = d3 + d4 * (double)i / 64.0;
            if ((n3 & 1) != 0) {
                dArray4[0] = dArray3[0] + d5 * Math.cos(d7);
                if ((n4 & 1) != 0) {
                    dArray4[0] = Math.log10(dArray4[0]);
                }
                fArray[0] = (float)(dArray4[0] * dArray[0] + dArray2[0]);
                floatBuffer.put(n5, fArray[0]);
            }
            if ((n3 & 2) != 0) {
                dArray4[1] = dArray3[1] + d6 * Math.sin(d7);
                if ((n4 & 2) != 0) {
                    dArray4[1] = Math.log10(dArray4[1]);
                }
                fArray[1] = (float)(dArray4[1] * dArray[1] + dArray2[1]);
                floatBuffer.put(n5 + 1, fArray[1]);
            }
            if ((n3 & 4) != 0) {
                dArray4[2] = dArray3[2];
                if ((n4 & 4) != 0) {
                    dArray4[2] = Math.log10(dArray4[2]);
                }
                fArray[2] = (float)(dArray4[2] * dArray[2] + dArray2[2]);
                floatBuffer.put(n5 + 2, fArray[2]);
            }
            if (n2 == 4 && (n3 & 8) != 0) {
                floatBuffer.put(n5 + 3, 1.0f);
            }
            n5 += n2;
        }
    }

    public static int fillIndices(IntBuffer intBuffer, Integer n, int n2) {
        boolean bl = ArcDecomposer.isValid(n, n2);
        if (bl) {
            for (int i = 0; i < 64; ++i) {
                intBuffer.put(0);
                intBuffer.put(i + 1);
                intBuffer.put(i + 2);
            }
            return 192;
        }
        return 0;
    }

    public static int fillWireIndices(IntBuffer intBuffer, Integer n, int n2) {
        boolean bl = ArcDecomposer.isValid(n, n2);
        if (bl) {
            for (int i = 0; i < 64; ++i) {
                intBuffer.put(i + 1);
                intBuffer.put(i + 2);
            }
            return 128;
        }
        return 0;
    }

    private static boolean isValid(Integer n, int n2) {
        boolean bl = false;
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 105);
        Double d = (Double)GraphicController.getController().getProperty(n, 106);
        Double d2 = (Double)GraphicController.getController().getProperty(n, 107);
        Double d3 = (Double)GraphicController.getController().getProperty(n, 108);
        Double d4 = (Double)GraphicController.getController().getProperty(n, 109);
        if (Utils.isValid(doubleArray[0], doubleArray[1], doubleArray[2]) && Utils.isValid(d) && Utils.isValid(d2) && Utils.isValid(d3) && Utils.isValid(d4)) {
            bl = true;
        }
        if (n2 != 0) {
            double[] dArray = new double[]{Math.min(doubleArray[0], doubleArray[0] + d), Math.min(doubleArray[1], doubleArray[1] - d2)};
            bl = bl && Utils.isLogValid(dArray[0], dArray[1], doubleArray[2], n2);
        }
        return bl;
    }
}

