/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.utils.shapes.geometry;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;

public final class SphereFactory {
    private static SphereFactory singleton;

    private SphereFactory() {
    }

    public static SphereFactory getSingleton() {
        if (singleton == null) {
            singleton = new SphereFactory();
        }
        return singleton;
    }

    public Geometry create(Canvas canvas, Float f, int n, int n2) {
        int n3 = n < 3 ? 3 : n;
        int n4 = n2 < 4 ? 4 : n2;
        ElementsBuffer elementsBuffer = canvas.getBuffersManager().createElementsBuffer();
        elementsBuffer.setData(this.createVertexData(f, n3, n4), 4);
        IndicesBuffer indicesBuffer = canvas.getBuffersManager().createIndicesBuffer();
        indicesBuffer.setData(this.createIndicesData(n3, n4));
        DefaultGeometry defaultGeometry = new DefaultGeometry();
        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
        defaultGeometry.setVertices(elementsBuffer);
        defaultGeometry.setIndices(indicesBuffer);
        return defaultGeometry;
    }

    private IntBuffer createIndicesData(int n, int n2) {
        int n3;
        int n4;
        int n5 = 6 * (n - 3) * n2 + 6 * n2;
        IntBuffer intBuffer = IntBuffer.allocate(n5);
        intBuffer.rewind();
        for (n4 = 0; n4 < n2; ++n4) {
            intBuffer.put(0);
            intBuffer.put(1 + n4);
            intBuffer.put(1 + (n4 + 1) % n2);
        }
        for (n4 = 1; n4 < n - 2; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                int n6 = 1 + n3 + (n4 - 1) * n2;
                int n7 = 1 + (n3 + 1) % n2 + (n4 - 1) * n2;
                int n8 = 1 + (n3 + 1) % n2 + n4 * n2;
                int n9 = 1 + n3 + n4 * n2;
                intBuffer.put(n6);
                intBuffer.put(n7);
                intBuffer.put(n8);
                intBuffer.put(n6);
                intBuffer.put(n8);
                intBuffer.put(n9);
            }
        }
        n4 = (n - 2) * n2 + 2 - 1;
        for (n3 = 0; n3 < n2; ++n3) {
            intBuffer.put(n4);
            intBuffer.put(n4 - n2 + n3);
            intBuffer.put(n4 - n2 + (n3 + 1) % n2);
        }
        intBuffer.rewind();
        return intBuffer;
    }

    private FloatBuffer createVertexData(Float f, int n, int n2) {
        int n3 = (n - 2) * n2 + 2;
        FloatBuffer floatBuffer = FloatBuffer.allocate(n3 * 4);
        floatBuffer.rewind();
        floatBuffer.put(new float[]{0.0f, 0.0f, f.floatValue(), 1.0f});
        for (int i = 1; i < n - 1; ++i) {
            double d = (double)i * Math.PI / (double)(n - 1);
            float f2 = (float)((double)f.floatValue() * Math.cos(d));
            float f3 = (float)((double)f.floatValue() * Math.sin(d));
            for (int j = 0; j < n2; ++j) {
                double d2 = (double)(j * 2) * Math.PI / (double)n2;
                float f4 = (float)((double)f3 * Math.cos(d2));
                float f5 = (float)((double)f3 * Math.sin(d2));
                floatBuffer.put(f4);
                floatBuffer.put(f5);
                floatBuffer.put(f2);
                floatBuffer.put(1.0f);
            }
        }
        floatBuffer.put(new float[]{0.0f, 0.0f, -f.floatValue(), 1.0f});
        floatBuffer.rewind();
        return floatBuffer;
    }
}

