/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.ruler.graduations;

import java.util.LinkedList;
import java.util.List;
import org.scilab.forge.scirenderer.ruler.graduations.AbstractGraduations;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;

public final class LinearGraduations
extends AbstractGraduations
implements Graduations {
    protected final int stepExponent;
    protected final int stepMantissa;
    private LinearGraduations moreGraduation;
    private LinearGraduations alternativeGraduation;
    private Graduations subGraduation;
    private Double stepValue;
    private List<Double> allValues;
    private List<Double> newValues;

    private LinearGraduations() {
        super(null);
        this.stepExponent = 0;
        this.stepMantissa = 0;
    }

    private LinearGraduations(Graduations graduations, int n, int n2) {
        super(graduations);
        this.stepExponent = n;
        this.stepMantissa = n2;
    }

    private LinearGraduations(Graduations graduations, double d, boolean bl, double d2, boolean bl2) {
        super(graduations, d, bl, d2, bl2);
        if (d != d2) {
            double d3 = d2 - d;
            this.stepExponent = (int)Math.ceil(Math.log10(d3));
            this.stepMantissa = 1;
        } else {
            this.stepExponent = 0;
            this.stepMantissa = 0;
            this.newValues = new LinkedList<Double>();
            this.allValues = new LinkedList<Double>();
            this.allValues.add(d);
        }
    }

    public static LinearGraduations create(double d, double d2) {
        return LinearGraduations.create(d, true, d2, true);
    }

    public static LinearGraduations create(Graduations graduations, double d, boolean bl, double d2, boolean bl2) {
        if (d < d2) {
            return new LinearGraduations(graduations, d, bl, d2, bl2);
        }
        return new LinearGraduations(graduations, d2, bl2, d, bl);
    }

    public static LinearGraduations create(double d, boolean bl, double d2, boolean bl2) {
        if (d < d2) {
            return new LinearGraduations(null, d, bl, d2, bl2);
        }
        return new LinearGraduations(null, d2, bl2, d, bl);
    }

    private static final double mypow10(int n) {
        boolean bl;
        double d = 10.0;
        double d2 = 1.0;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        while (n != 0) {
            if ((n & 1) != 0) {
                d2 *= d;
            }
            d *= d;
            n >>= 1;
        }
        return bl ? 1.0 / d2 : d2;
    }

    private static final long myceil(double d) {
        if (d == 0.0) {
            return 0L;
        }
        double d2 = Math.round(d);
        if (Math.abs(1.0 - d2 / d) <= 1.0E-8) {
            return (long)d2;
        }
        return (long)Math.ceil(d);
    }

    private Double getStepValue() {
        if (this.stepValue == null) {
            this.stepValue = this.stepMantissa == 1 ? Double.valueOf(LinearGraduations.mypow10(this.stepExponent)) : Double.valueOf((double)this.stepMantissa * LinearGraduations.mypow10(this.stepExponent));
        }
        return this.stepValue;
    }

    private final long getIndex(double d) {
        switch (this.stepMantissa) {
            case 1: {
                return LinearGraduations.myceil(LinearGraduations.mypow10(-this.stepExponent) * d);
            }
            case 2: {
                return LinearGraduations.myceil(5.0 * LinearGraduations.mypow10(-this.stepExponent - 1) * d);
            }
            case 5: {
                return LinearGraduations.myceil(LinearGraduations.mypow10(-this.stepExponent - 1) * d * 2.0);
            }
        }
        return LinearGraduations.myceil(LinearGraduations.mypow10(-this.stepExponent) * d / (double)this.stepMantissa);
    }

    private boolean isNewIndex(long l) {
        switch (this.stepMantissa) {
            case 1: {
                return l % 2L != 0L;
            }
            case 2: {
                return l % 5L != 0L;
            }
        }
        return l * (long)this.stepMantissa % 2L != 0L;
    }

    @Override
    public List<Double> getNewValues() {
        if (this.getParentGraduations() == null) {
            return this.getAllValues();
        }
        if (this.newValues == null) {
            this.newValues = new LinkedList<Double>();
            double d = this.getLowerBound();
            long l = this.getIndex(d);
            double d2 = this.getStepValue() * (double)l;
            double d3 = d2 - d;
            if (d3 == 0.0 && !this.containRelative(d3)) {
                d3 += this.getStepValue().doubleValue();
                ++l;
            }
            while (this.containRelative(d3) && !Double.isInfinite(d + d3)) {
                if (this.isNewIndex(l)) {
                    this.newValues.add(d + d3);
                }
                d3 += this.getStepValue().doubleValue();
                ++l;
            }
        }
        return this.newValues;
    }

    @Override
    public List<Double> getAllValues() {
        if (this.allValues == null) {
            double d = this.getLowerBound();
            this.allValues = new LinkedList<Double>();
            double d2 = this.getStepValue() * (double)this.getIndex(d);
            double d3 = d2 - d;
            if (d3 == 0.0 && !this.containRelative(d3)) {
                d3 += this.getStepValue().doubleValue();
            }
            while (this.containRelative(d3) && !Double.isInfinite(d + d3)) {
                this.allValues.add(d + d3);
                d3 += this.getStepValue().doubleValue();
            }
        }
        return this.allValues;
    }

    @Override
    public LinearGraduations getMore() {
        if (this.stepMantissa != 5) {
            if (this.moreGraduation == null) {
                this.moreGraduation = this.stepMantissa == 1 ? new LinearGraduations(this, this.stepExponent - 1, 2) : new LinearGraduations(this, this.stepExponent, 1);
            }
            return this.moreGraduation;
        }
        return null;
    }

    @Override
    public LinearGraduations getAlternative() {
        if (this.stepMantissa == 2) {
            if (this.alternativeGraduation == null) {
                this.alternativeGraduation = this.getParentGraduations() == null ? new LinearGraduations(null, this.getLowerBound(), true, this.getLowerBound(), true) : new LinearGraduations(this.getParentGraduations(), this.stepExponent, 5);
            }
            return this.alternativeGraduation;
        }
        return null;
    }

    @Override
    public Graduations getSubGraduations() {
        if (this.subGraduation == null) {
            switch (this.stepMantissa) {
                case 1: {
                    this.subGraduation = new LinearGraduations(this, this.stepExponent - 1, 5);
                    break;
                }
                case 2: {
                    this.subGraduation = new LinearGraduations(this, this.stepExponent, 1);
                    break;
                }
                case 5: {
                    this.subGraduation = new LinearGraduations(this.getParentGraduations(), this.stepExponent, 1);
                    break;
                }
                default: {
                    this.subGraduation = null;
                }
            }
        }
        return this.subGraduation;
    }

    @Override
    public int getSubDensity() {
        if (this.stepMantissa == 5) {
            return 5;
        }
        return 2;
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string + "; stepMantissa=" + this.stepMantissa + "; stepExponent=" + this.stepExponent + "; parent=" + this.getParentGraduations();
        return string;
    }
}

