/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.ruler;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.BuffersManager;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.ruler.DefaultRulerSpriteFactory;
import org.scilab.forge.scirenderer.ruler.RulerDrawingResult;
import org.scilab.forge.scirenderer.ruler.RulerModel;
import org.scilab.forge.scirenderer.ruler.RulerSpriteFactory;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;
import org.scilab.forge.scirenderer.ruler.graduations.UserDefinedFormat;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class RulerDrawer {
    private final Map<Double, Texture> spriteMap = new ConcurrentHashMap<Double, Texture>();
    private final TextureManager textureManager;
    private RulerSpriteFactory spriteFactory;
    private OneShotRulerDrawer oneShotRulerDrawer;

    public RulerDrawer(TextureManager textureManager) {
        this.textureManager = textureManager;
        this.spriteFactory = new DefaultRulerSpriteFactory();
        this.oneShotRulerDrawer = new OneShotRulerDrawer();
    }

    public RulerDrawingResult draw(DrawingTools drawingTools, RulerModel rulerModel) {
        return this.oneShotRulerDrawer.drawWithResults(drawingTools, rulerModel);
    }

    public RulerSpriteFactory getSpriteFactory() {
        return this.spriteFactory;
    }

    public void draw(DrawingTools drawingTools) {
        this.oneShotRulerDrawer.draw(drawingTools);
    }

    public RulerModel getModel() {
        return this.oneShotRulerDrawer.rulerModel;
    }

    public List<Double> getSubTicksValue() {
        return this.oneShotRulerDrawer.subTicksValue;
    }

    public List<Double> getTicksValue() {
        return this.oneShotRulerDrawer.ticksValue;
    }

    public RulerDrawingResult computeRuler(RulerModel rulerModel, Transformation transformation) {
        return this.oneShotRulerDrawer.computeRuler(rulerModel, transformation);
    }

    public void setSpriteFactory(RulerSpriteFactory rulerSpriteFactory) {
        this.disposeResources();
        this.spriteFactory = rulerSpriteFactory;
    }

    public void disposeResources() {
        this.textureManager.dispose(this.spriteMap.values());
        this.spriteMap.clear();
        this.oneShotRulerDrawer.dispose();
    }

    public double getDistanceRatio() {
        return this.oneShotRulerDrawer.getDistanceRatio();
    }

    private class OneShotRulerDrawer {
        private Transformation canvasProjection;
        private RulerModel rulerModel;
        private Vector3d windowSubTicksDelta;
        private Vector3d windowTicksDelta;
        private Map<Double, Dimension> spriteDimensionMap = new HashMap<Double, Dimension>();
        private List<PositionedSprite> spritesList = new LinkedList<PositionedSprite>();
        private double maximalSpritesDistance;
        private Graduations graduations;
        private List<Double> subTicksValue;
        private List<Double> ticksValue;
        private int density;
        private double distRatio;

        public synchronized void dispose() {
            this.spriteDimensionMap.clear();
            this.spritesList.clear();
            if (this.subTicksValue != null) {
                this.subTicksValue.clear();
            }
            if (this.ticksValue != null) {
                this.ticksValue.clear();
            }
            this.rulerModel = null;
        }

        public double getDistanceRatio() {
            return this.distRatio;
        }

        public synchronized RulerDrawingResult computeRuler(RulerModel rulerModel, Transformation transformation) {
            this.canvasProjection = transformation;
            this.rulerModel = rulerModel;
            this.subTicksValue = new LinkedList<Double>();
            this.ticksValue = new LinkedList<Double>();
            this.spritesList = new LinkedList<PositionedSprite>();
            Vector3d vector3d = transformation.projectDirection(rulerModel.getTicksDirection());
            vector3d = vector3d.setZ(0.0);
            Vector3d vector3d2 = vector3d.getNormalized();
            this.windowSubTicksDelta = vector3d2.times(rulerModel.getSubTicksLength());
            this.windowTicksDelta = vector3d2.times(rulerModel.getTicksLength());
            DecimalFormat decimalFormat = rulerModel.isAutoTicks() ? this.computeAutoGraduation() : this.computeUserGraduation();
            this.computeTicksData();
            double d = this.computeTicksDistanceRatio(vector3d.getNorm());
            return new RulerDrawingResult(decimalFormat, this.ticksValue, this.subTicksValue, this.density, d, vector3d2);
        }

        public synchronized RulerDrawingResult drawWithResults(DrawingTools drawingTools, RulerModel rulerModel) {
            this.rulerModel = rulerModel;
            this.subTicksValue = new LinkedList<Double>();
            this.ticksValue = new LinkedList<Double>();
            this.spritesList = new LinkedList<PositionedSprite>();
            this.canvasProjection = drawingTools.getTransformationManager().getCanvasProjection();
            Vector3d vector3d = this.canvasProjection.projectDirection(rulerModel.getTicksDirection());
            vector3d = vector3d.setZ(0.0);
            Vector3d vector3d2 = vector3d.getNormalized();
            this.windowSubTicksDelta = vector3d2.times(rulerModel.getSubTicksLength());
            this.windowTicksDelta = vector3d2.times(rulerModel.getTicksLength());
            DecimalFormat decimalFormat = rulerModel.isAutoTicks() ? this.computeAutoGraduation() : this.computeUserGraduation();
            this.computeTicksData();
            this.draw(drawingTools);
            double d = this.computeTicksDistanceRatio(vector3d.getNorm());
            return new RulerDrawingResult(decimalFormat, this.ticksValue, this.subTicksValue, this.density, d, vector3d2);
        }

        private double computeTicksDistanceRatio(double d) {
            this.distRatio = d == 0.0 ? 1.0 : (this.maximalSpritesDistance == 0.0 ? (double)this.rulerModel.getSpriteDistance() / d : this.maximalSpritesDistance / d);
            return this.distRatio;
        }

        private synchronized void draw(DrawingTools drawingTools) {
            if (this.rulerModel == null) {
                return;
            }
            BuffersManager buffersManager = drawingTools.getCanvas().getBuffersManager();
            ElementsBuffer elementsBuffer = buffersManager.createElementsBuffer();
            this.fillVertices(elementsBuffer, this.rulerModel, this.ticksValue, this.subTicksValue, this.canvasProjection);
            DefaultGeometry defaultGeometry = new DefaultGeometry();
            defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
            defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
            defaultGeometry.setVertices(elementsBuffer);
            Appearance appearance = new Appearance();
            appearance.setLineColor(this.rulerModel.getColor());
            appearance.setLineWidth((float)this.rulerModel.getLineWidth());
            drawingTools.getTransformationManager().useWindowCoordinate();
            try {
                for (PositionedSprite positionedSprite : this.spritesList) {
                    drawingTools.draw(positionedSprite.getSprite(), AnchorPosition.CENTER, positionedSprite.getWindowPosition());
                }
                drawingTools.draw(defaultGeometry, appearance);
            }
            catch (SciRendererException sciRendererException) {
                // empty catch block
            }
            drawingTools.getTransformationManager().useSceneCoordinate();
            buffersManager.dispose(elementsBuffer);
        }

        private DecimalFormat computeAutoGraduation() {
            Graduations graduations;
            double d = 0.0;
            Graduations graduations2 = graduations = this.rulerModel.getGraduations();
            DecimalFormat decimalFormat = graduations.getFormat();
            String string = this.rulerModel.getFormat();
            if (string != null && !string.isEmpty()) {
                decimalFormat = new UserDefinedFormat(decimalFormat, string, this.rulerModel.getScale(), this.rulerModel.getTranslate());
            }
            boolean bl = true;
            LinkedList<PositionedSprite> linkedList = new LinkedList<PositionedSprite>();
            while (graduations != null) {
                double d2 = 0.0;
                linkedList.clear();
                List<Double> list = graduations.getNewValues();
                for (double d3 : list) {
                    Texture texture = this.computeSprite(d3, decimalFormat);
                    Vector3d vector3d = this.canvasProjection.project(this.rulerModel.getPosition(d3));
                    if (vector3d.getX() != vector3d.getX()) {
                        return decimalFormat;
                    }
                    Dimension dimension = this.computeSpriteDimension(d3);
                    Vector3d vector3d2 = this.projectCenterToEdge(dimension, this.windowTicksDelta);
                    PositionedSprite positionedSprite = new PositionedSprite(texture, dimension, vector3d.plus(this.windowTicksDelta.plus(vector3d2)));
                    linkedList.add(positionedSprite);
                    Vector3d vector3d3 = this.windowTicksDelta.plus(vector3d2.times(2.0));
                    d2 = Math.max(d2, vector3d3.getNorm());
                }
                if (this.collide(linkedList, this.rulerModel.getMargin()) || this.collide(this.spritesList, linkedList, this.rulerModel.getMargin())) {
                    graduations = graduations.getAlternative();
                    bl = false;
                    continue;
                }
                d = Math.max(d, d2);
                this.spritesList.addAll(linkedList);
                graduations2 = graduations;
                if (bl) {
                    graduations = graduations.getMore();
                    continue;
                }
                graduations = null;
            }
            this.graduations = graduations2;
            this.maximalSpritesDistance = d;
            return decimalFormat;
        }

        private DecimalFormat computeUserGraduation() {
            double d = 0.0;
            Graduations graduations = this.rulerModel.getGraduations();
            List<Double> list = graduations.getNewValues();
            DecimalFormat decimalFormat = graduations.getFormat();
            for (double d2 : list) {
                Texture texture = this.computeSprite(d2, decimalFormat);
                if (texture == null) continue;
                Vector3d vector3d = this.canvasProjection.project(this.rulerModel.getPosition(d2));
                Vector3d vector3d2 = this.projectCenterToEdge(texture, this.windowTicksDelta);
                this.spritesList.add(new PositionedSprite(texture, vector3d.plus(this.windowTicksDelta.plus(vector3d2))));
                Vector3d vector3d3 = this.windowTicksDelta.plus(vector3d2.times(2.0));
                d = Math.max(d, vector3d3.getNorm());
            }
            this.graduations = graduations;
            this.maximalSpritesDistance = d;
            return decimalFormat;
        }

        private void computeTicksData() {
            if (this.graduations != null) {
                this.ticksValue = this.graduations.getAllValues();
                int n = this.rulerModel.getSubticksNumber();
                if (n < 0) {
                    Graduations graduations;
                    for (graduations = this.graduations.getSubGraduations(); graduations != null && this.computeTicksDistance(graduations) < this.rulerModel.getMinimalSubTicksDistance(); graduations = graduations.getAlternative()) {
                    }
                    this.subTicksValue = graduations != null ? graduations.getAllValues() : new LinkedList<Double>();
                } else {
                    this.subTicksValue = this.graduations.getSubGraduations(n);
                }
                this.density = this.getDensity();
            } else {
                this.subTicksValue = new LinkedList<Double>();
                this.ticksValue = new LinkedList<Double>();
                this.density = 0;
            }
        }

        private int getDensity() {
            int n;
            int n2 = this.ticksValue == null ? 0 : this.ticksValue.size();
            int n3 = n = this.subTicksValue == null ? 0 : this.subTicksValue.size();
            if (n <= n2 || n2 == 1) {
                return 0;
            }
            return (n - n2) / (n2 - 1);
        }

        private double computeTicksDistance(Graduations graduations) {
            double d = Double.MAX_VALUE;
            if (graduations != null) {
                Vector3d vector3d = null;
                for (double d2 : graduations.getAllValues()) {
                    Vector3d vector3d2 = this.canvasProjection.project(this.rulerModel.getPosition(d2));
                    if (vector3d != null) {
                        d = Math.min(d, vector3d2.minus(vector3d).getNorm2());
                    }
                    vector3d = vector3d2;
                }
                d = Math.sqrt(d);
            }
            return d;
        }

        private boolean collide(List<PositionedSprite> list, double d) {
            for (int i = 0; i < list.size(); ++i) {
                Rectangle2D rectangle2D = list.get(i).getWindowBounds();
                for (int j = i + 1; j < list.size(); ++j) {
                    if (!this.collide(rectangle2D, list.get(j).getWindowBounds(), d)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean collide(List<PositionedSprite> list, List<PositionedSprite> list2, double d) {
            for (PositionedSprite positionedSprite : list2) {
                Rectangle2D rectangle2D = positionedSprite.getWindowBounds();
                for (PositionedSprite positionedSprite2 : list) {
                    if (!this.collide(rectangle2D, positionedSprite2.getWindowBounds(), d)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean collide(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d) {
            return rectangle2D2.getMinX() - rectangle2D.getMaxX() < d && rectangle2D.getMinX() - rectangle2D2.getMaxX() < d && rectangle2D2.getMinY() - rectangle2D.getMaxY() < d && rectangle2D.getMinY() - rectangle2D2.getMaxY() < d;
        }

        private Vector3d projectCenterToEdge(Texture texture, Vector3d vector3d) {
            Vector3d vector3d2 = vector3d == null || vector3d.isZero() ? new Vector3d(1.0, 0.0, 0.0) : vector3d;
            Dimension dimension = texture.getDataProvider().getTextureSize();
            double d = (double)dimension.width / Math.abs(vector3d2.getX());
            double d2 = (double)dimension.height / Math.abs(vector3d2.getY());
            double d3 = Math.min(d2, d);
            return vector3d2.times((d3 + 1.0) / 2.0);
        }

        private Vector3d projectCenterToEdge(Dimension dimension, Vector3d vector3d) {
            Vector3d vector3d2 = vector3d == null || vector3d.isZero() ? new Vector3d(1.0, 0.0, 0.0) : vector3d;
            double d = (double)dimension.width / Math.abs(vector3d2.getX());
            double d2 = (double)dimension.height / Math.abs(vector3d2.getY());
            double d3 = Math.min(d2, d);
            return vector3d2.times((d3 + 1.0) / 2.0);
        }

        private void fillVertices(ElementsBuffer elementsBuffer, RulerModel rulerModel, List<Double> list, List<Double> list2, Transformation transformation) {
            Vector3d vector3d = rulerModel.getFirstPoint();
            Vector3d vector3d2 = rulerModel.getSecondPoint();
            if (vector3d != null && vector3d2 != null) {
                Vector3d vector3d3;
                int n = 2 * list.size() + 2 * list2.size();
                if (rulerModel.isLineVisible()) {
                    n += 2;
                }
                FloatBuffer floatBuffer = FloatBuffer.allocate(4 * n);
                floatBuffer.rewind();
                for (double d : list) {
                    vector3d3 = transformation.project(rulerModel.getPosition(d));
                    floatBuffer.put(vector3d3.getDataAsFloatArray(4));
                    floatBuffer.put(vector3d3.plus(this.windowTicksDelta).getDataAsFloatArray(4));
                }
                for (double d : list2) {
                    vector3d3 = transformation.project(rulerModel.getPosition(d));
                    floatBuffer.put(vector3d3.getDataAsFloatArray(4));
                    floatBuffer.put(vector3d3.plus(this.windowSubTicksDelta).getDataAsFloatArray(4));
                }
                if (rulerModel.isLineVisible()) {
                    floatBuffer.put(transformation.project(vector3d).getDataAsFloatArray(4));
                    floatBuffer.put(transformation.project(vector3d2).getDataAsFloatArray(4));
                }
                floatBuffer.rewind();
                elementsBuffer.setData(floatBuffer, 4);
            } else {
                elementsBuffer.setData(new float[0], 4);
            }
        }

        private Texture computeSprite(double d, DecimalFormat decimalFormat) {
            Texture texture = (Texture)RulerDrawer.this.spriteMap.get(d);
            if (texture == null && (texture = RulerDrawer.this.spriteFactory.create(d, decimalFormat, RulerDrawer.this.textureManager)) != null) {
                RulerDrawer.this.spriteMap.put(d, texture);
            }
            return texture;
        }

        private Dimension computeSpriteDimension(double d) {
            Texture texture;
            Dimension dimension = this.spriteDimensionMap.get(d);
            if (dimension == null && (texture = (Texture)RulerDrawer.this.spriteMap.get(d)) != null) {
                dimension = texture.getDataProvider().getTextureSize();
                this.spriteDimensionMap.put(d, dimension);
            }
            return dimension;
        }

        private class PositionedSprite {
            private final Texture sprite;
            private final Vector3d windowPosition;
            private final Rectangle2D windowsBounds;

            public PositionedSprite(Texture texture, Vector3d vector3d) {
                this.windowPosition = vector3d;
                this.sprite = texture;
                Dimension dimension = texture.getDataProvider().getTextureSize();
                this.windowsBounds = new Rectangle2D.Double(vector3d.getX(), vector3d.getY(), dimension.width, dimension.height);
            }

            public PositionedSprite(Texture texture, Dimension dimension, Vector3d vector3d) {
                this.windowPosition = vector3d;
                this.sprite = texture;
                this.windowsBounds = new Rectangle2D.Double(vector3d.getX(), vector3d.getY(), dimension.width, dimension.height);
            }

            public Texture getSprite() {
                return this.sprite;
            }

            public Vector3d getWindowPosition() {
                return this.windowPosition;
            }

            public Rectangle2D getWindowBounds() {
                return this.windowsBounds;
            }
        }
    }
}

