/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.texture;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLProfile;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.texture.AbstractTexture;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationManager;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class JoGLTextureManager
implements TextureManager {
    private final Set<JoGLTexture> allTextures = Collections.synchronizedSet(new HashSet());
    JoGLCanvas canvas;

    public JoGLTextureManager(JoGLCanvas joGLCanvas) {
        this.canvas = joGLCanvas;
    }

    public void bind(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture) throws SciRendererException {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture)) {
            ((JoGLTexture)texture).bind(joGLDrawingTools);
        }
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture) throws SciRendererException {
        JoGLTexture joGLTexture;
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture) && (joGLTexture = (JoGLTexture)texture).preDraw(joGLDrawingTools, null)) {
            joGLTexture.draw(joGLDrawingTools);
            joGLTexture.postDraw(joGLDrawingTools);
        }
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, int n, int n2, double d, Color color, ElementsBuffer elementsBuffer2) throws SciRendererException {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture) && elementsBuffer != null) {
            FloatBuffer floatBuffer = elementsBuffer.getData();
            FloatBuffer floatBuffer2 = null;
            if (floatBuffer != null) {
                floatBuffer.rewind();
                if (elementsBuffer2 != null && (floatBuffer2 = elementsBuffer2.getData()) != null) {
                    floatBuffer2.rewind();
                    if (floatBuffer2.limit() != floatBuffer.limit()) {
                        throw new SciRendererException("Vertices do not have the same number of positions and colors");
                    }
                }
                float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray3 = null;
                if (color != null) {
                    fArray3 = new float[4];
                    color.getComponents(fArray3);
                }
                int n3 = 0;
                JoGLTexture joGLTexture = (JoGLTexture)texture;
                if (joGLTexture.preDraw(joGLDrawingTools, fArray3)) {
                    n2 = n2 < 1 ? 1 : n2;
                    int n4 = n = n < 0 ? 0 : n;
                    if (n2 == 1) {
                        n3 = 4 * n;
                        floatBuffer.position(n3);
                        if (floatBuffer2 != null) {
                            floatBuffer2.position(n3);
                        }
                        while (floatBuffer.remaining() >= 4) {
                            floatBuffer.get(fArray);
                            if (floatBuffer2 == null) {
                                joGLTexture.draw(joGLDrawingTools, anchorPosition, new Vector3d(fArray), d, null);
                                continue;
                            }
                            floatBuffer2.get(fArray2);
                            joGLTexture.draw(joGLDrawingTools, anchorPosition, new Vector3d(fArray), d, fArray2);
                        }
                    } else {
                        n3 = 4 * n;
                        if (n3 < floatBuffer.capacity()) {
                            floatBuffer.position(n3);
                            while (floatBuffer.remaining() >= 4) {
                                floatBuffer.get(fArray);
                                if (floatBuffer2 == null) {
                                    joGLTexture.draw(joGLDrawingTools, anchorPosition, new Vector3d(fArray), d, null);
                                } else {
                                    floatBuffer2.position(n3);
                                    floatBuffer2.get(fArray2);
                                    joGLTexture.draw(joGLDrawingTools, anchorPosition, new Vector3d(fArray), d, fArray2);
                                }
                                if ((n3 += n2 * 4) < floatBuffer.capacity()) {
                                    floatBuffer.position(n3);
                                    if (floatBuffer2 == null) continue;
                                    floatBuffer2.position(n3);
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                    joGLTexture.postDraw(joGLDrawingTools);
                }
            }
        }
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture, AnchorPosition anchorPosition, Vector3d vector3d, double d) throws SciRendererException {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture)) {
            JoGLTexture joGLTexture = (JoGLTexture)texture;
            joGLTexture.preDraw(joGLDrawingTools, null);
            joGLTexture.draw(joGLDrawingTools, anchorPosition, vector3d, d, null);
            joGLTexture.postDraw(joGLDrawingTools);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glReload() {
        Set<JoGLTexture> set = this.allTextures;
        synchronized (set) {
            for (JoGLTexture joGLTexture : this.allTextures) {
                joGLTexture.glReload();
            }
        }
    }

    @Override
    public org.scilab.forge.scirenderer.texture.Texture createTexture() {
        JoGLTexture joGLTexture = new JoGLTexture();
        this.allTextures.add(joGLTexture);
        return joGLTexture;
    }

    @Override
    public void dispose(Collection<org.scilab.forge.scirenderer.texture.Texture> collection) {
        for (org.scilab.forge.scirenderer.texture.Texture texture : collection) {
            this.dispose(texture);
        }
    }

    @Override
    public void dispose(org.scilab.forge.scirenderer.texture.Texture texture) {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture)) {
            this.allTextures.remove((JoGLTexture)texture);
            ((JoGLTexture)texture).dispose();
        }
    }

    private static class JoGLTextureData
    extends TextureData {
        private ByteBuffer data;
        private int shift;

        public JoGLTextureData(GLProfile gLProfile, int[] nArray, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int n6) {
            super(gLProfile, nArray[0], n, n2, 0, nArray[1], nArray[2], false, false, true, null, null);
            this.data = byteBuffer;
            this.shift = n3 == 0 && n4 == 0 || byteBuffer.capacity() == 0 ? 0 : byteBuffer.capacity() / (n5 * n6) * (n3 + n4 * n5);
            this.rowLength = n5;
            this.alignment = nArray[3];
        }

        public JoGLTextureData(GLProfile gLProfile, TextureDataProvider.ImageType imageType, ByteBuffer byteBuffer, int n, int n2) {
            this(gLProfile, JoGLTextureData.getInfos(imageType), byteBuffer, n, n2, 0, 0, n, n2);
        }

        public JoGLTextureData(GLProfile gLProfile, TextureDataProvider.ImageType imageType, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int n6) {
            this(gLProfile, JoGLTextureData.getInfos(imageType), byteBuffer, n, n2, n3, n4, n5, n6);
        }

        public ByteBuffer getBuffer() {
            if (this.shift == 0) {
                return this.data;
            }
            this.data.position(this.shift);
            ByteBuffer byteBuffer = this.data.slice();
            this.data.rewind();
            return byteBuffer;
        }

        public void setData(ByteBuffer byteBuffer) {
            this.data = byteBuffer;
        }

        public void destroy() {
            super.destroy();
            this.data = null;
        }

        public static int[] getInfos(TextureDataProvider.ImageType imageType) {
            switch (imageType) {
                case RGB: {
                    return new int[]{6407, 6407, 5121, 1};
                }
                case RGB_RGBA: {
                    return new int[]{6407, 6408, 32821, 4};
                }
                case BGR: {
                    return new int[]{6407, 32992, 5121, 1};
                }
                case GRAY: {
                    return new int[]{6409, 6409, 5121, 1};
                }
                case GRAY_16: {
                    return new int[]{32834, 6409, 5123, 2};
                }
                case RGBA: {
                    return new int[]{6408, 6408, 32821, 4};
                }
                case RGBA_REV: {
                    return new int[]{6408, 6408, 33639, 4};
                }
                case ABGR: {
                    return new int[]{6408, 32768, 5121, 1};
                }
                case RGB_332: {
                    return new int[]{10768, 6407, 32818, 1};
                }
                case RED: {
                    return new int[]{6403, 6403, 5121, 1};
                }
                case GREEN: {
                    return new int[]{32849, 6404, 5121, 1};
                }
                case BLUE: {
                    return new int[]{32849, 6405, 5121, 1};
                }
                case INTENSITY: {
                    return new int[]{32841, 6409, 5121, 1};
                }
                case RGBA_4444: {
                    return new int[]{32854, 6408, 32819, 2};
                }
                case RGBA_5551: {
                    return new int[]{32855, 6408, 32820, 2};
                }
                case RGB_FLOAT: {
                    return new int[]{34843, 6407, 5126, 4};
                }
                case RGBA_FLOAT: {
                    return new int[]{34842, 6408, 5126, 4};
                }
                case GRAY_FLOAT: {
                    return new int[]{34846, 6409, 5126, 4};
                }
                case RED_16: {
                    return new int[]{32852, 6403, 5123, 2};
                }
                case GREEN_16: {
                    return new int[]{32852, 6404, 5123, 2};
                }
                case BLUE_16: {
                    return new int[]{32852, 6405, 5123, 2};
                }
                case RED_FLOAT: {
                    return new int[]{34843, 6403, 5126, 4};
                }
                case GREEN_FLOAT: {
                    return new int[]{34843, 6404, 5126, 4};
                }
                case BLUE_FLOAT: {
                    return new int[]{34843, 6405, 5126, 4};
                }
                case RGBA_BYTE: {
                    return new int[]{6408, 6408, 5121, 1};
                }
            }
            return new int[]{6407, 6407, 5121, 1};
        }
    }

    public class JoGLTexture
    extends AbstractTexture
    implements org.scilab.forge.scirenderer.texture.Texture {
        private Texture[] textures;
        private JoGLTextureData[] textureData;
        private int wCuts;
        private int hCuts;
        private double sfactor = 1.0;
        private double tfactor = 1.0;
        private ByteBuffer buffer;
        private TextureDataProvider.ImageType previousType;
        private JoGLDrawingTools drawingTools;

        public final boolean isRowMajorOrder() {
            return this.getDataProvider().isRowMajorOrder();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void bind(JoGLDrawingTools joGLDrawingTools) throws SciRendererException {
            if (this.drawingTools == null) {
                this.drawingTools = this.drawingTools;
            }
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            if (!this.isValid()) throw new SciRendererException("Texture have no data.");
            this.checkData(joGLDrawingTools);
            if (this.textures.length != 1) throw new SciRendererException("Texture is too large");
            gL2.glEnable(3553);
            gL2.glEnable(3042);
            gL2.glBlendFunc(770, 771);
            gL2.glTexEnvi(8960, 8704, 7681);
            this.textures[0].setTexParameteri((GL)gL2, 10240, this.getAsGLFilter(this.getMagnificationFilter(), false));
            this.textures[0].setTexParameteri((GL)gL2, 10241, this.getAsGLFilter(this.getMinifyingFilter(), false));
            if (gL2.isNPOTTextureAvailable()) {
                this.textures[0].setTexParameteri((GL)gL2, 10242, this.getAsGLWrappingMode(this.getSWrappingMode()));
                this.textures[0].setTexParameteri((GL)gL2, 10243, this.getAsGLWrappingMode(this.getTWrappingMode()));
            } else {
                this.textures[0].setTexParameteri((GL)gL2, 10242, 33071);
                this.textures[0].setTexParameteri((GL)gL2, 10243, 33071);
            }
            this.textures[0].bind((GL)gL2);
            Dimension dimension = this.getDataProvider().getTextureSize();
            this.sfactor = (double)dimension.width / (double)this.textures[0].getWidth();
            this.tfactor = (double)dimension.height / (double)this.textures[0].getHeight();
        }

        private synchronized void checkData(JoGLDrawingTools joGLDrawingTools) throws SciRendererException {
            if (this.isValid() && !this.upToDate) {
                GL2 gL2 = joGLDrawingTools.getGl().getGL2();
                Dimension dimension = this.getDataProvider().getTextureSize();
                int n = joGLDrawingTools.getGLCapacity().getMaximumTextureSize();
                this.wCuts = (int)Math.ceil(dimension.getWidth() / (double)n);
                this.hCuts = (int)Math.ceil(dimension.getHeight() / (double)n);
                ByteBuffer byteBuffer = this.getDataProvider().getData();
                TextureDataProvider.ImageType imageType = this.getDataProvider().getImageType();
                if (byteBuffer != null && dimension.width != 0 && dimension.height != 0) {
                    boolean bl = false;
                    if (byteBuffer != this.buffer || imageType != this.previousType) {
                        this.releaseTextures(gL2);
                        if (byteBuffer != null) {
                            this.textures = new Texture[this.wCuts * this.hCuts];
                            this.textureData = new JoGLTextureData[this.wCuts * this.hCuts];
                        }
                        this.buffer = byteBuffer;
                        this.previousType = imageType;
                        bl = true;
                    }
                    if (byteBuffer != null || this.buffer != null) {
                        if (this.wCuts == 1 && this.hCuts == 1) {
                            if (bl) {
                                this.textureData[0] = this.isRowMajorOrder() ? new JoGLTextureData(gL2.getGLProfile(), imageType, this.buffer, dimension.width, dimension.height) : new JoGLTextureData(gL2.getGLProfile(), imageType, this.buffer, dimension.height, dimension.width);
                                try {
                                    this.textures[0] = TextureIO.newTexture((TextureData)this.textureData[0]);
                                }
                                catch (Exception exception) {
                                    System.err.println(exception);
                                }
                            } else {
                                try {
                                    this.textures[0].updateSubImage((GL)gL2, (TextureData)this.textureData[0], 0, 0, 0);
                                }
                                catch (Exception exception) {
                                    System.err.println(exception);
                                }
                            }
                        } else {
                            int n2 = 0;
                            for (int i = 0; i < this.wCuts; ++i) {
                                for (int j = 0; j < this.hCuts; ++j) {
                                    if (bl) {
                                        int n3 = i * n;
                                        int n4 = j * n;
                                        int n5 = this.getSubTextureSize(i == this.wCuts - 1, dimension.width, n);
                                        int n6 = this.getSubTextureSize(j == this.hCuts - 1, dimension.height, n);
                                        this.textureData[n2] = this.isRowMajorOrder() ? new JoGLTextureData(gL2.getGLProfile(), imageType, this.buffer, n5, n6, n3, n4, dimension.width, dimension.height) : new JoGLTextureData(gL2.getGLProfile(), imageType, this.buffer, n6, n5, n4, n3, dimension.height, dimension.width);
                                        this.textures[n2] = TextureIO.newTexture((TextureData)this.textureData[n2]);
                                    } else {
                                        this.textures[n2].updateSubImage((GL)gL2, (TextureData)this.textureData[n2], 0, 0, 0);
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }
                }
                if (this.textures != null) {
                    this.upToDate = true;
                }
            }
        }

        private void releaseTextures(GL2 gL2) {
            if (this.textures != null) {
                for (Texture texture : this.textures) {
                    if (texture == null) continue;
                    texture.destroy((GL)gL2);
                }
                this.textures = null;
            }
            if (this.textureData != null) {
                for (JoGLTextureData joGLTextureData : this.textureData) {
                    if (joGLTextureData == null) continue;
                    joGLTextureData.destroy();
                }
                this.textureData = null;
            }
        }

        public void dispose() {
            if (this.drawingTools != null) {
                this.releaseTextures(this.drawingTools.getGl().getGL2());
            }
        }

        public boolean preDraw(JoGLDrawingTools joGLDrawingTools, float[] fArray) throws SciRendererException {
            this.checkData(joGLDrawingTools);
            if (this.textures == null) {
                return false;
            }
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            gL2.glMatrixMode(5890);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5889);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glEnable(3553);
            gL2.glEnable(3042);
            gL2.glBlendFunc(770, 771);
            gL2.glEnable(3008);
            gL2.glAlphaFunc(516, 0.0f);
            gL2.glPushAttrib(1048575);
            gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (fArray != null) {
                gL2.glTexEnvfv(8960, 8705, fArray, 0);
                gL2.glTexEnvi(8960, 8704, 3042);
            } else {
                gL2.glTexEnvi(8960, 8704, 8448);
            }
            for (int i = 0; i < this.wCuts * this.hCuts; ++i) {
                this.textures[i].enable((GL)gL2);
                this.textures[i].setTexParameteri((GL)gL2, 10240, this.getAsGLFilter(this.getMagnificationFilter(), false));
                this.textures[i].setTexParameteri((GL)gL2, 10241, this.getAsGLFilter(this.getMinifyingFilter(), false));
                if (gL2.isNPOTTextureAvailable()) {
                    this.textures[i].setTexParameteri((GL)gL2, 10242, this.getAsGLWrappingMode(this.getSWrappingMode()));
                    this.textures[i].setTexParameteri((GL)gL2, 10243, this.getAsGLWrappingMode(this.getTWrappingMode()));
                    continue;
                }
                this.textures[i].setTexParameteri((GL)gL2, 10242, 33071);
                this.textures[i].setTexParameteri((GL)gL2, 10243, 33071);
            }
            return true;
        }

        public void draw(JoGLDrawingTools joGLDrawingTools, AnchorPosition anchorPosition, Vector3d vector3d, double d, float[] fArray) throws SciRendererException {
            TransformationManager transformationManager = joGLDrawingTools.getTransformationManager();
            Transformation transformation = transformationManager.getCanvasProjection();
            boolean bl = joGLDrawingTools.getTransformationManager().isUsingSceneCoordinate();
            Dimension dimension = joGLDrawingTools.getCanvas().getDimension();
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            Vector3d vector3d2 = bl ? transformation.project(vector3d) : vector3d;
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glOrtho(0.0, (double)dimension.width, 0.0, (double)dimension.height, 1.0, -1.0);
            if (d == 0.0) {
                gL2.glTranslated((double)Math.round(vector3d2.getX() + this.getAnchorDeltaX(anchorPosition)), (double)Math.round(vector3d2.getY() + this.getAnchorDeltaY(anchorPosition)), vector3d2.getZ());
            } else {
                gL2.glTranslated((double)Math.round(vector3d2.getX()), (double)Math.round(vector3d2.getY()), vector3d2.getZ());
                gL2.glRotated(d, 0.0, 0.0, 1.0);
                gL2.glTranslated((double)Math.round(this.getAnchorDeltaX(anchorPosition)), (double)Math.round(this.getAnchorDeltaY(anchorPosition)), 0.0);
            }
            this.draw(joGLDrawingTools, fArray);
            gL2.glMatrixMode(5888);
            gL2.glPopMatrix();
        }

        public void postDraw(JoGLDrawingTools joGLDrawingTools) {
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            for (int i = 0; i < this.wCuts * this.hCuts; ++i) {
                this.textures[i].disable((GL)gL2);
            }
            gL2.glPopAttrib();
            gL2.glDisable(3008);
            gL2.glDisable(3553);
            gL2.glDisable(3042);
            gL2.glMatrixMode(5889);
            gL2.glPopMatrix();
            gL2.glMatrixMode(5890);
            gL2.glPopMatrix();
        }

        public void draw(JoGLDrawingTools joGLDrawingTools) throws SciRendererException {
            this.draw(joGLDrawingTools, null);
        }

        public void draw(JoGLDrawingTools joGLDrawingTools, float[] fArray) throws SciRendererException {
            int n = joGLDrawingTools.getGLCapacity().getMaximumTextureSize();
            Dimension dimension = this.getDataProvider().getTextureSize();
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            if (dimension != null && this.textures != null) {
                if (this.wCuts == 1 && this.hCuts == 1) {
                    TextureCoords textureCoords = this.isRowMajorOrder() ? this.textures[0].getSubImageTexCoords(0, 0, dimension.width, dimension.height) : this.textures[0].getSubImageTexCoords(0, 0, dimension.height, dimension.width);
                    this.textures[0].bind((GL)gL2);
                    if (fArray != null) {
                        gL2.glColor4fv(fArray, 0);
                    }
                    gL2.glBegin(7);
                    gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
                    if (this.isRowMajorOrder()) {
                        gL2.glVertex2f(0.0f, 0.0f);
                    } else {
                        gL2.glVertex2f((float)dimension.width, (float)dimension.height);
                    }
                    gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
                    gL2.glVertex2f((float)dimension.width, 0.0f);
                    gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
                    if (this.isRowMajorOrder()) {
                        gL2.glVertex2f((float)dimension.width, (float)dimension.height);
                    } else {
                        gL2.glVertex2f(0.0f, 0.0f);
                    }
                    gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
                    gL2.glVertex2f(0.0f, (float)dimension.height);
                    gL2.glEnd();
                } else {
                    int n2 = 0;
                    for (int i = 0; i < this.wCuts; ++i) {
                        for (int j = 0; j < this.hCuts; ++j) {
                            int n3 = i * n;
                            int n4 = j * n;
                            int n5 = this.getSubTextureSize(i == this.wCuts - 1, dimension.width, n);
                            int n6 = this.getSubTextureSize(j == this.hCuts - 1, dimension.height, n);
                            TextureCoords textureCoords = this.isRowMajorOrder() ? this.textures[n2].getSubImageTexCoords(0, 0, n5, n6) : this.textures[n2].getSubImageTexCoords(0, 0, n6, n5);
                            this.textures[n2].bind((GL)gL2);
                            if (fArray != null) {
                                gL2.glColor4fv(fArray, 0);
                            }
                            gL2.glBegin(7);
                            gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
                            gL2.glVertex2f((float)n3, (float)(dimension.height - n4));
                            gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
                            if (this.isRowMajorOrder()) {
                                gL2.glVertex2f((float)(n3 + n5), (float)(dimension.height - n4));
                            } else {
                                gL2.glVertex2f((float)n3, (float)(dimension.height - n4 - n6));
                            }
                            gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
                            gL2.glVertex2f((float)(n3 + n5), (float)(dimension.height - n4 - n6));
                            gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
                            if (this.isRowMajorOrder()) {
                                gL2.glVertex2f((float)n3, (float)(dimension.height - n4 - n6));
                            } else {
                                gL2.glVertex2f((float)(n3 + n5), (float)(dimension.height - n4));
                            }
                            gL2.glEnd();
                            ++n2;
                        }
                    }
                }
            }
        }

        @Override
        public double getSScaleFactor() {
            return this.sfactor;
        }

        @Override
        public double getTScaleFactor() {
            return this.tfactor;
        }

        private int getSubTextureSize(boolean bl, int n, int n2) {
            if (bl) {
                int n3 = n % n2;
                if (n3 == 0) {
                    return n2;
                }
                return n3;
            }
            return n2;
        }

        private int getAsGLWrappingMode(Texture.Wrap wrap) {
            switch (wrap) {
                case CLAMP: {
                    return 33071;
                }
                case REPEAT: {
                    return 10497;
                }
            }
            return 10497;
        }

        private int getAsGLFilter(Texture.Filter filter, boolean bl) {
            int n;
            if (bl) {
                switch (filter) {
                    case LINEAR: {
                        n = 9987;
                        break;
                    }
                    case NEAREST: {
                        n = 9984;
                        break;
                    }
                    default: {
                        n = 9728;
                        break;
                    }
                }
            } else {
                switch (filter) {
                    case LINEAR: {
                        n = 9729;
                        break;
                    }
                    case NEAREST: {
                        n = 9728;
                        break;
                    }
                    default: {
                        n = 9728;
                    }
                }
            }
            return n;
        }

        public void glReload() {
            this.buffer = null;
            this.textures = null;
            this.upToDate = false;
        }

        protected double getAnchorDeltaX(AnchorPosition anchorPosition) {
            int n = this.getDataProvider().getTextureSize().width;
            switch (anchorPosition) {
                case LEFT: 
                case LOWER_LEFT: 
                case UPPER_LEFT: {
                    return 0.0;
                }
                case UP: 
                case CENTER: 
                case DOWN: {
                    return (float)(-n) / 2.0f;
                }
                case RIGHT: 
                case LOWER_RIGHT: 
                case UPPER_RIGHT: {
                    return -n;
                }
            }
            return 0.0;
        }

        protected double getAnchorDeltaY(AnchorPosition anchorPosition) {
            int n = this.getDataProvider().getTextureSize().height;
            switch (anchorPosition) {
                case UPPER_LEFT: 
                case UP: 
                case UPPER_RIGHT: {
                    return -n;
                }
                case LEFT: 
                case CENTER: 
                case RIGHT: {
                    return (float)(-n) / 2.0f;
                }
                case LOWER_LEFT: 
                case DOWN: 
                case LOWER_RIGHT: {
                    return 0.0;
                }
            }
            return 0.0;
        }
    }
}

