/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.renderer;

import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.renderer.Renderer;

public class JoGLRenderer
implements Renderer {
    private Drawer drawer = null;
    private Integer glName = null;
    private boolean upToDate = false;

    JoGLRenderer() {
    }

    @Override
    public void setDrawer(Drawer drawer) {
        this.drawer = drawer;
        this.upToDate = false;
    }

    @Override
    public Drawer getDrawer() {
        return this.drawer;
    }

    @Override
    public void reload() {
        this.glName = null;
        this.upToDate = false;
    }

    public void draw(JoGLDrawingTools joGLDrawingTools) {
        if (joGLDrawingTools.getCanvas().getJoGLParameters().useDisplayList()) {
            this.synchronize(joGLDrawingTools);
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            gL2.glCallList(this.glName.intValue());
        } else if (this.drawer != null) {
            this.drawer.draw(joGLDrawingTools);
        }
    }

    private void synchronize(JoGLDrawingTools joGLDrawingTools) {
        GL2 gL2 = joGLDrawingTools.getGl().getGL2();
        if (this.glName == null || !gL2.glIsList(this.glName.intValue())) {
            this.glName = gL2.glGenLists(1);
            this.upToDate = false;
        }
        if (!this.upToDate) {
            gL2.glNewList(this.glName.intValue(), 4864);
            if (this.drawer != null) {
                this.drawer.draw(joGLDrawingTools);
            }
            gL2.glEndList();
            this.upToDate = true;
        }
    }

    void dispose(GL2 gL2) {
        if (this.glName != null && gL2.glIsList(this.glName.intValue())) {
            gL2.glDeleteLists(this.glName.intValue(), 1);
            this.glName = null;
            this.upToDate = false;
        }
    }
}

