/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.lightning;

import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.lightning.JoGLLight;
import org.scilab.forge.scirenderer.implementation.jogl.utils.GLShortCuts;
import org.scilab.forge.scirenderer.lightning.Light;
import org.scilab.forge.scirenderer.lightning.LightManager;
import org.scilab.forge.scirenderer.shapes.appearance.Material;

public class JoGLLightManager
implements LightManager {
    private final JoGLDrawingTools drawingTools;
    private final JoGLLight[] lights;
    private boolean isLightningEnable = false;

    public JoGLLightManager(JoGLDrawingTools joGLDrawingTools) {
        this.drawingTools = joGLDrawingTools;
        this.lights = new JoGLLight[this.getLightNumber()];
    }

    @Override
    public int getLightNumber() {
        return this.drawingTools.getGLCapacity().getLightNumber();
    }

    @Override
    public Light getLight(int n) {
        if (n < 0 || n >= this.getLightNumber()) {
            return null;
        }
        if (this.lights[n] == null) {
            this.lights[n] = new JoGLLight(this.drawingTools.getGl(), n);
        }
        return this.lights[n];
    }

    @Override
    public void setLightningEnable(boolean bl) {
        this.isLightningEnable = bl;
        GLShortCuts.setEnable(this.drawingTools.getGl().getGL2(), 2896, bl);
    }

    @Override
    public boolean isLightningEnable() {
        return this.isLightningEnable;
    }

    @Override
    public void setMaterial(Material material) {
        if (material != null) {
            GLShortCuts.setEnable(this.drawingTools.getGl().getGL2(), 2903, material.isColorMaterialEnable());
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            this.drawingTools.getGl().glLightModelfv(2899, fArray, 0);
            this.drawingTools.getGl().glLightModeli(2897, 0);
            this.drawingTools.getGl().glLightModeli(2898, 1);
            if (material.isColorMaterialEnable()) {
                this.drawingTools.getGl().glColorMaterial(1032, 5634);
            } else {
                this.drawingTools.getGl().glMaterialfv(1032, 4608, material.getAmbientColor().getComponents(null), 0);
                this.drawingTools.getGl().glMaterialfv(1032, 4609, material.getDiffuseColor().getComponents(null), 0);
            }
            this.drawingTools.getGl().glMaterialfv(1032, 4610, material.getSpecularColor().getComponents(null), 0);
            this.drawingTools.getGl().glMaterialf(1032, 5633, material.getShininess());
            float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.drawingTools.getGl().glMaterialfv(1032, 5632, fArray2, 0);
        }
    }

    public void reload() {
        GL2 gL2 = this.drawingTools.getGl().getGL2();
        GLShortCuts.setEnable(gL2, 2896, this.isLightningEnable);
        for (JoGLLight joGLLight : this.lights) {
            if (joGLLight == null || !joGLLight.isEnable()) continue;
            joGLLight.reload(gL2);
        }
    }
}

