/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.lightning;

import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.implementation.jogl.utils.GLShortCuts;
import org.scilab.forge.scirenderer.lightning.Light;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class JoGLLight
implements Light {
    private final int index;
    private GL2 gl;
    private boolean isEnable;
    private Color ambientColor = new Color(0.0f, 0.0f, 0.0f);
    private Color diffuseColor = new Color(0.0f, 0.0f, 0.0f);
    private Color specularColor = new Color(0.0f, 0.0f, 0.0f);
    private Vector3d position = new Vector3d(0.0, 0.0, 0.0);
    private Vector3d spotDirection = new Vector3d(0.0, 0.0, 1.0);
    private Vector3d direction = new Vector3d(0.0, 0.0, 0.0);
    private float spotAngle = 180.0f;
    private boolean isDirectional = false;

    public JoGLLight(GL2 gL2, int n) {
        this.gl = gL2;
        this.index = n;
    }

    public void reload(GL2 gL2) {
        this.gl = gL2;
        GLShortCuts.setEnable(gL2, 16384 + this.index, this.isEnable);
        gL2.glLightfv(16384 + this.index, 4608, this.ambientColor.getRGBComponents(null), 0);
        gL2.glLightfv(16384 + this.index, 4609, this.diffuseColor.getRGBComponents(null), 0);
        gL2.glLightfv(16384 + this.index, 4610, this.specularColor.getRGBComponents(null), 0);
        if (this.isDirectional) {
            float[] fArray = this.position.getDataAsFloatArray(4);
            fArray[3] = 0.0f;
            fArray[0] = -fArray[0];
            fArray[1] = -fArray[1];
            fArray[2] = -fArray[2];
            gL2.glLightfv(16384 + this.index, 4611, fArray, 0);
        } else {
            float[] fArray = this.position.getDataAsFloatArray(4);
            fArray[3] = 1.0f;
            gL2.glLightfv(16384 + this.index, 4611, fArray, 0);
        }
        gL2.glLightfv(16384 + this.index, 4612, this.spotDirection.getDataAsFloatArray(4), 0);
    }

    @Override
    public boolean isEnable() {
        return this.isEnable;
    }

    @Override
    public void setEnable(boolean bl) {
        if (bl != this.isEnable) {
            this.isEnable = bl;
            GLShortCuts.setEnable(this.gl, 16384 + this.index, this.isEnable);
        }
    }

    @Override
    public Color getAmbientColor() {
        return this.ambientColor;
    }

    @Override
    public void setAmbientColor(Color color) {
        if (color != null) {
            this.ambientColor = color;
            this.gl.glLightfv(16384 + this.index, 4608, this.ambientColor.getRGBComponents(null), 0);
        }
    }

    @Override
    public Color getDiffuseColor() {
        return this.diffuseColor;
    }

    @Override
    public void setDiffuseColor(Color color) {
        if (color != null) {
            this.diffuseColor = color;
            this.gl.glLightfv(16384 + this.index, 4609, this.diffuseColor.getRGBComponents(null), 0);
        }
    }

    @Override
    public Color getSpecularColor() {
        return this.specularColor;
    }

    @Override
    public void setSpecularColor(Color color) {
        if (color != null) {
            this.specularColor = color;
            this.gl.glLightfv(16384 + this.index, 4610, this.specularColor.getRGBComponents(null), 0);
        }
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d vector3d) {
        if (vector3d != null) {
            this.isDirectional = false;
            this.position = vector3d;
            float[] fArray = vector3d.getDataAsFloatArray(4);
            fArray[3] = 1.0f;
            this.gl.glLightfv(16384 + this.index, 4611, fArray, 0);
        }
    }

    @Override
    public Vector3d getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Vector3d vector3d) {
        if (vector3d != null) {
            this.isDirectional = true;
            this.direction = vector3d;
            float[] fArray = vector3d.getDataAsFloatArray(4);
            fArray[3] = 0.0f;
            fArray[0] = -fArray[0];
            fArray[1] = -fArray[1];
            fArray[2] = -fArray[2];
            this.gl.glLightfv(16384 + this.index, 4611, fArray, 0);
        }
    }

    @Override
    public Vector3d getSpotDirection() {
        return this.spotDirection;
    }

    @Override
    public void setSpotDirection(Vector3d vector3d) {
        if (vector3d != null) {
            this.spotDirection = vector3d;
            this.gl.glLightfv(16384 + this.index, 4612, vector3d.getNormalized().getDataAsFloatArray(4), 0);
        }
    }

    @Override
    public float getSpotAngle() {
        return this.spotAngle;
    }

    @Override
    public void setSpotAngle(float f) {
        if (f != this.spotAngle) {
            this.spotAngle = f;
            this.gl.glLightf(16384 + this.index, 4614, this.spotAngle);
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

