/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.drawer;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.buffers.JoGLBuffersManager;
import org.scilab.forge.scirenderer.implementation.jogl.utils.GLShortCuts;
import org.scilab.forge.scirenderer.lightning.LightManager;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.Texture;

public final class JoGLShapeDrawer {
    private static JoGLShapeDrawer drawer;

    private JoGLShapeDrawer() {
    }

    public static JoGLShapeDrawer getDrawer() {
        if (drawer == null) {
            drawer = new JoGLShapeDrawer();
        }
        return drawer;
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, Geometry geometry, Appearance appearance) throws SciRendererException {
        GL2 gL2 = joGLDrawingTools.getGl().getGL2();
        gL2.glFrontFace(2305);
        switch (geometry.getFaceCullingMode()) {
            case CW: {
                gL2.glEnable(2884);
                gL2.glCullFace(1028);
                break;
            }
            case CCW: {
                gL2.glEnable(2884);
                gL2.glCullFace(1029);
                break;
            }
            case BOTH: {
                gL2.glDisable(2884);
                break;
            }
            default: {
                gL2.glDisable(2884);
            }
        }
        gL2.glEnable(3058);
        gL2.glLogicOp(joGLDrawingTools.getGLPixelDrawingMode());
        if (joGLDrawingTools.getCanvas().getJoGLParameters().useVBO()) {
            this.vboDrawing(joGLDrawingTools, geometry, appearance);
        } else {
            this.directDrawing(joGLDrawingTools, geometry, appearance);
        }
        gL2.glDisable(3058);
        GLShortCuts.useLineAppearance(gL2, null);
        gL2.glDisable(2884);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vboDrawing(JoGLDrawingTools joGLDrawingTools, Geometry geometry, Appearance appearance) throws SciRendererException {
        int n;
        Object object;
        GL2 gL2 = joGLDrawingTools.getGl().getGL2();
        JoGLBuffersManager joGLBuffersManager = joGLDrawingTools.getCanvas().getBuffersManager();
        Texture texture = appearance.getTexture();
        int n2 = joGLBuffersManager.bindVertexBuffer(gL2, geometry.getVertices());
        if (n2 == 0) {
            gL2.glDisableClientState(32884);
            return;
        }
        joGLBuffersManager.bindNormalsBuffer(gL2, geometry.getNormals());
        if (texture != null && geometry.getTextureCoordinates() != null) {
            object = texture;
            synchronized (object) {
                if (texture.isValid()) {
                    joGLDrawingTools.bind(texture);
                    joGLBuffersManager.bindTextureCoordinatesBuffer(gL2, geometry.getTextureCoordinates());
                }
            }
        } else {
            joGLBuffersManager.bindColorsBuffer(gL2, geometry.getColors());
        }
        if (geometry.getPolygonOffsetMode()) {
            gL2.glEnable(32823);
            gL2.glPolygonOffset(1.0f, 1.0f);
        }
        GLShortCuts.useColor(gL2, appearance.getFillColor());
        object = joGLDrawingTools.getLightManager();
        boolean bl = object.isLightningEnable();
        if (bl) {
            object.setMaterial(appearance.getMaterial());
            gL2.glEnable(2977);
        }
        IndicesBuffer indicesBuffer = geometry.getIndices();
        if (geometry.getFillDrawingMode() != Geometry.FillDrawingMode.NONE) {
            if (indicesBuffer != null) {
                n = joGLBuffersManager.bindIndicesBuffer(gL2, indicesBuffer);
                if (n > 0) {
                    gL2.glDrawElements(this.getGlMode(geometry.getFillDrawingMode()), n, 5125, 0L);
                    gL2.glBindBuffer(34963, 0);
                }
            } else {
                n = geometry.getVertices().getSize();
                if (n > 0) {
                    gL2.glDrawArrays(this.getGlMode(geometry.getFillDrawingMode()), 0, n);
                }
            }
        }
        if (geometry.getPolygonOffsetMode()) {
            gL2.glDisable(32823);
        }
        gL2.glDisableClientState(32886);
        gL2.glDisableClientState(32885);
        gL2.glDisableClientState(32888);
        gL2.glDisable(3553);
        object.setLightningEnable(false);
        gL2.glDisable(2977);
        if (geometry.getLineDrawingMode() != Geometry.LineDrawingMode.NONE) {
            gL2.glShadeModel(7424);
            if (appearance.getLineColor() != null || geometry.getColors() != null) {
                GLShortCuts.useLineAppearance(gL2, appearance);
                if (appearance.getLineColor() == null) {
                    joGLBuffersManager.bindColorsBuffer(gL2, geometry.getColors());
                }
                if (geometry.getWireIndices() != null) {
                    n = joGLBuffersManager.bindIndicesBuffer(gL2, geometry.getWireIndices());
                    if (n > 0) {
                        gL2.glDrawElements(this.getGlMode(geometry.getLineDrawingMode()), n, 5125, 0L);
                        gL2.glBindBuffer(34963, 0);
                    }
                } else {
                    n = geometry.getVertices().getSize();
                    if (n > 0) {
                        gL2.glDrawArrays(this.getGlMode(geometry.getLineDrawingMode()), 0, n);
                    }
                }
                gL2.glDisableClientState(32886);
            }
        }
        gL2.glDisableClientState(32884);
        object.setLightningEnable(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directDrawing(JoGLDrawingTools joGLDrawingTools, Geometry geometry, Appearance appearance) throws SciRendererException {
        int n;
        IntBuffer intBuffer;
        LightManager lightManager;
        boolean bl;
        double d;
        double d2;
        FloatBuffer floatBuffer;
        float[] fArray = new float[4];
        GL2 gL2 = joGLDrawingTools.getGl().getGL2();
        if (geometry.getVertices() == null) {
            return;
        }
        FloatBuffer floatBuffer2 = geometry.getVertices().getData();
        IndicesBuffer indicesBuffer = geometry.getIndices();
        FloatBuffer floatBuffer3 = geometry.getColors() != null ? geometry.getColors().getData() : null;
        FloatBuffer floatBuffer4 = geometry.getNormals() != null ? geometry.getNormals().getData() : null;
        Texture texture = appearance.getTexture();
        if (texture != null && geometry.getTextureCoordinates() != null) {
            Texture texture2 = texture;
            synchronized (texture2) {
                joGLDrawingTools.bind(texture);
                floatBuffer = geometry.getTextureCoordinates().getData();
                d2 = texture.getSScaleFactor();
                d = texture.getTScaleFactor();
            }
        } else {
            floatBuffer = null;
            d2 = 1.0;
            d = 1.0;
        }
        if (geometry.getPolygonOffsetMode()) {
            gL2.glEnable(32823);
            gL2.glPolygonOffset(1.0f, 1.0f);
        }
        if (bl = (lightManager = joGLDrawingTools.getLightManager()).isLightningEnable()) {
            lightManager.setMaterial(appearance.getMaterial());
        }
        if (geometry.getFillDrawingMode() != Geometry.FillDrawingMode.NONE) {
            GLShortCuts.useColor(gL2, appearance.getFillColor());
            gL2.glShadeModel(7424);
            gL2.glBegin(this.getGlMode(geometry.getFillDrawingMode()));
            if (indicesBuffer != null) {
                intBuffer = indicesBuffer.getData();
                intBuffer.rewind();
                for (n = 0; n < intBuffer.limit(); ++n) {
                    int n2 = intBuffer.get(n);
                    if (n2 * 4 >= floatBuffer2.limit()) continue;
                    if (floatBuffer3 != null) {
                        floatBuffer3.position(n2 * 4);
                        gL2.glColor4fv(floatBuffer3);
                    }
                    if (floatBuffer4 != null) {
                        floatBuffer4.position(n2 * 4);
                        gL2.glNormal3fv(floatBuffer4);
                    }
                    if (floatBuffer != null) {
                        floatBuffer.position(n2 * 4);
                        floatBuffer.get(fArray);
                        gL2.glTexCoord4f((float)(d2 * (double)fArray[0]), (float)(d * (double)fArray[1]), fArray[2], fArray[3]);
                    }
                    floatBuffer2.position(n2 * 4);
                    gL2.glVertex4fv(floatBuffer2);
                }
            } else {
                floatBuffer2.rewind();
                if (floatBuffer3 != null) {
                    floatBuffer3.rewind();
                }
                if (floatBuffer4 != null) {
                    floatBuffer4.rewind();
                }
                for (int i = 0; i < floatBuffer2.limit(); i += 4) {
                    if (floatBuffer3 != null) {
                        floatBuffer3.position(i);
                        gL2.glColor4fv(floatBuffer3);
                    }
                    if (floatBuffer4 != null) {
                        floatBuffer4.position(i);
                        gL2.glNormal3fv(floatBuffer4);
                    }
                    if (floatBuffer != null) {
                        floatBuffer.position(i);
                        gL2.glTexCoord4fv(floatBuffer);
                    }
                    floatBuffer2.position(i);
                    gL2.glVertex4fv(floatBuffer2);
                }
            }
            gL2.glEnd();
        }
        if (geometry.getPolygonOffsetMode()) {
            gL2.glDisable(32823);
        }
        gL2.glDisable(3553);
        lightManager.setLightningEnable(false);
        if (geometry.getLineDrawingMode() != Geometry.LineDrawingMode.NONE) {
            GLShortCuts.useLineAppearance(gL2, appearance);
            if (appearance.getLineColor() != null) {
                gL2.glBegin(this.getGlMode(geometry.getLineDrawingMode()));
                if (geometry.getWireIndices() != null) {
                    intBuffer = geometry.getWireIndices().getData();
                    intBuffer.rewind();
                    while (intBuffer.remaining() != 0) {
                        n = intBuffer.get();
                        if (n * 4 >= floatBuffer2.limit()) continue;
                        floatBuffer2.position(n * 4);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                } else {
                    for (int i = 0; i < floatBuffer2.limit(); i += 4) {
                        floatBuffer2.position(i);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                }
                gL2.glEnd();
            } else if (floatBuffer3 != null) {
                gL2.glBegin(this.getGlMode(geometry.getLineDrawingMode()));
                if (geometry.getWireIndices() != null) {
                    intBuffer = geometry.getWireIndices().getData();
                    intBuffer.rewind();
                    while (intBuffer.remaining() != 0) {
                        n = intBuffer.get();
                        if (n * 4 >= floatBuffer2.limit()) continue;
                        floatBuffer3.position(n * 4);
                        gL2.glColor4fv(floatBuffer3);
                        floatBuffer2.position(n * 4);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                } else {
                    for (int i = 0; i < floatBuffer2.limit(); i += 4) {
                        floatBuffer3.position(i);
                        floatBuffer2.position(i);
                        gL2.glColor4fv(floatBuffer3);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                }
                gL2.glEnd();
            }
        }
        lightManager.setLightningEnable(bl);
    }

    private int getGlMode(Geometry.FillDrawingMode fillDrawingMode) {
        switch (fillDrawingMode) {
            case TRIANGLE_FAN: {
                return 6;
            }
            case TRIANGLE_STRIP: {
                return 5;
            }
            case TRIANGLES: {
                return 4;
            }
        }
        return 4;
    }

    private int getGlMode(Geometry.LineDrawingMode lineDrawingMode) {
        switch (lineDrawingMode) {
            case SEGMENTS: {
                return 1;
            }
            case SEGMENTS_LOOP: {
                return 2;
            }
            case SEGMENTS_STRIP: {
                return 3;
            }
        }
        return 1;
    }
}

