/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.clipping;

import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.clipping.ClippingPlane;
import org.scilab.forge.scirenderer.implementation.jogl.utils.GLShortCuts;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public class JoGLClippingPlane
implements ClippingPlane {
    private final int index;
    private GL2 gl;
    private boolean isEnable = false;
    private Vector4d equation = new Vector4d(0.0, 0.0, 0.0, 0.0);
    private Transformation transformation = TransformationFactory.getIdentity();

    public JoGLClippingPlane(GL2 gL2, int n) {
        this.index = n;
        this.reload(gL2);
    }

    @Override
    public boolean isEnable() {
        return this.isEnable;
    }

    @Override
    public void setEnable(boolean bl) {
        this.isEnable = bl;
        GLShortCuts.setEnable(this.gl, 12288 + this.getIndex(), bl);
    }

    @Override
    public void setEquation(Vector4d vector4d) {
        this.equation = vector4d;
        this.setGLEquation();
    }

    @Override
    public Vector4d getEquation() {
        return this.equation;
    }

    @Override
    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
        this.setGLEquation();
    }

    @Override
    public Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    void reload(GL2 gL2) {
        this.gl = gL2;
        GLShortCuts.setEnable(gL2, 12288 + this.getIndex(), this.isEnable());
        this.setGLEquation();
    }

    private void setGLEquation() {
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        if (this.transformation == null) {
            this.gl.glLoadIdentity();
        } else {
            this.gl.glLoadMatrixd(this.transformation.getMatrix(), 0);
        }
        this.gl.glClipPlane(12288 + this.getIndex(), this.equation.getData(), 0);
        this.gl.glPopMatrix();
    }
}

