/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.buffers;

import java.nio.Buffer;
import javax.media.opengl.GL;
import org.scilab.forge.scirenderer.buffers.DataBuffer;

public abstract class JoGLDataBuffer
implements DataBuffer {
    private boolean dataUploaded = false;
    private Integer glName = null;

    JoGLDataBuffer() {
    }

    public void reload() {
        this.glName = null;
        this.dataUploaded = false;
    }

    public void dispose(GL gL) {
        if (this.glName != null && gL.glIsBuffer(this.glName.intValue())) {
            int[] nArray = new int[]{this.glName};
            gL.glDeleteBuffers(1, nArray, 0);
            this.glName = null;
            this.dataUploaded = false;
        }
    }

    public int disposeWithoutDelete(GL gL) {
        if (this.glName != null && gL.glIsBuffer(this.glName.intValue())) {
            int n = this.glName;
            this.glName = null;
            this.dataUploaded = false;
            return n;
        }
        return -1;
    }

    protected void synchronize(GL gL) {
        if (this.glName == null || !gL.glIsBuffer(this.glName.intValue())) {
            int[] nArray = new int[1];
            gL.glGenBuffers(1, nArray, 0);
            this.glName = nArray[0];
            this.dataUploaded = false;
        }
        if (!this.dataUploaded) {
            gL.glBindBuffer(this.getGLBindDestination(), this.glName.intValue());
            gL.glBufferData(this.getGLBindDestination(), (long)this.getByteSize(), this.getByteBuffer(), 35044);
            gL.glBindBuffer(this.getGLBindDestination(), 0);
            this.dataUploaded = true;
        }
    }

    protected boolean isDataUploaded() {
        return this.dataUploaded;
    }

    protected void setDataUploaded(boolean bl) {
        this.dataUploaded = bl;
    }

    protected Integer getGlName(GL gL) {
        this.synchronize(gL);
        return this.glName;
    }

    protected abstract Buffer getByteBuffer();

    protected abstract int getGLBindDestination();

    public abstract int getByteSize();

    @Override
    public abstract void clear();
}

