/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.buffers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.buffers.BuffersManager;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.buffers.JoGLDataBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.buffers.JoGLElementsBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.buffers.JoGLIndicesBuffer;

public final class JoGLBuffersManager
implements BuffersManager {
    private final Set<JoGLDataBuffer> buffers = new HashSet<JoGLDataBuffer>();
    private final Stack<JoGLDataBuffer> deadBuffers = new Stack();

    @Override
    public synchronized ElementsBuffer createElementsBuffer() {
        JoGLElementsBuffer joGLElementsBuffer = new JoGLElementsBuffer();
        this.buffers.add(joGLElementsBuffer);
        return joGLElementsBuffer;
    }

    @Override
    public synchronized IndicesBuffer createIndicesBuffer() {
        JoGLIndicesBuffer joGLIndicesBuffer = new JoGLIndicesBuffer();
        this.buffers.add(joGLIndicesBuffer);
        return joGLIndicesBuffer;
    }

    @Override
    public synchronized void dispose(DataBuffer dataBuffer) {
        JoGLDataBuffer joGLDataBuffer = this.getLocalBuffer(dataBuffer);
        if (joGLDataBuffer != null) {
            this.buffers.remove(joGLDataBuffer);
            joGLDataBuffer.clear();
            this.deadBuffers.push(joGLDataBuffer);
        }
    }

    @Override
    public synchronized void dispose(Collection<? extends DataBuffer> collection) {
        for (DataBuffer dataBuffer : collection) {
            this.dispose(dataBuffer);
        }
    }

    public synchronized void glReload() {
        for (JoGLDataBuffer joGLDataBuffer : this.buffers) {
            joGLDataBuffer.reload();
        }
    }

    public synchronized void glSynchronize(GL2 gL2) {
        int[] nArray = new int[this.deadBuffers.size()];
        int n = 0;
        while (!this.deadBuffers.isEmpty()) {
            int n2 = this.deadBuffers.pop().disposeWithoutDelete((GL)gL2);
            if (n2 == -1) continue;
            nArray[n++] = n2;
        }
        if (n != 0) {
            gL2.glDeleteBuffers(n, nArray, 0);
        }
    }

    public int bindVertexBuffer(GL2 gL2, ElementsBuffer elementsBuffer) {
        JoGLElementsBuffer joGLElementsBuffer = this.getLocalElementsBuffer(elementsBuffer);
        if (joGLElementsBuffer != null) {
            return joGLElementsBuffer.bindAsVertexBuffer(gL2);
        }
        return 0;
    }

    public int bindNormalsBuffer(GL2 gL2, ElementsBuffer elementsBuffer) {
        JoGLElementsBuffer joGLElementsBuffer = this.getLocalElementsBuffer(elementsBuffer);
        if (joGLElementsBuffer != null) {
            return joGLElementsBuffer.bindAsNormalsBuffer(gL2);
        }
        return 0;
    }

    public int bindTextureCoordinatesBuffer(GL2 gL2, ElementsBuffer elementsBuffer) {
        JoGLElementsBuffer joGLElementsBuffer = this.getLocalElementsBuffer(elementsBuffer);
        if (joGLElementsBuffer != null) {
            return joGLElementsBuffer.bindAsTextureCoordinatesBuffer(gL2);
        }
        return 0;
    }

    public int bindColorsBuffer(GL2 gL2, ElementsBuffer elementsBuffer) {
        JoGLElementsBuffer joGLElementsBuffer = this.getLocalElementsBuffer(elementsBuffer);
        if (joGLElementsBuffer != null) {
            return joGLElementsBuffer.bindAsColorsBuffer(gL2);
        }
        return 0;
    }

    public int bindIndicesBuffer(GL2 gL2, IndicesBuffer indicesBuffer) {
        JoGLDataBuffer joGLDataBuffer = this.getLocalBuffer(indicesBuffer);
        if (joGLDataBuffer != null) {
            gL2.glBindBuffer(34963, joGLDataBuffer.getGlName((GL)gL2).intValue());
            return indicesBuffer.getSize();
        }
        return 0;
    }

    private synchronized JoGLDataBuffer getLocalBuffer(DataBuffer dataBuffer) {
        JoGLDataBuffer joGLDataBuffer;
        if (dataBuffer instanceof JoGLDataBuffer && this.buffers.contains(joGLDataBuffer = (JoGLDataBuffer)dataBuffer)) {
            return joGLDataBuffer;
        }
        return null;
    }

    private synchronized JoGLIndicesBuffer getLocalIndicesBuffer(IndicesBuffer indicesBuffer) {
        JoGLIndicesBuffer joGLIndicesBuffer;
        if (indicesBuffer instanceof JoGLIndicesBuffer && this.buffers.contains(joGLIndicesBuffer = (JoGLIndicesBuffer)indicesBuffer)) {
            return joGLIndicesBuffer;
        }
        return null;
    }

    private synchronized JoGLElementsBuffer getLocalElementsBuffer(ElementsBuffer elementsBuffer) {
        JoGLElementsBuffer joGLElementsBuffer;
        if (elementsBuffer instanceof JoGLElementsBuffer && this.buffers.contains(joGLElementsBuffer = (JoGLElementsBuffer)elementsBuffer)) {
            return joGLElementsBuffer;
        }
        return null;
    }
}

