/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl;

import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Semaphore;
import javax.media.opengl.DebugGL2;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import javax.swing.SwingUtilities;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLParameters;
import org.scilab.forge.scirenderer.implementation.jogl.buffers.JoGLBuffersManager;
import org.scilab.forge.scirenderer.implementation.jogl.picking.JoGLPickingManager;
import org.scilab.forge.scirenderer.implementation.jogl.renderer.JoGLRendererManager;
import org.scilab.forge.scirenderer.implementation.jogl.texture.JoGLTextureManager;
import org.scilab.forge.scirenderer.picking.PickingManager;
import org.scilab.forge.scirenderer.renderer.Renderer;

public final class JoGLCanvas
implements Canvas,
GLEventListener {
    private static final double[][][] ANTI_ALIASING_JITTER = new double[][][]{new double[][]{{0.0, 0.0}}, new double[][]{{0.5, 0.5}, {0.5, -0.5}}, new double[][]{{-0.25, -0.5}, {0.25, 0.5}, {0.75, -0.5}, {0.25, 0.5}}, new double[][]{{0.125, -0.125}, {-0.875, 0.875}, {-0.375, 0.375}, {0.375, 0.625}, {0.625, -0.625}, {0.875, 0.125}, {-0.125, -0.875}, {-0.625, -0.375}}, new double[][]{{-0.25, -0.125}, {0.25, -0.875}, {0.75, -0.625}, {-0.75, -0.875}, {-0.25, 0.375}, {0.75, -0.125}, {0.25, 0.125}, {-0.25, 0.875}, {0.25, -0.375}, {-0.75, 0.125}, {-0.75, 0.625}, {-0.25, -0.625}, {0.75, 0.875}, {0.75, 0.375}, {-0.75, -0.375}, {0.25, 0.625}}};
    private final GLAutoDrawable autoDrawable;
    private final JoGLDrawingTools drawingTools;
    private final JoGLParameters parameters;
    private final JoGLBuffersManager buffersManager;
    private final JoGLRendererManager rendererManager;
    private final JoGLPickingManager pickingManager;
    private final JoGLTextureManager textureManager;
    private final CanvasAnimator canvasAnimator;
    private boolean isOffscreen;
    private DebugGL2 debug;
    private boolean isValid = true;
    private boolean displayFinished;
    private Drawer mainDrawer;
    private int antiAliasingLevel = 0;

    JoGLCanvas(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = gLAutoDrawable;
        this.parameters = new JoGLParameters();
        this.buffersManager = new JoGLBuffersManager();
        this.rendererManager = new JoGLRendererManager();
        this.drawingTools = new JoGLDrawingTools(this);
        this.pickingManager = new JoGLPickingManager(this);
        this.textureManager = new JoGLTextureManager(this);
        gLAutoDrawable.addGLEventListener((GLEventListener)this);
        this.canvasAnimator = new CanvasAnimator(gLAutoDrawable);
        this.canvasAnimator.redraw();
    }

    JoGLCanvas(int n, int n2) {
        this(JoGLCanvas.getOffscreenDrawable(n, n2));
        this.isOffscreen = true;
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl ? new DebugGL2(this.autoDrawable.getGL().getGL2()) : null;
    }

    @Override
    public void setMainDrawer(Drawer drawer) {
        this.mainDrawer = drawer;
    }

    @Override
    public Drawer getMainDrawer() {
        return this.mainDrawer;
    }

    @Override
    public JoGLRendererManager getRendererManager() {
        return this.rendererManager;
    }

    @Override
    public JoGLBuffersManager getBuffersManager() {
        return this.buffersManager;
    }

    @Override
    public PickingManager getPickingManager() {
        return this.pickingManager;
    }

    @Override
    public JoGLTextureManager getTextureManager() {
        return this.textureManager;
    }

    @Override
    public int getWidth() {
        return this.autoDrawable.getSurfaceWidth();
    }

    @Override
    public int getHeight() {
        return this.autoDrawable.getSurfaceHeight();
    }

    @Override
    public Dimension getDimension() {
        return new Dimension(this.autoDrawable.getSurfaceWidth(), this.autoDrawable.getSurfaceHeight());
    }

    @Override
    public void redraw() {
        this.canvasAnimator.redraw();
    }

    @Override
    public void redrawAndWait() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.autoDrawable != null) {
                this.autoDrawable.display();
            }
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JoGLCanvas.this.autoDrawable.display();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void waitImage() {
        this.canvasAnimator.waitEndOfDrawing();
    }

    @Override
    public int getAntiAliasingLevel() {
        return this.antiAliasingLevel;
    }

    @Override
    public void setAntiAliasingLevel(int n) {
        this.antiAliasingLevel = n;
    }

    public GL2 getGl() {
        if (this.debug == null) {
            return this.autoDrawable.getGL().getGL2();
        }
        return this.debug;
    }

    public JoGLParameters getJoGLParameters() {
        return this.parameters;
    }

    public BufferedImage getImage() {
        return this.getImage(true);
    }

    public BufferedImage getImage(final boolean bl) {
        while (!this.canvasAnimator.isDrawFinished() || !this.displayFinished) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        final BufferedImage[] bufferedImageArray = new BufferedImage[1];
        final GLContext gLContext = this.autoDrawable.getContext();
        if (SwingUtilities.isEventDispatchThread()) {
            gLContext.makeCurrent();
            AWTGLReadBufferUtil aWTGLReadBufferUtil = new AWTGLReadBufferUtil(GLProfile.getDefault(), bl);
            bufferedImageArray[0] = aWTGLReadBufferUtil.readPixelsToBufferedImage((GL)this.getGl(), 0, 0, this.autoDrawable.getSurfaceWidth(), this.autoDrawable.getSurfaceHeight(), true);
            gLContext.release();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        gLContext.makeCurrent();
                        AWTGLReadBufferUtil aWTGLReadBufferUtil = new AWTGLReadBufferUtil(GLProfile.getDefault(), bl);
                        bufferedImageArray[0] = aWTGLReadBufferUtil.readPixelsToBufferedImage((GL)JoGLCanvas.this.getGl(), 0, 0, JoGLCanvas.this.autoDrawable.getSurfaceWidth(), JoGLCanvas.this.autoDrawable.getSurfaceHeight(), true);
                        gLContext.release();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println(invocationTargetException);
                invocationTargetException.printStackTrace();
            }
        }
        return bufferedImageArray[0];
    }

    @Override
    public void destroy() {
        if (this.isOffscreen) {
            ((GLOffscreenAutoDrawable)this.autoDrawable).destroy();
        }
        try {
            this.isValid = false;
            this.canvasAnimator.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static GLAutoDrawable getOffscreenDrawable(int n, int n2) {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setPBuffer(true);
        return gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, n, n2);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this.isValid) {
            this.displayFinished = false;
            GL2 gL2 = this.getGl().getGL2();
            this.buffersManager.glSynchronize(gL2);
            this.rendererManager.glSynchronize(gL2);
            this.drawingTools.glSynchronize(gL2);
            if (this.mainDrawer != null) {
                gL2.glEnable(2929);
                gL2.glDepthFunc(515);
                if (this.antiAliasingLevel > 0 && this.antiAliasingLevel < 5 && this.drawingTools.getGLCapacity().isAccumulationBufferPresent()) {
                    Renderer renderer = this.rendererManager.createRenderer();
                    renderer.setDrawer(this.mainDrawer);
                    double[][] dArray = ANTI_ALIASING_JITTER[this.antiAliasingLevel];
                    Dimension dimension = this.getDimension();
                    gL2.glClear(512);
                    for (double[] dArray2 : dArray) {
                        this.drawingTools.glSynchronize(gL2);
                        gL2.glMatrixMode(5889);
                        gL2.glLoadIdentity();
                        gL2.glTranslated(dArray2[0] / dimension.getWidth(), dArray2[1] / dimension.getHeight(), 0.0);
                        gL2.glClear(256);
                        this.rendererManager.draw(this.drawingTools, renderer);
                        gL2.glReadBuffer(1029);
                        gL2.glAccum(256, 1.0f / (float)dArray.length);
                    }
                    this.rendererManager.dispose(this.drawingTools, renderer);
                    gL2.glDrawBuffer(1029);
                    gL2.glAccum(258, 1.0f);
                } else {
                    gL2.glMatrixMode(5889);
                    gL2.glLoadIdentity();
                    gL2.glClear(256);
                    this.mainDrawer.draw(this.drawingTools);
                }
            }
            this.pickingManager.glConsume(this.drawingTools);
            this.displayFinished = true;
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.textureManager.glReload();
        this.buffersManager.glReload();
        this.rendererManager.glReload();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    private class CanvasAnimator
    implements Runnable {
        private final Semaphore semaphore = new Semaphore(1);
        private final Thread thread;
        private final GLAutoDrawable autoDrawable;
        private boolean running = true;

        public CanvasAnimator(GLAutoDrawable gLAutoDrawable) {
            this.autoDrawable = gLAutoDrawable;
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void finalize() throws Throwable {
            this.running = false;
            this.semaphore.release();
            this.autoDrawable.destroy();
            super.finalize();
        }

        public synchronized boolean isDrawFinished() {
            return this.semaphore.availablePermits() == 0;
        }

        public synchronized void redraw() {
            this.semaphore.release();
        }

        public void waitEndOfDrawing() {
            this.semaphore.drainPermits();
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    this.semaphore.acquire();
                    this.semaphore.drainPermits();
                    if (!this.running) continue;
                    this.autoDrawable.display();
                }
                catch (InterruptedException interruptedException) {
                    if (!this.running) break;
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (GLException gLException) {
                    if (!this.running) break;
                    throw gLException;
                }
            }
        }
    }
}

