/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import org.scilab.forge.scirenderer.implementation.g2d.motor.AbstractDrawable3DObject;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class BoundingBox {
    private double minX = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;
    private double minZ = Double.POSITIVE_INFINITY;
    private double maxZ = Double.NEGATIVE_INFINITY;

    public BoundingBox(double d, double d2, double d3, double d4, double d5, double d6) {
        this.minX = d;
        this.maxX = d2;
        this.minY = d3;
        this.maxY = d4;
        this.minZ = d5;
        this.maxZ = d6;
    }

    public int xCompare(BoundingBox boundingBox) {
        if (boundingBox.minX >= this.maxX) {
            return -1;
        }
        if (this.minX >= boundingBox.maxX) {
            return 1;
        }
        return 0;
    }

    public int yCompare(BoundingBox boundingBox) {
        if (boundingBox.minY >= this.maxY) {
            return -1;
        }
        if (this.minY >= boundingBox.maxY) {
            return 1;
        }
        return 0;
    }

    public int zCompare(BoundingBox boundingBox) {
        if (boundingBox.minZ >= this.maxZ) {
            return 1;
        }
        if (this.minZ >= boundingBox.maxZ) {
            return -1;
        }
        return 0;
    }

    public boolean isIntersecting(BoundingBox boundingBox) {
        return boundingBox.maxX >= this.minX && this.maxX >= boundingBox.minX && boundingBox.maxY >= this.minY && this.maxY >= boundingBox.minY && boundingBox.maxZ >= this.minZ && this.maxZ >= boundingBox.minZ;
    }

    public boolean isNonZOverlapping(BoundingBox boundingBox) {
        return boundingBox.maxX < this.minX || this.maxX < boundingBox.minX || boundingBox.maxY < this.minY || this.maxY < boundingBox.minY || (boundingBox.maxZ < this.minZ || this.maxZ < boundingBox.minZ) && (this.maxX == boundingBox.minX || boundingBox.maxX == this.minX || boundingBox.minY == this.maxY || this.minY == boundingBox.maxY);
    }

    public boolean isStrictlyIntersecting(BoundingBox boundingBox) {
        return boundingBox.maxX > this.minX && this.maxX > boundingBox.minX && boundingBox.maxY > this.minY && this.maxY > boundingBox.minY && boundingBox.maxZ > this.minZ && this.maxZ > boundingBox.minZ;
    }

    public static BoundingBox getBoundingBox(AbstractDrawable3DObject abstractDrawable3DObject) {
        Vector3d[] vector3dArray = abstractDrawable3DObject.vertices;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vector3dArray.length; ++i) {
            double d7 = vector3dArray[i].getX();
            double d8 = vector3dArray[i].getY();
            double d9 = vector3dArray[i].getZ();
            if (d7 < d) {
                d = d7;
            }
            if (d7 > d2) {
                d2 = d7;
            }
            if (d8 < d3) {
                d3 = d8;
            }
            if (d8 > d4) {
                d4 = d8;
            }
            if (d9 < d5) {
                d5 = d9;
            }
            if (!(d9 > d6)) continue;
            d6 = d9;
        }
        return new BoundingBox(d, d2, d3, d4, d5, d6);
    }

    public String toString() {
        return "[" + this.minX + ";" + this.maxX + "]x" + "[" + this.minY + ";" + this.maxY + "]x" + "[" + this.minZ + ";" + this.maxZ + "]";
    }
}

