/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.lighting;

import org.scilab.forge.scirenderer.lightning.Light;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class G2DLight
implements Light {
    private int index;
    private boolean isEnable;
    private Color ambientColor = new Color(0.0f, 0.0f, 0.0f);
    private Color diffuseColor = new Color(0.0f, 0.0f, 0.0f);
    private Color specularColor = new Color(0.0f, 0.0f, 0.0f);
    private Vector3d position = new Vector3d(0.0, 0.0, 0.0);
    private Vector3d spotDirection = new Vector3d(0.0, 0.0, -1.0);
    private Vector3d direction = new Vector3d(0.0, 0.0, 0.0);
    private float spotAngle = 180.0f;
    private boolean isDirectional = false;

    public G2DLight(int n) {
        this.index = n;
    }

    @Override
    public boolean isEnable() {
        return this.isEnable;
    }

    @Override
    public void setEnable(boolean bl) {
        if (bl != this.isEnable) {
            this.isEnable = bl;
        }
    }

    @Override
    public Color getAmbientColor() {
        return this.ambientColor;
    }

    @Override
    public void setAmbientColor(Color color) {
        if (color != null) {
            this.ambientColor = color;
        }
    }

    @Override
    public Color getDiffuseColor() {
        return this.diffuseColor;
    }

    @Override
    public void setDiffuseColor(Color color) {
        if (color != null) {
            this.diffuseColor = color;
        }
    }

    @Override
    public Color getSpecularColor() {
        return this.specularColor;
    }

    @Override
    public void setSpecularColor(Color color) {
        if (color != null) {
            this.specularColor = color;
        }
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d vector3d) {
        if (vector3d != null) {
            this.isDirectional = false;
            this.position = vector3d;
        }
    }

    @Override
    public Vector3d getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Vector3d vector3d) {
        if (vector3d != null) {
            this.isDirectional = true;
            this.direction = vector3d.getNormalized();
        }
    }

    @Override
    public Vector3d getSpotDirection() {
        return this.spotDirection;
    }

    @Override
    public void setSpotDirection(Vector3d vector3d) {
        if (vector3d != null) {
            this.spotDirection = vector3d;
        }
    }

    @Override
    public float getSpotAngle() {
        return this.spotAngle;
    }

    @Override
    public void setSpotAngle(float f) {
        if (f != this.spotAngle) {
            this.spotAngle = f;
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public boolean isPoint() {
        return !this.isDirectional;
    }
}

