/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.utils.textRendering;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class FontManager {
    private static final String SCIDIR = System.getenv("SCI");
    private static final float[] INTERVALS = new float[]{3.0f, 4.0f, 5.0f};
    private static final float[] FIRST_POLY = new float[]{2.0f, 8.0f};
    private static final float[] SECOND_POLY = new float[]{4.0f, 2.0f};
    private static final float[] THIRD_POLY = new float[]{6.0f, -6.0f};
    private static final float[] FOURTH_POLY = new float[]{10.0f, -26.0f};
    private static final float SIX = 6.0f;
    private static final float[] INV_INTERVALS = new float[]{14.0f, 18.0f, 24.0f};
    private static final float[] INV_FIRST_POLY = new float[]{0.5f, -4.0f};
    private static final float[] INV_SECOND_POLY = new float[]{0.25f, -0.5f};
    private static final float[] INV_THIRD_POLY = new float[]{0.16666667f, 1.0f};
    private static final float[] INV_FOURTH_POLY = new float[]{0.1f, 2.6f};
    private static final String MONOSPACED = "Monospaced";
    private static final String SANSSERIF = "SansSerif";
    private static final String SERIF = "Serif";
    private static final String SCILABSYMBOLSFONT = "ScilabSymbols";
    private static final String SYMBOLSFONTPATH = "/thirdparty/fonts/scilabsymbols.ttf";
    private static final Font DEFAULT_FONT = new Font("Default", 0, 1);
    private static final FontManager sciFontManager = new FontManager();
    private static FontList sciFonts;

    private FontManager() {
        this.initializeFontManager();
    }

    public static FontManager getSciFontManager() {
        return sciFontManager;
    }

    public static float scilabSizeToAwtSize(double d) {
        float f = (float)d;
        if (f < INTERVALS[0]) {
            return FIRST_POLY[0] * f + FIRST_POLY[1];
        }
        if (f < INTERVALS[1]) {
            return SECOND_POLY[0] * f + SECOND_POLY[1];
        }
        if (f < INTERVALS[2]) {
            return THIRD_POLY[0] * f + THIRD_POLY[1];
        }
        return FOURTH_POLY[0] * f + FOURTH_POLY[1];
    }

    public static double awtSizeToScilabSize(float f) {
        if (f < INV_INTERVALS[0]) {
            return INV_FIRST_POLY[0] * f + INV_FIRST_POLY[1];
        }
        if (f < INV_INTERVALS[1]) {
            return INV_SECOND_POLY[0] * f + INV_SECOND_POLY[1];
        }
        if (f < INV_INTERVALS[2]) {
            return INV_THIRD_POLY[0] * f + INV_THIRD_POLY[1];
        }
        return INV_FOURTH_POLY[0] * f + INV_FOURTH_POLY[1];
    }

    public final Font getFontFromIndex(int n) {
        if (n >= 0 && n < sciFonts.size()) {
            return (Font)sciFonts.get(n);
        }
        if (n < 0) {
            return (Font)sciFonts.get(0);
        }
        return (Font)sciFonts.get(sciFonts.size() - 1);
    }

    public final Font getFontFromIndex(int n, double d) {
        Font font = this.getFontFromIndex(n);
        return font.deriveFont(FontManager.scilabSizeToAwtSize(d));
    }

    public final int addFont(Font font) {
        sciFonts.add(font);
        return sciFonts.size() - 1;
    }

    public final int changeFont(int n, Font font) {
        int n2 = sciFonts.size();
        if (n > n2) {
            for (int i = n2; i < n; ++i) {
                this.addFont(DEFAULT_FONT);
            }
            return this.addFont(font);
        }
        if (n == n2) {
            return this.addFont(font);
        }
        sciFonts.set(n, font);
        return n;
    }

    protected final Font createFont(String string) {
        return new Font(string, 0, 1);
    }

    protected final Font loadScilabSymbolFont() {
        return this.loadFont(SCIDIR + SYMBOLSFONTPATH);
    }

    protected final Font loadFont(String string) {
        Font font;
        FileInputStream fileInputStream;
        File file = new File(string);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Font font2 = DEFAULT_FONT;
            return font2;
        }
        try {
            font = Font.createFont(0, fileInputStream);
        }
        catch (IOException iOException) {
            font = DEFAULT_FONT;
        }
        catch (FontFormatException fontFormatException) {
            font = DEFAULT_FONT;
        }
        return font;
    }

    protected final Font createFont(String string, boolean bl, boolean bl2) {
        int n = bl && bl2 ? 3 : (bl ? 1 : (bl2 ? 2 : 0));
        return new Font(string, n, 1);
    }

    public final int addFont(String string) {
        return this.addFont(this.createFont(string));
    }

    public final int addFont(String string, boolean bl, boolean bl2) {
        return this.addFont(this.createFont(string, bl, bl2));
    }

    public final int addFontFromFilename(String string) {
        return this.addFont(this.loadFont(string));
    }

    public final int changeFont(int n, String string) {
        return this.changeFont(n, this.createFont(string));
    }

    public final int changeFontFromFilename(int n, String string) {
        return this.changeFont(n, this.loadFont(string));
    }

    public final int changeFont(int n, String string, boolean bl, boolean bl2) {
        return this.changeFont(n, this.createFont(string, bl, bl2));
    }

    public final String[] getAvailableFontsName() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public final int getSizeAvailableFontsName() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames().length;
    }

    public final boolean isAvailableFontName(String string) {
        int n = this.getSizeAvailableFontsName();
        String[] stringArray = this.getAvailableFontsName();
        for (n = 0; n < stringArray.length; ++n) {
            if (string.compareTo(stringArray[n]) != 0) continue;
            return true;
        }
        return false;
    }

    public final String[] getInstalledFontsName() {
        int n = sciFonts.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Font font = this.getFontFromIndex(i);
            stringArray[i] = font.getFamily();
            if (font.isBold()) {
                int n2 = i;
                stringArray[n2] = stringArray[n2] + " Bold";
            }
            if (!font.isItalic()) continue;
            int n3 = i;
            stringArray[n3] = stringArray[n3] + " Italic";
        }
        return stringArray;
    }

    public final int getSizeInstalledFontsName() {
        return sciFonts.size();
    }

    public final void initializeFontManager() {
        sciFonts = new FontList();
        sciFonts.add(this.createFont(MONOSPACED));
        if (this.isAvailableFontName(SCILABSYMBOLSFONT)) {
            sciFonts.add(this.createFont(SCILABSYMBOLSFONT));
        } else {
            sciFonts.add(this.loadScilabSymbolFont());
        }
        sciFonts.add(this.createFont(SERIF));
        sciFonts.add(this.createFont(SERIF, false, true));
        sciFonts.add(this.createFont(SERIF, true, false));
        sciFonts.add(this.createFont(SERIF, true, true));
        sciFonts.add(this.createFont(SANSSERIF));
        sciFonts.add(this.createFont(SANSSERIF, false, true));
        sciFonts.add(this.createFont(SANSSERIF, true, false));
        sciFonts.add(this.createFont(SANSSERIF, true, true));
        sciFonts.add(this.createFont(SANSSERIF, true, true));
    }

    private static class FontList
    extends ArrayList<Font> {
        private static final long serialVersionUID = 1L;
    }
}

