/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.texture.TextEntity;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureDrawingTools;
import org.scilab.modules.console.utils.ScilabSpecialTextUtilities;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.graphic_objects.textObject.TextObject;
import org.scilab.modules.jvm.LoadClassPath;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.utils.textRendering.FontManager;

public class TextObjectSpriteDrawer
implements TextureDrawer {
    private static final int HMARGIN = 2;
    private static final int VMARGIN = 2;
    private static final int SPACEWIDTH = (int)Math.ceil(new TextEntity("_").getSize().getWidth()) - 2;
    private Appearance appearance;
    private int thickness;
    private final Object[][] entities;
    private float alignmentFactor;
    private final int[] lineHeight;
    private final int[] columnWidth;
    private final float[] lineAscent;
    private final int width;
    private final int height;
    private boolean latexSet = false;
    private boolean mathmlSet = false;

    public TextObjectSpriteDrawer(ColorMap colorMap, TextObject textObject) {
        Object object2;
        String[][] stringArray = this.computeTextData(textObject);
        int n = -1;
        for (Object object2 : stringArray) {
            n = Math.max(((String[])object2).length, n);
        }
        int n2 = stringArray.length;
        this.lineHeight = new int[n2];
        this.lineAscent = new float[n2];
        this.columnWidth = new int[n];
        this.entities = new Object[n][n2];
        int n3 = textObject.getFontFractional().booleanValue() ? 1 : 0;
        org.scilab.forge.scirenderer.shapes.appearance.Color color = ColorFactory.createColor(colorMap, textObject.getFont().getColor());
        object2 = this.computeFont(textObject);
        this.loadDeps(stringArray);
        this.fillEntityMatrix(stringArray, n3 != 0, color, (Font)object2);
        this.width = this.sum(this.columnWidth) + 2 * (n + 1) + 2 * this.thickness + SPACEWIDTH * (n - 1);
        this.height = this.sum(this.lineHeight) + 2 * (n2 + 1) + 2 * this.thickness;
    }

    public TextObjectSpriteDrawer(ColorMap colorMap, TextObject textObject, double d) {
        Object object2;
        String[][] stringArray = this.computeTextData(textObject);
        int n = -1;
        for (Object object2 : stringArray) {
            n = Math.max(((String[])object2).length, n);
        }
        int n2 = stringArray.length;
        this.lineHeight = new int[n2];
        this.lineAscent = new float[n2];
        this.columnWidth = new int[n];
        this.entities = new Object[n][n2];
        int n3 = textObject.getFontFractional().booleanValue() ? 1 : 0;
        org.scilab.forge.scirenderer.shapes.appearance.Color color = ColorFactory.createColor(colorMap, textObject.getFont().getColor());
        object2 = this.computeFont(textObject, d);
        this.loadDeps(stringArray);
        this.fillEntityMatrix(stringArray, n3 != 0, color, (Font)object2);
        this.width = (int)((double)this.sum(this.columnWidth) + d * (double)(2 * (n + 1)) + (double)(2 * this.thickness) + d * (double)(SPACEWIDTH * (n - 1)));
        this.height = (int)((double)this.sum(this.lineHeight) + d * (double)(2 * (n2 + 1)) + (double)(2 * this.thickness));
    }

    protected void loadDeps(String[][] stringArray) {
        String[][] stringArray2 = stringArray;
        int n = stringArray2.length;
        block0: for (int i = 0; i < n; ++i) {
            String[] stringArray3;
            for (String string : stringArray3 = stringArray2[i]) {
                if (string == null) continue;
                if (!this.latexSet && this.isLatex(string)) {
                    this.latexSet = true;
                    LoadClassPath.loadOnUse((String)"graphics_latex_textrendering");
                    continue;
                }
                if (!this.mathmlSet && this.isMathML(string)) {
                    LoadClassPath.loadOnUse((String)"graphics_mathml_textrendering");
                    continue;
                }
                if (this.latexSet && this.mathmlSet) break block0;
            }
        }
    }

    protected void fillEntityMatrix(String[][] stringArray, boolean bl, org.scilab.forge.scirenderer.shapes.appearance.Color color, Font font) {
        int n = 0;
        for (String[] stringArray2 : stringArray) {
            int n2 = 0;
            for (String string : stringArray2) {
                if (string != null) {
                    TextEntity textEntity;
                    Dimension dimension = null;
                    Icon icon = null;
                    float f = 0.0f;
                    if (this.isLatex(string)) {
                        try {
                            textEntity = new TeXFormula(string.substring(1, string.length() - 1));
                            textEntity.setColor((Color)color);
                            icon = textEntity.createTeXIcon(0, (float)font.getSize());
                            f = ((TeXIcon)icon).getIconHeight() - ((TeXIcon)icon).getIconDepth();
                        }
                        catch (Exception exception) {}
                    } else if (this.isMathML(string)) {
                        try {
                            icon = ScilabSpecialTextUtilities.compileMathMLExpression((String)string, (int)font.getSize(), (Color)color);
                            textEntity = (ScilabSpecialTextUtilities.SpecialIcon)icon;
                            f = textEntity.getIconHeight() - textEntity.getIconDepth();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (icon != null) {
                        dimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                        this.entities[n2][n] = icon;
                    } else {
                        textEntity = new TextEntity(string);
                        textEntity.setTextUseFractionalMetrics(bl);
                        textEntity.setTextAntiAliased(true);
                        textEntity.setTextColor(color);
                        textEntity.setFont(font);
                        this.entities[n2][n] = textEntity;
                        dimension = textEntity.getSize();
                        f = textEntity.isValid() ? textEntity.getLayout().getAscent() : 0.0f;
                    }
                    this.lineAscent[n] = Math.max(this.lineAscent[n], f);
                    if (dimension != null) {
                        this.columnWidth[n2] = Math.max(this.columnWidth[n2], dimension.width);
                        this.lineHeight[n] = Math.max(this.lineHeight[n], dimension.height);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean isLatex(String string) {
        return string.length() >= 2 && string.endsWith("$") && string.startsWith("$");
    }

    private boolean isMathML(String string) {
        return string.length() >= 2 && string.endsWith(">") && string.startsWith("<");
    }

    public void draw(TextureDrawingTools textureDrawingTools) {
        int n;
        if (this.appearance.getFillColor().getAlphaAsFloat() != 0.0f) {
            textureDrawingTools.clear(this.appearance.getFillColor());
        }
        int n2 = this.getHMargin();
        int n3 = this.getVMargin();
        int n4 = this.getSpaceWidth();
        int n5 = n2 + this.thickness;
        int n6 = 0;
        for (Object[] objectArray : this.entities) {
            n = n3 + this.thickness;
            int n7 = 0;
            for (Object object : objectArray) {
                ScilabSpecialTextUtilities.SpecialIcon specialIcon;
                Object object2;
                if (object == null) continue;
                if (object instanceof TextEntity) {
                    object2 = (TextEntity)object;
                    float f = object2.isValid() ? object2.getLayout().getAscent() : 0.0f;
                    double d = (double)this.alignmentFactor * ((double)this.columnWidth[n6] - object2.getSize().getWidth());
                    textureDrawingTools.draw((TextEntity)object2, (int)((double)n5 + d), Math.round((float)n - f + this.lineAscent[n7]));
                    n += this.lineHeight[n7] + n3;
                    ++n7;
                    continue;
                }
                if (!(object instanceof Icon)) continue;
                object2 = (Icon)object;
                double d = this.alignmentFactor * (float)(this.columnWidth[n6] - object2.getIconWidth());
                if (this.latexSet && object2 instanceof TeXIcon) {
                    specialIcon = (TeXIcon)object2;
                    float f = specialIcon.getIconHeight() - specialIcon.getIconDepth();
                    textureDrawingTools.draw((Icon)object2, (int)((double)n5 + d), Math.round((float)n - f + this.lineAscent[n7]));
                } else {
                    specialIcon = (ScilabSpecialTextUtilities.SpecialIcon)object2;
                    int n8 = specialIcon.getIconHeight() - specialIcon.getIconDepth();
                    textureDrawingTools.draw((Icon)object2, (int)((double)n5 + d), n - n8 + Math.round(this.lineAscent[n7]));
                }
                n += this.lineHeight[n7] + n3;
                ++n7;
            }
            n5 += this.columnWidth[n6] + n2 + n4;
            ++n6;
        }
        if (this.appearance.getLineWidth() > 0.0f) {
            float f = this.appearance.getLineWidth() / 2.0f;
            int n9 = (int)f;
            int n10 = (int)f;
            int n11 = (int)((float)this.width - f);
            n = (int)((float)this.height - f);
            textureDrawingTools.drawPolyline(new int[]{n9, n10, n11, n10, n11, n, n9, n, n9, n10}, this.appearance);
        }
    }

    public TextureDrawer.OriginPosition getOriginPosition() {
        return TextureDrawer.OriginPosition.UPPER_LEFT;
    }

    public Dimension getTextureSize() {
        return new Dimension(this.width, this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setAlignmentFactor(float f) {
        this.alignmentFactor = f;
    }

    protected void setAppearance(Appearance appearance) {
        this.appearance = appearance;
    }

    protected void setThickness(int n) {
        this.thickness = n;
    }

    public int getHMargin() {
        return 2;
    }

    public int getVMargin() {
        return 2;
    }

    public int getSpaceWidth() {
        return SPACEWIDTH;
    }

    protected String[][] computeTextData(TextObject textObject) {
        String[] stringArray = textObject.getTextStrings();
        Integer[] integerArray = textObject.getTextArrayDimensions();
        String[][] stringArray2 = new String[integerArray[0].intValue()][integerArray[1].intValue()];
        int n = 0;
        for (int i = 0; i < integerArray[1]; ++i) {
            for (int j = 0; j < integerArray[0]; ++j) {
                stringArray2[j][i] = stringArray[n];
                ++n;
            }
        }
        return stringArray2;
    }

    private Font computeFont(TextObject textObject) {
        return FontManager.getSciFontManager().getFontFromIndex(textObject.getFontStyle(), textObject.getFontSize());
    }

    private Font computeFont(TextObject textObject, double d) {
        Font font = FontManager.getSciFontManager().getFontFromIndex(textObject.getFontStyle(), 1.0);
        return font.deriveFont(font.getSize2D() * (float)d);
    }

    protected float computeAlignmentFactor(Text text) {
        switch (text.getAlignmentAsEnum()) {
            case LEFT: {
                return 0.0f;
            }
            case CENTER: {
                return 0.5f;
            }
            case RIGHT: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    private int sum(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }
}

