/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.util;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.scirenderer.texture.TextEntity;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureDrawingTools;
import org.scilab.modules.console.utils.ScilabSpecialTextUtilities;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.textObject.Font;
import org.scilab.modules.graphic_objects.textObject.FormattedText;
import org.scilab.modules.jvm.LoadClassPath;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.utils.textRendering.FontManager;

public class FormattedTextSpriteDrawer
implements TextureDrawer {
    private final TextEntity textEntity;
    private final Dimension dimension;
    private final int descent;
    private final Icon icon;

    public FormattedTextSpriteDrawer(ColorMap colorMap, String string, Font font) {
        if (string != null && font != null) {
            if (FormattedTextSpriteDrawer.isLatex(string)) {
                LoadClassPath.loadOnUse((String)"graphics_latex_textrendering");
                TeXFormula teXFormula = new TeXFormula(string.substring(1, string.length() - 1));
                teXFormula.setColor((Color)ColorFactory.createColor(colorMap, font.getColor()));
                this.icon = teXFormula.createTeXIcon(0, FontManager.scilabSizeToAwtSize(font.getSize()));
                this.descent = ((TeXIcon)this.icon).getIconDepth();
            } else if (FormattedTextSpriteDrawer.isMathML(string)) {
                LoadClassPath.loadOnUse((String)"graphics_mathml_textrendering");
                this.icon = ScilabSpecialTextUtilities.compileMathMLExpression((String)string, (int)((int)FontManager.scilabSizeToAwtSize(font.getSize() + 0.5)), (Color)ColorFactory.createColor(colorMap, font.getColor()));
                this.descent = 0;
            } else {
                this.icon = null;
                this.descent = 0;
            }
            if (this.icon != null) {
                this.textEntity = null;
                this.dimension = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight() + this.descent);
            } else {
                this.textEntity = new TextEntity(string);
                this.textEntity.setFont(FontManager.getSciFontManager().getFontFromIndex(font.getStyle(), font.getSize()));
                this.textEntity.setText(string);
                this.textEntity.setTextColor(ColorFactory.createColor(colorMap, font.getColor()));
                this.textEntity.setTextUseFractionalMetrics(font.getFractional().booleanValue());
                this.textEntity.setTextAntiAliased(true);
                this.dimension = this.textEntity.getSize();
            }
        } else {
            this.icon = null;
            this.textEntity = null;
            this.dimension = new Dimension();
            this.descent = 0;
        }
    }

    public FormattedTextSpriteDrawer(ColorMap colorMap, FormattedText formattedText) {
        this(colorMap, formattedText != null ? formattedText.getText() : null, formattedText != null ? formattedText.getFont() : null);
    }

    public void draw(TextureDrawingTools textureDrawingTools) {
        if (this.textEntity != null) {
            textureDrawingTools.draw(this.textEntity, 0, 0);
        } else if (this.icon != null) {
            textureDrawingTools.draw(this.icon, 0, this.descent);
        }
    }

    public Dimension getTextureSize() {
        return new Dimension(this.dimension);
    }

    public TextureDrawer.OriginPosition getOriginPosition() {
        return TextureDrawer.OriginPosition.UPPER_LEFT;
    }

    public Dimension getSpriteSize() {
        return new Dimension(this.dimension);
    }

    public static boolean isLatex(String string) {
        return string.length() >= 2 && string.endsWith("$") && string.startsWith("$");
    }

    public static boolean isMathML(String string) {
        return string.length() >= 2 && string.endsWith(">") && string.startsWith("<");
    }
}

