/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.mark;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.contouredObject.Mark;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.renderer.JoGLView.mark.MarkSpriteFactory;

public class MarkSpriteManager {
    private final TextureManager textureManager;
    private final Map<Integer, Map<Integer, Texture>> spriteMap = new ConcurrentHashMap<Integer, Map<Integer, Texture>>();

    public MarkSpriteManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public Texture getMarkSprite(ContouredObject contouredObject, ColorMap colorMap, Appearance appearance) {
        Integer n = contouredObject.getIdentifier();
        Map<Integer, Texture> map = this.spriteMap.get(n);
        Texture texture = null;
        int n2 = contouredObject.getMark().getSize();
        if (map == null) {
            map = new ConcurrentHashMap<Integer, Texture>();
            this.spriteMap.put(n, map);
        } else {
            texture = map.get(n2);
        }
        if (texture == null) {
            Integer n3 = contouredObject.getSelected() != false ? contouredObject.getSelectedColor() : null;
            texture = MarkSpriteFactory.getMarkSprite(this.textureManager, contouredObject.getMark(), n3, colorMap, appearance);
            map.put(n2, texture);
        }
        return texture;
    }

    public Texture getMarkSprite(Integer n, Mark mark, ColorMap colorMap, Appearance appearance) {
        Map<Integer, Texture> map = this.spriteMap.get(n);
        Texture texture = null;
        int n2 = mark.getSize();
        if (map == null) {
            map = new ConcurrentHashMap<Integer, Texture>();
            this.spriteMap.put(n, map);
        } else {
            texture = map.get(n2);
        }
        if (texture == null) {
            texture = MarkSpriteFactory.getMarkSprite(this.textureManager, mark, null, colorMap, appearance);
            map.put(n2, texture);
        }
        return texture;
    }

    public void update(Integer n, int n2) {
        if (n2 == 195 || n2 == 196 || n2 == 197 || n2 == 198 || n2 == 199 || n2 == 200 || n2 == 191 || n2 == 203 || n2 == 397 || n2 == 398 || n2 == 400 || n2 == 402) {
            this.dispose(n);
        }
    }

    public void dispose(Integer n) {
        Map<Integer, Texture> map = this.spriteMap.get(n);
        if (map != null) {
            this.textureManager.dispose(map.values());
            map.clear();
        }
        this.spriteMap.remove(n);
    }

    public void disposeAll() {
        for (Map<Integer, Texture> map : this.spriteMap.values()) {
            this.textureManager.dispose(map.values());
            map.clear();
        }
        this.spriteMap.clear();
    }
}

