/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.mark;

import java.awt.Dimension;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureDrawingTools;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.modules.graphic_objects.contouredObject.Mark;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;

public class MarkSpriteFactory {
    public static Texture getMarkSprite(TextureManager textureManager, Mark mark, Integer n, ColorMap colorMap, Appearance appearance) {
        int n2 = mark.getMarkSizeUnit() == Mark.MarkSizeUnitType.TABULATED ? (mark.getStyle() == 0 && mark.getSize() == 0 ? 1 : 8 + 2 * mark.getSize()) : mark.getSize();
        Texture texture = textureManager.createTexture();
        texture.setDrawer(MarkSpriteFactory.getSpriteDrawer(mark, n, n2, colorMap, appearance));
        return texture;
    }

    private static TextureDrawer getSpriteDrawer(Mark mark, Integer n, int n2, ColorMap colorMap, Appearance appearance) {
        Color color;
        Color color2;
        Integer n3;
        Appearance appearance2 = new Appearance();
        Integer n4 = n3 = n == null ? mark.getForeground() : n;
        if (colorMap != null) {
            color2 = ColorFactory.createColor(colorMap, mark.getBackground());
            color = ColorFactory.createColor(colorMap, n3);
        } else if (mark.getBackground() == -3 && mark.getForeground() == -3) {
            color2 = new Color(0.0f, 0.0f, 0.0f, 1.0f);
            color = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        } else if (mark.getBackground() == -3) {
            color2 = new Color(0.0f, 0.0f, 0.0f, 1.0f);
            color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            color2 = new Color(1.0f, 1.0f, 1.0f, 1.0f);
            color = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        }
        if (mark.getBackground() != 0) {
            appearance2.setFillColor(color2);
        } else {
            appearance2.setFillColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        }
        appearance2.setLineColor(color);
        if (appearance != null) {
            appearance2.setLineWidth(appearance.getLineWidth());
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n2 != 1) {
            switch (mark.getStyle()) {
                case 0: {
                    if (colorMap == null) {
                        return new DotSpriteDrawer(color2, n2);
                    }
                    return new DotSpriteDrawer(color, n2);
                }
                case 1: {
                    return new PlusSpriteDrawer(appearance2, n2);
                }
                case 2: {
                    return new CrossSpriteDrawer(appearance2, n2);
                }
                case 3: {
                    return new StarSpriteDrawer(appearance2, n2);
                }
                case 4: {
                    if (colorMap == null) {
                        return new FilledDiamondSpriteDrawer(color2, n2);
                    }
                    return new FilledDiamondSpriteDrawer(color, n2);
                }
                case 5: {
                    return new DiamondSpriteDrawer(appearance2, n2);
                }
                case 6: {
                    return new TriangleUpSpriteDrawer(appearance2, n2);
                }
                case 7: {
                    return new TriangleDownSpriteDrawer(appearance2, n2);
                }
                case 8: {
                    return new DiamondPlusSpriteDrawer(appearance2, n2);
                }
                case 9: {
                    return new CircleSpriteDrawer(appearance2, n2);
                }
                case 10: {
                    return new AsteriskSpriteDrawer(appearance2, n2);
                }
                case 11: {
                    return new SquareSpriteDrawer(appearance2, n2);
                }
                case 12: {
                    return new TriangleRightSpriteDrawer(appearance2, n2);
                }
                case 13: {
                    return new TriangleLeftSpriteDrawer(appearance2, n2);
                }
                case 14: {
                    return new PentagramSpriteDrawer(appearance2, n2);
                }
            }
            return new PlusSpriteDrawer(appearance2, n2);
        }
        return new PlusSpriteDrawer(appearance2, n2);
    }

    private static class PentagramSpriteDrawer
    extends ScilabSpriteDrawer {
        private final int[] coordinates;
        private static final double COS_PI_OVER_10 = Math.cos(0.3141592653589793);
        private static final double SIN_PI_OVER_10 = Math.sin(0.3141592653589793);
        private static final double COS_3_PI_OVER_10 = Math.cos(0.9424777960769379);
        private static final double SIN_3_PI_OVER_10 = Math.sin(0.9424777960769379);

        public PentagramSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            int n2 = n / 2;
            double d = SIN_PI_OVER_10 * (double)n2;
            int n3 = (int)(COS_PI_OVER_10 * (double)n2);
            int n4 = (int)(SIN_PI_OVER_10 * (double)n2);
            int n5 = (int)(COS_3_PI_OVER_10 * (double)n2);
            int n6 = (int)(SIN_3_PI_OVER_10 * (double)n2);
            double d2 = d / SIN_3_PI_OVER_10;
            int n7 = (int)(d2 * COS_3_PI_OVER_10);
            int n8 = n4;
            int n9 = (int)(d2 * COS_PI_OVER_10);
            int n10 = (int)(d2 * SIN_PI_OVER_10);
            int n11 = (int)d2;
            this.coordinates = new int[]{-n5, n6, -n9, n10, -n3, -n4, -n7, -n8, 0, -n2, n7, -n8, n3, -n4, n9, n10, n5, n6, 0, n11};
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillPolygon(this.coordinates, this.appearance);
        }
    }

    private static class TriangleLeftSpriteDrawer
    extends TriangleSpriteDrawer {
        public TriangleLeftSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            this.coordinates = new int[]{this.basey, this.basex, -this.r, 0, this.basey, -this.basex};
        }
    }

    private static class TriangleRightSpriteDrawer
    extends TriangleSpriteDrawer {
        public TriangleRightSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            this.coordinates = new int[]{-this.basey, this.basex, -this.basey, -this.basex, this.r, 0};
        }
    }

    private static class SquareSpriteDrawer
    extends ScilabSpriteDrawer {
        private final int[] coordinate;

        public SquareSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            int n2 = n / 2;
            this.coordinate = new int[]{-n2, -n2, n2, -n2, n2, n2, -n2, n2};
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillPolygon(this.coordinate, this.appearance);
        }
    }

    private static class AsteriskSpriteDrawer
    extends ScilabSpriteDrawer {
        private final int[] coordinate1;
        private final int[] coordinate2;
        private final int[] coordinate3;
        private final int[] coordinate4;

        public AsteriskSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            int n2 = n / 2;
            this.coordinate1 = new int[]{-n2, 0, n2, 0};
            this.coordinate2 = new int[]{0, -n2, 0, n2};
            n2 = (int)((double)n2 * Math.sqrt(2.0) / 2.0);
            this.coordinate3 = new int[]{-n2, -n2, n2, n2};
            this.coordinate4 = new int[]{-n2, n2, n2, -n2};
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.drawPolyline(this.coordinate1, this.appearance);
            textureDrawingTools.drawPolyline(this.coordinate2, this.appearance);
            textureDrawingTools.drawPolyline(this.coordinate3, this.appearance);
            textureDrawingTools.drawPolyline(this.coordinate4, this.appearance);
        }
    }

    private static class CircleSpriteDrawer
    extends ScilabSpriteDrawer {
        public CircleSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillDisc(0, 0, this.size, this.appearance.getFillColor());
            textureDrawingTools.drawCircle(0, 0, this.size, this.appearance);
        }
    }

    private static class DiamondPlusSpriteDrawer
    extends DiamondSpriteDrawer {
        private final int[] coordinate1;
        private final int[] coordinate2;

        public DiamondPlusSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            this.coordinate1 = new int[]{this.coordinates[0], this.coordinates[1], this.coordinates[4], this.coordinates[5]};
            this.coordinate2 = new int[]{this.coordinates[2], this.coordinates[3], this.coordinates[6], this.coordinates[7]};
        }

        @Override
        public void draw(TextureDrawingTools textureDrawingTools) {
            super.draw(textureDrawingTools);
            textureDrawingTools.drawPolyline(this.coordinate1, this.appearance);
            textureDrawingTools.drawPolyline(this.coordinate2, this.appearance);
        }
    }

    private static class TriangleDownSpriteDrawer
    extends TriangleSpriteDrawer {
        public TriangleDownSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            this.coordinates = new int[]{-this.basex, -this.basey, this.basex, -this.basey, 0, this.r};
        }
    }

    private static class TriangleUpSpriteDrawer
    extends TriangleSpriteDrawer {
        public TriangleUpSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            this.coordinates = new int[]{-this.basex, this.basey, 0, -this.r, this.basex, this.basey};
        }
    }

    private static class DiamondSpriteDrawer
    extends ScilabSpriteDrawer {
        protected final int[] coordinates;

        public DiamondSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            int n2 = n / 2;
            this.coordinates = new int[]{-n2, 0, 0, -n2, n2, 0, 0, n2};
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillPolygon(this.coordinates, this.appearance);
        }
    }

    private static abstract class TriangleSpriteDrawer
    extends ScilabSpriteDrawer {
        protected final int r;
        protected final int basex;
        protected final int basey;
        protected int[] coordinates;

        public TriangleSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            double d = n / 2;
            this.r = (int)d;
            this.basex = (int)(d * 0.5 * Math.sqrt(3.0));
            this.basey = (int)(d * 0.5);
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillPolygon(this.coordinates, this.appearance);
        }
    }

    private static class FilledDiamondSpriteDrawer
    extends ScilabSpriteDrawer {
        private final Appearance appearance;
        private final int[] coordinates;

        public FilledDiamondSpriteDrawer(Color color, int n) {
            super(null, n);
            int n2 = n / 2;
            this.appearance = new Appearance();
            this.appearance.setFillColor(color);
            this.appearance.setLineColor(color);
            this.coordinates = new int[]{-n2, 0, 0, -n2, n2, 0, 0, n2};
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillPolygon(this.coordinates, this.appearance);
        }
    }

    private static class StarSpriteDrawer
    extends ScilabSpriteDrawer {
        private final int[] coordinate1;
        private final int[] coordinate2;

        public StarSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            int n2 = n / 2;
            this.coordinate1 = new int[]{-n2, 0, n2, 0};
            this.coordinate2 = new int[]{0, -n2, 0, n2};
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillDisc(0, 0, this.size, this.appearance.getFillColor());
            textureDrawingTools.drawCircle(0, 0, this.size, this.appearance);
            textureDrawingTools.drawPolyline(this.coordinate1, this.appearance);
            textureDrawingTools.drawPolyline(this.coordinate2, this.appearance);
        }
    }

    private static class CrossSpriteDrawer
    extends ScilabSpriteDrawer {
        private final int[] coordinate1;
        private final int[] coordinate2;

        public CrossSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
            int n2 = (int)((double)n * Math.sqrt(2.0) / 2.0);
            this.coordinate1 = new int[]{-n2, -n2, n2, n2};
            this.coordinate2 = new int[]{-n2, n2, n2, -n2};
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.drawPolyline(this.coordinate1, this.appearance);
            textureDrawingTools.drawPolyline(this.coordinate2, this.appearance);
        }
    }

    private static class PlusSpriteDrawer
    extends ScilabSpriteDrawer {
        public PlusSpriteDrawer(Appearance appearance, int n) {
            super(appearance, n);
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.drawPlus(this.size, this.appearance);
        }
    }

    private static class DotSpriteDrawer
    extends ScilabSpriteDrawer {
        private final Color color;

        public DotSpriteDrawer(Color color, int n) {
            super(null, n);
            this.color = color;
        }

        public void draw(TextureDrawingTools textureDrawingTools) {
            textureDrawingTools.fillDisc(0, 0, this.size, this.color);
        }
    }

    private static abstract class ScilabSpriteDrawer
    implements TextureDrawer {
        protected final Appearance appearance;
        protected final int size;

        public ScilabSpriteDrawer(Appearance appearance, int n) {
            this.appearance = appearance;
            this.size = n;
        }

        public TextureDrawer.OriginPosition getOriginPosition() {
            return TextureDrawer.OriginPosition.CENTER;
        }

        public Dimension getTextureSize() {
            int n = this.size % 2 == 0 ? 3 : 2;
            return new Dimension(this.size + n, this.size + n);
        }
    }
}

