/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.legend;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.TransformationStack;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.legend.Legend;
import org.scilab.modules.graphic_objects.polyline.Polyline;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.legend.LegendSpriteDrawer;
import org.scilab.modules.renderer.JoGLView.mark.MarkSpriteManager;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;

public class LegendDrawer {
    private static final Set<Integer> SPRITE_PROPERTIES = new HashSet<Integer>(Arrays.asList(218, 219, 217, 220, 253, 254));
    private static final float BAR_HEIGHT = 0.5f;
    private final DrawerVisitor visitor;
    private final TextureManager textureManager;
    private final MarkSpriteManager markManager;
    private LegendSpriteDrawer legendSpriteDrawer;
    public static final double LINE_WIDTH = 0.1;
    public static final double Y_OFFSET = 0.01;
    private static final double TICK_LABEL_SIZE = 0.055;
    private static final float Z_FRONT = 0.99f;
    private ElementsBuffer rectangleVertices;
    private ElementsBuffer lineVertices;
    private ElementsBuffer barVertices;
    private IndicesBuffer lineIndices;
    private IndicesBuffer rectangleIndices;
    private IndicesBuffer rectangleOutlineIndices;
    private Map<Integer, Texture> textureMap;

    public LegendDrawer(DrawerVisitor drawerVisitor) {
        this.visitor = drawerVisitor;
        this.textureManager = drawerVisitor.getCanvas().getTextureManager();
        this.markManager = drawerVisitor.getMarkManager();
        this.rectangleVertices = drawerVisitor.getCanvas().getBuffersManager().createElementsBuffer();
        this.lineVertices = drawerVisitor.getCanvas().getBuffersManager().createElementsBuffer();
        this.barVertices = drawerVisitor.getCanvas().getBuffersManager().createElementsBuffer();
        this.lineIndices = drawerVisitor.getCanvas().getBuffersManager().createIndicesBuffer();
        this.rectangleIndices = drawerVisitor.getCanvas().getBuffersManager().createIndicesBuffer();
        this.rectangleOutlineIndices = drawerVisitor.getCanvas().getBuffersManager().createIndicesBuffer();
        this.textureMap = new ConcurrentHashMap<Integer, Texture>();
        int[] nArray = new int[]{0, 1, 1, 2};
        this.lineIndices.setData(nArray);
    }

    public Dimension computeDimensions(Axes axes, Legend legend) {
        Legend.LegendLocation legendLocation = legend.getLegendLocationAsEnum();
        if (legendLocation != Legend.LegendLocation.IN_UPPER_RIGHT && legendLocation != Legend.LegendLocation.IN_UPPER_LEFT && legendLocation != Legend.LegendLocation.IN_LOWER_RIGHT && legendLocation != Legend.LegendLocation.IN_LOWER_LEFT) {
            Figure figure = (Figure)GraphicController.getController().getObjectFromId(axes.getParentFigure());
            ColorMap colorMap = figure.getColorMap();
            Integer[] integerArray = legend.getLinks();
            int n = this.getNumberValidLinks(legend);
            if (n < integerArray.length) {
                this.dispose(legend.getIdentifier());
                this.updateLinks(legend, n);
            }
            if (n > 0) {
                Texture texture = this.getTexture(colorMap, legend);
                return texture.getDataProvider().getTextureSize();
            }
        }
        return null;
    }

    public void draw(Legend legend) throws SciRendererException {
        Object[] objectArray;
        double[] dArray = new double[]{0.25, 0.75, 0.99f};
        DrawingTools drawingTools = this.visitor.getDrawingTools();
        ColorMap colorMap = this.visitor.getColorMap();
        Canvas canvas = this.visitor.getCanvas();
        Integer[] integerArray = legend.getLinks();
        int n = this.getNumberValidLinks(legend);
        if (n < integerArray.length) {
            this.dispose(legend.getIdentifier());
            this.updateLinks(legend, n);
        }
        integerArray = legend.getLinks();
        TransformationStack transformationStack = drawingTools.getTransformationManager().getModelViewStack();
        TransformationStack transformationStack2 = drawingTools.getTransformationManager().getProjectionStack();
        Transformation transformation = TransformationFactory.getIdentity();
        transformationStack.push(transformation);
        Transformation transformation2 = TransformationFactory.getOrthographic((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)-1.0, (double)0.0);
        transformationStack2.push(transformation2);
        Integer n2 = legend.getParentAxes();
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(n2);
        Double[] doubleArray = axes.getAxesBounds();
        Double[] doubleArray2 = axes.getMargins();
        int n3 = axes.getXAxisLocation();
        int n4 = axes.getYAxisLocation();
        int n5 = canvas.getWidth();
        int n6 = canvas.getHeight();
        if (n5 == 0) {
            n5 = 1;
        }
        if (n6 == 0) {
            n6 = 1;
        }
        Texture texture = null;
        double d = 0.0;
        double d2 = 0.0;
        if (n > 0) {
            texture = this.getTexture(colorMap, legend);
            Dimension dimension = texture.getDataProvider().getTextureSize();
            d = dimension.getWidth() / (double)n5;
            d2 = dimension.getHeight() / (double)n6;
        }
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double d3 = legend.getLineWidth() * doubleArray[2] * (1.0 - doubleArray2[0] - doubleArray2[1]);
        double d4 = 0.1 * doubleArray[2] * (1.0 - doubleArray2[0] - doubleArray2[1]) / 8.0;
        double d5 = 0.01 * doubleArray[3] * (1.0 - doubleArray2[2] - doubleArray2[3]);
        dArray2[0] = d + d3 + 3.0 * d4;
        dArray2[1] = d2 + 2.0 * d5;
        Double[] doubleArray3 = new Double[]{dArray2[0], dArray2[1]};
        legend.setSize(doubleArray3);
        dArray3[0] = doubleArray[0];
        dArray3[1] = 1.0 - (doubleArray[1] + doubleArray[3]);
        dArray4[0] = doubleArray[2];
        dArray4[1] = doubleArray[3];
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        Legend.LegendLocation legendLocation = legend.getLegendLocationAsEnum();
        dArray5[0] = dArray3[0] + doubleArray2[0] * dArray4[0];
        dArray5[1] = dArray3[1] + doubleArray2[3] * dArray4[1];
        dArray6[0] = dArray3[0] + (1.0 - doubleArray2[1]) * dArray4[0];
        dArray6[1] = dArray3[1] + (1.0 - doubleArray2[2]) * dArray4[1];
        switch (legendLocation) {
            case IN_UPPER_RIGHT: {
                dArray[0] = (float)(dArray6[0] - d4 - dArray2[0]);
                dArray[1] = (float)(dArray6[1] - d5 - dArray2[1]);
                break;
            }
            case IN_UPPER_LEFT: {
                dArray[0] = (float)(dArray5[0] + d4);
                dArray[1] = (float)(dArray6[1] - d5 - dArray2[1]);
                break;
            }
            case IN_LOWER_RIGHT: {
                dArray[0] = (float)(dArray6[0] - d4 - dArray2[0]);
                dArray[1] = (float)(dArray5[1] + d5);
                break;
            }
            case IN_LOWER_LEFT: {
                dArray[0] = (float)(dArray5[0] + d4);
                dArray[1] = (float)(dArray5[1] + d5);
                break;
            }
            case OUT_UPPER_RIGHT: {
                dArray[0] = (float)(dArray6[0] + d4);
                dArray[1] = (float)(dArray6[1] - dArray2[1]);
                break;
            }
            case OUT_UPPER_LEFT: {
                dArray[0] = (float)(dArray5[0] - d4 - dArray2[0]);
                dArray[1] = (float)(dArray6[1] - dArray2[1]);
                break;
            }
            case OUT_LOWER_RIGHT: {
                dArray[0] = (float)(dArray6[0] + d4);
                dArray[1] = (float)dArray5[1];
                break;
            }
            case OUT_LOWER_LEFT: {
                dArray[0] = (float)(dArray5[0] - d4 - dArray2[0]);
                dArray[1] = (float)dArray5[1];
                break;
            }
            case UPPER_CAPTION: {
                dArray[0] = (float)dArray5[0];
                dArray[1] = (float)(dArray6[1] + d5);
                if (n3 != 1) break;
                dArray[1] = dArray[1] + 0.055;
                break;
            }
            case LOWER_CAPTION: {
                dArray[0] = (float)dArray5[0];
                dArray[1] = (float)(dArray5[1] - d5 - dArray2[1]);
                if (n3 != 0) break;
                dArray[1] = dArray[1] - 0.055;
                break;
            }
            case BY_COORDINATES: {
                objectArray = legend.getPosition();
                dArray[0] = (float)(dArray3[0] + objectArray[0] * doubleArray[2]);
                dArray[1] = (float)(dArray3[1] + (1.0 - objectArray[1]) * doubleArray[3] - dArray2[1]);
            }
        }
        if ((legendLocation == Legend.LegendLocation.OUT_UPPER_LEFT || legendLocation == Legend.LegendLocation.OUT_LOWER_LEFT) && n4 == 4) {
            dArray[0] = dArray[0] - 0.055;
        } else if ((legendLocation == Legend.LegendLocation.OUT_UPPER_RIGHT || legendLocation == Legend.LegendLocation.OUT_LOWER_RIGHT) && n4 == 5) {
            dArray[0] = dArray[0] + 0.055;
        }
        objectArray = new float[]{(float)dArray[0], (float)dArray[1], 0.99f, 1.0f, (float)(dArray[0] + dArray2[0]), (float)dArray[1], 0.99f, 1.0f, (float)dArray[0], (float)(dArray[1] + dArray2[1]), 0.99f, 1.0f, (float)(dArray[0] + dArray2[0]), (float)(dArray[1] + dArray2[1]), 0.99f, 1.0f};
        int[] nArray = new int[]{0, 1, 3, 0, 3, 2};
        int[] nArray2 = new int[]{0, 1, 1, 3, 3, 2, 2, 0};
        this.rectangleIndices.setData(nArray);
        this.rectangleOutlineIndices.setData(nArray2);
        this.rectangleVertices.setData((float[])objectArray, 4);
        DefaultGeometry defaultGeometry = new DefaultGeometry();
        defaultGeometry.setVertices(this.rectangleVertices);
        defaultGeometry.setIndices(this.rectangleIndices);
        Appearance appearance = new Appearance();
        if (legend.getFillMode().booleanValue()) {
            defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
            appearance.setFillColor(ColorFactory.createColor(colorMap, legend.getBackground()));
        } else {
            defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
        }
        if (legend.getLineMode().booleanValue()) {
            defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
            defaultGeometry.setWireIndices(this.rectangleOutlineIndices);
            appearance.setLineColor(ColorFactory.createColor(colorMap, legend.getLineColor()));
            appearance.setLineWidth(legend.getLineThickness().floatValue());
            appearance.setLinePattern(legend.getLineStyleAsEnum().asPattern());
        } else {
            defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.NONE);
        }
        drawingTools.draw((Geometry)defaultGeometry, appearance);
        float[] fArray = new float[]{0.25f, 0.75f, 0.99f, 1.0f, 0.5f, 0.75f, 0.99f, 1.0f, 0.75f, 0.75f, 0.99f, 1.0f};
        double d6 = 0.0;
        if (n > 0) {
            d6 = (double)this.legendSpriteDrawer.getVMargin() / (double)n6;
        }
        fArray[0] = (float)(dArray[0] + d4);
        fArray[1] = (float)(dArray[1] + d6 + d5);
        fArray[4] = fArray[0] + 0.5f * (float)d3;
        fArray[5] = fArray[1];
        fArray[8] = fArray[0] + (float)d3;
        fArray[9] = fArray[1];
        float f = 0.0f;
        if (integerArray.length > 0) {
            f = (float)(d2 - 2.0 * d6) / (float)integerArray.length;
        }
        fArray[1] = fArray[1] + 0.5f * f;
        fArray[5] = fArray[5] + 0.5f * f;
        fArray[9] = fArray[9] + 0.5f * f;
        float[] fArray2 = new float[]{0.25f, 0.75f, 0.99f, 1.0f, 0.75f, 0.75f, 0.99f, 1.0f, 0.25f, 1.0f, 0.99f, 1.0f, 0.75f, 1.0f, 0.99f, 1.0f};
        float f2 = 0.5f * f;
        fArray2[0] = (float)(dArray[0] + d4);
        fArray2[1] = (float)(dArray[1] + d6 + d5) + 0.5f * (f - f2);
        fArray2[4] = fArray2[0] + (float)d3;
        fArray2[5] = fArray2[1];
        fArray2[8] = fArray2[0];
        fArray2[9] = fArray2[1] + f2;
        fArray2[12] = fArray2[4];
        fArray2[13] = fArray2[9];
        for (Integer n7 : integerArray) {
            Polyline polyline = (Polyline)GraphicController.getController().getObjectFromId(n7);
            this.drawLegendItem(legend, drawingTools, colorMap, polyline, fArray2, fArray);
            fArray[1] = fArray[1] + f;
            fArray[5] = fArray[5] + f;
            fArray[9] = fArray[9] + f;
            fArray2[1] = fArray2[1] + f;
            fArray2[5] = fArray2[5] + f;
            fArray2[9] = fArray2[9] + f;
            fArray2[13] = fArray2[13] + f;
        }
        float[] fArray3 = new float[]{fArray[8] + (float)d4, (float)(dArray[1] + d5), 0.99f};
        if (n > 0) {
            drawingTools.draw(texture, AnchorPosition.LOWER_LEFT, new Vector3d(fArray3));
        }
        transformationStack.pop();
        transformationStack2.pop();
        Double[] doubleArray4 = new Double[2];
        if (dArray4[0] == 0.0) {
            dArray4[0] = 1.0;
        }
        if (dArray4[1] == 0.0) {
            dArray4[1] = 1.0;
        }
        doubleArray4[0] = (dArray[0] - dArray3[0]) / dArray4[0];
        doubleArray4[1] = 1.0 - (dArray[1] + dArray2[1] - dArray3[1]) / dArray4[1];
        if (legendLocation != Legend.LegendLocation.BY_COORDINATES) {
            legend.setPosition(doubleArray4);
        }
    }

    private void drawLegendItem(Legend legend, DrawingTools drawingTools, ColorMap colorMap, Polyline polyline, float[] fArray, float[] fArray2) throws SciRendererException {
        Appearance appearance;
        DefaultGeometry defaultGeometry;
        boolean bl;
        int n = polyline.getPolylineStyle();
        int n2 = polyline.getLineColor();
        double d = polyline.getLineThickness();
        short s = polyline.getLineStyleAsEnum().asPattern();
        boolean bl2 = n == 6 || n == 7;
        boolean bl3 = bl = bl2 || polyline.getFillMode() != false;
        if (bl) {
            this.barVertices.setData(fArray, 4);
            defaultGeometry = new DefaultGeometry();
            defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
            appearance = new Appearance();
            appearance.setFillColor(ColorFactory.createColor(colorMap, polyline.getBackground()));
            defaultGeometry.setVertices(this.barVertices);
            defaultGeometry.setIndices(this.rectangleIndices);
            if (bl2 || polyline.getLineMode().booleanValue()) {
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                defaultGeometry.setWireIndices(this.rectangleOutlineIndices);
                appearance.setLineColor(ColorFactory.createColor(colorMap, polyline.getLineColor()));
                appearance.setLineWidth((float)d);
                appearance.setLinePattern(s);
            } else {
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.NONE);
            }
            drawingTools.draw((Geometry)defaultGeometry, appearance);
        }
        if (!bl) {
            this.lineVertices.setData(fArray2, 4);
            if (polyline.getLineMode().booleanValue() || n == 3) {
                defaultGeometry = new DefaultGeometry();
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS_STRIP);
                defaultGeometry.setVertices(this.lineVertices);
                appearance = new Appearance();
                appearance.setLineColor(ColorFactory.createColor(colorMap, n2));
                appearance.setLineWidth((float)d);
                appearance.setLinePattern(s);
                drawingTools.draw((Geometry)defaultGeometry, appearance);
            }
        }
        if (n == 4) {
            if (bl) {
                this.visitor.getArrowDrawer().drawArrows(polyline.getParentAxes(), this.barVertices, this.rectangleOutlineIndices, polyline.getArrowSizeFactor(), d, n2, false);
            } else {
                this.visitor.getArrowDrawer().drawArrows(polyline.getParentAxes(), this.lineVertices, this.lineIndices, polyline.getArrowSizeFactor(), d, n2, false);
            }
        }
        if (polyline.getMarkMode().booleanValue()) {
            defaultGeometry = new Appearance();
            defaultGeometry.setLineWidth((float)d);
            appearance = this.markManager.getMarkSprite((ContouredObject)polyline, colorMap, (Appearance)defaultGeometry);
            if (bl) {
                drawingTools.draw((Texture)appearance, AnchorPosition.CENTER, this.barVertices);
            } else {
                int n3 = legend.getMarksCount();
                if (n3 != 0) {
                    float[] fArray3;
                    switch (n3) {
                        case 1: {
                            fArray3 = new float[]{fArray2[4], fArray2[5], fArray2[6], fArray2[7]};
                            break;
                        }
                        case 2: {
                            fArray3 = new float[]{fArray2[0], fArray2[1], fArray2[2], fArray2[3], fArray2[8], fArray2[9], fArray2[10], fArray2[11]};
                            break;
                        }
                        default: {
                            fArray3 = new float[]{fArray2[0], fArray2[1], fArray2[2], fArray2[3], fArray2[4], fArray2[5], fArray2[6], fArray2[7], fArray2[8], fArray2[9], fArray2[10], fArray2[11]};
                        }
                    }
                    this.lineVertices.setData(fArray3, 4);
                    drawingTools.draw((Texture)appearance, AnchorPosition.CENTER, this.lineVertices);
                }
            }
        }
    }

    public void update(Integer n, int n2) {
        if (this.textureMap.containsKey(n) && SPRITE_PROPERTIES.contains(n2)) {
            this.dispose(n);
        }
    }

    public void dispose(Integer n) {
        Texture texture = this.textureMap.get(n);
        if (texture != null) {
            this.textureManager.dispose(texture);
            this.textureMap.remove(n);
        }
    }

    public void disposeAll() {
        this.visitor.getCanvas().getBuffersManager().dispose((DataBuffer)this.rectangleVertices);
        this.visitor.getCanvas().getBuffersManager().dispose((DataBuffer)this.lineVertices);
        this.visitor.getCanvas().getBuffersManager().dispose((DataBuffer)this.barVertices);
        this.visitor.getCanvas().getBuffersManager().dispose((DataBuffer)this.lineIndices);
        this.visitor.getCanvas().getBuffersManager().dispose((DataBuffer)this.rectangleIndices);
        this.visitor.getCanvas().getBuffersManager().dispose((DataBuffer)this.rectangleOutlineIndices);
        this.textureManager.dispose(this.textureMap.values());
        this.textureMap.clear();
    }

    private Texture getTexture(ColorMap colorMap, Legend legend) {
        Texture texture = this.textureMap.get(legend.getIdentifier());
        if (texture == null) {
            this.legendSpriteDrawer = new LegendSpriteDrawer(colorMap, legend);
            texture = this.textureManager.createTexture();
            texture.setDrawer((TextureDrawer)this.legendSpriteDrawer);
            this.textureMap.put(legend.getIdentifier(), texture);
        }
        return texture;
    }

    private int getNumberValidLinks(Legend legend) {
        Integer[] integerArray;
        int n = 0;
        for (Integer n2 : integerArray = legend.getLinks()) {
            Polyline polyline = (Polyline)GraphicController.getController().getObjectFromId(n2);
            if (polyline == null) continue;
            ++n;
        }
        return n;
    }

    private void updateLinks(Legend legend, int n) {
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(legend.getLinks().length);
        Integer[] integerArray = new Integer[]{n == 0 ? Integer.valueOf(1) : Integer.valueOf(n), 1};
        String[] stringArray = new String[integerArray[0].intValue()];
        if (n == 0) {
            stringArray[0] = new String("");
        }
        Integer[] integerArray2 = legend.getLinks();
        String[] stringArray2 = legend.getTextStrings();
        for (int i = 0; i < integerArray2.length; ++i) {
            Polyline polyline = (Polyline)GraphicController.getController().getObjectFromId(integerArray2[i]);
            if (polyline == null) continue;
            arrayList.add(integerArray2[i]);
            stringArray[n - n2 - 1] = new String(stringArray2[stringArray2.length - i - 1]);
            ++n2;
        }
        legend.setLinks(arrayList);
        legend.setTextArrayDimensions(integerArray);
        legend.setTextStrings(stringArray);
    }
}

