/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.label;

import java.awt.Dimension;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;

public abstract class LabelPositioner {
    protected boolean autoPosition = false;
    protected boolean autoRotation = false;
    protected Vector3d labelPosition = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d labelUserPosition = new Vector3d(0.0, 0.0, 0.0);
    protected double rotationAngle = 0.0;
    protected double userRotationAngle = 0.0;
    protected Vector3d labelDisplacement = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d anchorPoint = new Vector3d(0.0, 0.0, 0.0);
    protected AnchorPosition anchorPosition = AnchorPosition.LOWER_LEFT;
    protected Texture labelTexture = null;
    protected DrawingTools drawingTools = null;
    protected Axes parentAxes = null;
    protected boolean useWindowCoordinates = false;
    protected Vector3d projAnchorPoint = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d projHalfWidth = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d projHalfHeight = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d[] projCornerCoordinates = new Vector3d[4];

    public void setAutoPosition(boolean bl) {
        this.autoPosition = bl;
    }

    public boolean getAutoPosition() {
        return this.autoPosition;
    }

    public void setAutoRotation(boolean bl) {
        this.autoRotation = bl;
    }

    public boolean getAutoRotation() {
        return this.autoRotation;
    }

    public void setLabelPosition(Vector3d vector3d) {
        this.labelPosition = new Vector3d(vector3d);
    }

    public Vector3d getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelUserPosition(Vector3d vector3d) {
        this.labelUserPosition = new Vector3d(vector3d);
    }

    public Vector3d getLabelUserPosition() {
        return this.labelUserPosition;
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setUserRotationAngle(double d) {
        this.userRotationAngle = d;
    }

    public double getUserRotationAngle() {
        return this.userRotationAngle;
    }

    public void setLabelDisplacement(Vector3d vector3d) {
        this.labelDisplacement = new Vector3d(vector3d);
    }

    public Vector3d getLabelDisplacement() {
        return this.labelDisplacement;
    }

    public Vector3d getAnchorPoint() {
        return this.anchorPoint;
    }

    public AnchorPosition getAnchorPosition() {
        return this.anchorPosition;
    }

    public void setLabelTexture(Texture texture) {
        this.labelTexture = texture;
    }

    public void setDrawingTools(DrawingTools drawingTools) {
        this.drawingTools = drawingTools;
    }

    public void setParentAxes(Axes axes) {
        this.parentAxes = axes;
    }

    public boolean getUseWindowCoordinates() {
        return this.useWindowCoordinates;
    }

    public void positionLabel() {
        this.computeAnchorPoint();
        this.computeRotationAngle();
        this.computeAnchorPosition();
        this.computeCorners();
    }

    private void computeAnchorPoint() {
        this.anchorPoint = this.autoPosition ? this.computeDisplacedPosition() : this.labelUserPosition;
    }

    protected Vector3d computeDisplacedPosition() {
        Vector3d vector3d = new Vector3d(this.labelPosition);
        this.labelDisplacement = new Vector3d(0.0, 0.0, 0.0);
        return vector3d;
    }

    private void computeRotationAngle() {
        if (this.autoRotation) {
            this.setRotationAngle(this.getAutoRotationAngle());
        } else {
            this.setRotationAngle(this.userRotationAngle);
        }
    }

    protected double getAutoRotationAngle() {
        return 0.0;
    }

    protected AnchorPosition getAutoAnchorPosition() {
        return AnchorPosition.LEFT;
    }

    private void computeAnchorPosition() {
        this.anchorPosition = this.autoPosition ? this.getAutoAnchorPosition() : AnchorPosition.LOWER_LEFT;
    }

    private Vector3d computeLowerLeftCornerPosition(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Vector3d vector3d4 = new Vector3d(vector3d);
        if (this.anchorPosition == AnchorPosition.LEFT) {
            vector3d4 = vector3d4.minus(vector3d3);
        } else if (this.anchorPosition == AnchorPosition.RIGHT) {
            vector3d4 = vector3d4.minus(vector3d2.times(2.0));
            vector3d4 = vector3d4.minus(vector3d3);
        } else if (this.anchorPosition == AnchorPosition.UP) {
            vector3d4 = vector3d4.minus(vector3d2);
            vector3d4 = vector3d4.minus(vector3d3.times(2.0));
        } else if (this.anchorPosition == AnchorPosition.DOWN) {
            vector3d4 = vector3d4.minus(vector3d2);
        } else if (this.anchorPosition == AnchorPosition.UPPER_LEFT) {
            vector3d4 = vector3d4.minus(vector3d3.times(2.0));
        } else if (this.anchorPosition == AnchorPosition.UPPER_RIGHT) {
            vector3d4 = vector3d4.minus(vector3d2.times(2.0));
            vector3d4 = vector3d4.minus(vector3d3.times(2.0));
        } else if (this.anchorPosition != AnchorPosition.LOWER_LEFT && this.anchorPosition == AnchorPosition.LOWER_RIGHT) {
            vector3d4 = vector3d4.minus(vector3d2.times(2.0));
        }
        return vector3d4;
    }

    public Vector3d getLowerLeftCornerPosition() {
        Transformation transformation = this.drawingTools.getTransformationManager().getCanvasProjection();
        Vector3d vector3d = new Vector3d(this.anchorPoint);
        Vector3d vector3d2 = new Vector3d(this.projAnchorPoint);
        Vector3d vector3d3 = vector3d2.plus(this.projHalfWidth);
        Vector3d vector3d4 = transformation.unproject(vector3d3);
        Vector3d vector3d5 = vector3d4.minus(vector3d);
        Vector3d vector3d6 = vector3d2.plus(this.projHalfHeight);
        Vector3d vector3d7 = transformation.unproject(vector3d6);
        Vector3d vector3d8 = vector3d7.minus(vector3d);
        Vector3d vector3d9 = this.computeLowerLeftCornerPosition(vector3d, vector3d5, vector3d8);
        return vector3d9;
    }

    private void computeCorners() {
        Transformation transformation;
        Transformation transformation2 = this.drawingTools.getTransformationManager().getCanvasProjection();
        Vector3d vector3d = new Vector3d(this.anchorPoint);
        try {
            transformation = TransformationFactory.getRotationTransformation((double)this.rotationAngle, (double)0.0, (double)0.0, (double)1.0);
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            transformation = TransformationFactory.getIdentity();
        }
        Dimension dimension = this.labelTexture.getDataProvider().getTextureSize();
        this.projHalfWidth = new Vector3d(0.5 * dimension.getWidth(), 0.0, 0.0);
        this.projHalfHeight = new Vector3d(0.0, 0.5 * dimension.getHeight(), 0.0);
        this.projHalfWidth = transformation.projectDirection(this.projHalfWidth);
        this.projHalfHeight = transformation.projectDirection(this.projHalfHeight);
        this.projAnchorPoint = transformation2.project(vector3d);
        Vector3d vector3d2 = this.computeLowerLeftCornerPosition(this.projAnchorPoint, this.projHalfWidth, this.projHalfHeight);
        this.projCornerCoordinates[0] = new Vector3d(vector3d2);
        this.projCornerCoordinates[1] = vector3d2.plus(this.projHalfWidth.times(2.0));
        this.projCornerCoordinates[2] = vector3d2.plus(this.projHalfHeight.times(2.0));
        this.projCornerCoordinates[3] = this.projCornerCoordinates[2].plus(this.projHalfWidth.times(2.0));
    }

    public Vector3d[] getProjCorners() {
        return this.projCornerCoordinates;
    }
}

