/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.BuffersManager;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.axes.ruler.AxesRulerSpriteFactory;
import org.scilab.modules.renderer.JoGLView.interaction.FigureInteraction;
import org.scilab.modules.renderer.JoGLView.interaction.RubberBoxListener;
import org.scilab.modules.renderer.JoGLView.interaction.util.HelpersGeometry;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointAComputer;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointBComputer;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointCComputer;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointComputer;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointDComputer;
import org.scilab.modules.renderer.JoGLView.postRendering.PostRendered;

public class RubberBox
extends FigureInteraction
implements PostRendered,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.###E0");
    private static final String[] AXES_NAMES;
    private static final int[] CUBE_INDICES;
    private static final Color RUBBER_BOX_COLOR;
    private static final float RUBBER_BOX_THICKNESS = 2.0f;
    private static final short RUBBER_BOX_PATTERN = -1286;
    private static Appearance helpersAppearance;
    private static Appearance cubeAppearance;
    private final EventListenerList listenerList = new EventListenerList();
    private HelpersGeometry helpersGeometry;
    private DefaultGeometry cubeGeometry;
    protected Status status = Status.WAIT_POINT_A;
    protected ArrayList<AxesZoom> axesZoomList = new ArrayList();
    protected int mouseButton;
    protected Point lastPoint = null;

    protected RubberBox(DrawerVisitor drawerVisitor) {
        super(drawerVisitor);
    }

    public final void addListener(RubberBoxListener rubberBoxListener) {
        this.listenerList.add(RubberBoxListener.class, rubberBoxListener);
    }

    public final void removeListener(RubberBoxListener rubberBoxListener) {
        this.listenerList.remove(RubberBoxListener.class, rubberBoxListener);
    }

    protected void fireRubberBoxEnd() {
        for (RubberBoxListener rubberBoxListener : (RubberBoxListener[])this.listenerList.getListeners(RubberBoxListener.class)) {
            rubberBoxListener.rubberBoxEnd();
        }
    }

    @Override
    public final void draw(DrawingTools drawingTools) throws SciRendererException {
        if (this.isEnable()) {
            for (AxesZoom axesZoom : this.axesZoomList) {
                drawingTools.getTransformationManager().useSceneCoordinate();
                drawingTools.getTransformationManager().getModelViewStack().push(this.getDrawerVisitor().getAxesDrawer().getSceneProjection(axesZoom.axes.getIdentifier()));
                if (this.status != Status.WAIT_POINT_A) {
                    drawingTools.draw(this.getCubeGeometry(drawingTools, axesZoom), this.getCubeAppearance());
                }
                if (axesZoom.secondPoint != null) {
                    drawingTools.draw(this.getHelpersGeometry(drawingTools, axesZoom), this.getHelpersAppearance());
                }
                drawingTools.getTransformationManager().getModelViewStack().pop();
            }
        }
    }

    @Override
    public final void changeEnable(boolean bl) {
        Component component = this.getDrawerVisitor().getComponent();
        if (bl) {
            this.axesZoomList.clear();
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            component.addKeyListener(this);
            component.setFocusTraversalKeysEnabled(false);
            component.setFocusable(true);
            component.requestFocus();
        } else {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            component.removeKeyListener(this);
        }
        this.updateInfoMessage(null);
        this.getDrawerVisitor().getCanvas().redraw();
    }

    @Override
    public final void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            this.mouseButton = -1;
            this.setEnable(false);
            this.fireRubberBoxEnd();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseButton = mouseEvent.getButton();
        this.lastPoint = mouseEvent.getPoint();
        switch (this.status) {
            case WAIT_POINT_A: {
                if (this.setPointA(mouseEvent.getPoint())) {
                    this.status = Status.WAIT_POINT_B;
                    break;
                }
                this.setEnable(false);
                this.fireRubberBoxEnd();
                break;
            }
            case WAIT_POINT_B: {
                this.setPointB(mouseEvent.getPoint());
                if (!this.valid3D()) {
                    this.process();
                    this.setEnable(false);
                    this.fireRubberBoxEnd();
                    break;
                }
                this.status = Status.WAIT_POINT_C;
                break;
            }
            case WAIT_POINT_C: {
                this.setPointC(mouseEvent.getPoint());
                this.status = Status.WAIT_POINT_D;
                break;
            }
            case WAIT_POINT_D: {
                this.setPointD(mouseEvent.getPoint());
                this.process();
                this.setEnable(false);
                this.fireRubberBoxEnd();
                break;
            }
        }
        this.updateInfoMessage(mouseEvent.getPoint());
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
        switch (this.status) {
            case WAIT_POINT_A: {
                this.setPointA(mouseEvent.getPoint());
                this.getDrawerVisitor().getCanvas().redraw();
                break;
            }
            case WAIT_POINT_B: {
                this.setPointB(mouseEvent.getPoint());
                this.getDrawerVisitor().getCanvas().redraw();
                break;
            }
            case WAIT_POINT_C: {
                this.setPointC(mouseEvent.getPoint());
                this.getDrawerVisitor().getCanvas().redraw();
                break;
            }
            case WAIT_POINT_D: {
                this.setPointD(mouseEvent.getPoint());
                this.getDrawerVisitor().getCanvas().redraw();
                break;
            }
        }
        this.updateInfoMessage(mouseEvent.getPoint());
    }

    protected void updateInfoMessage(Point point) {
        if (this.isEnable()) {
            Axes axes = null;
            PointComputer pointComputer = null;
            PointComputer pointComputer2 = null;
            PointComputer pointComputer3 = null;
            PointComputer pointComputer4 = null;
            AxesZoom axesZoom = this.getClosestAxesZoom(point);
            if (axesZoom != null) {
                axes = axesZoom.axes;
                pointComputer = axesZoom.pointAComputer;
                pointComputer2 = axesZoom.pointBComputer;
                pointComputer3 = axesZoom.pointCComputer;
                pointComputer4 = axesZoom.pointDComputer;
            }
            switch (this.status) {
                case WAIT_POINT_A: {
                    this.setInfoMessage(Messages.gettext((String)"Click to set first bounds"), axes, pointComputer, false);
                    break;
                }
                case WAIT_POINT_B: {
                    this.setInfoMessage(Messages.gettext((String)"Click to set second bounds"), axes, pointComputer2, false);
                    break;
                }
                case WAIT_POINT_C: {
                    this.setInfoMessage(Messages.gettext((String)"Click to set first"), axes, pointComputer3, true);
                    break;
                }
                case WAIT_POINT_D: {
                    this.setInfoMessage(Messages.gettext((String)"Click to set second"), axes, pointComputer4, true);
                    break;
                }
            }
        } else {
            GraphicController.getController().setProperty(this.getDrawerVisitor().getFigure().getIdentifier(), 89, (Object)"");
        }
    }

    private void setInfoMessage(String string, Axes axes, PointComputer pointComputer, boolean bl) {
        if (pointComputer != null && pointComputer.isValid()) {
            String string2 = string + " ";
            double[] dArray = pointComputer.getSecondPosition().getData();
            double[][] dArray2 = axes.getScaleTranslateFactors();
            dArray[0] = (dArray[0] - dArray2[1][0]) / dArray2[0][0];
            dArray[1] = (dArray[1] - dArray2[1][1]) / dArray2[0][1];
            dArray[2] = (dArray[2] - dArray2[1][2]) / dArray2[0][2];
            String string3 = bl ? "" : ", ";
            for (int i = 0; i < 3; ++i) {
                if (!(i != pointComputer.getFirstAxisIndex() ^ bl)) continue;
                string2 = string2 + AXES_NAMES[i] + " = " + DECIMAL_FORMAT.format(dArray[i]) + string3;
                string3 = "";
            }
            GraphicController.getController().setProperty(this.getDrawerVisitor().getFigure().getIdentifier(), 89, (Object)string2);
        } else {
            String string4 = Messages.gettext((String)"Move your mouse on an axes box.");
            GraphicController.getController().setProperty(this.getDrawerVisitor().getFigure().getIdentifier(), 89, (Object)string4);
        }
    }

    protected void process() {
    }

    protected boolean setPointA(Point point) {
        Axes[] axesArray;
        this.axesZoomList.clear();
        boolean bl = false;
        for (Axes axes : axesArray = this.getAllVisibleAxes(point)) {
            AxesZoom axesZoom = new AxesZoom(axes);
            PointAComputer pointAComputer = new PointAComputer(axes, point);
            if (!pointAComputer.isValid()) continue;
            axesZoom.pointAComputer = pointAComputer;
            axesZoom.secondPoint = axesZoom.firstPoint = pointAComputer.getPosition();
            this.axesZoomList.add(axesZoom);
            bl = true;
        }
        return bl;
    }

    protected boolean setPointB(Point point) {
        boolean bl = false;
        for (AxesZoom axesZoom : this.axesZoomList) {
            PointBComputer pointBComputer = new PointBComputer(axesZoom.axes, axesZoom.pointAComputer, point);
            if (!pointBComputer.isValid()) continue;
            axesZoom.pointBComputer = pointBComputer;
            axesZoom.firstPoint = pointBComputer.getFirstPosition();
            axesZoom.secondPoint = pointBComputer.getSecondPosition();
            this.getDrawerVisitor().getCanvas().redraw();
            bl = true;
        }
        return bl;
    }

    protected boolean setPointC(Point point) {
        boolean bl = false;
        for (AxesZoom axesZoom : this.axesZoomList) {
            PointCComputer pointCComputer;
            if (axesZoom.pointBComputer.is2D() || !(pointCComputer = new PointCComputer(axesZoom.axes, axesZoom.pointBComputer, point)).isValid()) continue;
            axesZoom.pointCComputer = pointCComputer;
            axesZoom.firstPoint = pointCComputer.getFirstPosition();
            axesZoom.secondPoint = pointCComputer.getSecondPosition();
            this.getDrawerVisitor().getCanvas().redraw();
            bl = true;
        }
        return bl;
    }

    protected boolean setPointD(Point point) {
        boolean bl = false;
        for (AxesZoom axesZoom : this.axesZoomList) {
            PointDComputer pointDComputer;
            if (axesZoom.pointBComputer.is2D() || !(pointDComputer = new PointDComputer(axesZoom.axes, axesZoom.pointCComputer, point)).isValid()) continue;
            axesZoom.pointDComputer = pointDComputer;
            axesZoom.firstPoint = pointDComputer.getFirstPosition();
            axesZoom.secondPoint = pointDComputer.getSecondPosition();
            this.getDrawerVisitor().getCanvas().redraw();
            bl = true;
        }
        return bl;
    }

    private Geometry getHelpersGeometry(DrawingTools drawingTools, AxesZoom axesZoom) {
        if (this.helpersGeometry == null) {
            this.helpersGeometry = new HelpersGeometry(drawingTools);
        }
        this.helpersGeometry.updateVertex(axesZoom.axes, axesZoom.pointAComputer, axesZoom.secondPoint, this.status);
        return this.helpersGeometry;
    }

    public final Appearance getHelpersAppearance() {
        if (helpersAppearance == null) {
            helpersAppearance = new Appearance();
            helpersAppearance.setLineColor(new Color(1.0f, 0.0f, 0.0f));
            helpersAppearance.setLineWidth(2.0f);
        }
        return helpersAppearance;
    }

    private Geometry getCubeGeometry(DrawingTools drawingTools, AxesZoom axesZoom) {
        if (this.cubeGeometry == null) {
            this.cubeGeometry = new DefaultGeometry();
            BuffersManager buffersManager = drawingTools.getCanvas().getBuffersManager();
            ElementsBuffer elementsBuffer = buffersManager.createElementsBuffer();
            IndicesBuffer indicesBuffer = buffersManager.createIndicesBuffer();
            indicesBuffer.setData(CUBE_INDICES);
            this.cubeGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
            this.cubeGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
            this.cubeGeometry.setVertices(elementsBuffer);
            this.cubeGeometry.setWireIndices(indicesBuffer);
        }
        this.cubeGeometry.getVertices().setData(new float[]{(float)axesZoom.firstPoint.getX(), (float)axesZoom.firstPoint.getY(), (float)axesZoom.firstPoint.getZ(), 1.0f, (float)axesZoom.firstPoint.getX(), (float)axesZoom.firstPoint.getY(), (float)axesZoom.secondPoint.getZ(), 1.0f, (float)axesZoom.firstPoint.getX(), (float)axesZoom.secondPoint.getY(), (float)axesZoom.secondPoint.getZ(), 1.0f, (float)axesZoom.firstPoint.getX(), (float)axesZoom.secondPoint.getY(), (float)axesZoom.firstPoint.getZ(), 1.0f, (float)axesZoom.secondPoint.getX(), (float)axesZoom.firstPoint.getY(), (float)axesZoom.firstPoint.getZ(), 1.0f, (float)axesZoom.secondPoint.getX(), (float)axesZoom.firstPoint.getY(), (float)axesZoom.secondPoint.getZ(), 1.0f, (float)axesZoom.secondPoint.getX(), (float)axesZoom.secondPoint.getY(), (float)axesZoom.secondPoint.getZ(), 1.0f, (float)axesZoom.secondPoint.getX(), (float)axesZoom.secondPoint.getY(), (float)axesZoom.firstPoint.getZ(), 1.0f}, 4);
        return this.cubeGeometry;
    }

    private Appearance getCubeAppearance() {
        if (cubeAppearance == null) {
            cubeAppearance = new Appearance();
            cubeAppearance.setLineColor(RUBBER_BOX_COLOR);
            cubeAppearance.setLineWidth(2.0f);
            cubeAppearance.setLinePattern((short)-1286);
        }
        return cubeAppearance;
    }

    private double calculateAxesDistance2(Double[] doubleArray, double d, double d2) {
        boolean bl;
        double d3 = doubleArray[0] + doubleArray[2];
        double d4 = doubleArray[1] + doubleArray[3];
        double d5 = doubleArray[0];
        double d6 = doubleArray[1];
        boolean bl2 = d >= d5 && d <= d3;
        boolean bl3 = bl = d2 >= d6 && d2 <= d4;
        if (bl2 && bl) {
            return 0.0;
        }
        d6 -= d2;
        d4 -= d2;
        d6 *= d6;
        d4 *= d4;
        if (bl2) {
            return Math.min(d6, d4);
        }
        d5 -= d;
        d3 -= d;
        d5 *= d5;
        d3 *= d3;
        if (bl) {
            return Math.min(d5, d3);
        }
        return Math.min(Math.min(d5 + d6, d5 + d4), Math.min(d3 + d6, d3 + d4));
    }

    protected AxesZoom getClosestAxesZoom(Point point) {
        AxesZoom axesZoom = null;
        if (point == null) {
            point = new Point(0, 0);
        }
        double d = Double.MAX_VALUE;
        Dimension dimension = this.drawerVisitor.getCanvas().getDimension();
        double d2 = point.getX() / dimension.getWidth();
        double d3 = point.getY() / dimension.getHeight();
        for (AxesZoom axesZoom2 : this.axesZoomList) {
            Double[] doubleArray = axesZoom2.axes.getAxesBounds();
            double d4 = this.calculateAxesDistance2(doubleArray, d2, d3);
            if (!(d > d4)) continue;
            axesZoom = axesZoom2;
            d = d4;
        }
        return axesZoom;
    }

    protected boolean valid3D() {
        boolean bl = false;
        for (AxesZoom axesZoom : this.axesZoomList) {
            if (axesZoom.pointBComputer == null || axesZoom.pointBComputer.is2D()) continue;
            Double[] doubleArray = new Double[]{axesZoom.firstPoint.getX(), axesZoom.secondPoint.getX(), axesZoom.firstPoint.getY(), axesZoom.secondPoint.getY(), axesZoom.firstPoint.getZ(), axesZoom.secondPoint.getZ()};
            int n = 0;
            n = doubleArray[0].compareTo(doubleArray[1]) != 0 ? ++n : n;
            n = doubleArray[2].compareTo(doubleArray[3]) != 0 ? ++n : n;
            n = doubleArray[4].compareTo(doubleArray[5]) != 0 ? ++n : n;
            if (n < 2) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public double[] getResults() {
        AxesZoom axesZoom = this.getClosestAxesZoom(this.lastPoint);
        if (axesZoom != null) {
            double[][] dArray = axesZoom.axes.getScaleTranslateFactors();
            double[] dArray2 = new double[]{this.mouseButton - 1, (Math.min(axesZoom.firstPoint.getX(), axesZoom.secondPoint.getX()) - dArray[1][0]) / dArray[0][0], (Math.max(axesZoom.firstPoint.getY(), axesZoom.secondPoint.getY()) - dArray[1][1]) / dArray[0][1], (Math.max(axesZoom.firstPoint.getZ(), axesZoom.secondPoint.getZ()) - dArray[1][2]) / dArray[0][2], Math.abs(axesZoom.firstPoint.getX() - axesZoom.secondPoint.getX()) / dArray[0][0], Math.abs(axesZoom.firstPoint.getY() - axesZoom.secondPoint.getY()) / dArray[0][1], Math.abs(axesZoom.firstPoint.getZ() - axesZoom.secondPoint.getZ()) / dArray[0][2]};
            return dArray2;
        }
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    static {
        AxesRulerSpriteFactory.setScilabStyle(DECIMAL_FORMAT);
        AXES_NAMES = new String[]{"X", "Y", "Z"};
        CUBE_INDICES = new int[]{0, 1, 3, 2, 4, 5, 7, 6, 0, 3, 1, 2, 4, 7, 5, 6, 0, 4, 1, 5, 3, 7, 2, 6};
        RUBBER_BOX_COLOR = new Color(0.2f, 0.3f, 0.4f);
    }

    public static enum Status {
        WAIT_POINT_A,
        WAIT_POINT_B,
        WAIT_POINT_C,
        WAIT_POINT_D;

    }

    protected class AxesZoom {
        public final Axes axes;
        public PointComputer pointAComputer;
        public PointComputer pointBComputer;
        public PointComputer pointCComputer;
        public PointComputer pointDComputer;
        public Vector3d firstPoint;
        public Vector3d secondPoint;

        public AxesZoom(Axes axes) {
            this.axes = axes;
            this.firstPoint = new Vector3d(0.0, 0.0, 0.0);
            this.secondPoint = new Vector3d(0.0, 0.0, 0.0);
        }
    }
}

