/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.interaction.PointRubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.RubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointAComputer;

public class OnePointRubberBox
extends RubberBox
implements PointRubberBox {
    public OnePointRubberBox(DrawerVisitor drawerVisitor) {
        super(drawerVisitor);
    }

    public OnePointRubberBox(DrawerVisitor drawerVisitor, double[] dArray) {
        super(drawerVisitor);
        this.status = RubberBox.Status.WAIT_POINT_B;
        this.setEnable(true);
        RubberBox.AxesZoom axesZoom = new RubberBox.AxesZoom(this, drawerVisitor.getAxes());
        double[][] dArray2 = axesZoom.axes.getScaleTranslateFactors();
        axesZoom.secondPoint = axesZoom.firstPoint = new Vector3d(dArray[0] * dArray2[0][0] + dArray2[1][0], dArray[1] * dArray2[0][1] + dArray2[1][1], 0.0);
        this.axesZoomList.add(axesZoom);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseButton = mouseEvent.getButton();
        this.lastPoint = mouseEvent.getPoint();
        this.setPointB(mouseEvent.getPoint());
        this.process();
        this.setEnable(false);
        this.fireRubberBoxEnd();
    }

    @Override
    protected boolean setPointB(Point point) {
        PointAComputer pointAComputer;
        RubberBox.AxesZoom axesZoom = this.getClosestAxesZoom(point);
        if (axesZoom != null && (pointAComputer = new PointAComputer(axesZoom.axes, point)).isValid()) {
            axesZoom.pointBComputer = pointAComputer;
            axesZoom.secondPoint = pointAComputer.getPosition();
            return true;
        }
        return false;
    }
}

