/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction;

import org.scilab.modules.commons.utils.BlockingResult;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.interaction.DragPointRubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.DragZoomRotateInteraction;
import org.scilab.modules.renderer.JoGLView.interaction.OnePointRubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.PointRubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.RubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.RubberBoxListener;
import org.scilab.modules.renderer.JoGLView.interaction.TwoPointsRubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.ZoomRubberBox;

public class InteractionManager
implements RubberBoxListener {
    private RubberBox rubberBox;
    private final DragZoomRotateInteraction dragZoomRotateInteraction;
    private DrawerVisitor drawerVisitor;

    public InteractionManager(DrawerVisitor drawerVisitor) {
        this.drawerVisitor = drawerVisitor;
        this.dragZoomRotateInteraction = new DragZoomRotateInteraction(drawerVisitor);
        this.dragZoomRotateInteraction.setEnable(true);
    }

    public void finalize() throws Throwable {
        if (this.rubberBox != null) {
            this.rubberBox.removeListener(this);
        }
        super.finalize();
    }

    public void startInteractiveZoom() {
        final ZoomRubberBox zoomRubberBox = new ZoomRubberBox(this.drawerVisitor);
        this.dragZoomRotateInteraction.setEnable(false);
        zoomRubberBox.addListener(new RubberBoxListener(){

            @Override
            public void rubberBoxEnd() {
                InteractionManager.this.dragZoomRotateInteraction.setEnable(true);
                InteractionManager.this.drawerVisitor.removePostRendering(zoomRubberBox);
            }
        });
        this.drawerVisitor.addPostRendering(zoomRubberBox);
        zoomRubberBox.setEnable(true);
    }

    public double[] startClickRubberBox(double[] dArray) {
        final BlockingResult blockingResult = new BlockingResult();
        RubberBox rubberBox = dArray.length == 0 ? new TwoPointsRubberBox(this.drawerVisitor) : new OnePointRubberBox(this.drawerVisitor, dArray);
        this.dragZoomRotateInteraction.setEnable(false);
        rubberBox.addListener(new RubberBoxListener((PointRubberBox)((Object)rubberBox)){
            final /* synthetic */ PointRubberBox val$rubberBox;
            {
                this.val$rubberBox = pointRubberBox;
            }

            @Override
            public void rubberBoxEnd() {
                blockingResult.setResult((Object)this.val$rubberBox.getResults());
                InteractionManager.this.dragZoomRotateInteraction.setEnable(true);
                InteractionManager.this.drawerVisitor.removePostRendering(this.val$rubberBox);
            }
        });
        this.drawerVisitor.addPostRendering(rubberBox);
        rubberBox.setEnable(true);
        return (double[])blockingResult.getResult();
    }

    public double[] startDragRubberBox() {
        final BlockingResult blockingResult = new BlockingResult();
        final DragPointRubberBox dragPointRubberBox = new DragPointRubberBox(this.drawerVisitor);
        this.dragZoomRotateInteraction.setEnable(false);
        dragPointRubberBox.addListener(new RubberBoxListener(){

            @Override
            public void rubberBoxEnd() {
                blockingResult.setResult((Object)dragPointRubberBox.getResults());
                InteractionManager.this.dragZoomRotateInteraction.setEnable(true);
                InteractionManager.this.drawerVisitor.removePostRendering(dragPointRubberBox);
            }
        });
        this.drawerVisitor.addPostRendering(dragPointRubberBox);
        dragPointRubberBox.setEnable(true);
        return (double[])blockingResult.getResult();
    }

    @Override
    public void rubberBoxEnd() {
        this.dragZoomRotateInteraction.setEnable(true);
        this.rubberBox = null;
    }

    public boolean isInteractiveZoom() {
        return !this.dragZoomRotateInteraction.isEnable();
    }

    public void setTranslationEnable(boolean bl) {
        this.dragZoomRotateInteraction.setTranslationEnable(bl);
    }
}

