/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.scilab.modules.commons.OS;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.renderer.CallRenderer;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.interaction.FigureInteraction;
import org.scilab.modules.renderer.JoGLView.util.ScaleUtils;
import org.scilab.modules.renderer.utils.EntityPicker;

public class DragZoomRotateInteraction
extends FigureInteraction {
    private static final int XY_TRANSLATION_MODIFIER = 16;
    private static final int Z_TRANSLATION_MODIFIER = 24;
    private static final int ROTATION_MODIFIER = 4;
    private static final int MACOSX_ROTATION_MODIFIER = 18;
    private static final double ZOOM_FACTOR = 1.02;
    private final MouseListener mouseListener;
    private final MouseWheelListener mouseWheelListener;
    private final MouseMotionListener mouseMotionListener = new FigureMouseMotionListener();
    private MouseEvent previousEvent;
    private Axes[] currentAxes;

    public DragZoomRotateInteraction(DrawerVisitor drawerVisitor) {
        super(drawerVisitor);
        this.mouseWheelListener = new FigureMouseWheelListener();
        this.mouseListener = new FigureMouseListener();
        this.currentAxes = new Axes[0];
    }

    @Override
    protected void changeEnable(boolean bl) {
        Component component = this.getDrawerVisitor().getComponent();
        if (component != null) {
            if (bl) {
                component.addMouseListener(this.mouseListener);
                component.addMouseWheelListener(this.mouseWheelListener);
            } else {
                component.removeMouseListener(this.mouseListener);
                component.removeMouseMotionListener(this.mouseMotionListener);
                component.removeMouseWheelListener(this.mouseWheelListener);
            }
        }
    }

    public void setTranslationEnable(boolean bl) {
        ((FigureMouseMotionListener)this.mouseMotionListener).setTranslateEnable(bl);
    }

    private static void applyUnlog(Double[] doubleArray, Axes axes) {
        if (axes.getXAxisLogFlag().booleanValue()) {
            doubleArray[0] = Math.pow(10.0, doubleArray[0]);
            doubleArray[1] = Math.pow(10.0, doubleArray[1]);
        }
        if (axes.getYAxisLogFlag().booleanValue()) {
            doubleArray[2] = Math.pow(10.0, doubleArray[2]);
            doubleArray[3] = Math.pow(10.0, doubleArray[3]);
        }
        if (axes.getZAxisLogFlag().booleanValue()) {
            doubleArray[4] = Math.pow(10.0, doubleArray[4]);
            doubleArray[5] = Math.pow(10.0, doubleArray[5]);
        }
    }

    static /* synthetic */ Axes[] access$402(DragZoomRotateInteraction dragZoomRotateInteraction, Axes[] axesArray) {
        dragZoomRotateInteraction.currentAxes = axesArray;
        return axesArray;
    }

    private class FigureMouseMotionListener
    extends MouseMotionAdapter
    implements MouseMotionListener {
        private boolean translateEnabled = true;

        private FigureMouseMotionListener() {
        }

        public void setTranslateEnable(boolean bl) {
            this.translateEnabled = bl;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (OS.get() == OS.MAC && mouseEvent.isControlDown() && mouseEvent.getButton() == 0) {
                this.doRotation(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            switch (mouseEvent.getModifiers()) {
                case 18: {
                    if (OS.get() != OS.MAC || !mouseEvent.isControlDown()) break;
                    this.doRotation(mouseEvent);
                    break;
                }
                case 16: {
                    if (!this.translateEnabled) break;
                    this.doXYTranslation(mouseEvent);
                    break;
                }
                case 24: {
                    this.doZTranslation(mouseEvent);
                    break;
                }
                case 4: {
                    this.doRotation(mouseEvent);
                }
            }
            DragZoomRotateInteraction.this.previousEvent = mouseEvent;
        }

        private void doRotation(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - DragZoomRotateInteraction.this.previousEvent.getX();
            int n2 = mouseEvent.getY() - DragZoomRotateInteraction.this.previousEvent.getY();
            for (Axes axes : DragZoomRotateInteraction.this.currentAxes) {
                Double[] doubleArray;
                if (axes.getView() == 0) continue;
                Double[] doubleArray2 = doubleArray = axes.getRotationAngles();
                Double.valueOf(doubleArray2[0] - (double)n2 / 4.0);
                doubleArray2 = doubleArray;
                Double.valueOf(doubleArray2[1] - Math.signum(Math.sin(Math.toRadians(doubleArray[0]))) * ((double)n / 4.0));
                GraphicController.getController().setProperty(axes.getIdentifier(), 168, (Object)doubleArray);
            }
        }

        private void doXYTranslation(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - DragZoomRotateInteraction.this.previousEvent.getX();
            int n2 = mouseEvent.getY() - DragZoomRotateInteraction.this.previousEvent.getY();
            for (Axes axes : DragZoomRotateInteraction.this.currentAxes) {
                Object object;
                Double[] doubleArray;
                if (!axes.getZoomEnabled().booleanValue()) continue;
                Double[] doubleArray2 = axes.getDisplayedBounds();
                Integer[] integerArray = (Integer[])GraphicController.getController().getProperty(axes.getParent(), 85);
                if (integerArray == null) {
                    doubleArray = (Double[])GraphicController.getController().getProperty(axes.getParent(), 80);
                    integerArray = new Integer[]{doubleArray[2].intValue(), doubleArray[3].intValue()};
                }
                doubleArray = (Double[])GraphicController.getController().getProperty(axes.getIdentifier(), 183);
                Double[] doubleArray3 = (Double[])GraphicController.getController().getProperty(axes.getIdentifier(), 181);
                Integer n3 = (Integer)GraphicController.getController().getProperty(axes.getIdentifier(), 165);
                double d = Math.abs(doubleArray2[0] - doubleArray2[1]) / ((double)integerArray[0].intValue() * doubleArray[2] * (1.0 - doubleArray3[0] - doubleArray3[1]));
                double d2 = Math.abs(doubleArray2[2] - doubleArray2[3]) / ((double)integerArray[1].intValue() * doubleArray[3] * (1.0 - doubleArray3[2] - doubleArray3[3]));
                if (n3 == 0) {
                    object = doubleArray2;
                    Double.valueOf(object[0] - d * (double)n);
                    object = doubleArray2;
                    Double.valueOf(object[1] - d * (double)n);
                    object = doubleArray2;
                    Double.valueOf(object[2] + d2 * (double)n2);
                    object = doubleArray2;
                    Double.valueOf(object[3] + d2 * (double)n2);
                } else {
                    double d3 = -Math.signum(Math.cos(Math.toRadians(axes.getRotationAngles()[0])));
                    double d4 = -d3 * Math.toRadians(axes.getRotationAngles()[1]);
                    double d5 = (double)n * Math.sin(d4) + (double)n2 * Math.cos(d4);
                    double d6 = (double)n * Math.cos(d4) - (double)n2 * Math.sin(d4);
                    Double[] doubleArray4 = doubleArray2;
                    Double.valueOf(doubleArray4[0] - d * d5 * d3);
                    doubleArray4 = doubleArray2;
                    Double.valueOf(doubleArray4[1] - d * d5 * d3);
                    doubleArray4 = doubleArray2;
                    Double.valueOf(doubleArray4[2] + d2 * d6);
                    doubleArray4 = doubleArray2;
                    Double.valueOf(doubleArray4[3] + d2 * d6);
                }
                object = this.tightZoomBoxToDataBounds(axes, doubleArray2);
                boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
                ScaleUtils.applyInverseLogScaleToBounds(doubleArray2, blArray);
                GraphicController.getController().setProperty(axes.getIdentifier(), 178, (Object)doubleArray2);
                GraphicController.getController().setProperty(axes.getIdentifier(), 177, object);
            }
        }

        private void doZTranslation(MouseEvent mouseEvent) {
            int n = mouseEvent.getY() - DragZoomRotateInteraction.this.previousEvent.getY();
            for (Axes axes : DragZoomRotateInteraction.this.currentAxes) {
                Double[] doubleArray = axes.getDisplayedBounds();
                double d = (doubleArray[5] - doubleArray[4]) / 100.0;
                Object object = doubleArray;
                Double.valueOf(object[4] + d * (double)n);
                object = doubleArray;
                Double.valueOf(object[5] + d * (double)n);
                object = this.tightZoomBoxToDataBounds(axes, doubleArray);
                boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
                ScaleUtils.applyInverseLogScaleToBounds(doubleArray, blArray);
                GraphicController.getController().setProperty(axes.getIdentifier(), 178, (Object)doubleArray);
                GraphicController.getController().setProperty(axes.getIdentifier(), 177, object);
            }
        }

        private boolean tightZoomBoxToDataBounds(Axes axes, Double[] doubleArray) {
            int n;
            Double[] doubleArray2;
            double d;
            boolean bl = false;
            Double[] doubleArray3 = axes.getMaximalDisplayedBounds();
            for (int n2 : new int[]{0, 2, 4}) {
                if (doubleArray[n2] < doubleArray3[n2]) {
                    d = doubleArray3[n2] - doubleArray[n2];
                    doubleArray[n2] = doubleArray3[n2];
                    doubleArray2 = doubleArray;
                    n = n2 + 1;
                    Double.valueOf(doubleArray2[n] + d);
                    continue;
                }
                bl = true;
            }
            for (int n2 : new int[]{1, 3, 5}) {
                if (doubleArray[n2] > doubleArray3[n2]) {
                    d = doubleArray3[n2] - doubleArray[n2];
                    doubleArray[n2] = doubleArray3[n2];
                    doubleArray2 = doubleArray;
                    n = n2 - 1;
                    Double.valueOf(doubleArray2[n] + d);
                    continue;
                }
                bl = true;
            }
            return bl;
        }
    }

    private class FigureMouseWheelListener
    implements MouseWheelListener {
        private FigureMouseWheelListener() {
        }

        private void applyZoom(Axes axes, double d, double[] dArray) {
            if (axes != null) {
                Double[] doubleArray = axes.getDisplayedBounds();
                double[][] dArray2 = axes.getScaleTranslateFactors();
                if (dArray[0] > doubleArray[0] && dArray[0] < doubleArray[1] && dArray[1] > doubleArray[2] && dArray[1] < doubleArray[3] && dArray[2] > doubleArray[4] && dArray[2] < doubleArray[5]) {
                    doubleArray[0] = dArray[0] + (doubleArray[0] - dArray[0]) * d;
                    doubleArray[1] = dArray[0] + (doubleArray[1] - dArray[0]) * d;
                    doubleArray[2] = dArray[1] + (doubleArray[2] - dArray[1]) * d;
                    doubleArray[3] = dArray[1] + (doubleArray[3] - dArray[1]) * d;
                    doubleArray[4] = dArray[2] + (doubleArray[4] - dArray[2]) * d;
                    doubleArray[5] = dArray[2] + (doubleArray[5] - dArray[2]) * d;
                    doubleArray[0] = doubleArray[0] * dArray2[0][0] + dArray2[1][0];
                    doubleArray[1] = doubleArray[1] * dArray2[0][0] + dArray2[1][0];
                    doubleArray[2] = doubleArray[2] * dArray2[0][1] + dArray2[1][1];
                    doubleArray[3] = doubleArray[3] * dArray2[0][1] + dArray2[1][1];
                    doubleArray[4] = doubleArray[4] * dArray2[0][2] + dArray2[1][2];
                    doubleArray[5] = doubleArray[5] * dArray2[0][2] + dArray2[1][2];
                    Boolean bl = DragZoomRotateInteraction.this.tightZoomBounds(axes, doubleArray);
                    doubleArray[0] = (doubleArray[0] - dArray2[1][0]) / dArray2[0][0];
                    doubleArray[1] = (doubleArray[1] - dArray2[1][0]) / dArray2[0][0];
                    doubleArray[2] = (doubleArray[2] - dArray2[1][1]) / dArray2[0][1];
                    doubleArray[3] = (doubleArray[3] - dArray2[1][1]) / dArray2[0][1];
                    doubleArray[4] = (doubleArray[4] - dArray2[1][2]) / dArray2[0][2];
                    doubleArray[5] = (doubleArray[5] - dArray2[1][2]) / dArray2[0][2];
                    boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
                    ScaleUtils.applyInverseLogScaleToBounds(doubleArray, blArray);
                    GraphicController.getController().setProperty(axes.getIdentifier(), 178, (Object)doubleArray);
                    GraphicController.getController().setProperty(axes.getIdentifier(), 177, (Object)bl);
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            Axes[] axesArray = mouseWheelEvent.isControlDown() ? DragZoomRotateInteraction.this.getAllVisibleAxes(mouseWheelEvent.getPoint()) : DragZoomRotateInteraction.this.getAllUnderlyingAxes(mouseWheelEvent.getPoint());
            double d = Math.pow(1.02, mouseWheelEvent.getUnitsToScroll());
            double[] dArray = null;
            for (Axes axes : axesArray) {
                Object object;
                Double[] doubleArray = axes.getDisplayedBounds();
                Double[] doubleArray2 = axes.getDisplayedBounds();
                boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
                ScaleUtils.applyInverseLogScaleToBounds(doubleArray2, blArray);
                EntityPicker entityPicker = new EntityPicker();
                Integer n = entityPicker.pick(axes.getParentFigure(), mouseWheelEvent.getX(), mouseWheelEvent.getY());
                EntityPicker.SurfaceInfo surfaceInfo = entityPicker.pickSurface(axes.getParentFigure(), new Integer[]{mouseWheelEvent.getX(), mouseWheelEvent.getY()});
                if (n != null) {
                    object = entityPicker.pickPoint(n, mouseWheelEvent.getX(), mouseWheelEvent.getY());
                    double[] dArray2 = (double[])PolylineData.getDataX((int)n);
                    double[] dArray3 = (double[])PolylineData.getDataY((int)n);
                    double[] dArray4 = (double[])PolylineData.getDataZ((int)n);
                    if (dArray2[((EntityPicker.PickedPoint)object).point] > doubleArray2[0] && dArray2[((EntityPicker.PickedPoint)object).point] < doubleArray2[1] && dArray3[((EntityPicker.PickedPoint)object).point] > doubleArray2[2] && dArray3[((EntityPicker.PickedPoint)object).point] < doubleArray2[3] && dArray4[((EntityPicker.PickedPoint)object).point] > doubleArray2[4] && dArray4[((EntityPicker.PickedPoint)object).point] < doubleArray2[5]) {
                        dArray = new double[]{dArray2[((EntityPicker.PickedPoint)object).point], dArray3[((EntityPicker.PickedPoint)object).point], dArray4[((EntityPicker.PickedPoint)object).point]};
                    }
                } else if (surfaceInfo != null && surfaceInfo.point != null) {
                    dArray = new double[]{surfaceInfo.point.getX(), surfaceInfo.point.getY(), surfaceInfo.point.getZ()};
                }
                if (dArray == null) {
                    if (axes.getView() == 0) {
                        object = new double[]{mouseWheelEvent.getX(), mouseWheelEvent.getY(), 0.0};
                        dArray = CallRenderer.get2dViewFromPixelCoordinates(axes.getIdentifier(), (double[])object);
                        dArray[2] = (doubleArray[4] + doubleArray[5]) / 2.0;
                    } else {
                        dArray = new double[]{(doubleArray[1] + doubleArray[0]) / 2.0, (doubleArray[3] + doubleArray[2]) / 2.0, (doubleArray[5] + doubleArray[4]) / 2.0};
                    }
                }
                ScaleUtils.applyLogScale(dArray, blArray);
                this.applyZoom(axes, d, dArray);
            }
        }
    }

    private class FigureMouseListener
    extends MouseAdapter
    implements MouseListener {
        private int pressedButtons = 0;

        private FigureMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.pressedButtons == 0) {
                DragZoomRotateInteraction.this.previousEvent = mouseEvent;
                if (DragZoomRotateInteraction.this.currentAxes.length == 0) {
                    DragZoomRotateInteraction.access$402(DragZoomRotateInteraction.this, DragZoomRotateInteraction.this.getAllUnderlyingAxes(mouseEvent.getPoint()));
                    if (DragZoomRotateInteraction.this.currentAxes.length > 0) {
                        DragZoomRotateInteraction.this.getDrawerVisitor().getComponent().addMouseMotionListener(DragZoomRotateInteraction.this.mouseMotionListener);
                        switch (mouseEvent.getButton()) {
                            case 1: {
                                Cursor cursor = Cursor.getPredefinedCursor(12);
                                mouseEvent.getComponent().setCursor(cursor);
                                break;
                            }
                        }
                    }
                }
            }
            ++this.pressedButtons;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pressedButtons > 0) {
                --this.pressedButtons;
            }
            if (this.pressedButtons == 0) {
                DragZoomRotateInteraction.this.getDrawerVisitor().getComponent().removeMouseMotionListener(DragZoomRotateInteraction.this.mouseMotionListener);
                DragZoomRotateInteraction.access$402(DragZoomRotateInteraction.this, new Axes[0]);
            }
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

