/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.axes.ruler;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;
import org.scilab.modules.graphic_objects.axes.AxisProperty;

class UserDefineGraduation
implements Graduations {
    private final AxisProperty axisProperty;
    private final double lowerBound;
    private final double upperBound;
    private List<Double> allValues;
    private List<Double> subValues;

    public UserDefineGraduation(AxisProperty axisProperty, double d, double d2) {
        this.axisProperty = axisProperty;
        this.lowerBound = d;
        this.upperBound = d2;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundIncluded() {
        return true;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundIncluded() {
        return true;
    }

    public boolean contain(double d) {
        return this.getLowerBound() <= d && d <= this.getUpperBound();
    }

    public DecimalFormat getFormat() {
        return new DecimalFormat();
    }

    public List<Double> getAllValues() {
        if (this.allValues == null) {
            Double[] doubleArray = this.axisProperty.getTicksLocations();
            boolean bl = this.axisProperty.getLogFlag();
            this.allValues = new LinkedList<Double>();
            for (Double d : doubleArray) {
                double d2;
                double d3 = d2 = bl ? Math.log10(d) : d;
                if (!this.contain(d2)) continue;
                this.allValues.add(d);
            }
        }
        return this.allValues;
    }

    public List<Double> getNewValues() {
        return this.getAllValues();
    }

    public Graduations getParentGraduations() {
        return null;
    }

    public Graduations getMore() {
        return null;
    }

    public Graduations getAlternative() {
        return null;
    }

    public Graduations getSubGraduations() {
        return null;
    }

    public List<Double> getSubGraduations(int n) {
        if (this.subValues == null) {
            if (n == 0) {
                this.subValues = new LinkedList<Double>();
                return this.subValues;
            }
            boolean bl = this.axisProperty.getLogFlag();
            List<Double> list = this.getAllValues();
            if (list.isEmpty()) {
                Double[] doubleArray = this.axisProperty.getTicksLocations();
                list = new LinkedList<Double>();
                for (Double d : doubleArray) {
                    list.add(d);
                }
            }
            Collections.sort(list);
            this.subValues = new LinkedList<Double>();
            if (!list.isEmpty()) {
                double d;
                for (int i = 0; i < list.size() - 1; ++i) {
                    double d2 = list.get(i);
                    double d3 = list.get(i + 1);
                    double d4 = (d3 - d2) / (double)(n + 1);
                    double d5 = d2;
                    for (int j = 0; j <= n; ++j) {
                        double d6;
                        double d7 = d6 = bl ? Math.log10(d5) : d5;
                        if (this.contain(d6)) {
                            this.subValues.add(d5);
                        }
                        d5 += d4;
                    }
                }
                double d8 = list.get(list.size() - 1);
                double d9 = d = bl ? Math.log10(d8) : d8;
                if (this.contain(d)) {
                    this.subValues.add(d8);
                }
            }
        }
        return this.subValues;
    }

    public int getSubDensity() {
        return this.axisProperty.getSubticks() + 1;
    }
}

