/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.axes.ruler;

import java.awt.Dimension;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Arrays;
import java.util.List;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.ruler.DefaultRulerModel;
import org.scilab.forge.scirenderer.ruler.RulerDrawer;
import org.scilab.forge.scirenderer.ruler.RulerDrawingResult;
import org.scilab.forge.scirenderer.ruler.RulerModel;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axes.AxisProperty;
import org.scilab.modules.graphic_objects.axes.Camera;
import org.scilab.modules.graphic_objects.contouredObject.Line;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.JoGLView.axes.ruler.AxesRulerSpriteFactory;
import org.scilab.modules.renderer.JoGLView.axes.ruler.RulerDrawerManager;
import org.scilab.modules.renderer.JoGLView.axes.ruler.UserDefineGraduation;
import org.scilab.modules.renderer.JoGLView.label.AxisLabelPositioner;
import org.scilab.modules.renderer.JoGLView.label.TitlePositioner;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;

public class AxesRulerDrawer {
    private static final double LINEAR_MINIMAL_SUB_TICKS_DISTANCE = 8.0;
    private static final double LOG_MINIMAL_SUB_TICKS_DISTANCE = 2.0;
    public static final int TICKS_LENGTH = 6;
    private static final int SUB_TICKS_LENGTH = 3;
    private static final int SPRITE_DISTANCE = 12;
    private final RulerDrawerManager rulerDrawerManager;

    public AxesRulerDrawer(Canvas canvas) {
        this.rulerDrawerManager = new RulerDrawerManager(canvas.getTextureManager());
    }

    public RulerDrawer getRulerDrawer(Axes axes, int n) {
        return this.rulerDrawerManager.get(axes)[n];
    }

    private final DefaultRulerModel getDefaultRulerModel(Axes axes, ColorMap colorMap) {
        DefaultRulerModel defaultRulerModel = new DefaultRulerModel();
        defaultRulerModel.setTicksLength(6);
        defaultRulerModel.setSubTicksLength(3);
        defaultRulerModel.setLineWidth(axes.getLineThickness().doubleValue());
        defaultRulerModel.setSpriteDistance(12);
        defaultRulerModel.setColor(ColorFactory.createColor(colorMap, axes.getLineColor()));
        return defaultRulerModel;
    }

    public void computeRulers(Axes axes, AxesDrawer axesDrawer, ColorMap colorMap, Transformation transformation, Transformation transformation2) {
        Object object;
        double d;
        double[] dArray;
        RulerDrawingResult rulerDrawingResult;
        Double[] doubleArray = axes.getDisplayedBounds();
        double[] dArray2 = transformation.getMatrix();
        RulerDrawer[] rulerDrawerArray = this.rulerDrawerManager.get(axes);
        DefaultRulerModel defaultRulerModel = this.getDefaultRulerModel(axes, colorMap);
        Vector3d vector3d = this.computeXAxisPosition(dArray2, doubleArray, axes.getXAxis().getAxisLocation(), axes.getYAxis().getReverse());
        Vector3d vector3d2 = this.computeYAxisPosition(dArray2, doubleArray, axes.getYAxis().getAxisLocation(), axes.getXAxis().getReverse());
        Vector3d vector3d3 = transformation2.projectDirection(new Vector3d(1.0, 0.0, 0.0)).setZ(0.0);
        Vector3d vector3d4 = transformation2.projectDirection(new Vector3d(0.0, 1.0, 0.0)).setZ(0.0);
        Vector3d vector3d5 = transformation2.projectDirection(new Vector3d(0.0, 0.0, 1.0)).setZ(0.0);
        Vector3d vector3d6 = vector3d4.getNorm2() > vector3d5.getNorm2() ? new Vector3d(0.0, AxesRulerDrawer.getNonZeroSignum(vector3d.getY()), 0.0) : new Vector3d(0.0, 0.0, AxesRulerDrawer.getNonZeroSignum(vector3d.getZ()));
        Vector3d vector3d7 = vector3d3.getNorm2() > vector3d5.getNorm2() ? new Vector3d(AxesRulerDrawer.getNonZeroSignum(vector3d2.getX()), 0.0, 0.0) : new Vector3d(0.0, 0.0, AxesRulerDrawer.getNonZeroSignum(vector3d2.getZ()));
        defaultRulerModel.setTicksDirection(vector3d6);
        defaultRulerModel.setFirstPoint(vector3d.setX(-1.0));
        defaultRulerModel.setSecondPoint(vector3d.setX(1.0));
        if (!axes.getAutoSubticks().booleanValue()) {
            defaultRulerModel.setSubticksNumber(axes.getXAxisSubticks().intValue());
        }
        this.setRulerBounds(axes.getXAxis(), defaultRulerModel, doubleArray[0], doubleArray[1]);
        defaultRulerModel.setFormat(axes.getXAxisFormat());
        defaultRulerModel.setSTFactors(axes.getXAxisSTFactors());
        defaultRulerModel.setLogarithmic(axes.getXAxis().getLogFlag().booleanValue());
        defaultRulerModel.setMinimalSubTicksDistance(axes.getXAxis().getLogFlag() != false ? 2.0 : 8.0);
        if (!axes.getXAxis().getAutoTicks().booleanValue()) {
            defaultRulerModel.setUserGraduation((Graduations)new UserDefineGraduation(axes.getXAxis(), doubleArray[0], doubleArray[1]));
            if (axes.getAutoSubticks().booleanValue()) {
                defaultRulerModel.setSubticksNumber(axes.getXAxisSubticks().intValue());
            }
            defaultRulerModel.setAutoTicks(false);
        } else {
            defaultRulerModel.setAutoTicks(true);
        }
        AxisLabelPositioner axisLabelPositioner = axesDrawer.getXAxisLabelPositioner(axes);
        axisLabelPositioner.setLabelPosition(vector3d);
        if (axes.getXAxisVisible().booleanValue()) {
            rulerDrawingResult = rulerDrawerArray[0].computeRuler((RulerModel)defaultRulerModel, transformation2);
            dArray = rulerDrawingResult.getTicksValues();
            if (axes.getXAxisAutoTicks().booleanValue()) {
                Arrays.sort(dArray);
                GraphicController.getController().setProperty(axes.getIdentifier(), 124, (Object)this.toDoubleArray(dArray));
                GraphicController.getController().setProperty(axes.getIdentifier(), 125, (Object)this.toStringArray(dArray, rulerDrawingResult.getFormat()));
                if (axes.getAutoSubticks().booleanValue()) {
                    axes.setXAxisSubticks(Integer.valueOf(rulerDrawingResult.getSubTicksDensity()));
                }
            }
            d = rulerDrawingResult.getMaxDistToTicksDirNorm();
            axisLabelPositioner.setTicksDirection(vector3d6);
            axisLabelPositioner.setDistanceRatio(d);
            axisLabelPositioner.setProjectedTicksDirection(rulerDrawingResult.getNormalizedTicksDirection().setZ(0.0));
        } else {
            axisLabelPositioner.setTicksDirection(vector3d6);
            object = transformation2.projectDirection(vector3d6);
            axisLabelPositioner.setDistanceRatio(6.0 / object.getNorm());
            axisLabelPositioner.setProjectedTicksDirection(object.getNormalized().setZ(0.0));
        }
        object = axesDrawer.getTitlePositioner(axes);
        Dimension dimension = axesDrawer.getLabelManager().getXLabelSize(colorMap, axes, axesDrawer);
        ((TitlePositioner)object).setXLabelHeight(dimension.height);
        ((TitlePositioner)object).setDistanceRatio(axisLabelPositioner.getDistanceRatio());
        defaultRulerModel = this.getDefaultRulerModel(axes, colorMap);
        defaultRulerModel.setTicksDirection(vector3d7);
        defaultRulerModel.setFirstPoint(vector3d2.setY(-1.0));
        defaultRulerModel.setSecondPoint(vector3d2.setY(1.0));
        if (!axes.getAutoSubticks().booleanValue()) {
            defaultRulerModel.setSubticksNumber(axes.getYAxisSubticks().intValue());
        }
        this.setRulerBounds(axes.getYAxis(), defaultRulerModel, doubleArray[2], doubleArray[3]);
        defaultRulerModel.setFormat(axes.getYAxisFormat());
        defaultRulerModel.setSTFactors(axes.getYAxisSTFactors());
        defaultRulerModel.setLogarithmic(axes.getYAxis().getLogFlag().booleanValue());
        defaultRulerModel.setMinimalSubTicksDistance(axes.getYAxis().getLogFlag() != false ? 2.0 : 8.0);
        if (!axes.getYAxis().getAutoTicks().booleanValue()) {
            defaultRulerModel.setUserGraduation((Graduations)new UserDefineGraduation(axes.getYAxis(), doubleArray[2], doubleArray[3]));
            if (axes.getAutoSubticks().booleanValue()) {
                defaultRulerModel.setSubticksNumber(axes.getYAxisSubticks().intValue());
            }
            defaultRulerModel.setAutoTicks(false);
        } else {
            defaultRulerModel.setAutoTicks(true);
        }
        AxisLabelPositioner axisLabelPositioner2 = axesDrawer.getYAxisLabelPositioner(axes);
        axisLabelPositioner2.setLabelPosition(vector3d2);
        if (axes.getYAxisVisible().booleanValue()) {
            rulerDrawingResult = rulerDrawerArray[1].computeRuler((RulerModel)defaultRulerModel, transformation2);
            dArray = rulerDrawingResult.getTicksValues();
            if (axes.getYAxisAutoTicks().booleanValue()) {
                Arrays.sort(dArray);
                GraphicController.getController().setProperty(axes.getIdentifier(), 140, (Object)this.toDoubleArray(dArray));
                GraphicController.getController().setProperty(axes.getIdentifier(), 141, (Object)this.toStringArray(dArray, rulerDrawingResult.getFormat()));
                if (axes.getAutoSubticks().booleanValue()) {
                    axes.setYAxisSubticks(Integer.valueOf(rulerDrawingResult.getSubTicksDensity()));
                }
            }
            d = rulerDrawingResult.getMaxDistToTicksDirNorm();
            axisLabelPositioner2.setTicksDirection(vector3d7);
            axisLabelPositioner2.setDistanceRatio(d);
            axisLabelPositioner2.setProjectedTicksDirection(rulerDrawingResult.getNormalizedTicksDirection().setZ(0.0));
        } else {
            axisLabelPositioner2.setTicksDirection(vector3d7);
            Vector3d vector3d8 = transformation2.projectDirection(vector3d7);
            axisLabelPositioner2.setDistanceRatio(6.0 / vector3d8.getNorm());
            axisLabelPositioner2.setProjectedTicksDirection(vector3d8.getNormalized().setZ(0.0));
        }
        if (axes.getViewAsEnum() == Camera.ViewType.VIEW_3D) {
            double d2;
            double d3;
            double d4;
            double d5;
            if (Math.abs(dArray2[2]) < Math.abs(dArray2[6])) {
                d5 = dArray2[2] > 0.0 ? 1.0 : -1.0;
                d4 = dArray2[6] > 0.0 ? -1.0 : 1.0;
                d3 = d5;
                d2 = 0.0;
            } else {
                d5 = dArray2[2] > 0.0 ? -1.0 : 1.0;
                d4 = dArray2[6] > 0.0 ? 1.0 : -1.0;
                d3 = 0.0;
                d2 = d4;
            }
            defaultRulerModel = this.getDefaultRulerModel(axes, colorMap);
            defaultRulerModel.setFirstPoint(new Vector3d(d5, d4, -1.0));
            defaultRulerModel.setSecondPoint(new Vector3d(d5, d4, 1.0));
            defaultRulerModel.setTicksDirection(new Vector3d(d3, d2, 0.0));
            if (!axes.getAutoSubticks().booleanValue()) {
                defaultRulerModel.setSubticksNumber(axes.getZAxisSubticks().intValue());
            }
            this.setRulerBounds(axes.getZAxis(), defaultRulerModel, doubleArray[4], doubleArray[5]);
            defaultRulerModel.setFormat(axes.getZAxisFormat());
            defaultRulerModel.setSTFactors(axes.getZAxisSTFactors());
            defaultRulerModel.setLogarithmic(axes.getZAxis().getLogFlag().booleanValue());
            defaultRulerModel.setMinimalSubTicksDistance(axes.getZAxis().getLogFlag() != false ? 2.0 : 8.0);
            if (!axes.getZAxis().getAutoTicks().booleanValue()) {
                defaultRulerModel.setUserGraduation((Graduations)new UserDefineGraduation(axes.getZAxis(), doubleArray[4], doubleArray[5]));
                if (axes.getAutoSubticks().booleanValue()) {
                    defaultRulerModel.setSubticksNumber(axes.getZAxisSubticks().intValue());
                }
                defaultRulerModel.setAutoTicks(false);
            } else {
                defaultRulerModel.setAutoTicks(true);
            }
            AxisLabelPositioner axisLabelPositioner3 = axesDrawer.getZAxisLabelPositioner(axes);
            axisLabelPositioner3.setLabelPosition(new Vector3d(d5, d4, 0.0));
            if (axes.getZAxisVisible().booleanValue()) {
                rulerDrawingResult = rulerDrawerArray[2].computeRuler((RulerModel)defaultRulerModel, transformation2);
                dArray = rulerDrawingResult.getTicksValues();
                if (axes.getZAxisAutoTicks().booleanValue()) {
                    Arrays.sort(dArray);
                    GraphicController.getController().setProperty(axes.getIdentifier(), 156, (Object)this.toDoubleArray(dArray));
                    GraphicController.getController().setProperty(axes.getIdentifier(), 157, (Object)this.toStringArray(dArray, rulerDrawingResult.getFormat()));
                    if (axes.getAutoSubticks().booleanValue()) {
                        axes.setZAxisSubticks(Integer.valueOf(rulerDrawingResult.getSubTicksDensity()));
                    }
                }
                d = rulerDrawingResult.getMaxDistToTicksDirNorm();
                axisLabelPositioner3.setTicksDirection(new Vector3d(d3, d2, 0.0));
                axisLabelPositioner3.setDistanceRatio(d);
                axisLabelPositioner3.setProjectedTicksDirection(rulerDrawingResult.getNormalizedTicksDirection().setZ(0.0).setY(1.0E-7));
            } else {
                Vector3d vector3d9 = new Vector3d(d3, d2, 0.0);
                axisLabelPositioner3.setTicksDirection(vector3d9);
                Vector3d vector3d10 = transformation2.projectDirection(vector3d9);
                axisLabelPositioner3.setDistanceRatio(6.0 / vector3d10.getNorm());
                axisLabelPositioner3.setProjectedTicksDirection(vector3d10.getNormalized().setZ(0.0));
            }
        }
    }

    public void drawRuler(Axes axes, AxesDrawer axesDrawer, ColorMap colorMap, DrawingTools drawingTools) throws SciRendererException {
        DefaultGeometry defaultGeometry;
        FloatBuffer floatBuffer;
        List list;
        boolean bl;
        Appearance appearance = new Appearance();
        Double[] doubleArray = axes.getDisplayedBounds();
        double[] dArray = drawingTools.getTransformationManager().getModelViewStack().peek().getMatrix();
        RulerDrawer[] rulerDrawerArray = this.rulerDrawerManager.get(axes);
        ElementsBuffer elementsBuffer = drawingTools.getCanvas().getBuffersManager().createElementsBuffer();
        boolean bl2 = bl = axes.getViewAsEnum() == Camera.ViewType.VIEW_3D;
        if (rulerDrawerArray[0].getModel() == null || rulerDrawerArray[1].getModel() == null || bl && rulerDrawerArray[2].getModel() == null) {
            this.computeRulers(axes, axesDrawer, colorMap, drawingTools.getTransformationManager().getModelViewStack().peek(), drawingTools.getTransformationManager().getCanvasProjection());
        }
        int n = axes.getGridPositionAsEnum().equals((Object)Axes.GridPosition.FOREGROUND) ? 1 : -1;
        if (axes.getXAxisVisible().booleanValue()) {
            rulerDrawerArray[0].draw(drawingTools);
            if (axes.getXAxisGridColor() != -1) {
                floatBuffer = axes.getXAxisLogFlag().booleanValue() ? ((list = rulerDrawerArray[0].getSubTicksValue()) == null || list.isEmpty() ? this.getXGridData(rulerDrawerArray[0].getTicksValue(), rulerDrawerArray[0].getModel()) : this.getXGridData(list, rulerDrawerArray[0].getModel())) : this.getXGridData(rulerDrawerArray[0].getTicksValue(), rulerDrawerArray[0].getModel());
                elementsBuffer.setData(floatBuffer, 4);
                try {
                    list = TransformationFactory.getScaleTransformation((double)1.0, (double)(dArray[6] < 0.0 ? (double)n : (double)(-n)), (double)(dArray[10] < 0.0 ? (double)n : (double)(-n)));
                }
                catch (DegenerateMatrixException degenerateMatrixException) {
                    list = TransformationFactory.getIdentity();
                }
                appearance.setLineColor(ColorFactory.createColor(colorMap, axes.getXAxisGridColor()));
                appearance.setLineWidth(axes.getXAxisGridThickness().floatValue());
                appearance.setLinePattern(Line.LineType.fromScilabIndex((Integer)axes.getXAxisGridStyle()).asPattern());
                drawingTools.getTransformationManager().getModelViewStack().pushRightMultiply((Transformation)list);
                defaultGeometry = new DefaultGeometry();
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                defaultGeometry.setVertices(elementsBuffer);
                drawingTools.draw((Geometry)defaultGeometry, appearance);
                drawingTools.getTransformationManager().getModelViewStack().pop();
            }
        }
        if (axes.getYAxisVisible().booleanValue()) {
            rulerDrawerArray[1].draw(drawingTools);
            if (axes.getYAxisGridColor() != -1) {
                floatBuffer = axes.getYAxisLogFlag().booleanValue() ? ((list = rulerDrawerArray[1].getSubTicksValue()) == null || list.isEmpty() ? this.getYGridData(rulerDrawerArray[1].getTicksValue(), rulerDrawerArray[1].getModel()) : this.getYGridData(list, rulerDrawerArray[1].getModel())) : this.getYGridData(rulerDrawerArray[1].getTicksValue(), rulerDrawerArray[1].getModel());
                elementsBuffer.setData(floatBuffer, 4);
                try {
                    list = TransformationFactory.getScaleTransformation((double)(dArray[2] < 0.0 ? (double)n : (double)(-n)), (double)1.0, (double)(dArray[10] < 0.0 ? (double)n : (double)(-n)));
                }
                catch (DegenerateMatrixException degenerateMatrixException) {
                    list = TransformationFactory.getIdentity();
                }
                appearance.setLineColor(ColorFactory.createColor(colorMap, axes.getYAxisGridColor()));
                appearance.setLineWidth(axes.getYAxisGridThickness().floatValue());
                appearance.setLinePattern(Line.LineType.fromScilabIndex((Integer)axes.getYAxisGridStyle()).asPattern());
                drawingTools.getTransformationManager().getModelViewStack().pushRightMultiply((Transformation)list);
                defaultGeometry = new DefaultGeometry();
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                defaultGeometry.setVertices(elementsBuffer);
                drawingTools.draw((Geometry)defaultGeometry, appearance);
                drawingTools.getTransformationManager().getModelViewStack().pop();
            }
        }
        if (bl && axes.getZAxisVisible().booleanValue()) {
            rulerDrawerArray[2].draw(drawingTools);
            if (axes.getZAxisGridColor() != -1) {
                floatBuffer = axes.getZAxisLogFlag().booleanValue() ? ((list = rulerDrawerArray[2].getSubTicksValue()) == null || list.isEmpty() ? this.getZGridData(rulerDrawerArray[2].getTicksValue(), rulerDrawerArray[2].getModel()) : this.getZGridData(list, rulerDrawerArray[2].getModel())) : this.getZGridData(rulerDrawerArray[2].getTicksValue(), rulerDrawerArray[2].getModel());
                elementsBuffer.setData(floatBuffer, 4);
                try {
                    list = TransformationFactory.getScaleTransformation((double)(dArray[2] < 0.0 ? (double)n : (double)(-n)), (double)(dArray[6] < 0.0 ? (double)n : (double)(-n)), (double)1.0);
                }
                catch (DegenerateMatrixException degenerateMatrixException) {
                    list = TransformationFactory.getIdentity();
                }
                appearance.setLineColor(ColorFactory.createColor(colorMap, axes.getZAxisGridColor()));
                appearance.setLineWidth(axes.getZAxisGridThickness().floatValue());
                appearance.setLinePattern(Line.LineType.fromScilabIndex((Integer)axes.getZAxisGridStyle()).asPattern());
                drawingTools.getTransformationManager().getModelViewStack().pushRightMultiply((Transformation)list);
                defaultGeometry = new DefaultGeometry();
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                defaultGeometry.setVertices(elementsBuffer);
                drawingTools.draw((Geometry)defaultGeometry, appearance);
                drawingTools.getTransformationManager().getModelViewStack().pop();
            }
        }
        drawingTools.getCanvas().getBuffersManager().dispose((DataBuffer)elementsBuffer);
    }

    private static final double getNonZeroSignum(double d) {
        if (d < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    private void setRulerBounds(AxisProperty axisProperty, DefaultRulerModel defaultRulerModel, double d, double d2) {
        double d3;
        double d4;
        if (axisProperty.getReverse().booleanValue()) {
            d4 = d;
            d3 = d2;
        } else {
            d4 = d2;
            d3 = d;
        }
        if (axisProperty.getLogFlag().booleanValue()) {
            d4 = Math.pow(10.0, d4);
            d3 = Math.pow(10.0, d3);
        }
        defaultRulerModel.setValues(d4, d3);
    }

    private Vector3d computeXAxisPosition(double[] dArray, Double[] doubleArray, AxisProperty.AxisLocation axisLocation, boolean bl) {
        double d;
        double d2;
        switch (axisLocation) {
            default: {
                d2 = -Math.signum(dArray[9]);
                d = -Math.signum(dArray[6]) * d2 * Math.signum(dArray[10]);
                if (d != 0.0) break;
                d = 1.0;
                break;
            }
            case MIDDLE: {
                d2 = Math.signum(dArray[9]);
                d = 0.0;
                break;
            }
            case TOP: {
                d2 = Math.signum(dArray[9]);
                d = -Math.signum(dArray[6]) * d2 * Math.signum(dArray[10]);
                if (d != 0.0) break;
                d = -1.0;
                break;
            }
            case ORIGIN: {
                d2 = Math.signum(dArray[9]);
                d = (double)(bl ? -1 : 1) * (doubleArray[3] + doubleArray[2]) / (doubleArray[3] - doubleArray[2]);
                if (!(Math.abs(d) > 1.0)) break;
                d = Math.signum(d);
            }
        }
        return new Vector3d(0.0, d, d2);
    }

    private Vector3d computeYAxisPosition(double[] dArray, Double[] doubleArray, AxisProperty.AxisLocation axisLocation, boolean bl) {
        double d;
        double d2;
        switch (axisLocation) {
            default: {
                d2 = -Math.signum(dArray[9]);
                d = -Math.signum(dArray[2]) * d2 * Math.signum(dArray[10]);
                if (d != 0.0) break;
                d = 1.0;
                break;
            }
            case MIDDLE: {
                d2 = Math.signum(dArray[9]);
                d = 0.0;
                break;
            }
            case RIGHT: {
                d2 = Math.signum(dArray[9]);
                d = -Math.signum(dArray[2]) * d2 * Math.signum(dArray[10]);
                if (d != 0.0) break;
                d = -1.0;
                break;
            }
            case ORIGIN: {
                d2 = Math.signum(dArray[9]);
                d = (double)(bl ? -1 : 1) * (doubleArray[1] + doubleArray[0]) / (doubleArray[1] - doubleArray[0]);
                if (!(Math.abs(d) > 1.0)) break;
                d = Math.signum(d);
            }
        }
        return new Vector3d(d, 0.0, d2);
    }

    private String[] toStringArray(double[] dArray, DecimalFormat decimalFormat) {
        AxesRulerSpriteFactory.setScilabStyle(decimalFormat);
        String[] stringArray = new String[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            stringArray[i] = decimalFormat.format(dArray[i], new StringBuffer(), new FieldPosition(0)).toString();
        }
        return stringArray;
    }

    private Double[] toDoubleArray(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    private FloatBuffer getXGridData(List<Double> list, RulerModel rulerModel) {
        FloatBuffer floatBuffer = FloatBuffer.allocate(list.size() * 16);
        for (double d : list) {
            float f = (float)rulerModel.getPosition(d).getX();
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(1.0f);
        }
        floatBuffer.rewind();
        return floatBuffer;
    }

    private FloatBuffer getYGridData(List<Double> list, RulerModel rulerModel) {
        FloatBuffer floatBuffer = FloatBuffer.allocate(list.size() * 16);
        for (double d : list) {
            float f = (float)rulerModel.getPosition(d).getY();
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(1.0f);
        }
        floatBuffer.rewind();
        return floatBuffer;
    }

    private FloatBuffer getZGridData(List<Double> list, RulerModel rulerModel) {
        FloatBuffer floatBuffer = FloatBuffer.allocate(list.size() * 16);
        int n = 0;
        for (double d : list) {
            float f = (float)rulerModel.getPosition(d).getZ();
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(f);
            floatBuffer.put(1.0f);
            n += 16;
        }
        floatBuffer.limit(n);
        return floatBuffer;
    }

    public void disposeAll() {
        this.rulerDrawerManager.disposeAll();
    }

    public boolean update(Integer n, int n2) {
        return this.rulerDrawerManager.update(n, n2);
    }

    public void dispose(Integer n) {
        this.rulerDrawerManager.dispose(n);
    }
}

