/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.ruler.DefaultRulerModel;
import org.scilab.forge.scirenderer.ruler.RulerDrawer;
import org.scilab.forge.scirenderer.ruler.RulerModel;
import org.scilab.forge.scirenderer.ruler.RulerSpriteFactory;
import org.scilab.forge.scirenderer.ruler.graduations.AbstractGraduations;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axis.Axis;
import org.scilab.modules.graphic_objects.textObject.FormattedText;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.FormattedTextSpriteDrawer;
import org.scilab.modules.renderer.JoGLView.util.ScaleUtils;

public class AxisDrawer {
    private static final int TICKS_LENGTH = 8;
    private static final int SUB_TICKS_LENGTH = 5;
    private static final int SPRITE_DISTANCE = 12;
    private final DrawerVisitor drawerVisitor;

    public AxisDrawer(DrawerVisitor drawerVisitor) {
        this.drawerVisitor = drawerVisitor;
    }

    public void draw(Axes axes, Axis axis) {
        double d;
        double d2;
        double[] dArray;
        double[] dArray2;
        DefaultRulerModel defaultRulerModel = new DefaultRulerModel();
        defaultRulerModel.setSpriteDistance(12);
        defaultRulerModel.setSubTicksLength(5);
        defaultRulerModel.setTicksLength(8);
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        double[][] dArray3 = this.calcCorrectedFactors(axes, axis);
        if (axis.getXTicksCoords().length == 1) {
            Double[] doubleArray = axis.getXTicksCoords();
            Double[] doubleArray2 = this.decodeValue(axis.getYTicksCoords(), axis.getTicksStyle());
            dArray2 = this.getMinAndMax(doubleArray);
            dArray = this.getMinAndMax(doubleArray2);
            d2 = dArray[0];
            d = dArray[1];
            defaultRulerModel.setUserGraduation((Graduations)new AxisGraduation(axis, doubleArray2, dArray));
        } else {
            Double[] doubleArray = this.decodeValue(axis.getXTicksCoords(), axis.getTicksStyle());
            Double[] doubleArray3 = axis.getYTicksCoords();
            dArray2 = this.getMinAndMax(doubleArray);
            dArray = this.getMinAndMax(doubleArray3);
            d2 = dArray2[0];
            d = dArray2[1];
            defaultRulerModel.setUserGraduation((Graduations)new AxisGraduation(axis, doubleArray, dArray2));
        }
        Vector3d vector3d = new Vector3d(dArray2[0], dArray[0], 0.0);
        Vector3d vector3d2 = new Vector3d(dArray2[1], dArray[1], 0.0);
        vector3d = ScaleUtils.applyLogScale(vector3d, blArray);
        vector3d2 = ScaleUtils.applyLogScale(vector3d2, blArray);
        vector3d = new Vector3d(vector3d.getX() * dArray3[0][0] + dArray3[1][0], vector3d.getY() * dArray3[0][1] + dArray3[1][1], vector3d.getZ() * dArray3[0][2] + dArray3[1][2]);
        vector3d2 = new Vector3d(vector3d2.getX() * dArray3[0][0] + dArray3[1][0], vector3d2.getY() * dArray3[0][1] + dArray3[1][1], vector3d2.getZ() * dArray3[0][2] + dArray3[1][2]);
        defaultRulerModel.setAutoTicks(false);
        defaultRulerModel.setFirstValue(0.0);
        defaultRulerModel.setSecondValue(1.0);
        defaultRulerModel.setLineVisible(axis.getTicksSegment().booleanValue());
        defaultRulerModel.setColor(ColorFactory.createColor(this.drawerVisitor.getColorMap(), axis.getTicksColor()));
        defaultRulerModel.setPoints(vector3d, vector3d2);
        defaultRulerModel.setTicksDirection(this.computeTicksDirection(axis.getTicksDirectionAsEnum()));
        DrawingTools drawingTools = this.drawerVisitor.getDrawingTools();
        RulerDrawer rulerDrawer = new RulerDrawer(this.drawerVisitor.getCanvas().getTextureManager());
        rulerDrawer.setSpriteFactory((RulerSpriteFactory)new AxisSpriteFactory(axis, d2, d));
        rulerDrawer.draw(drawingTools, (RulerModel)defaultRulerModel);
        axis.getFormatn();
        rulerDrawer.disposeResources();
    }

    private double[][] calcCorrectedFactors(Axes axes, Axis axis) {
        Double[] doubleArray = axes.getDisplayedBounds();
        double[][] dArrayArray = new double[][]{{2.0 / (doubleArray[1] - doubleArray[0]), 2.0 / (doubleArray[3] - doubleArray[2]), 2.0 / (doubleArray[5] - doubleArray[4])}, {-(doubleArray[1] + doubleArray[0]) / (doubleArray[1] - doubleArray[0]), -(doubleArray[3] + doubleArray[2]) / (doubleArray[3] - doubleArray[2]), -(doubleArray[5] + doubleArray[4]) / (doubleArray[5] - doubleArray[4])}};
        double[][] dArray = axes.getScaleTranslateFactors();
        double d = dArray[0][2] / (dArrayArray[0][2] == 0.0 ? 1.0 : dArrayArray[0][2]);
        double d2 = dArrayArray[0][2] / (dArray[0][2] == 0.0 ? 1.0 : dArray[0][2]);
        double[] dArray2 = dArray[0];
        dArray2[2] = dArray2[2] * d;
        dArray[1][2] = d * (dArray[1][2] + (d2 * dArray[1][2] - dArrayArray[1][2]));
        if (axis.getYNumberTicks() == 1 || this.isConst(axis.getYTicksCoords())) {
            d = dArray[0][1] / (dArrayArray[0][1] == 0.0 ? 1.0 : dArrayArray[0][1]);
            d2 = dArrayArray[0][1] / (dArray[0][1] == 0.0 ? 1.0 : dArray[0][1]);
            double[] dArray3 = dArray[0];
            dArray3[1] = dArray3[1] * d;
            dArray[1][1] = d * (dArray[1][1] + (d2 * dArray[1][1] - dArrayArray[1][1]));
        }
        if (axis.getXNumberTicks() == 1 || this.isConst(axis.getXTicksCoords())) {
            d = dArray[0][0] / (dArrayArray[0][0] == 0.0 ? 1.0 : dArrayArray[0][0]);
            d2 = dArrayArray[0][0] / (dArray[0][0] == 0.0 ? 1.0 : dArray[0][0]);
            double[] dArray4 = dArray[0];
            dArray4[0] = dArray4[0] * d;
            dArray[1][0] = d * (dArray[1][0] + (d2 * dArray[1][0] - dArrayArray[1][0]));
        }
        return dArray;
    }

    private boolean isConst(Double[] doubleArray) {
        if (doubleArray.length > 0) {
            double d = doubleArray[0];
            for (int i = 0; i < doubleArray.length; ++i) {
                if (doubleArray[i] == d) continue;
                return false;
            }
        }
        return true;
    }

    private double[] getMinAndMax(Double[] doubleArray) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        Double[] doubleArray2 = doubleArray;
        int n = doubleArray2.length;
        for (int i = 0; i < n; ++i) {
            double d3 = doubleArray2[i];
            d = Math.min(d, d3);
            d2 = Math.max(d2, d3);
        }
        return new double[]{d, d2};
    }

    private Double[] decodeValue(Double[] doubleArray, int n) {
        if (n == 1 && doubleArray.length >= 3) {
            double d = doubleArray[0];
            double d2 = doubleArray[1];
            int n2 = doubleArray[2].intValue();
            Double[] doubleArray2 = new Double[n2 + 1];
            double d3 = (d2 - d) / (double)n2;
            for (int i = 0; i <= n2; ++i) {
                doubleArray2[i] = d + (double)i * d3;
            }
            return doubleArray2;
        }
        if (n == 2 && doubleArray.length >= 4) {
            double d = Math.pow(10.0, doubleArray[2]);
            double d4 = doubleArray[0] * d;
            double d5 = doubleArray[1] * d;
            int n3 = doubleArray[3].intValue();
            Double[] doubleArray3 = new Double[n3 + 1];
            double d6 = (d5 - d4) / (double)n3;
            for (int i = 0; i <= n3; ++i) {
                doubleArray3[i] = d4 + (double)i * d6;
            }
            return doubleArray3;
        }
        return doubleArray;
    }

    private Vector3d computeTicksDirection(Axis.TicksDirection ticksDirection) {
        switch (ticksDirection) {
            case TOP: {
                return new Vector3d(0.0, 1.0, 0.0);
            }
            case BOTTOM: {
                return new Vector3d(0.0, -1.0, 0.0);
            }
            case LEFT: {
                return new Vector3d(-1.0, 0.0, 0.0);
            }
        }
        return new Vector3d(1.0, 0.0, 0.0);
    }

    private class AxisSpriteFactory
    implements RulerSpriteFactory {
        private final Axis axis;
        private final double min;
        private final double max;

        public AxisSpriteFactory(Axis axis, double d, double d2) {
            this.axis = axis;
            this.min = d;
            this.max = d2;
        }

        public Texture create(double d, DecimalFormat decimalFormat, TextureManager textureManager) {
            String string = this.getLabel(d);
            if (string != null) {
                FormattedText formattedText = new FormattedText();
                formattedText.setFont(this.axis.getFont());
                formattedText.setText(this.getLabel(d));
                FormattedTextSpriteDrawer formattedTextSpriteDrawer = new FormattedTextSpriteDrawer(AxisDrawer.this.drawerVisitor.getColorMap(), formattedText);
                Texture texture = textureManager.createTexture();
                texture.setMagnificationFilter(Texture.Filter.LINEAR);
                texture.setMinifyingFilter(Texture.Filter.LINEAR);
                texture.setDrawer((TextureDrawer)formattedTextSpriteDrawer);
                return texture;
            }
            return null;
        }

        private String getLabel(double d) {
            String[] stringArray = this.axis.getTicksLabels();
            int n = (int)Math.round(d * (double)(stringArray.length - 1));
            if (n < 0 || n > stringArray.length || stringArray.length == 0) {
                return null;
            }
            return stringArray[n];
        }
    }

    private class AxisGraduation
    extends AbstractGraduations {
        private final List<Double> subTicksValue;
        private final List<Double> allValues;
        private final Axis axis;

        AxisGraduation(Axis axis, Double[] doubleArray, double[] dArray) {
            super(0.0, 1.0);
            this.axis = axis;
            this.allValues = this.computeValue(doubleArray, dArray);
            this.subTicksValue = this.computeSubValue(this.allValues, axis.getSubticks());
        }

        private List<Double> computeSubValue(List<Double> list, Integer n) {
            if (list == null || list.size() < 2) {
                return new LinkedList<Double>();
            }
            LinkedList<Double> linkedList = new LinkedList<Double>();
            Iterator<Double> iterator = list.iterator();
            double d = iterator.next();
            while (iterator.hasNext()) {
                double d2 = iterator.next();
                double d3 = (d2 - d) / (double)n.intValue();
                for (int i = 1; i < n; ++i) {
                    linkedList.add(d + (double)i * d3);
                }
                d = d2;
            }
            return linkedList;
        }

        private List<Double> computeValue(Double[] doubleArray, double[] dArray) {
            if (doubleArray == null || doubleArray.length == 0) {
                return new LinkedList<Double>();
            }
            if (doubleArray.length == 1) {
                LinkedList<Double> linkedList = new LinkedList<Double>();
                linkedList.add(0.0);
                return linkedList;
            }
            LinkedList<Double> linkedList = new LinkedList<Double>();
            double d = dArray[1];
            double d2 = dArray[0];
            if (d == d2) {
                for (Double d3 : doubleArray) {
                    linkedList.add(0.0);
                }
            } else {
                double d4 = 1.0 / (d - d2);
                Double[] doubleArray2 = doubleArray;
                int n = doubleArray2.length;
                for (int i = 0; i < n; ++i) {
                    double d5 = doubleArray2[i];
                    linkedList.add(d4 * (d5 - d2));
                }
                Collections.sort(linkedList);
            }
            return linkedList;
        }

        public List<Double> getAllValues() {
            return this.allValues;
        }

        public List<Double> getNewValues() {
            return this.allValues;
        }

        public Graduations getMore() {
            return null;
        }

        public Graduations getAlternative() {
            return null;
        }

        public Graduations getSubGraduations() {
            return new AbstractGraduations((Graduations)this){

                public List<Double> getAllValues() {
                    return AxisGraduation.this.subTicksValue;
                }

                public List<Double> getNewValues() {
                    return this.getAllValues();
                }

                public Graduations getMore() {
                    return null;
                }

                public Graduations getAlternative() {
                    return null;
                }

                public Graduations getSubGraduations() {
                    return null;
                }

                public int getSubDensity() {
                    return 0;
                }
            };
        }

        public int getSubDensity() {
            return this.axis.getSubticks();
        }
    }
}

