/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.action_binding.highlevel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.action_binding.utils.ActionBindingMessages;
import org.scilab.modules.action_binding.utils.Signal;

public final class ScilabInterpreterManagement
extends InterpreterManagement {
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private static Set<String> runningTasks = Collections.synchronizedSet(new HashSet());
    private static final String NOTIFY = ";notify(\"";
    private static final String CLOSE = "\");";

    private ScilabInterpreterManagement() {
    }

    public static void synchronousScilabExec(String string) throws InterpreterException {
        String string2 = Integer.toString(string.hashCode());
        String string3 = ScilabInterpreterManagement.protectStatements(string, string2);
        if (runningTasks.contains(string2)) {
            throw new InterpreterException(ActionBindingMessages.SCILAB_SAMECOMMAND);
        }
        int n = InterpreterManagement.requestScilabExec(string3);
        if (n != 0) {
            throw new InterpreterException(ActionBindingMessages.SCILAB_UNABLE);
        }
        runningTasks.add(string2);
        Signal.wait(string2);
        runningTasks.remove(string2);
    }

    public static void synchronousScilabExec(String string, Object ... objectArray) throws InterpreterException {
        ScilabInterpreterManagement.synchronousScilabExec(ScilabInterpreterManagement.buildCall(string, objectArray));
    }

    @Deprecated
    public static void asynchronousScilabExec(String string, final ActionListener actionListener) throws InterpreterException {
        int n = string.hashCode();
        final String string2 = Integer.toString(n);
        final String string3 = ScilabInterpreterManagement.protectStatements(string, string2);
        final ActionEvent actionEvent = new ActionEvent(ScilabInterpreterManagement.class, n, string);
        if (runningTasks.contains(string2)) {
            throw new InterpreterException(ActionBindingMessages.SCILAB_SAMECOMMAND);
        }
        executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int n = InterpreterManagement.putCommandInScilabQueue(string3);
                if (n != 0) {
                    throw new InterpreterException(ActionBindingMessages.SCILAB_UNABLE);
                }
                runningTasks.add(string2);
                Signal.wait(string2);
                runningTasks.remove(string2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        actionListener.actionPerformed(actionEvent);
                    }
                });
                return null;
            }
        });
    }

    public static void asynchronousScilabExec(final ActionListener actionListener, String string) throws InterpreterException {
        int n = string.hashCode();
        final String string2 = Integer.toString(n);
        final String string3 = ScilabInterpreterManagement.protectStatements(string, string2);
        final ActionEvent actionEvent = new ActionEvent(ScilabInterpreterManagement.class, n, string);
        if (runningTasks.contains(string2)) {
            throw new InterpreterException(ActionBindingMessages.SCILAB_SAMECOMMAND);
        }
        executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int n = InterpreterManagement.putCommandInScilabQueue(string3);
                if (n != 0) {
                    throw new InterpreterException(ActionBindingMessages.SCILAB_UNABLE);
                }
                runningTasks.add(string2);
                Signal.wait(string2);
                runningTasks.remove(string2);
                if (actionListener != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            actionListener.actionPerformed(actionEvent);
                        }
                    });
                }
                return null;
            }
        });
    }

    public static void asynchronousScilabExec(ActionListener actionListener, String string, Object ... objectArray) throws InterpreterException {
        ScilabInterpreterManagement.asynchronousScilabExec(actionListener, ScilabInterpreterManagement.buildCall(string, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopScilabExec(int n) {
        String string = Integer.toString(n);
        Set<String> set = runningTasks;
        synchronized (set) {
            if (runningTasks.contains(string)) {
                Signal.notify(string);
                runningTasks.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAllScilabExec() {
        Set<String> set = runningTasks;
        synchronized (set) {
            ScilabInterpreterManagement.interruptScilab();
            for (String string : runningTasks) {
                Signal.notify(string);
            }
        }
    }

    public static String buildCall(String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('(');
        List<Object> list = Arrays.asList(objectArray);
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof CharSequence) {
                stringBuilder.append("\"");
                stringBuilder.append(object);
                stringBuilder.append("\"");
            } else if (object instanceof char[]) {
                stringBuilder.append((char[])object);
            } else if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (bl) {
                    stringBuilder.append("%t");
                } else {
                    stringBuilder.append("%f");
                }
            } else {
                stringBuilder.append(object);
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static String protectStatements(String string, String string2) {
        return new StringBuilder().insert(0, "try, ").append(string).append(" ,catch").append(" disp(lasterror()); ").append(" end ").append(NOTIFY).append(string2).append(CLOSE).toString();
    }

    public static class InterpreterException
    extends Exception {
        private static final long serialVersionUID = -7222406936060866827L;

        public InterpreterException(String string) {
            super(string);
        }
    }
}

