/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.scinotes.EditorComponent;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.actions.CloseAction;
import org.scilab.modules.scinotes.actions.CloseAllButThisAction;
import org.scilab.modules.scinotes.actions.RestoreOpenedFilesAction;
import org.scilab.modules.scinotes.actions.SaveAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class ScilabTabbedPane
extends JTabbedPane
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Transferable {
    private static final ImageIcon CLOSEICON = new ImageIcon(System.getenv("SCI") + "/modules/gui/images/icons/close-tab.png");
    private static final ImageIcon CLOSEONICON = new ImageIcon(System.getenv("SCI") + "/modules/gui/images/icons/close-tab-on.png");
    private static final int BUTTONSIZE = 18;
    private static DataFlavor DATAFLAVOR;
    private static ScilabTabbedPane currentWhenDragged;
    private SciNotes editor;
    private int draggedIndex;

    public ScilabTabbedPane(SciNotes sciNotes) {
        this.editor = sciNotes;
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container container, Component component) {
                if (component instanceof ScilabEditorPane) {
                    return component;
                }
                return super.getComponentAfter(container, component);
            }
        });
        this.setFocusCycleRoot(true);
        this.setComponentPopupMenu(this.createPopupMenu());
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        DropTarget dropTarget = new DropTarget(this, this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    int n = ScilabTabbedPane.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                    ((CloseTabButton)ScilabTabbedPane.this.getTabComponentAt(n)).closeTab();
                    mouseEvent.consume();
                }
            }
        });
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        this.setTabComponentAt(n, new CloseTabButton(string));
    }

    public String getScilabTitleAt(int n) {
        CloseTabButton closeTabButton = (CloseTabButton)this.getTabComponentAt(n);
        if (closeTabButton != null) {
            return closeTabButton.getText();
        }
        return "";
    }

    @Override
    public String getTitleAt(int n) {
        return "";
    }

    @Override
    public void setTitleAt(int n, String string) {
        CloseTabButton closeTabButton = (CloseTabButton)this.getTabComponentAt(n);
        if (closeTabButton != null) {
            closeTabButton.setText(string);
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (!dataFlavor.equals(DATAFLAVOR)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DATAFLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DATAFLAVOR);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DATAFLAVOR)) {
            dropTargetDragEvent.acceptDrag(2);
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            if (component instanceof ScilabTabbedPane) {
                currentWhenDragged = (ScilabTabbedPane)component;
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DATAFLAVOR)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (!dropTargetDropEvent.isDataFlavorSupported(DATAFLAVOR) || dropTargetDropEvent.getSourceActions() != 2) {
            dropTargetDropEvent.rejectDrop();
        } else {
            try {
                ScilabTabbedPane scilabTabbedPane = (ScilabTabbedPane)dropTargetDropEvent.getTransferable().getTransferData(DATAFLAVOR);
                int n = this.indexAtLocation(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
                if (scilabTabbedPane == this && (n == scilabTabbedPane.draggedIndex || this.getTabCount() == 1)) {
                    dropTargetDropEvent.rejectDrop();
                } else {
                    Component component = scilabTabbedPane.getComponentAt(scilabTabbedPane.draggedIndex);
                    String string = scilabTabbedPane.getScilabTitleAt(scilabTabbedPane.draggedIndex);
                    ConfigSciNotesManager.removeFromOpenFiles(scilabTabbedPane.editor, scilabTabbedPane.editor.getTextPane(scilabTabbedPane.draggedIndex));
                    if (scilabTabbedPane.editor.getNavigator() != null) {
                        scilabTabbedPane.editor.getNavigator().removePane(scilabTabbedPane.editor.getTextPane(scilabTabbedPane.draggedIndex));
                    }
                    scilabTabbedPane.remove(component);
                    if (scilabTabbedPane.getTabCount() == 0) {
                        SciNotes.closeEditor(scilabTabbedPane.editor);
                    }
                    if (n == -1) {
                        n = this.getTabCount();
                    }
                    this.insertTab(string, null, component, null, n);
                    ScilabEditorPane scilabEditorPane = this.editor.getTextPane(this.indexOfComponent(component));
                    if (scilabTabbedPane != this) {
                        scilabEditorPane.setEditor(this.editor);
                        this.editor.initInputMap(scilabEditorPane);
                    }
                    if (scilabEditorPane.getName() != null) {
                        ConfigSciNotesManager.saveToOpenFiles(scilabEditorPane.getName(), this.editor, scilabEditorPane, n);
                    } else if (scilabTabbedPane != this) {
                        int n2 = this.editor.getNumberForEmptyTab();
                        scilabEditorPane.setShortName(SciNotesMessages.UNTITLED + n2);
                        scilabEditorPane.setTitle(SciNotesMessages.UNTITLED + n2);
                        this.setTitleAt(n, SciNotesMessages.UNTITLED + n2);
                        this.editor.setTitle(scilabEditorPane.getTitle());
                    }
                    this.setSelectedIndex(n);
                    this.editor.updateTabTitle();
                    dropTargetDropEvent.acceptDrop(2);
                }
            }
            catch (IOException iOException) {
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        Component component = null;
        for (SciNotes sciNotes : SciNotes.getSciNotesList()) {
            Point point = new Point(dragSourceDropEvent.getLocation());
            SwingUtilities.convertPointFromScreen(point, (Component)((Object)sciNotes));
            component = SwingUtilities.getDeepestComponentAt((Component)((Object)sciNotes), (int)point.getX(), (int)point.getY());
            if (component == null) continue;
            break;
        }
        if (component == null) {
            SciNotes.cloneAndCloseCurrentTab(this.editor, true, dragSourceDropEvent.getX(), dragSourceDropEvent.getY());
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        Point point = new Point(dragSourceDragEvent.getX(), dragSourceDragEvent.getY());
        JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, currentWhenDragged);
        if (jRootPane != null) {
            SwingUtilities.convertPointFromScreen(point, jRootPane);
            Component component = SwingUtilities.getDeepestComponentAt(jRootPane, point.x, point.y);
            if (component != null && !(component instanceof ScilabEditorPane) && !(component instanceof ScilabTabbedPane)) {
                component = SwingUtilities.getAncestorOfClass(ScilabTabbedPane.class, component);
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        MouseEvent mouseEvent;
        int n;
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (inputEvent instanceof MouseEvent && ((n = this.indexAtLocation((mouseEvent = (MouseEvent)inputEvent).getX(), mouseEvent.getY())) == -1 || this.getComponentAt(n) instanceof EditorComponent)) {
            currentWhenDragged = this;
            if (n != -1) {
                this.draggedIndex = n;
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, this, this);
            }
        }
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu(){

            @Override
            public void show(Component component, int n, int n2) {
                int n3 = ScilabTabbedPane.this.indexAtLocation(n, n2);
                ScilabTabbedPane.this.setSelectedIndex(n3);
                super.show(component, n, n2);
            }
        };
        Map<String, KeyStroke> map = SciNotes.getActionKeys();
        SwingScilabMenuItem swingScilabMenuItem = (SwingScilabMenuItem)SaveAction.createMenu(SciNotesMessages.SAVE, this.editor, map.get("scinotes-save")).getAsSimpleMenuItem();
        jPopupMenu.add((JMenuItem)swingScilabMenuItem);
        swingScilabMenuItem = (SwingScilabMenuItem)CloseAction.createMenu(SciNotesMessages.CLOSE, this.editor, map.get("scinotes-close")).getAsSimpleMenuItem();
        jPopupMenu.add((JMenuItem)swingScilabMenuItem);
        swingScilabMenuItem = (SwingScilabMenuItem)CloseAllButThisAction.createMenu(SciNotesMessages.CLOSEALLBUTTHIS, this.editor, map.get("scinotes-close-all-but")).getAsSimpleMenuItem();
        jPopupMenu.add((JMenuItem)swingScilabMenuItem);
        jPopupMenu.addSeparator();
        final JMenuItem jMenuItem = new JMenuItem(SciNotesMessages.COPYFULLFILEPATH);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScilabTabbedPane.this.editor.getTextPane() != null) {
                    StringSelection stringSelection = new StringSelection(ScilabTabbedPane.this.editor.getTextPane().getName());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
            }
        });
        jMenuItem.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ScilabTabbedPane.this.editor.getTextPane() != null) {
                    String string = ScilabTabbedPane.this.editor.getTextPane().getName();
                    jMenuItem.setEnabled(string != null && !string.isEmpty());
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    static {
        try {
            DATAFLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + ScilabTabbedPane.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    class CloseTabButton
    extends JPanel {
        private JLabel label;

        public CloseTabButton(String string) {
            super(new FlowLayout(0, 0, 0));
            this.setOpaque(false);
            this.label = new JLabel(string);
            this.add(this.label);
            this.add(new JLabel("   "));
            this.add(new CloseButton());
        }

        public void setText(String string) {
            this.label.setText(string);
        }

        public String getText() {
            return this.label.getText();
        }

        public void closeTab() {
            ScilabEditorPane scilabEditorPane = ScilabTabbedPane.this.editor.getTextPane(ScilabTabbedPane.this.editor.getTabPane().indexOfTabComponent(this));
            if (scilabEditorPane != null) {
                String string = scilabEditorPane.getName();
                ScilabTabbedPane.this.editor.closeTabAt(ScilabTabbedPane.this.editor.getTabPane().indexOfTabComponent(this));
                if (ScilabTabbedPane.this.getTabCount() == 0) {
                    if (string != null) {
                        ScilabTabbedPane.this.editor.addEmptyTab();
                    } else {
                        SciNotes.closeEditor(ScilabTabbedPane.this.editor);
                    }
                }
            } else if (ScilabTabbedPane.this.editor.getTabPane().getTabComponentAt(ScilabTabbedPane.this.editor.getTabPane().indexOfTabComponent(this)) != null) {
                ScilabTabbedPane.this.editor.getTabPane().remove(ScilabTabbedPane.this.editor.getTabPane().indexOfTabComponent(this));
                if (ScilabTabbedPane.this.editor.getTabPane().getTabCount() == 0) {
                    ScilabTabbedPane.this.editor.addEmptyTab();
                }
                RestoreOpenedFilesAction.restoreEnabledComponents(ScilabTabbedPane.this.editor);
            }
        }

        class CloseButton
        extends JButton {
            CloseButton() {
                super(CLOSEICON);
                this.setFocusable(false);
                this.setContentAreaFilled(true);
                this.setOpaque(false);
                this.setRolloverEnabled(true);
                this.setRolloverIcon(CLOSEONICON);
                this.setBorderPainted(false);
                this.setPreferredSize(new Dimension(18, 18));
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CloseTabButton.this.closeTab();
                    }
                });
            }
        }
    }
}

