/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.scinotes.SciNotesAutosave;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public final class SaveFile {
    private static final String LINE_SEPARATOR = "line.separator";

    private SaveFile() {
    }

    public static boolean doSave(ScilabEditorPane scilabEditorPane, int n, File file, EditorKit editorKit) {
        return SaveFile.doSave(scilabEditorPane, n, file, editorKit, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doSave(ScilabDocument scilabDocument, File file, EditorKit editorKit) throws IOException {
        String string = System.getProperty(LINE_SEPARATOR);
        boolean bl = false;
        BufferedWriter bufferedWriter = null;
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = null;
        if (scilabDocument.getEOL().compareTo(string) != 0) {
            System.setProperty(LINE_SEPARATOR, scilabDocument.getEOL());
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, SciNotesOptions.getSciNotesPreferences().encoding);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            editorKit.write(bufferedWriter, (Document)scilabDocument, 0, scilabDocument.getLength());
            bufferedWriter.flush();
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        System.setProperty(LINE_SEPARATOR, string);
        return bl;
    }

    public static boolean doSave(ScilabEditorPane scilabEditorPane, int n, File file, EditorKit editorKit, boolean bl, boolean bl2) {
        return SaveFile.doSave(scilabEditorPane, n, file, editorKit, bl, bl2, SciNotesOptions.getSciNotesAutosave().autoSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doSave(ScilabEditorPane scilabEditorPane, int n, File file, EditorKit editorKit, boolean bl, boolean bl2, boolean bl3) {
        File[] fileArray;
        String string;
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        boolean bl4 = false;
        File file2 = null;
        if (!scilabDocument.getEncoding().equalsIgnoreCase(SciNotesOptions.getSciNotesPreferences().encoding)) {
            if (!bl2) {
                string = String.format(SciNotesMessages.DIFFERENT_ENCODINGS, scilabDocument.getEncoding(), SciNotesOptions.getSciNotesPreferences().encoding);
                if (ScilabModalDialog.show((SimpleTab)scilabEditorPane.getEditor(), (String)string, (String)SciNotesMessages.DIFFERENT_ENCODINGS_TITLE, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.NO_OPTION) {
                    return false;
                }
                bl4 = true;
            } else {
                return false;
            }
        }
        if (bl3) {
            file2 = SciNotesAutosave.getBackupFile(file.getName());
        }
        try {
            file.createNewFile();
            if (file2 != null) {
                file2.createNewFile();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (!file.canWrite()) {
            if (!bl2) {
                ScilabModalDialog.show((SimpleTab)scilabEditorPane.getEditor(), (String)SciNotesMessages.NOTWRITABLE, (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
            }
            return false;
        }
        if (file2 != null && !file2.canWrite()) {
            file2 = null;
        }
        string = System.getProperty(LINE_SEPARATOR);
        if (scilabDocument.getEOL().compareTo(string) != 0) {
            System.setProperty(LINE_SEPARATOR, scilabDocument.getEOL());
        }
        if (bl) {
            scilabDocument.addEOL();
        }
        boolean bl5 = false;
        BufferedWriter bufferedWriter = null;
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = null;
        for (File file3 : fileArray = new File[]{file, file2}) {
            if (file3 == null) continue;
            try {
                fileOutputStream = new FileOutputStream(file3);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, SciNotesOptions.getSciNotesPreferences().encoding);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                editorKit.write(bufferedWriter, (Document)scilabDocument, 0, scilabDocument.getLength());
                bufferedWriter.flush();
                bl5 = true;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                bl5 = false;
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
                bl5 = false;
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
        System.setProperty(LINE_SEPARATOR, string);
        if (bl4) {
            scilabEditorPane.getEditor().reload(n);
        }
        return bl5;
    }
}

