/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.print.PageFormat;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.ScilabTransformerFactory;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.helptools.scilab.HTMLWithStyleScilabCodeHandler;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.utils.FOCodeConverter;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class CodeExporter
extends FOCodeConverter {
    public static final String PDF = "application/pdf";
    public static final String PS = "application/postscript";
    public static final String EPS = "application/postscript";
    public static final String RTF = "application/rtf";
    public static final String PNG = "image/png";
    public static final String PREVIEW = "application/X-fop-awt-preview";
    public static final String PRINT = "application/X-fop-print";
    private static final String CREATOR = "SciNotes for Scilab";
    private SciNotes editor;

    public CodeExporter(ScilabEditorPane scilabEditorPane) {
        super(scilabEditorPane);
        this.editor = scilabEditorPane.getEditor();
    }

    public static void convert(ScilabEditorPane scilabEditorPane, String string, String string2, PageFormat pageFormat) {
        if ("text/html".equals(string2)) {
            try {
                HTMLWithStyleScilabCodeHandler hTMLWithStyleScilabCodeHandler = new HTMLWithStyleScilabCodeHandler(Collections.emptySet(), Collections.emptySet());
                hTMLWithStyleScilabCodeHandler.convert((Reader)new StringReader(((ScilabDocument)scilabEditorPane.getDocument()).getText()), (Writer)new FileWriter(string));
            }
            catch (IOException iOException) {
                System.err.println(SciNotesMessages.EXPORTERROR + ":");
                iOException.printStackTrace();
            }
        } else {
            CodeExporter codeExporter = new CodeExporter(scilabEditorPane);
            codeExporter.convert(((ScilabDocument)scilabEditorPane.getDocument()).getText(), scilabEditorPane.getXln().getLineNumber(), string, string2, scilabEditorPane.getShortName(), pageFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String string, int[] nArray, String string2, String string3, String string4, PageFormat pageFormat) {
        OutputStream outputStream = null;
        try {
            Fop fop;
            FopFactory fopFactory = FopFactory.newInstance((File)new File(ScilabConstants.SCI + "/modules/helptools/etc/fopconf.xml"));
            FOUserAgent fOUserAgent = fopFactory.newFOUserAgent();
            fOUserAgent.setProducer(CREATOR);
            fOUserAgent.setTitle(string4);
            fOUserAgent.setAuthor(System.getProperty("user.name"));
            if (!(string3.equals(PRINT) || string3.equals(PREVIEW) || string2 == null || string2.isEmpty())) {
                outputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                fop = fopFactory.newFop(string3, fOUserAgent, outputStream);
            } else {
                fop = fopFactory.newFop(string3, fOUserAgent);
            }
            String string5 = ScilabTransformerFactory.useDefaultTransformerFactoryImpl();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            String string6 = super.convert(string, nArray, pageFormat);
            StreamSource streamSource = new StreamSource(new StringReader(string6));
            SAXResult sAXResult = new SAXResult(fop.getDefaultHandler());
            transformer.transform(streamSource, sAXResult);
            ScilabTransformerFactory.restoreTransformerFactoryImpl((String)string5);
        }
        catch (Exception exception) {
            if (string3.equals(PRINT)) {
                ScilabModalDialog.show((SimpleTab)this.editor, (String)(SciNotesMessages.PRINTERERROR + "\n" + exception.getLocalizedMessage()));
            } else {
                System.err.println(SciNotesMessages.EXPORTERROR + ":");
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

