/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import com.artenum.rosetta.core.CompletionItemImpl;
import com.artenum.rosetta.interfaces.core.CompletionItem;
import com.artenum.rosetta.interfaces.core.CompletionManager;
import com.artenum.rosetta.interfaces.core.ConsoleConfiguration;
import com.artenum.rosetta.interfaces.core.GenericInterpreter;
import com.artenum.rosetta.interfaces.core.HistoryManager;
import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.CompletionWindow;
import com.artenum.rosetta.interfaces.ui.InputCommandView;
import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.interfaces.ui.PromptView;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.scilab.modules.completion.Completion;
import org.scilab.modules.console.CompletionAction;
import org.scilab.modules.console.SciCompletionManager;
import org.scilab.modules.console.SciInputParsingManager;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.scinotes.KeywordEvent;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.utils.SciNotesCompletionWindow;

public final class SciNotesCompletionAction
extends CompletionAction {
    private SciNotes editor;

    public SciNotesCompletionAction(JComponent jComponent, SciNotes sciNotes) {
        this.editor = sciNotes;
        this.configuration = new SciNotesCompletionConfiguration();
    }

    public SciNotesCompletionAction(SciNotes sciNotes) {
        this.editor = sciNotes;
    }

    public SciNotesCompletionAction(String string, SciNotes sciNotes) {
        this.editor = sciNotes;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.configuration == null) {
            this.configuration = new SciNotesCompletionConfiguration();
        }
        this.configuration.getCompletionWindow().setGraphicalContext((Component)this.editor.getTextPane());
        super.actionPerformed(actionEvent);
    }

    public static MenuItem createMenu(String string, final SciNotes sciNotes, KeyStroke keyStroke) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setText(string);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).addActionListener(new ActionListener(){
            private SciNotesCompletionAction action;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.action == null) {
                    this.action = new SciNotesCompletionAction(sciNotes);
                }
                this.action.actionPerformed(actionEvent);
            }
        });
        if (keyStroke != null) {
            ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(keyStroke);
        }
        return menuItem;
    }

    class SciNotesCompletionConfiguration
    implements ConsoleConfiguration {
        private SciNotesInputParsingManager xipm;
        private SciCompletionManager scm;
        private SciNotesCompletionWindow cwi;

        public SciNotesCompletionConfiguration() {
            this.xipm = new SciNotesInputParsingManager();
            this.scm = new SciNotesCompletionManager();
            this.scm.setInputParsingManager((InputParsingManager)this.xipm);
            this.cwi = new SciNotesCompletionWindow(SciNotesCompletionAction.this.editor, (CompletionManager)this.scm);
            this.cwi.setInputParsingManager((InputParsingManager)this.xipm);
            this.cwi.setGraphicalContext(SciNotesCompletionAction.this.editor.getTextPane());
        }

        public InputParsingManager getInputParsingManager() {
            return this.xipm;
        }

        public CompletionManager getCompletionManager() {
            return this.scm;
        }

        public CompletionWindow getCompletionWindow() {
            return this.cwi;
        }

        public PromptView getPromptView() {
            return null;
        }

        public OutputView getOutputView() {
            return null;
        }

        public InputCommandView getInputCommandView() {
            return null;
        }

        public StyledDocument getOutputViewStyledDocument() {
            return null;
        }

        public StyledDocument getInputCommandViewStyledDocument() {
            return null;
        }

        public HistoryManager getHistoryManager() {
            return null;
        }

        public String getBackgroundColor() {
            return null;
        }

        public String getForegroundColor() {
            return null;
        }

        public int getScrollableUnitIncrement() {
            return 0;
        }

        public int getScrollableBlockIncrement() {
            return 0;
        }

        public boolean getHorizontalWrapAllowed() {
            return true;
        }

        public boolean getVerticalWrapAllowed() {
            return true;
        }

        public String getFontName() {
            return null;
        }

        public int getFontStyle() {
            return 0;
        }

        public int getFontSize() {
            return 0;
        }

        public String getWelcomeLine() {
            return null;
        }

        public GenericInterpreter getGenericInterpreter() {
            return null;
        }

        public ActionMap getActionMapping() {
            return null;
        }

        public void setActiveProfile(String string) {
        }

        public String getActiveProfile() {
            return null;
        }

        public InputMap getKeyMapping() {
            return null;
        }
    }

    class SciNotesCompletionManager
    extends SciCompletionManager {
        public List<CompletionItem> getCompletionItems() {
            ArrayList arrayList = super.getCompletionItems();
            if (arrayList.isEmpty()) {
                Object object;
                ScilabEditorPane scilabEditorPane = SciNotesCompletionAction.this.editor.getTextPane();
                KeywordEvent keywordEvent = scilabEditorPane.getKeywordEvent();
                String string = null;
                boolean bl = false;
                try {
                    if (keywordEvent.getType() == 1) {
                        object = scilabEditorPane.getDocument().getText(keywordEvent.getStart(), keywordEvent.getLength());
                        if (((String)object).equals(".")) {
                            string = " ";
                        }
                    } else if (keywordEvent.getType() == 18) {
                        string = scilabEditorPane.getDocument().getText(keywordEvent.getStart(), keywordEvent.getLength());
                    }
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
                object = Completion.searchHandleGraphicsPropertiesDictionary(string);
                String string2 = Messages.gettext((String)"Graphics handle field");
                arrayList = new ArrayList();
                if (object != null) {
                    for (Object object2 : object) {
                        this.dictionary.add(new CompletionItemImpl(string2, (String)object2 + " (" + string2 + ")", (String)object2, Messages.gettext((String)"No help")));
                    }
                }
                return this.dictionary;
            }
            return arrayList;
        }
    }

    class SciNotesInputParsingManager
    extends SciInputParsingManager {
        SciNotesInputParsingManager() {
        }

        public void reset() {
            try {
                ((ScilabDocument)SciNotesCompletionAction.this.editor.getTextPane().getDocument()).setFocused(true);
                Element element = SciNotesCompletionAction.this.editor.getTextPane().getDocument().getDefaultRootElement();
                int n = SciNotesCompletionAction.this.editor.getTextPane().getCaretPosition();
                int n2 = element.getElementIndex(n);
                int n3 = element.getElement(n2).getStartOffset();
                SciNotesCompletionAction.this.editor.getTextPane().getDocument().remove(n3, n - n3);
                SciNotesCompletionAction.this.editor.getTextPane().setCaretPosition(n3);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public int getCaretPosition() {
            Element element = SciNotesCompletionAction.this.editor.getTextPane().getDocument().getDefaultRootElement();
            int n = SciNotesCompletionAction.this.editor.getTextPane().getCaretPosition();
            int n2 = element.getElementIndex(n);
            int n3 = element.getElement(n2).getStartOffset();
            return n - n3;
        }

        public String getCommandLine() {
            try {
                Element element = SciNotesCompletionAction.this.editor.getTextPane().getDocument().getDefaultRootElement();
                int n = SciNotesCompletionAction.this.editor.getTextPane().getCaretPosition();
                int n2 = element.getElementIndex(n);
                int n3 = element.getElement(n2).getStartOffset();
                KeywordEvent keywordEvent = SciNotesCompletionAction.this.editor.getTextPane().getKeywordEvent();
                if (keywordEvent.getType() == 18 && (keywordEvent = SciNotesCompletionAction.this.editor.getTextPane().getKeywordEvent(keywordEvent.getStart() - 1)).getType() == 6) {
                    return "";
                }
                return SciNotesCompletionAction.this.editor.getTextPane().getDocument().getText(n3, n - n3);
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        public void append(String string) {
            try {
                ScilabDocument scilabDocument = (ScilabDocument)SciNotesCompletionAction.this.editor.getTextPane().getDocument();
                scilabDocument.setFocused(true);
                Element element = SciNotesCompletionAction.this.editor.getTextPane().getDocument().getDefaultRootElement();
                int n = SciNotesCompletionAction.this.editor.getTextPane().getCaretPosition();
                scilabDocument.mergeEditsBegin();
                SciNotesCompletionAction.this.editor.getTextPane().getDocument().insertString(n, string, null);
                scilabDocument.mergeEditsEnd();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Point getWindowCompletionLocation() {
            try {
                int n = SciNotesCompletionAction.this.editor.getTextPane().getCaretPosition();
                Rectangle rectangle = SciNotesCompletionAction.this.editor.getTextPane().modelToView(n);
                return new Point(rectangle.x, rectangle.y + rectangle.height);
            }
            catch (BadLocationException badLocationException) {
                return new Point(0, 0);
            }
        }

        public int getCompletionLevel() {
            return 0;
        }

        public String getPartLevel(int n) {
            return Completion.getPartLevel((String)this.getCommandLine());
        }

        public String getFilePartLevel(int n) {
            return "";
        }

        public void writeCompletionPart(String string) {
        }

        public int getNumberOfLines() {
            return 0;
        }

        public boolean isBlockEditing() {
            return true;
        }

        public void setInputCommandView(InputCommandView inputCommandView) {
        }

        public void backspace() {
            try {
                Element element = SciNotesCompletionAction.this.editor.getTextPane().getDocument().getDefaultRootElement();
                int n = SciNotesCompletionAction.this.editor.getTextPane().getCaretPosition();
                SciNotesCompletionAction.this.editor.getTextPane().getDocument().remove(n - 1, 1);
                SciNotesCompletionAction.this.editor.getTextPane().setCaretPosition(n - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

