/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.KeywordEvent;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexer;
import org.scilab.modules.scinotes.ScilabLexerConstants;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class OpenSourceFileOnKeywordAction
extends DefaultAction {
    private static final long serialVersionUID = 1L;
    private static final int GAP = 5;
    private static boolean windowAlreadyExist;
    private static JFrame mainFrame;
    private NavigableSet<String> macrosSet;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox comboComplete;
    private boolean onMenu;
    private int lastSize;

    public OpenSourceFileOnKeywordAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    public OpenSourceFileOnKeywordAction(String string, SciNotes sciNotes, boolean bl) {
        this(string, sciNotes);
        this.onMenu = bl;
    }

    public static void close() {
        mainFrame = null;
    }

    @Override
    public void doAction() {
        ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
        KeywordEvent keywordEvent = scilabEditorPane.getKeywordEvent(scilabEditorPane.getSelectionEnd());
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        if (ScilabLexerConstants.isOpenable(keywordEvent.getType())) {
            String string = "";
            try {
                string = scilabDocument.getText(keywordEvent.getStart(), keywordEvent.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.onMenu) {
                this.openSourceBox(string);
            } else {
                this.openSource(string);
            }
        } else {
            this.openSourceBox("");
        }
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return OpenSourceFileOnKeywordAction.createMenu(string, null, new OpenSourceFileOnKeywordAction(string, sciNotes, true), keyStroke);
    }

    public static void openSource(ScilabEditorPane scilabEditorPane, String string) {
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        int n = scilabDocument.searchFunctionByName(string);
        if (n != -1) {
            scilabEditorPane.scrollTextToPos(n);
        } else {
            String string2 = "get_function_path('" + string + "')";
            InterpreterManagement.requestScilabExec((String)("if " + string2 + " ~=[] then editor(" + string2 + ");end"));
        }
    }

    public static void closeOpenSourceWindow() {
        if (windowAlreadyExist) {
            mainFrame.dispose();
            windowAlreadyExist = false;
        }
    }

    public void openSourceBox(String string) {
        if (windowAlreadyExist) {
            mainFrame.setVisible(true);
            if (string.length() != 0) {
                this.comboComplete.removeAllItems();
                this.comboComplete.getEditor().setItem(string);
                this.comboComplete.hidePopup();
            }
            return;
        }
        this.macrosSet = new TreeSet<String>(ScilabLexer.macros);
        mainFrame = new JFrame();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"scilab")).getImage());
        mainFrame.setDefaultCloseOperation(3);
        windowAlreadyExist = true;
        JLabel jLabel = new JLabel(SciNotesMessages.OPEN_SOURCE_FILE_OF);
        this.comboComplete = new JComboBox();
        this.comboComplete.setEditable(true);
        if (string.length() != 0) {
            this.comboComplete.removeAllItems();
            this.comboComplete.getEditor().setItem(string);
        } else {
            this.updateComboComplete(" ");
        }
        this.comboComplete.hidePopup();
        this.cancelButton = new JButton(SciNotesMessages.CANCEL);
        this.okButton = new JButton(SciNotesMessages.OK);
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel.add(new JLabel());
        jPanel.add(new JLabel());
        jPanel.add(this.cancelButton);
        jPanel.add(this.okButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel2.add(jLabel);
        jPanel2.add(this.comboComplete);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        mainFrame.setContentPane(jPanel3);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                windowAlreadyExist = false;
                mainFrame.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                windowAlreadyExist = false;
                mainFrame.dispose();
                OpenSourceFileOnKeywordAction.this.openSource((String)OpenSourceFileOnKeywordAction.this.comboComplete.getEditor().getItem());
            }
        });
        this.comboComplete.getEditor().getEditorComponent().addKeyListener(new KeyListener(){
            private String old = "";

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    if (OpenSourceFileOnKeywordAction.this.comboComplete.getSelectedIndex() == -1 && OpenSourceFileOnKeywordAction.this.comboComplete.getItemCount() > 0) {
                        OpenSourceFileOnKeywordAction.this.comboComplete.setSelectedIndex(0);
                    }
                    OpenSourceFileOnKeywordAction.this.comboComplete.hidePopup();
                    OpenSourceFileOnKeywordAction.this.okButton.requestFocus();
                } else if (n == 27) {
                    OpenSourceFileOnKeywordAction.this.comboComplete.hidePopup();
                } else if (n != 38 && n != 40) {
                    OpenSourceFileOnKeywordAction.this.updateComboComplete(this.old);
                    OpenSourceFileOnKeywordAction.this.comboComplete.setPopupVisible(true);
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.old = (String)OpenSourceFileOnKeywordAction.this.comboComplete.getEditor().getItem();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        mainFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                windowAlreadyExist = false;
                mainFrame.dispose();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        mainFrame.setDefaultCloseOperation(0);
        mainFrame.setTitle(SciNotesMessages.OPEN_SOURCE);
        mainFrame.pack();
        mainFrame.setLocationRelativeTo((Component)((Object)this.getEditor()));
        mainFrame.setVisible(true);
    }

    private void openSource(String string) {
        OpenSourceFileOnKeywordAction.openSource(this.getEditor().getTextPane(), string);
    }

    private void updateComboComplete(String string) {
        String string2 = (String)this.comboComplete.getEditor().getItem();
        NavigableSet<String> navigableSet = null;
        if (string2 != null && !string2.equals(string)) {
            Iterator<String> iterator;
            String string3 = "";
            int n = string2.length();
            if (n != 0) {
                if (n == 1) {
                    string3 = new String(new char[]{(char)(string2.charAt(0) + '\u0001')});
                } else {
                    string3 = string2.substring(0, n - 1);
                    string3 = string3 + (char)(string2.charAt(n - 1) + '\u0001');
                }
                navigableSet = this.macrosSet.subSet(string2, true, string3, false);
                iterator = navigableSet.iterator();
            } else {
                iterator = this.macrosSet.iterator();
            }
            if (navigableSet != null && navigableSet.size() != this.lastSize) {
                this.comboComplete.removeAllItems();
                while (iterator.hasNext()) {
                    this.comboComplete.addItem(iterator.next());
                }
                this.lastSize = navigableSet.size();
                this.comboComplete.setPopupVisible(false);
            }
            this.comboComplete.getEditor().setItem(string2);
            JTextComponent jTextComponent = (JTextComponent)this.comboComplete.getEditor().getEditorComponent();
            jTextComponent.setSelectionStart(jTextComponent.getSelectionEnd());
        }
    }
}

