/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.actions.RecentFileAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;

public class OpenAction
extends DefaultAction {
    private static final long serialVersionUID = -8765712033802048782L;
    private String initialDirectoryPath;

    public OpenAction(String string, SciNotes sciNotes) {
        this(string, sciNotes, "");
    }

    public OpenAction(String string, SciNotes sciNotes, String string2) {
        super(string, sciNotes);
        this.initialDirectoryPath = string2;
    }

    @Override
    public void doAction() {
        String string = this.initialDirectoryPath.length() == 0 ? this.getEditor().getTextPane().getName() : this.initialDirectoryPath;
        if (string == null) {
            string = ConfigManager.getLastOpenedDirectory();
        }
        String[] stringArray = new String[]{"*.cos*", "*.sci", "*.sce", "*.tst", "*.start", "*.quit", "*.dem", "*.sc*", "all"};
        SwingScilabFileChooser swingScilabFileChooser = (SwingScilabFileChooser)ScilabFileChooser.createFileChooser().getAsSimpleFileChooser();
        swingScilabFileChooser.setMultiSelectionEnabled(true);
        swingScilabFileChooser.setInitialDirectory(string);
        swingScilabFileChooser.setAcceptAllFileFilterUsed(true);
        swingScilabFileChooser.addMask(stringArray, null);
        swingScilabFileChooser.setUiDialogType(1);
        int n = swingScilabFileChooser.showOpenDialog((Component)((Object)this.getEditor()));
        if (n == 0) {
            File[] fileArray = swingScilabFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ConfigSciNotesManager.saveToRecentOpenedFiles(fileArray[i].getAbsolutePath());
                this.getEditor().readFile(fileArray[i]);
            }
            RecentFileAction.updateRecentOpenedFilesMenu(this.getEditor());
        }
    }

    public static Object createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return OpenAction.createMenu(string, null, new OpenAction(string, sciNotes), keyStroke);
    }

    public static JButton createButton(String string, String string2, SciNotes sciNotes) {
        return OpenAction.createButton(string, string2, (ActionListener)((Object)new OpenAction(string, sciNotes)));
    }
}

