/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public final class IncrementalSearchAction
extends DefaultAction {
    private static final long serialVersionUID = -3093932085002970876L;
    private static final String SCI = ScilabConstants.SCI.getPath();
    private static final String TAB = "tab";
    private static final ImageIcon CLOSEICON = new ImageIcon(SCI + "/modules/gui/images/icons/close-tab.png");
    private static final ImageIcon TOPICON = new ImageIcon(FindIconHelper.findIcon((String)"go-top"));
    private static final ImageIcon BOTICON = new ImageIcon(FindIconHelper.findIcon((String)"go-bottom"));
    private static final int BUTTONSIZE = 28;
    private static Map<SciNotes, SearchField> fields = new HashMap<SciNotes, SearchField>();

    public IncrementalSearchAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        if (!fields.containsKey((Object)this.getEditor())) {
            SearchField searchField = new SearchField();
            fields.put(this.getEditor(), searchField);
            this.getEditor().insertBottomComponent(searchField);
            searchField.requestFocus();
        } else {
            fields.get((Object)this.getEditor()).requestFocus();
        }
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return IncrementalSearchAction.createMenu(string, null, new IncrementalSearchAction(string, sciNotes), keyStroke);
    }

    public static JButton createButton(String string, String string2, SciNotes sciNotes) {
        return IncrementalSearchAction.createButton(string, string2, (ActionListener)((Object)new IncrementalSearchAction(string, sciNotes)));
    }

    public static void close(SciNotes sciNotes) {
        if (fields.containsKey((Object)sciNotes)) {
            fields.get((Object)sciNotes).removeListeners();
            fields.remove((Object)sciNotes);
        }
    }

    public static String getWord(SciNotes sciNotes) {
        if (fields.containsKey((Object)sciNotes)) {
            return fields.get((Object)sciNotes).getWord();
        }
        return null;
    }

    public static boolean getExact(SciNotes sciNotes) {
        if (fields.containsKey((Object)sciNotes)) {
            return fields.get((Object)sciNotes).getExact();
        }
        return false;
    }

    class SearchField
    extends JPanel
    implements FocusListener,
    KeyListener {
        private String text;
        private final JTextField field;
        private boolean exact;

        public SearchField() {
            super(new BorderLayout());
            this.field = new JTextField();
            this.field.addKeyListener(this);
            this.field.addFocusListener(this);
            this.field.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            this.field.getInputMap().put(KeyStroke.getKeyStroke(9, 0), IncrementalSearchAction.TAB);
            this.field.getActionMap().put(IncrementalSearchAction.TAB, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IncrementalSearchAction.this.getEditor().getTextPane().requestFocus();
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
            jPanel.add(new CloseButton());
            jPanel.add(new TopBotButtons(true));
            jPanel.add(new TopBotButtons(false));
            JCheckBox jCheckBox = new JCheckBox(SciNotesMessages.EXACT);
            jCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SearchField.this.exact = itemEvent.getStateChange() == 1;
                    SearchField.this.changeText();
                }
            });
            jPanel.add(jCheckBox);
            this.add((Component)jPanel, "West");
            this.add((Component)this.field, "Center");
            this.setVisible(true);
        }

        public String getWord() {
            return this.field.getText();
        }

        public boolean getExact() {
            return this.exact;
        }

        @Override
        public void requestFocus() {
            this.field.requestFocus();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.text == null) {
                this.changeText();
            }
            this.field.select(0, this.field.getText().length());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.text = null;
        }

        public void removeListeners() {
            this.field.removeFocusListener(this.field.getFocusListeners()[0]);
            this.field.removeKeyListener(this.field.getKeyListeners()[0]);
        }

        public void hideField() {
            this.removeListeners();
            fields.remove((Object)IncrementalSearchAction.this.getEditor());
            IncrementalSearchAction.this.getEditor().insertBottomComponent(null);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                this.hideField();
                return;
            }
            if (n != 37 && n != 39 && n != 38 && n != 40) {
                ScilabEditorPane scilabEditorPane = IncrementalSearchAction.this.getEditor().getTextPane();
                int n2 = scilabEditorPane.getSelectionStart();
                String string = this.field.getText();
                if (string != null) {
                    int n3;
                    scilabEditorPane.highlightWords(string, this.exact);
                    if (!this.exact) {
                        string = string.toLowerCase();
                    }
                    if (n == 10 && (keyEvent.getModifiers() & 1) != 0) {
                        n3 = this.text.lastIndexOf(string, n2 - 1);
                        keyEvent.consume();
                    } else {
                        if (n == 10) {
                            ++n2;
                        }
                        n3 = this.text.indexOf(string, n2);
                    }
                    if (n3 != -1) {
                        scilabEditorPane.select(n3, n3 + string.length());
                        this.field.setForeground(Color.BLACK);
                    } else {
                        this.field.setForeground(Color.RED);
                    }
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        private void changeText() {
            if (IncrementalSearchAction.this.getEditor().getTextPane() != null) {
                ScilabEditorPane scilabEditorPane = IncrementalSearchAction.this.getEditor().getTextPane();
                ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
                this.text = scilabDocument.getText();
                if (!this.exact) {
                    this.text = this.text.toLowerCase();
                }
                scilabEditorPane.highlightWords(this.field.getText(), this.exact);
            }
        }

        class TopBotButtons
        extends JButton {
            TopBotButtons(final boolean bl) {
                super(bl ? TOPICON : BOTICON);
                this.setFocusable(false);
                this.setContentAreaFilled(true);
                this.setOpaque(false);
                this.setRolloverEnabled(true);
                this.setBorderPainted(false);
                this.setPreferredSize(new Dimension(28, 28));
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ScilabEditorPane scilabEditorPane = IncrementalSearchAction.this.getEditor().getTextPane();
                        int n = scilabEditorPane.getSelectionStart();
                        String string = SearchField.this.field.getText();
                        ScilabDocument scilabDocument = (ScilabDocument)IncrementalSearchAction.this.getEditor().getTextPane().getDocument();
                        String string2 = scilabDocument.getText();
                        if (!SearchField.this.exact) {
                            string2 = string2.toLowerCase();
                        }
                        if (string != null) {
                            int n2;
                            if (!SearchField.this.exact) {
                                string = string.toLowerCase();
                            }
                            if ((n2 = bl ? string2.lastIndexOf(string, n - 1) : string2.indexOf(string, n + 1)) != -1) {
                                scilabEditorPane.select(n2, n2 + string.length());
                                SearchField.this.field.setForeground(Color.BLACK);
                            } else {
                                SearchField.this.field.setForeground(Color.RED);
                            }
                        }
                    }
                });
            }
        }

        class CloseButton
        extends JButton {
            CloseButton() {
                super(CLOSEICON);
                this.setFocusable(false);
                this.setContentAreaFilled(true);
                this.setOpaque(false);
                this.setRolloverEnabled(true);
                this.setBorderPainted(false);
                this.setPreferredSize(new Dimension(28, 28));
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchField.this.hideField();
                    }
                });
            }
        }
    }
}

