/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.FunctionScanner;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.actions.DefaultAction;

public class GenerateHelpFromFunctionAction
extends DefaultAction {
    private static final long serialVersionUID = 5008914832562621484L;
    public static final String TEMPLATE = "//\n//\n// Syntax\n// [returnValues] = functionName(argsValues) // \n// Parameters\n// argsValuesOnColumn\n// returnValuesOnColumn\n// \n// Description\n// \n// \n// Examples\n// \n// \n// See Also\n// \n// \n// Authors\n// \n\n";

    public GenerateHelpFromFunctionAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        ScilabDocument.ScilabLeafElement scilabLeafElement;
        ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
        int n = scilabEditorPane.getCaretPosition();
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        Element element = scilabDocument.getDefaultRootElement();
        Element element2 = element.getElement(element.getElementIndex(n));
        if (element2 instanceof ScilabDocument.ScilabLeafElement && (scilabLeafElement = (ScilabDocument.ScilabLeafElement)element2).isFunction()) {
            FunctionScanner.FunctionInfo functionInfo = scilabLeafElement.getFunctionInfo();
            String string = TEMPLATE.replaceFirst("functionName", functionInfo.functionName);
            string = string.replaceFirst("returnValues", this.generateList(functionInfo.returnValues, ", ", ""));
            string = string.replaceFirst("argsValues", this.generateList(functionInfo.argsValues, ", ", ""));
            string = string.replaceFirst("returnValuesOnColumn", this.generateList(functionInfo.returnValues, ": \n// ", ": "));
            string = string.replaceFirst("argsValuesOnColumn", this.generateList(functionInfo.argsValues, ": \n// ", ": "));
            try {
                scilabDocument.mergeEditsEnd();
                scilabDocument.insertString(element2.getEndOffset(), string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private String generateList(List<String> list, String string, String string2) {
        String string3 = "";
        for (int i = 0; i < list.size() - 1; ++i) {
            string3 = string3 + list.get(i) + string;
        }
        if (list.size() >= 1) {
            string3 = string3 + list.get(list.size() - 1) + string2;
        }
        return string3;
    }

    public static MenuItem createMenu(String string, final SciNotes sciNotes, KeyStroke keyStroke) {
        final MenuItem menuItem = GenerateHelpFromFunctionAction.createMenu(string, null, new GenerateHelpFromFunctionAction(string, sciNotes), keyStroke);
        ((JMenuItem)menuItem.getAsSimpleMenuItem()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (sciNotes.getTextPane() != null) {
                    Element element = sciNotes.getTextPane().getDocument().getDefaultRootElement();
                    int n = sciNotes.getTextPane().getCaretPosition();
                    ScilabDocument.ScilabLeafElement scilabLeafElement = (ScilabDocument.ScilabLeafElement)element.getElement(element.getElementIndex(n));
                    menuItem.setEnabled(scilabLeafElement.isFunction());
                }
            }
        });
        return menuItem;
    }
}

