/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.bridge.textbox.SwingScilabTextBox;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.SearchManager;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public final class FindAction
extends DefaultAction
implements WindowFocusListener {
    private static final long serialVersionUID = -5499974793656106222L;
    private static final int GAP = 5;
    private static final int THREE = 3;
    private static final String FILTERNEWLINES = "filterNewlines";
    private static final String ESCAPE = "ESCAPE";
    private static final Color SELECTEDCOLOR = new Color(205, 183, 158);
    private static final Highlighter.HighlightPainter ACTIVEPAINTER = new DefaultHighlighter.DefaultHighlightPainter(Color.green);
    private static final Highlighter.HighlightPainter INACTIVEPAINTER = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
    private static final Highlighter.HighlightPainter SELECTEDPAINTER = new DefaultHighlighter.DefaultHighlightPainter(SELECTEDCOLOR);
    private static String previousSearch;
    private static boolean windowAlreadyExist;
    private static FindAction current;
    private JFrame frame;
    private JButton buttonClose;
    private JButton buttonFind;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton buttonReplace;
    private JButton buttonReplaceAll;
    private JButton buttonReplaceFind;
    private JCheckBox checkCase;
    private JCheckBox checkRegular;
    private JCheckBox checkCircular;
    private JCheckBox checkWhole;
    private JComboBox comboFind;
    private JComboBox comboReplace;
    private JLabel labelFind;
    private JLabel labelReplace;
    private JPanel panelButton;
    private JPanel panelDirection;
    private JPanel panelFind;
    private JPanel panelFrame;
    private JPanel panelOptions;
    private JPanel panelScope;
    private SwingScilabTextBox statusBar;
    private JRadioButton radioAll;
    private JRadioButton radioFromCaret;
    private JRadioButton radioBackward;
    private JRadioButton radioForward;
    private JRadioButton radioSelection;
    private String oldWord;
    private String newWord;
    private String wordToFind;
    private String lastSearch = "";
    private String lastReplace = "";
    private int startSelectedLines;
    private int endSelectedLines;
    private int startFind;
    private int endFind;
    private boolean restarted;
    private Object[] highlighters;
    private Object selectedHighlight;
    private String previousRegexp;
    private int previousIndex;
    private List<Integer[]> foundOffsets;
    private final MyListener myListener = new MyListener();
    private boolean comboReplaceCanceled;
    private boolean comboFindCanceled;
    private Document previousDocument;

    public FindAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        if (windowAlreadyExist) {
            if (current != this) {
                current.closeFindReplaceWindow();
                current = this;
                this.findReplaceBox();
            } else {
                this.frame.setVisible(true);
                this.buttonFind.requestFocus();
                this.frame.toFront();
            }
        } else {
            current = this;
            this.findReplaceBox();
        }
        this.previousRegexp = "";
        this.previousIndex = -1;
        this.getEditor().getTextPane().removeCaretListener(this.myListener);
        this.startSelectedLines = 0;
        this.endSelectedLines = 0;
        try {
            ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
            int n = scilabEditorPane.getSelectionStart();
            int n2 = scilabEditorPane.getSelectionEnd();
            Element element = scilabEditorPane.getDocument().getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementIndex(n2);
            if (n != n2) {
                if (n3 != n4) {
                    this.radioSelection.doClick();
                    this.comboFind.setSelectedIndex(-1);
                    this.comboReplace.setSelectedIndex(-1);
                } else {
                    this.radioAll.doClick();
                    this.comboFind.getEditor().setItem(scilabEditorPane.getDocument().getText(n, n2 - n));
                    this.comboFind.getEditor().selectAll();
                }
            } else {
                this.radioAll.doClick();
                this.comboFind.setSelectedIndex(-1);
                this.comboReplace.setSelectedIndex(-1);
            }
            windowAlreadyExist = true;
            this.updateFindReplaceButtonStatus();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return FindAction.createMenu(string, null, new FindAction(string, sciNotes), keyStroke);
    }

    public static JButton createButton(String string, String string2, SciNotes sciNotes) {
        return FindAction.createButton(string, string2, (ActionListener)((Object)new FindAction(string, sciNotes)));
    }

    public static void close() {
        if (current != null) {
            current.closeFindReplaceWindow();
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.getEditor().getSwingParentWindow()) {
            this.frame.setAlwaysOnTop(true);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (windowEvent.getOppositeWindow() != this.frame && windowEvent.getOppositeWindow() != this.getEditor().getSwingParentWindow()) {
            this.frame.setAlwaysOnTop(false);
        }
    }

    public void findReplaceBox() {
        this.frame = new JFrame();
        this.frame.setAlwaysOnTop(true);
        this.frame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), ESCAPE);
        this.frame.getRootPane().getActionMap().put(ESCAPE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.closeFindReplaceWindow();
            }
        });
        this.frame.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"scilab")).getImage());
        this.frame.setDefaultCloseOperation(0);
        this.frame.setTitle(SciNotesMessages.FIND_REPLACE);
        this.frame.setResizable(false);
        this.getEditor().getSwingParentWindow().addWindowFocusListener((WindowFocusListener)this);
        this.frame.addWindowFocusListener(this);
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.panelFrame = new JPanel();
        this.panelDirection = new JPanel();
        this.radioForward = new JRadioButton();
        this.radioBackward = new JRadioButton();
        this.panelScope = new JPanel();
        this.radioAll = new JRadioButton();
        this.radioFromCaret = new JRadioButton();
        this.radioSelection = new JRadioButton();
        this.panelOptions = new JPanel();
        this.checkCase = new JCheckBox();
        this.checkWhole = new JCheckBox();
        this.checkRegular = new JCheckBox();
        this.checkCircular = new JCheckBox();
        this.panelFind = new JPanel();
        this.labelFind = new JLabel();
        this.labelReplace = new JLabel();
        this.comboFind = new JComboBox();
        this.comboReplace = new JComboBox();
        this.panelButton = new JPanel();
        this.buttonFind = new JButton();
        this.buttonReplaceFind = new JButton();
        this.buttonReplace = new JButton();
        this.buttonReplaceAll = new JButton();
        this.buttonClose = new JButton();
        this.statusBar = new SwingScilabTextBox();
        this.panelFrame.setLayout(new BoxLayout(this.panelFrame, 3));
        this.panelFrame.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.labelFind.setText(SciNotesMessages.FIND);
        this.labelReplace.setText(SciNotesMessages.REPLACE);
        this.comboFind.setEditable(true);
        this.comboReplace.setEditable(true);
        this.panelFind.setLayout(new GridLayout(2, 2, 5, 5));
        this.panelFind.add(this.labelFind);
        this.panelFind.add(this.comboFind);
        this.panelFind.add(this.labelReplace);
        this.panelFind.add(this.comboReplace);
        this.panelFrame.add(this.panelFind);
        this.panelDirection.setBorder(BorderFactory.createTitledBorder(SciNotesMessages.DIRECTION));
        this.buttonGroup1.add(this.radioForward);
        this.radioForward.setText(SciNotesMessages.FORWARD);
        this.buttonGroup1.add(this.radioBackward);
        this.radioBackward.setText(SciNotesMessages.BACKWARD);
        this.panelDirection.setLayout(new GridLayout(3, 1, 5, 5));
        this.panelDirection.add(this.radioForward);
        this.panelDirection.add(this.radioBackward);
        this.panelScope.setBorder(BorderFactory.createTitledBorder(SciNotesMessages.SCOPE));
        this.buttonGroup2.add(this.radioAll);
        this.radioAll.setText(SciNotesMessages.SELECT_ALL);
        this.buttonGroup2.add(this.radioFromCaret);
        this.radioFromCaret.setText(SciNotesMessages.SELECT_FROM_CARET);
        this.buttonGroup2.add(this.radioSelection);
        this.radioSelection.setText(SciNotesMessages.SELECTED_LINES);
        this.panelScope.setLayout(new GridLayout(3, 1, 5, 5));
        this.panelScope.add(this.radioAll);
        this.panelScope.add(this.radioFromCaret);
        this.panelScope.add(this.radioSelection);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel.add(this.panelDirection);
        jPanel.add(this.panelScope);
        this.panelFrame.add(jPanel);
        this.panelOptions.setBorder(BorderFactory.createTitledBorder(SciNotesMessages.OPTIONS));
        this.checkCase.setText(SciNotesMessages.CASE_SENSITIVE);
        this.checkWhole.setText(SciNotesMessages.WHOLE_WORD);
        this.checkRegular.setText(SciNotesMessages.REGULAR_EXPRESSIONS);
        this.checkCircular.setText(SciNotesMessages.CIRCULAR_SEARCH);
        this.checkCircular.setSelected(true);
        this.panelOptions.setLayout(new GridLayout(2, 2, 5, 5));
        this.panelOptions.add(this.checkCase);
        this.panelOptions.add(this.checkRegular);
        this.panelOptions.add(this.checkWhole);
        this.panelOptions.add(this.checkCircular);
        this.panelFrame.add(this.panelOptions);
        this.buttonFind.setText(SciNotesMessages.FIND_BUTTON);
        this.buttonReplaceFind.setText(SciNotesMessages.REPLACE_FIND);
        this.buttonReplace.setText(SciNotesMessages.REPLACE);
        this.buttonReplaceAll.setText(SciNotesMessages.REPLACE_ALL);
        this.buttonClose.setText(SciNotesMessages.CLOSE);
        this.statusBar.setText("");
        this.panelButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelButton.setLayout(new GridLayout(3, 3, 5, 5));
        this.panelButton.add(new JLabel());
        this.panelButton.add(this.buttonFind);
        this.panelButton.add(this.buttonReplaceFind);
        this.panelButton.add(new JLabel());
        this.panelButton.add(this.buttonReplace);
        this.panelButton.add(this.buttonReplaceAll);
        this.panelButton.add(new JLabel());
        this.panelButton.add(new JLabel());
        this.panelButton.add(this.buttonClose);
        this.panelFrame.add(this.panelButton);
        this.panelFrame.add((Component)this.statusBar);
        this.frame.setContentPane(this.panelFrame);
        this.frame.pack();
        this.frame.setLocationRelativeTo((Component)((Object)this.getEditor()));
        this.frame.setVisible(true);
        this.buttonReplaceFind.setEnabled(false);
        this.buttonReplace.setEnabled(false);
        this.buttonFind.setEnabled(false);
        this.buttonReplaceAll.setEnabled(false);
        this.radioForward.setSelected(true);
        this.radioAll.doClick();
        this.fillSearch();
        this.fillReplace();
        this.restoreConfiguration();
        ((JTextField)this.comboReplace.getEditor().getEditorComponent()).getDocument().putProperty(FILTERNEWLINES, Boolean.FALSE);
        ((JTextField)this.comboFind.getEditor().getEditorComponent()).getDocument().putProperty(FILTERNEWLINES, Boolean.FALSE);
        this.checkCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveCaseSensitive(FindAction.this.checkCase.isSelected());
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.checkWhole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveWholeWord(FindAction.this.checkWhole.isSelected());
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.checkCircular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveCircularSearch(FindAction.this.checkCircular.isSelected());
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.checkRegular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveRegularExpression(FindAction.this.checkRegular.isSelected());
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.radioSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScilabEditorPane scilabEditorPane = FindAction.this.getEditor().getTextPane();
                Element element = scilabEditorPane.getDocument().getDefaultRootElement();
                int n = scilabEditorPane.getSelectionStart();
                int n2 = scilabEditorPane.getSelectionEnd();
                int n3 = element.getElementIndex(n);
                int n4 = element.getElementIndex(n2);
                FindAction.this.startSelectedLines = element.getElement(n3).getStartOffset();
                FindAction.this.endSelectedLines = element.getElement(n4).getEndOffset() - 1;
                scilabEditorPane.setCaretPosition(FindAction.this.startSelectedLines);
                FindAction.this.removeAllHighlights();
                FindAction.this.setSelectedHighlight();
                scilabEditorPane.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, focusEvent.getOppositeComponent());
                        if (jFrame == FindAction.this.frame) {
                            FindAction.this.removeAllHighlights();
                            FindAction.this.previousRegexp = "";
                            FindAction.this.radioAll.setSelected(true);
                            FindAction.this.getEditor().getTextPane().removeFocusListener(this);
                        }
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                    }
                });
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.radioAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.removeAllHighlights();
                FindAction.this.previousRegexp = "";
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.radioFromCaret.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.removeAllHighlights();
                FindAction.this.previousRegexp = "";
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.radioBackward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.buttonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.updateRecentSearch();
                FindAction.this.findText();
            }
        });
        this.buttonReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.updateRecentSearch();
                FindAction.this.updateRecentReplace();
                ScilabEditorPane scilabEditorPane = FindAction.this.getEditor().getTextPane();
                ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
                scilabDocument.mergeEditsBegin();
                FindAction.this.replaceOnlyText();
                scilabDocument.mergeEditsEnd();
            }
        });
        this.buttonReplaceFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.updateRecentSearch();
                FindAction.this.updateRecentReplace();
                ScilabEditorPane scilabEditorPane = FindAction.this.getEditor().getTextPane();
                ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
                scilabDocument.mergeEditsBegin();
                if (FindAction.this.buttonReplace.isEnabled()) {
                    FindAction.this.replaceText();
                }
                scilabDocument.mergeEditsEnd();
                FindAction.this.findText();
            }
        });
        this.buttonReplaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                FindAction.this.updateRecentSearch();
                FindAction.this.updateRecentReplace();
                ScilabEditorPane scilabEditorPane = FindAction.this.getEditor().getTextPane();
                ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
                int n = 0;
                int n2 = scilabDocument.getLength();
                String string2 = "";
                boolean bl = FindAction.this.checkWhole.isSelected() && FindAction.this.checkWhole.isEnabled();
                boolean bl2 = FindAction.this.checkRegular.isSelected();
                boolean bl3 = FindAction.this.checkCase.isSelected();
                int n3 = ((JTextComponent)scilabEditorPane).getCaretPosition();
                if (FindAction.this.radioSelection.isSelected()) {
                    n = FindAction.this.startSelectedLines;
                    n2 = FindAction.this.endSelectedLines;
                    try {
                        string2 = scilabDocument.getText(FindAction.this.startSelectedLines, FindAction.this.endSelectedLines - FindAction.this.startSelectedLines);
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (FindAction.this.radioFromCaret.isSelected()) {
                    if (FindAction.this.radioForward.isSelected()) {
                        n = n3;
                        n2 = scilabDocument.getLength();
                    } else {
                        n = 0;
                        n2 = n3;
                    }
                    try {
                        string2 = scilabDocument.getText(n, n2 - n);
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    string2 = scilabDocument.getText();
                }
                FindAction.this.oldWord = (String)FindAction.this.comboFind.getEditor().getItem();
                FindAction.this.newWord = (String)FindAction.this.comboReplace.getEditor().getItem();
                FindAction.setPreviousSearch(FindAction.this.oldWord);
                Pattern pattern = SearchManager.generatePattern(FindAction.this.oldWord, bl3, bl, bl2);
                Matcher matcher = pattern.matcher(string2);
                if (bl2) {
                    FindAction.this.newWord = FindAction.this.newWord.replaceAll("\\\\r\\\\n|\\\\n", "\n").replaceAll("\\\\t", "\t");
                    string = matcher.replaceAll(FindAction.this.newWord);
                } else {
                    string = matcher.replaceAll(Matcher.quoteReplacement(FindAction.this.newWord));
                }
                if (string.compareTo(string2) != 0 && string2.length() > 0) {
                    try {
                        List<ScilabDocument.Anchor> list = scilabDocument.getAnchorsBetween(n, n2);
                        scilabDocument.mergeEditsBegin();
                        scilabDocument.setFocused(true);
                        scilabDocument.replace(n, string2.length(), string, null);
                        scilabDocument.mergeEditsEnd();
                        Element element = scilabDocument.getDefaultRootElement();
                        for (ScilabDocument.Anchor anchor : list) {
                            ScilabDocument.ScilabLeafElement scilabLeafElement = (ScilabDocument.ScilabLeafElement)element.getElement(anchor.getLine());
                            scilabLeafElement.setAnchor(anchor.toString());
                        }
                        if (FindAction.this.getEditor().getNavigator() != null) {
                            FindAction.this.getEditor().getNavigator().update();
                        }
                        FindAction.this.previousRegexp = "";
                        FindAction.this.previousIndex = -1;
                        FindAction.this.buttonReplace.setEnabled(false);
                        FindAction.this.buttonReplaceFind.setEnabled(false);
                        FindAction.this.buttonReplaceAll.setEnabled(false);
                        scilabEditorPane.setCaretPosition(Math.min(n3, scilabDocument.getLength()));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                if (FindAction.this.radioSelection.isSelected()) {
                    FindAction.this.removeAllHighlights();
                    FindAction.this.endSelectedLines = FindAction.this.startSelectedLines + string.length();
                    FindAction.this.setSelectedHighlight();
                }
            }
        });
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindAction.this.closeFindReplaceWindow();
            }
        });
        this.comboReplace.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                FindAction.this.comboReplaceCanceled = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.comboReplace.getEditor().getEditorComponent().addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FindAction.this.closeComboPopUp();
                FindAction.this.updateFindReplaceButtonStatus();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
        this.comboReplace.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    if (FindAction.this.comboReplaceCanceled) {
                        FindAction.this.comboReplaceCanceled = false;
                    } else {
                        FindAction.this.closeFindReplaceWindow();
                    }
                }
                if (keyEvent.getKeyCode() == 10) {
                    FindAction.this.replaceText();
                    FindAction.this.findText();
                    FindAction.this.buttonReplaceFind.requestFocus();
                }
                FindAction.this.updateFindReplaceButtonStatus();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.comboFind.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                FindAction.this.comboFindCanceled = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.comboFind.getEditor().getEditorComponent().addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FindAction.this.closeComboPopUp();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
        this.comboFind.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FindAction.this.updateFindReplaceButtonStatus();
            }
        });
        this.comboFind.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    if (FindAction.this.comboFindCanceled) {
                        FindAction.this.comboFindCanceled = false;
                    } else {
                        FindAction.this.closeFindReplaceWindow();
                    }
                }
                if (keyEvent.getKeyCode() == 10) {
                    FindAction.this.buttonFind.requestFocus();
                    FindAction.this.findText();
                }
                FindAction.this.updateFindReplaceButtonStatus();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FindAction.this.closeFindReplaceWindow();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
    }

    private void closeComboPopUp() {
        if (this.comboFind.isPopupVisible()) {
            this.comboFind.hidePopup();
        }
        if (this.comboReplace.isPopupVisible()) {
            this.comboReplace.hidePopup();
        }
    }

    private void fillSearch() {
        this.comboFind.removeAllItems();
        List<String> list = ConfigSciNotesManager.getRecentSearch();
        for (String string : list) {
            this.comboFind.addItem(string);
        }
    }

    private void fillReplace() {
        this.comboReplace.removeAllItems();
        List<String> list = ConfigSciNotesManager.getRecentReplace();
        for (String string : list) {
            this.comboReplace.addItem(string);
        }
    }

    private void updateRecentSearch() {
        List<String> list;
        String string = (String)this.comboFind.getEditor().getItem();
        if (string != null && string.length() != 0 && !string.equals(this.lastSearch) && !(list = ConfigSciNotesManager.getRecentSearch()).contains(string)) {
            this.comboFind.addItem(string);
            ConfigSciNotesManager.saveRecentSearch(string);
            this.lastSearch = string;
        }
    }

    private void updateRecentReplace() {
        List<String> list;
        String string = (String)this.comboReplace.getEditor().getItem();
        if (string != null && string.length() != 0 && !string.equals(this.lastReplace) && !(list = ConfigSciNotesManager.getRecentReplace()).contains(string)) {
            this.comboReplace.addItem(string);
            ConfigSciNotesManager.saveRecentReplace(string);
            this.lastReplace = string;
        }
    }

    private void restoreConfiguration() {
        this.checkRegular.setSelected(ConfigSciNotesManager.getRegularExpression());
        this.checkCircular.setSelected(ConfigSciNotesManager.getCircularSearch());
        this.checkWhole.setSelected(ConfigSciNotesManager.getWholeWord());
        this.checkCase.setSelected(ConfigSciNotesManager.getCaseSensitive());
    }

    protected void updateFindReplaceButtonStatus() {
        String string = (String)this.comboFind.getEditor().getItem();
        if (string.compareTo("") != 0) {
            this.buttonFind.setEnabled(true);
            this.buttonReplace.setEnabled(true);
            this.buttonReplaceAll.setEnabled(true);
            this.buttonReplaceFind.setEnabled(true);
            this.statusBar.setText("");
        } else {
            this.buttonFind.setEnabled(false);
            this.buttonReplace.setEnabled(false);
            this.buttonReplaceAll.setEnabled(false);
            this.buttonReplaceFind.setEnabled(false);
        }
        Pattern pattern = Pattern.compile("\\w*");
        Matcher matcher = pattern.matcher(string);
        this.checkWhole.setEnabled(false);
        if (matcher.find() && matcher.end() - matcher.start() == string.length()) {
            this.checkWhole.setEnabled(true);
        }
        if (this.checkRegular.isSelected()) {
            try {
                Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.statusBar.setText(String.format(SciNotesMessages.INVALID_REGEXP, string));
                this.buttonFind.setEnabled(false);
                this.buttonReplaceAll.setEnabled(false);
            }
        }
        if (this.buttonReplace.isEnabled() && this.oldWord != null && this.oldWord.compareTo(string) != 0) {
            this.buttonReplace.setEnabled(false);
            this.buttonReplaceFind.setEnabled(false);
        }
    }

    public void addHighlighters(boolean bl) {
        Highlighter highlighter = this.getEditor().getTextPane().getHighlighter();
        this.removeAllHighlights();
        this.highlighters = new Object[this.foundOffsets.size()];
        for (int i = 0; i < this.foundOffsets.size(); ++i) {
            try {
                if (bl) {
                    this.highlighters[i] = highlighter.addHighlight(this.foundOffsets.get(i)[0], this.foundOffsets.get(i)[1], ACTIVEPAINTER);
                    continue;
                }
                this.highlighters[i] = highlighter.addHighlight(this.foundOffsets.get(i)[0], this.foundOffsets.get(i)[1], INACTIVEPAINTER);
                continue;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (this.radioSelection.isSelected()) {
            this.setSelectedHighlight();
        }
    }

    public void changeHighlighter(int n, boolean bl) {
        if (this.highlighters != null) {
            Highlighter highlighter = this.getEditor().getTextPane().getHighlighter();
            highlighter.removeHighlight(this.highlighters[n]);
            try {
                this.highlighters[n] = bl ? highlighter.addHighlight(this.foundOffsets.get(n)[0], this.foundOffsets.get(n)[1], ACTIVEPAINTER) : highlighter.addHighlight(this.foundOffsets.get(n)[0], this.foundOffsets.get(n)[1], INACTIVEPAINTER);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            if (this.radioSelection.isSelected()) {
                this.setSelectedHighlight();
            }
        }
    }

    public void setSelectedHighlight() {
        Highlighter highlighter = this.getEditor().getTextPane().getHighlighter();
        try {
            if (this.selectedHighlight != null) {
                highlighter.removeHighlight(this.selectedHighlight);
            }
            this.selectedHighlight = highlighter.addHighlight(this.startSelectedLines, this.endSelectedLines, SELECTEDPAINTER);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void removeHighlighter(int n) {
        if (this.highlighters != null) {
            Highlighter highlighter = this.getEditor().getTextPane().getHighlighter();
            highlighter.removeHighlight(this.highlighters[n]);
        }
    }

    public void removeAllHighlights() {
        Highlighter highlighter = this.getEditor().getTextPane().getHighlighter();
        if (this.highlighters != null) {
            for (int i = 0; i < this.highlighters.length; ++i) {
                highlighter.removeHighlight(this.highlighters[i]);
            }
        }
        if (this.selectedHighlight != null) {
            highlighter.removeHighlight(this.selectedHighlight);
            this.selectedHighlight = null;
        }
    }

    private int getSearched(int n, boolean bl, boolean bl2) {
        int n2 = -1;
        for (int i = 0; i < this.foundOffsets.size(); ++i) {
            if (bl && this.foundOffsets.get(i)[0] >= n) {
                n2 = i;
                break;
            }
            if (bl || this.foundOffsets.get(i)[0] < n) continue;
            if (i == 0) {
                return -1;
            }
            n2 = i - 1;
            break;
        }
        if (n2 == -1 && bl2) {
            if (bl) {
                return 0;
            }
            return this.foundOffsets.size() - 1;
        }
        return n2;
    }

    public boolean generateOffsets() {
        boolean bl = this.checkCase.isSelected();
        boolean bl2 = this.checkWhole.isSelected() && this.checkWhole.isEnabled();
        boolean bl3 = this.checkRegular.isSelected();
        boolean bl4 = this.radioSelection.isSelected();
        Document document = this.getEditor().getTextPane().getDocument();
        this.wordToFind = (String)this.comboFind.getEditor().getItem();
        String string = SearchManager.generatePattern(this.wordToFind, bl, bl2, bl3).toString();
        if (document != this.previousDocument || !this.previousRegexp.equals(string)) {
            this.previousRegexp = string;
            if (document != this.previousDocument) {
                this.previousDocument = document;
            }
            this.foundOffsets = bl4 ? SearchManager.findWord(document, this.wordToFind, this.startSelectedLines, this.endSelectedLines, bl, bl2, bl3) : SearchManager.findWord(document, this.wordToFind, 0, document.getLength(), bl, bl2, bl3);
            return true;
        }
        return false;
    }

    private void findText() {
        boolean bl = this.checkCircular.isSelected();
        boolean bl2 = this.radioForward.isSelected();
        boolean bl3 = this.radioBackward.isSelected();
        String string = (String)this.comboFind.getEditor().getItem();
        if (string.compareTo("") == 0) {
            return;
        }
        FindAction.setPreviousSearch(this.wordToFind);
        ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
        if (this.generateOffsets()) {
            this.addHighlighters(false);
            this.previousIndex = -1;
        }
        int n = scilabEditorPane.getSelectionStart();
        n = bl2 ? scilabEditorPane.getSelectionEnd() : scilabEditorPane.getSelectionStart() - 1;
        this.statusBar.setText("");
        int n2 = this.foundOffsets.size();
        if (n2 > 0) {
            int n3 = -1;
            if (this.previousIndex == -1) {
                n3 = this.getSearched(n, !bl3, bl);
            } else {
                n3 = bl3 ? (bl ? (n2 + this.previousIndex - 1) % n2 : this.previousIndex - 1) : (bl ? (this.previousIndex + 1) % n2 : this.previousIndex + 1);
                this.changeHighlighter(this.previousIndex, false);
            }
            if (n3 == n2) {
                n3 = -1;
            }
            if (n3 != -1) {
                if (this.restarted) {
                    this.statusBar.setText("");
                    this.restarted = false;
                } else if (bl && n2 >= 2 && n3 <= this.previousIndex) {
                    this.statusBar.setText(SciNotesMessages.RESTART_FROM_BEGINNING);
                    this.restarted = true;
                }
                this.changeHighlighter(n3, true);
                this.previousIndex = n3;
                if (bl3) {
                    scilabEditorPane.setCaretPosition(this.foundOffsets.get(n3)[0]);
                } else {
                    scilabEditorPane.setCaretPosition(this.foundOffsets.get(n3)[1]);
                }
                scilabEditorPane.addFocusListener(this.myListener);
                this.buttonReplace.setEnabled(true);
                this.buttonReplaceFind.setEnabled(true);
                this.startFind = this.foundOffsets.get(n3)[0];
                this.endFind = this.foundOffsets.get(n3)[1];
            } else {
                this.startFind = 0;
                this.endFind = 0;
                this.buttonFind.setEnabled(false);
                this.buttonReplace.setEnabled(false);
                this.buttonReplaceFind.setEnabled(false);
                this.statusBar.setText(String.format(SciNotesMessages.STRING_NOT_FOUND, this.wordToFind));
            }
        } else {
            this.statusBar.setText(String.format(SciNotesMessages.STRING_NOT_FOUND, this.wordToFind));
            this.buttonFind.setEnabled(false);
            this.buttonReplace.setEnabled(false);
            this.buttonReplaceFind.setEnabled(false);
            this.buttonReplaceAll.setEnabled(false);
        }
    }

    private void replaceOnlyText() {
        this.replaceText();
        this.buttonReplace.setEnabled(false);
        this.buttonReplaceFind.setEnabled(false);
    }

    private void replaceText() {
        boolean bl = this.checkCase.isSelected();
        boolean bl2 = this.checkWhole.isSelected() && this.checkWhole.isEnabled();
        boolean bl3 = this.checkRegular.isSelected();
        String string = (String)this.comboFind.getEditor().getItem();
        String string2 = (String)this.comboReplace.getEditor().getItem();
        string2 = bl3 ? string2.replaceAll("\\\\r\\\\n|\\\\n", "\n").replaceAll("\\\\t", "\t") : Matcher.quoteReplacement(string2);
        if (string.compareTo("") == 0 || this.startFind == this.endFind) {
            return;
        }
        FindAction.setPreviousSearch(string);
        ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
        try {
            Pattern pattern = SearchManager.generatePattern(string, bl, bl2, bl3);
            Matcher matcher = pattern.matcher(scilabEditorPane.getText(this.startFind, this.endFind - this.startFind + 1));
            String string3 = matcher.replaceAll(string2);
            ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
            scilabDocument.setFocused(true);
            scilabDocument.replace(this.startFind, this.endFind - this.startFind + 1, string3, null);
            scilabEditorPane.setCaretPosition(this.startFind + string3.length());
            this.endSelectedLines += string3.length() - (this.endFind - this.startFind + 1);
            this.previousRegexp = "";
            this.previousIndex = -1;
            if (this.generateOffsets()) {
                this.addHighlighters(false);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void closeFindReplaceWindow() {
        if (windowAlreadyExist) {
            ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
            if (scilabEditorPane != null) {
                scilabEditorPane.getHighlighter().removeAllHighlights();
                int n = scilabEditorPane.getSelectionStart();
                int n2 = scilabEditorPane.getSelectionEnd();
                ((JTextComponent)scilabEditorPane).select(n, n2);
            }
            this.getEditor().getSwingParentWindow().removeWindowFocusListener((WindowFocusListener)this);
            this.frame.removeWindowFocusListener(this);
            this.frame.dispose();
            windowAlreadyExist = false;
        }
    }

    public static String getPreviousSearch() {
        return previousSearch;
    }

    public static void setPreviousSearch(String string) {
        previousSearch = string;
    }

    private class MyListener
    implements CaretListener,
    FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (FindAction.this.previousIndex != -1) {
                int n = ((Integer[])FindAction.this.foundOffsets.get(FindAction.this.previousIndex))[0];
                int n2 = ((Integer[])FindAction.this.foundOffsets.get(FindAction.this.previousIndex))[1];
                FindAction.this.getEditor().getTextPane().select(n, n2);
            }
            FindAction.this.getEditor().getTextPane().addCaretListener(this);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            FindAction.this.removeAllHighlights();
            FindAction.this.getEditor().getTextPane().removeCaretListener(this);
            FindAction.this.getEditor().getTextPane().removeFocusListener(this);
            FindAction.this.previousRegexp = "";
        }
    }
}

