/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.SciFileFilter;
import org.scilab.modules.jvm.LoadClassPath;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.actions.PageSetupAction;
import org.scilab.modules.scinotes.utils.CodeExporter;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class ExportAction
extends DefaultAction {
    private static final long serialVersionUID = 7796680521955058413L;
    private static final String DOT = ".";
    private boolean codeConverterLoaded;
    private File currentFile;

    public ExportAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        int n;
        String string = null;
        String string2 = "Export";
        String string3 = "";
        String string4 = string3;
        if (string4 == null) {
            string4 = this.getEditor().getTextPane().getName();
        }
        if (string4 == null) {
            string4 = ConfigManager.getLastOpenedDirectory();
        }
        SciFileFilter sciFileFilter = new SciFileFilter("*.html", null, 0);
        SciFileFilter sciFileFilter2 = new SciFileFilter("*.pdf", null, 1);
        SciFileFilter sciFileFilter3 = new SciFileFilter("*.ps", null, 2);
        SciFileFilter sciFileFilter4 = new SciFileFilter("*.eps", null, 3);
        SciFileFilter sciFileFilter5 = new SciFileFilter("*.rtf", null, 4);
        final SwingScilabFileChooser swingScilabFileChooser = (SwingScilabFileChooser)ScilabFileChooser.createFileChooser().getAsSimpleFileChooser();
        swingScilabFileChooser.setInitialDirectory(ConfigManager.getLastOpenedDirectory());
        swingScilabFileChooser.setAcceptAllFileFilterUsed(false);
        swingScilabFileChooser.setInitialDirectory(string4);
        swingScilabFileChooser.setDialogTitle(Messages.gettext((String)string2));
        swingScilabFileChooser.setApproveButtonText(Messages.gettext((String)string2));
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter2);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter3);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter4);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter5);
        swingScilabFileChooser.setFileFilter((FileFilter)sciFileFilter);
        swingScilabFileChooser.setTitle(string2);
        swingScilabFileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof SciFileFilter) {
                    String string = ((SciFileFilter)object).getDescription();
                    String string2 = ExportAction.this.currentFile.getName();
                    int n = string2.lastIndexOf(ExportAction.DOT);
                    if (n != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if ((n = string.lastIndexOf(ExportAction.DOT)) != -1) {
                        string = string.substring(n, string.length() - 1);
                    }
                    swingScilabFileChooser.setSelectedFile(new File(string2 + string));
                }
            }
        });
        swingScilabFileChooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof File) {
                    ExportAction.this.currentFile = (File)object;
                }
            }
        });
        String string5 = this.getEditor().getTextPane().getName();
        if (string5 == null && (string5 = ((ScilabDocument)this.getEditor().getTextPane().getDocument()).getFirstFunctionName()) == null) {
            string5 = "";
        }
        if ((n = string5.lastIndexOf(DOT)) != -1) {
            string5 = string5.substring(0, n);
        }
        if (string5 != null) {
            string5 = string5 + ".pdf";
            swingScilabFileChooser.setSelectedFile(new File(string5));
        }
        int n2 = swingScilabFileChooser.showSaveDialog((Component)((Object)this.getEditor()));
        String string6 = null;
        String string7 = null;
        if (n2 == 0) {
            int n3;
            File file = SciNotes.fileToCanonicalFile(swingScilabFileChooser.getSelectedFile());
            string4 = file.getPath();
            if (file.exists() && ScilabModalDialog.show((SimpleTab)this.getEditor(), (String)SciNotesMessages.REPLACE_FILE_TITLE, (String)SciNotesMessages.FILE_ALREADY_EXIST, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.NO_OPTION) {
                return;
            }
            boolean bl = true;
            string6 = file.getName();
            if (string6.lastIndexOf(DOT) != -1 && (n3 = string6.substring(string6.lastIndexOf(DOT), string6.length()).length()) >= 2 && n3 <= 4) {
                bl = false;
                string = string6.substring(string6.lastIndexOf(DOT) + 1, string6.length());
            }
            if (string == null) {
                if (swingScilabFileChooser.getFileFilter() == sciFileFilter) {
                    string = "html";
                    string7 = "text/html";
                } else if (swingScilabFileChooser.getFileFilter() == sciFileFilter2) {
                    string = "pdf";
                    string7 = "application/pdf";
                } else if (swingScilabFileChooser.getFileFilter() == sciFileFilter3) {
                    string = "ps";
                    string7 = "application/postscript";
                } else if (swingScilabFileChooser.getFileFilter() == sciFileFilter4) {
                    string = "eps";
                    string7 = "application/postscript";
                } else if (swingScilabFileChooser.getFileFilter() == sciFileFilter5) {
                    string = "rtf";
                    string7 = "application/rtf";
                } else {
                    string = "";
                    string7 = null;
                }
            } else if (string.equalsIgnoreCase("html")) {
                string7 = "text/html";
            } else if (string.equalsIgnoreCase("pdf")) {
                string7 = "application/pdf";
            } else if (string.equalsIgnoreCase("ps")) {
                string7 = "application/postscript";
            } else if (string.equalsIgnoreCase("eps")) {
                string7 = "application/postscript";
            } else if (string.equalsIgnoreCase("rtf")) {
                string7 = "application/rtf";
            }
            string6 = bl ? file.getPath() + DOT + string : file.getPath();
        } else if (n2 == 1) {
            string6 = null;
        }
        if (!this.codeConverterLoaded) {
            LoadClassPath.loadOnUse((String)"copyAsHTMLinScinotes");
            LoadClassPath.loadOnUse((String)"pdf_ps_eps_graphic_export");
            this.codeConverterLoaded = true;
        }
        if (string6 != null && string7 != null) {
            this.getEditor().getTextPane().setCursor(Cursor.getPredefinedCursor(3));
            CodeExporter.convert(this.getEditor().getTextPane(), string6, string7, PageSetupAction.getPageFormat());
            this.getEditor().getTextPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return ExportAction.createMenu(string, null, new ExportAction(string, sciNotes), keyStroke);
    }
}

