/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.im.InputContext;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.jvm.LoadClassPath;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.utils.HTMLCodeConverter;

public class CopyAsHTMLAction
extends DefaultAction {
    private static final long serialVersionUID = 5363720520521282071L;
    protected boolean printLineNumber;

    public CopyAsHTMLAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        String string;
        if (!this.getEditor().getTextPane().copyColumnSelectionInClipBoard() && (string = this.getEditor().getTextPane().getSelectedText()) != null) {
            HTMLSelection hTMLSelection = new HTMLSelection(this.getEditor().getTextPane(), string, this.printLineNumber);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(hTMLSelection, hTMLSelection);
        }
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return CopyAsHTMLAction.createMenu(string, null, new CopyAsHTMLAction(string, sciNotes), keyStroke);
    }

    public static JButton createButton(String string, String string2, SciNotes sciNotes) {
        return CopyAsHTMLAction.createButton(string, string2, (ActionListener)((Object)new CopyAsHTMLAction(string, sciNotes)));
    }

    public static class HTMLTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -5089826958820112637L;

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            ScilabEditorPane scilabEditorPane = (ScilabEditorPane)jComponent;
            String string = scilabEditorPane.getSelectedText();
            if (string != null) {
                return new HTMLSelection(scilabEditorPane, string, false);
            }
            return null;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor[] dataFlavorArray;
            if (jComponent instanceof ScilabEditorPane && (dataFlavorArray = transferable.getTransferDataFlavors()) != null) {
                int n;
                for (n = 0; n < dataFlavorArray.length && !dataFlavorArray[n].equals(DataFlavor.stringFlavor); ++n) {
                }
                if (n != dataFlavorArray.length) {
                    InputContext inputContext = jComponent.getInputContext();
                    if (inputContext != null) {
                        inputContext.endComposition();
                    }
                    try {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        ((ScilabEditorPane)jComponent).replaceSelection(string);
                        return true;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }
    }

    public static class HTMLSelection
    implements Transferable,
    ClipboardOwner {
        private DataFlavor htmlFlavor;
        private String data;
        private boolean printLineNumber;
        private ScilabEditorPane pane;
        private boolean codeConverterLoaded;

        HTMLSelection(ScilabEditorPane scilabEditorPane, String string, boolean bl) {
            this.data = string;
            this.printLineNumber = bl;
            this.pane = scilabEditorPane;
            try {
                this.htmlFlavor = new DataFlavor("text/html;class=java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            String string = null;
            if (dataFlavor.equals(this.htmlFlavor)) {
                if (!this.codeConverterLoaded) {
                    LoadClassPath.loadOnUse((String)"copyAsHTMLinScinotes");
                    this.codeConverterLoaded = true;
                }
                string = new HTMLCodeConverter(this.pane).convert(this.data, this.printLineNumber);
            } else if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                string = this.data;
            }
            return string;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.htmlFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(this.htmlFlavor) || dataFlavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

