/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorKit;
import org.scilab.modules.scinotes.ScilabLexer;
import org.scilab.modules.scinotes.utils.SciNotesMessages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SearchManager {
    private static final ImageIcon FILEIMAGE = new ImageIcon(FindIconHelper.findIcon((String)"stock_search"));
    private static final ImageIcon SCILABFILEIMAGE = new ImageIcon(FindIconHelper.findIcon((String)"scilab_search"));
    private static final ImageIcon FOLDERIMAGE = new ImageIcon(FindIconHelper.findIcon((String)"folder-saved-search"));
    private static final ImageIcon LINEICON = new ImageIcon(FindIconHelper.findIcon((String)"line-found"));

    public static List<Integer[]> findWord(Document document, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        String string2 = "";
        try {
            string2 = document.getText(n, n2 - n + 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (string2.length() == 0) {
            return null;
        }
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        if (string != null && !string.equals("")) {
            Pattern pattern = SearchManager.generatePattern(string, bl, bl2, bl3);
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                if (matcher.start() == matcher.end()) continue;
                arrayList.add(new Integer[]{matcher.start() + n, matcher.end() + n});
            }
        }
        return arrayList;
    }

    public static List<Integer[]> findToken(ScilabDocument scilabDocument, int n, ScilabLexer scilabLexer, Pattern pattern) {
        String string = scilabDocument.getText();
        if (string.length() == 0) {
            return null;
        }
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            if (n != -1 && n != scilabLexer.getKeyword(n2, false)) continue;
            arrayList.add(new Integer[]{n2, n3});
        }
        return arrayList;
    }

    public static Pattern generatePattern(String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = string;
        if (string2 != null && !string2.equals("")) {
            if (!bl3) {
                string2 = string2.replace("\\E", "\\E\\\\E\\Q");
                string2 = "\\Q" + string2 + "\\E";
                if (bl2 && string.matches("\\b.*\\b")) {
                    string2 = "\\b" + string2 + "\\b";
                }
            }
            if (!bl) {
                string2 = "(?i)" + string2;
            }
            if (bl3) {
                string2 = "(?m)" + string2;
            }
            return Pattern.compile(string2);
        }
        return Pattern.compile("");
    }

    public static MatchingPositions searchInFiles(final BackgroundSearch backgroundSearch, String string, final boolean bl, final boolean bl2, String string2, boolean bl3, String string3, boolean bl4, boolean bl5, boolean bl6) {
        final File file = new File(string);
        Pattern pattern = null;
        if (string3 != null && string3.length() != 0) {
            pattern = SearchManager.generatePattern(string3, bl4, bl5, bl6);
        }
        string2 = string2.replace(".", "\\.").replace("*", ".*").replace("?", ".?");
        final Pattern pattern2 = SearchManager.generatePattern(string2, bl3, false, true);
        final boolean[] blArray = new boolean[]{false};
        if (backgroundSearch == null) {
            return SearchManager.searchInFiles(blArray, file, bl, bl2, pattern2, pattern);
        }
        final Pattern pattern3 = pattern;
        SwingWorker<Object, Object> swingWorker = new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                long l = System.currentTimeMillis();
                backgroundSearch.setResults(SearchManager.searchInFiles(blArray, file, bl, bl2, pattern2, pattern3));
                long l2 = System.currentTimeMillis();
                backgroundSearch.setElapsedTime(l2 - l);
                return null;
            }

            @Override
            public void done() {
                backgroundSearch.done();
            }
        };
        backgroundSearch.setKilled(blArray);
        backgroundSearch.setSwingWorker(swingWorker);
        swingWorker.execute();
        return null;
    }

    public static MatchingPositions searchInFiles(boolean[] blArray, File file, boolean bl, boolean bl2, final Pattern pattern, Pattern pattern2) {
        MatchingPositions matchingPositions = null;
        if (file.exists() && file.isDirectory() && file.canRead() && !blArray[0]) {
            MatchingPositions matchingPositions2;
            int n;
            ArrayList<MatchingPositions> arrayList = new ArrayList<MatchingPositions>();
            matchingPositions = new MatchingPositions(file.getAbsolutePath(), arrayList);
            int n2 = 0;
            Object[] objectArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    return file2.isFile() && file2.canRead() && pattern.matcher(string).matches();
                }
            });
            Arrays.sort(objectArray);
            if (pattern2 != null) {
                for (n = 0; n < objectArray.length && !blArray[0]; ++n) {
                    matchingPositions2 = !bl2 ? SearchManager.searchWordInFile((File)objectArray[n], pattern2) : SearchManager.searchWordInFileIgnoringCR((File)objectArray[n], pattern2);
                    if (matchingPositions2 == null || matchingPositions2.getOccurences() == 0) continue;
                    arrayList.add(matchingPositions2);
                    n2 += matchingPositions2.getOccurences();
                }
            } else {
                for (n = 0; n < objectArray.length && !blArray[0]; ++n) {
                    arrayList.add(new MatchingPositions(((File)objectArray[n]).getAbsolutePath()));
                }
                n2 += objectArray.length;
            }
            if (bl) {
                objectArray = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        File file2 = new File(file, string);
                        return file2.isDirectory() && file2.canRead();
                    }
                });
                Arrays.sort(objectArray);
                for (n = 0; n < objectArray.length && !blArray[0]; ++n) {
                    matchingPositions2 = SearchManager.searchInFiles(blArray, (File)objectArray[n], true, bl2, pattern, pattern2);
                    if (matchingPositions2 == null) continue;
                    arrayList.add(matchingPositions2);
                    n2 += matchingPositions2.getOccurences();
                }
            }
            matchingPositions.setOccurences(n2);
            if (arrayList.isEmpty()) {
                return null;
            }
        }
        return matchingPositions;
    }

    public static MatchingPositions searchWordInFile(File file, Pattern pattern) {
        if (file.exists() && file.canRead()) {
            String string;
            MatchingPositions matchingPositions = new MatchingPositions(file.getAbsolutePath());
            try {
                string = ScilabEditorKit.tryToGuessEncoding(file).name();
            }
            catch (Exception exception) {
                string = Charset.defaultCharset().name();
            }
            try {
                Scanner scanner = new Scanner(file, string);
                int n = 0;
                int n2 = 0;
                while (scanner.hasNextLine()) {
                    ++n2;
                    String string2 = scanner.nextLine();
                    Matcher matcher = pattern.matcher(string2);
                    int n3 = n;
                    while (matcher.find()) {
                        ++n;
                    }
                    if (n == n3) continue;
                    matchingPositions.addLine(n2, string2, pattern);
                }
                scanner.close();
                matchingPositions.setOccurences(n);
                return matchingPositions;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static MatchingPositions searchWordInFileIgnoringCR(File file, Pattern pattern) {
        if (file.exists() && file.canRead()) {
            String string;
            MatchingPositions matchingPositions = new MatchingPositions(file.getAbsolutePath());
            try {
                string = ScilabEditorKit.tryToGuessEncoding(file).name();
            }
            catch (Exception exception) {
                string = Charset.defaultCharset().name();
            }
            try {
                Scanner scanner = new Scanner(file, string);
                int n = 0;
                while (scanner.findWithinHorizon(pattern, 0) != null) {
                    ++n;
                }
                matchingPositions.setOccurences(n);
                scanner.close();
                return matchingPositions;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int countFiles(File file, Pattern pattern) {
        if (!file.isDirectory() || !file.canRead()) {
            return -1;
        }
        int[] nArray = new int[]{0};
        SearchManager.countFiles(file, pattern, nArray);
        return nArray[0];
    }

    private static void countFiles(File file, final Pattern pattern, final int[] nArray) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                if (file2.isFile() && file2.canRead() && pattern.matcher(string).matches()) {
                    nArray[0] = nArray[0] + 1;
                } else if (file2.isDirectory() && file2.canRead()) {
                    SearchManager.countFiles(file2, pattern, nArray);
                }
                return false;
            }
        });
    }

    public static boolean isBinaryFile(File file) {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            char[] cArray = new char[8192];
            int n2 = bufferedReader.read(cArray, 0, 8192);
            bufferedReader.close();
            if (n2 != -1) {
                for (n = 0; n < n2 && cArray[n] != '\u0000'; ++n) {
                }
            }
            return n2 != -1 && n != n2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static void indent(BufferedWriter bufferedWriter, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            bufferedWriter.append("    ");
        }
    }

    public static abstract class BackgroundSearch {
        private MatchingPositions pos;
        private SwingWorker worker;
        private long time;
        private boolean[] killed;

        public void stop() {
            if (this.worker != null && !this.isDone()) {
                this.worker.cancel(true);
                this.worker = null;
                if (this.killed != null && this.killed.length >= 1) {
                    this.killed[0] = true;
                }
            }
        }

        public abstract void done();

        public boolean isDone() {
            if (this.worker != null) {
                return this.worker.isDone();
            }
            return true;
        }

        public MatchingPositions getResults() {
            if (this.isDone()) {
                this.worker = null;
                return this.pos;
            }
            return null;
        }

        public void setElapsedTime(long l) {
            this.time = l;
        }

        public long getElapsedTime() {
            return this.time;
        }

        private void setSwingWorker(SwingWorker swingWorker) {
            this.worker = swingWorker;
        }

        private void setKilled(boolean[] blArray) {
            this.killed = blArray;
        }

        private void setResults(MatchingPositions matchingPositions) {
            this.pos = matchingPositions;
        }
    }

    public static interface Iconable {
        public Icon getIcon();
    }

    public static class Line
    implements Iconable {
        private final int number;
        private String content;

        public Line(int n, String string, Pattern pattern) {
            this.number = n;
            Matcher matcher = pattern.matcher(string);
            if (string.length() > 128) {
                string = string.substring(0, 128) + "...";
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "\u0000");
                stringBuffer.append(matcher.group());
                stringBuffer.append("\u0000\u0000");
            }
            matcher.appendTail(stringBuffer);
            this.content = stringBuffer.toString();
            this.content = this.content.replace("&", "&amp;").replace("/", "&#47;").replace("\\", "&#92;").replace("<", "&lt;").replace(">", "&gt;").replace("\u0000\u0000", "</b>").replace("\u0000", "<b>");
        }

        public Line(Element element) {
            this.number = Integer.parseInt(element.getAttribute("number"));
            this.content = element.getAttribute("content");
        }

        public int getNumber() {
            return this.number;
        }

        public String getContent() {
            return this.content;
        }

        @Override
        public Icon getIcon() {
            return LINEICON;
        }

        public void toXML(BufferedWriter bufferedWriter, int n) throws IOException {
            SearchManager.indent(bufferedWriter, n);
            bufferedWriter.append("<Line content=\"" + ScilabXMLUtilities.getXMLString((String)this.content) + "\" number=\"" + this.number + "\"/>\n");
        }

        public String toString() {
            return "<html><u>line " + this.number + "</u>&thinsp;: " + this.content + "</html>";
        }
    }

    public static class MatchingPositions
    implements Iconable {
        private final String file;
        private boolean isRoot;
        private Icon icon;
        private int occurences;
        private List<MatchingPositions> children;
        private final List<Line> lines = new ArrayList<Line>();

        public MatchingPositions(String string, List<MatchingPositions> list) {
            this.file = string;
            this.children = list;
            this.setIcon();
        }

        public MatchingPositions(String string) {
            this(string, null);
        }

        public MatchingPositions(Element element) {
            this.file = element.getAttribute("file");
            this.isRoot = Boolean.parseBoolean(element.getAttribute("isRoot"));
            this.occurences = Integer.parseInt(element.getAttribute("occurences"));
            if (element.hasChildNodes()) {
                NodeList nodeList = element.getChildNodes();
                Element element2 = (Element)nodeList.item(1);
                if (element2.getTagName().equals("Position")) {
                    this.children = new ArrayList<MatchingPositions>();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (!(nodeList.item(i) instanceof Element)) continue;
                        element2 = (Element)nodeList.item(i);
                        this.children.add(new MatchingPositions(element2));
                    }
                } else {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (!(nodeList.item(i) instanceof Element)) continue;
                        element2 = (Element)nodeList.item(i);
                        this.lines.add(new Line(element2));
                    }
                }
            }
            this.setIcon();
        }

        private void setIcon() {
            this.icon = this.children != null ? FOLDERIMAGE : (this.file.endsWith(".sce") || this.file.endsWith(".sci") ? SCILABFILEIMAGE : FILEIMAGE);
        }

        public void setRoot() {
            this.isRoot = true;
        }

        public void setOccurences(int n) {
            this.occurences = n;
        }

        public int getOccurences() {
            return this.occurences;
        }

        public void addLine(int n, String string, Pattern pattern) {
            this.lines.add(new Line(n, string, pattern));
        }

        public String getFileName() {
            return this.file;
        }

        public boolean isDirectory() {
            return this.children != null;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        public boolean hasLines() {
            return !this.lines.isEmpty();
        }

        public List<MatchingPositions> getChildren() {
            return this.children;
        }

        public DefaultMutableTreeNode toDefaultMutableTreeNode() {
            DefaultMutableTreeNode defaultMutableTreeNode;
            block3: {
                block2: {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(this);
                    if (this.children == null || this.children.isEmpty()) break block2;
                    for (int i = 0; i < this.children.size(); ++i) {
                        defaultMutableTreeNode.add(this.children.get(i).toDefaultMutableTreeNode());
                    }
                    break block3;
                }
                if (this.lines.isEmpty()) break block3;
                for (Line line : this.lines) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(line));
                }
            }
            return defaultMutableTreeNode;
        }

        public void toXML(BufferedWriter bufferedWriter, int n) throws IOException {
            SearchManager.indent(bufferedWriter, n);
            bufferedWriter.append("<Position file=\"" + ScilabXMLUtilities.getXMLString((String)this.file) + "\" isRoot=\"" + this.isRoot + "\" occurences=\"" + this.occurences + "\"");
            if (this.children != null && !this.children.isEmpty()) {
                bufferedWriter.append(">\n");
                for (int i = 0; i < this.children.size(); ++i) {
                    this.children.get(i).toXML(bufferedWriter, n + 1);
                }
                SearchManager.indent(bufferedWriter, n);
                bufferedWriter.append("</Position>\n");
            } else if (!this.lines.isEmpty()) {
                bufferedWriter.append(">\n");
                for (Line line : this.lines) {
                    line.toXML(bufferedWriter, n + 1);
                }
                SearchManager.indent(bufferedWriter, n);
                bufferedWriter.append("</Position>\n");
            } else {
                bufferedWriter.append("/>\n");
            }
        }

        public String toString() {
            String string = SciNotesMessages.MATCHES;
            if (this.occurences <= 1) {
                string = SciNotesMessages.MATCH;
            }
            String string2 = !this.isDirectory() && this.occurences != 0 ? new File(this.getFileName()).getName() : (this.isRoot ? this.getFileName() : new File(this.getFileName()).getName());
            if (this.occurences == 0 && !this.isRoot) {
                return string2;
            }
            string2 = string2.replace("&", "&amp;").replace("/", "&#47;").replace("\\", "&#92;").replace("<", "&lt;").replace(">", "&gt;");
            return String.format(string, string2, this.occurences);
        }
    }
}

