/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.gui.ScilabCaret;
import org.scilab.modules.console.utils.ScilabLaTeXViewer;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.utils.WebBrowser;
import org.scilab.modules.scinotes.CommentManager;
import org.scilab.modules.scinotes.EditorComponent;
import org.scilab.modules.scinotes.HelpOnTypingManager;
import org.scilab.modules.scinotes.IndentManager;
import org.scilab.modules.scinotes.KeywordAdapter;
import org.scilab.modules.scinotes.KeywordEvent;
import org.scilab.modules.scinotes.KeywordListener;
import org.scilab.modules.scinotes.MatchingBlockManager;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.SciNotesCaret;
import org.scilab.modules.scinotes.SciNotesConfiguration;
import org.scilab.modules.scinotes.SciNotesLineNumberPanel;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorKit;
import org.scilab.modules.scinotes.ScilabLexer;
import org.scilab.modules.scinotes.ScilabLexerConstants;
import org.scilab.modules.scinotes.ScilabPlainView;
import org.scilab.modules.scinotes.ScilabView;
import org.scilab.modules.scinotes.SearchManager;
import org.scilab.modules.scinotes.TabManager;
import org.scilab.modules.scinotes.TrailingWhiteManager;
import org.scilab.modules.scinotes.actions.CopyAsHTMLAction;
import org.scilab.modules.scinotes.actions.OpenSourceFileOnKeywordAction;
import org.scilab.modules.scinotes.utils.NavigatorWindow;
import org.scilab.modules.scinotes.utils.SciNotesMessages;
import org.scilab.modules.scinotes.utils.ScilabScrollPane;

public class ScilabEditorPane
extends JEditorPane
implements Highlighter.HighlightPainter,
CaretListener,
MouseListener,
MouseMotionListener,
Cloneable,
KeyListener {
    private static final long serialVersionUID = 4322071415211939097L;
    private static final String TIRET = " - ";
    private static final Cursor HANDCURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor TEXTCURSOR = Cursor.getPredefinedCursor(2);
    private static final DefaultHighlighter.DefaultHighlightPainter HIGHLIGHTER = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private static ScilabEditorPane focused;
    private Color highlightColor;
    private Color highlightContourColor;
    private boolean highlightEnable;
    private Object highlightCL;
    private boolean matchingKeywordsEnable;
    private boolean matchingOpenersEnable;
    private boolean overwriteMode;
    private ScilabLexer lexer;
    private SciNotes editor;
    private IndentManager indent;
    private TabManager tab;
    private CommentManager com;
    private HelpOnTypingManager helpOnTyping;
    private TrailingWhiteManager trailingWhite;
    private boolean readonly;
    private boolean binary;
    private String infoBar = "";
    private String shortName = "";
    private String title = "";
    private Timer selectionTimer;
    private Timer matcherTimer;
    private Point mousePoint;
    private long lastModified;
    private long lastExternalModification;
    private MatchingBlockManager matchLR;
    private MatchingBlockManager matchRL;
    private boolean suppressCom = false;
    private SciNotesLineNumberPanel xln;
    private ScilabEditorPane rightTextPane;
    private UUID uuid;
    private EditorComponent edComponent;
    private boolean hand;
    private boolean infoBarChanged;
    private boolean ctrlHit;
    private Color saveHighlightContourColor;
    private Color saveHighlightColor;
    private boolean hasBeenSaved;
    private boolean saveHighlightEnable;
    private EventListenerList kwListeners = new EventListenerList();
    private Map<Integer, Object> highlightedWords = new HashMap<Integer, Object>();

    public ScilabEditorPane(SciNotes sciNotes) {
        if (focused == null) {
            focused = this;
        }
        this.editor = sciNotes;
        this.uuid = UUID.randomUUID();
        this.edComponent = new EditorComponent(this);
        this.setFocusCycleRoot(false);
        this.addCaretListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.enableMatchingKeywords(SciNotesOptions.getSciNotesDisplay().highlightKeywords);
        this.enableMatchingOpeners(SciNotesOptions.getSciNotesDisplay().highlightBrackets);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NavigatorWindow navigatorWindow;
                ScilabEditorPane.this.updateInfosWhenFocused();
                if (ScilabEditorPane.this.editor != null && (navigatorWindow = ScilabEditorPane.this.editor.getNavigator()) != null) {
                    navigatorWindow.update((ScilabDocument)ScilabEditorPane.this.getDocument());
                }
                ScilabEditorPane.this.setMustAdjustVisibility(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ((ScilabDocument)ScilabEditorPane.this.getDocument()).setFocused(false);
                if (focusEvent.getOppositeComponent() == ScilabEditorPane.this.getOtherPaneInSplit()) {
                    ScilabEditorPane.this.setMustAdjustVisibility(false);
                }
            }
        });
        this.addKeywordListener(new KeywordAdapter.MouseOverAdapter(){

            @Override
            public void caughtKeyword(KeywordEvent keywordEvent) {
                block21: {
                    if (ScilabLexerConstants.isClickable(keywordEvent.getType())) {
                        if (ScilabEditorPane.this.ctrlHit) {
                            ScilabEditorPane.this.setCursor(HANDCURSOR);
                            ScilabEditorPane.this.hand = true;
                            try {
                                String string;
                                String string2 = ((ScilabDocument)ScilabEditorPane.this.getDocument()).getText(keywordEvent.getStart(), keywordEvent.getLength());
                                if (!ScilabLexerConstants.isClickable(keywordEvent.getType())) break block21;
                                switch (keywordEvent.getType()) {
                                    case 20: {
                                        string = SciNotesMessages.OPENURL;
                                        break;
                                    }
                                    case 21: {
                                        string = SciNotesMessages.MAILTO;
                                        break;
                                    }
                                    case 16: {
                                        string = SciNotesMessages.OPENSOURCE;
                                        break;
                                    }
                                    case 17: {
                                        string = SciNotesMessages.SHOWSOURCE;
                                        break;
                                    }
                                    default: {
                                        string = null;
                                    }
                                }
                                if (string != null && ScilabEditorPane.this.editor != null) {
                                    ScilabEditorPane.this.editor.getInfoBar().setText(string + string2);
                                    ScilabEditorPane.this.infoBarChanged = true;
                                }
                            }
                            catch (BadLocationException badLocationException) {}
                        } else if (ScilabEditorPane.this.editor != null) {
                            ScilabEditorPane.this.editor.getInfoBar().setText(SciNotesMessages.CLICKABLE_URL);
                            ScilabEditorPane.this.infoBarChanged = true;
                            if (ScilabEditorPane.this.hand) {
                                ScilabEditorPane.this.setCursor(TEXTCURSOR);
                                ScilabEditorPane.this.hand = false;
                            }
                        }
                    } else {
                        if (ScilabEditorPane.this.hand) {
                            ScilabEditorPane.this.setCursor(TEXTCURSOR);
                            ScilabEditorPane.this.hand = false;
                        }
                        if (ScilabEditorPane.this.infoBarChanged && ScilabEditorPane.this.editor != null) {
                            ScilabEditorPane.this.editor.getInfoBar().setText(ScilabEditorPane.this.infoBar);
                            ScilabEditorPane.this.infoBarChanged = false;
                        }
                        if (ScilabLexerConstants.isLaTeX(keywordEvent.getType())) {
                            try {
                                int n = keywordEvent.getStart();
                                int n2 = n + keywordEvent.getLength();
                                String string = ((ScilabDocument)ScilabEditorPane.this.getDocument()).getText(n, keywordEvent.getLength());
                                ScilabScrollPane scilabScrollPane = ScilabEditorPane.this.getScrollPane();
                                int n3 = scilabScrollPane != null ? scilabScrollPane.getHeight() + scilabScrollPane.getVerticalScrollBar().getValue() : ScilabEditorPane.this.edComponent.getHeight();
                                ScilabLaTeXViewer.displayExpression((JTextComponent)ScilabEditorPane.this, (int)n3, (String)string, (int)n, (int)n2);
                            }
                            catch (BadLocationException badLocationException) {}
                        } else {
                            ScilabLaTeXViewer.removeLaTeXViewer((JTextComponent)ScilabEditorPane.this);
                        }
                    }
                }
            }
        });
        this.addKeywordListener(new KeywordAdapter.MouseClickedAdapter(){

            @Override
            public void caughtKeyword(KeywordEvent keywordEvent) {
                if (ScilabEditorPane.this.ctrlHit && ScilabLexerConstants.isClickable(keywordEvent.getType())) {
                    try {
                        ScilabEditorPane.this.hand = false;
                        ScilabEditorPane.this.ctrlHit = false;
                        ScilabEditorPane.this.infoBarChanged = false;
                        ScilabEditorPane.this.setCursor(TEXTCURSOR);
                        if (ScilabEditorPane.this.editor != null) {
                            ScilabEditorPane.this.editor.getInfoBar().setText(ScilabEditorPane.this.infoBar);
                        }
                        String string = ((ScilabDocument)ScilabEditorPane.this.getDocument()).getText(keywordEvent.getStart(), keywordEvent.getLength());
                        if (20 == keywordEvent.getType() || 21 == keywordEvent.getType()) {
                            WebBrowser.openUrl((String)string);
                        } else if (ScilabLexerConstants.isOpenable(keywordEvent.getType())) {
                            OpenSourceFileOnKeywordAction.openSource(ScilabEditorPane.this, string);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.getScrollPane().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (OS.get() == OS.MAC && mouseWheelEvent.isMetaDown() || mouseWheelEvent.isControlDown()) {
                    int n = mouseWheelEvent.getWheelRotation();
                    SciNotes.updateFontSize(n);
                    mouseWheelEvent.consume();
                }
            }
        });
        this.addKeyListener(this);
        this.setTransferHandler(new CopyAsHTMLAction.HTMLTransferHandler());
        ((ScilabCaret)this.getCaret()).setMustAdjustVisibility(false);
    }

    public void enableColorization(boolean bl) {
        View view = ((ScilabDocument)this.getDocument()).getView();
        if (view != null) {
            if (view instanceof ScilabView) {
                ((ScilabView)view).enable(bl);
            } else {
                ((ScilabPlainView)view).enable(bl);
            }
        }
    }

    public void configurationChanged(SciNotesConfiguration.Conf conf) {
        ((ScilabEditorKit)this.getEditorKit()).getStylePreferences().configurationChanged(conf);
        if (conf.font) {
            this.resetFont();
        }
        if (conf.display) {
            this.enableHighlightedLine(SciNotesOptions.getSciNotesDisplay().highlightCurrentLine);
            this.setHighlightedLineColor(SciNotesOptions.getSciNotesDisplay().currentLineColor);
            this.enableColorization(SciNotesOptions.getSciNotesDisplay().keywordsColorization);
            this.setBackground(SciNotesOptions.getSciNotesDisplay().backgroundColor);
            this.setCaretColor(SciNotesOptions.getSciNotesDisplay().caretColor);
            boolean bl = SciNotesOptions.getSciNotesDisplay().highlightKeywords;
            boolean bl2 = SciNotesOptions.getSciNotesDisplay().highlightBrackets;
            if ((bl || bl2) && !this.matchingKeywordsEnable && !this.matchingOpenersEnable) {
                this.matchLR = new MatchingBlockManager((ScilabDocument)this.getDocument(), this, true, this.getHighlighter());
                this.matchLR.setDefaults();
                this.matchRL = new MatchingBlockManager((ScilabDocument)this.getDocument(), this, false, this.getHighlighter());
                this.matchRL.setDefaults();
                this.enableMatchingKeywords(bl);
                this.enableMatchingOpeners(bl2);
                return;
            }
            if ((bl || bl2) && (this.matchingKeywordsEnable || this.matchingOpenersEnable)) {
                this.matchLR.configurationChanged(conf);
                this.matchRL.configurationChanged(conf);
                return;
            }
            if (!bl && !bl2 && (this.matchingKeywordsEnable || this.matchingOpenersEnable)) {
                this.matchLR.desactivateMouseOver();
                this.matchLR = null;
                this.matchRL.desactivateMouseOver();
                this.matchRL = null;
                return;
            }
        }
    }

    public ScilabLexer getLexer() {
        return this.lexer;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (((ScilabDocument)this.getDocument()).getView() instanceof ScilabView) {
            return !this.edComponent.isSplited();
        }
        return super.getScrollableTracksViewportWidth();
    }

    public boolean getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(boolean bl) {
        this.overwriteMode = bl;
        ((ScilabCaret)this.getCaret()).setOverwriteMode(bl);
    }

    @Override
    public void replaceSelection(String string) {
        if (this.overwriteMode && this.getSelectionStart() == this.getSelectionEnd()) {
            int n = this.getCaretPosition();
            this.select(n, n + string.length());
        }
        if (((SciNotesCaret)((Object)this.getCaret())).isEmptySelection()) {
            super.replaceSelection(string);
        } else {
            SciNotesCaret sciNotesCaret = (SciNotesCaret)((Object)this.getCaret());
            int[][] nArray = sciNotesCaret.getSelectedPositions();
            List<Object> list = sciNotesCaret.getSelections();
            int n = string.length();
            int n2 = 0;
            ScilabDocument scilabDocument = (ScilabDocument)this.getDocument();
            scilabDocument.getUndoManager().enableOneShot(true);
            scilabDocument.mergeEditsBegin();
            sciNotesCaret.protectHighlights(true);
            for (int i = 0; i < nArray.length; ++i) {
                if (list.get(i) == null) continue;
                int n3 = nArray[i][0] + n2;
                try {
                    scilabDocument.replace(n3, nArray[i][1] - nArray[i][0], string, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                n2 = n3 + n - nArray[i][1];
                nArray[i][0] = n3 + n;
                nArray[i][1] = n3 + n;
            }
            scilabDocument.mergeEditsEnd();
            scilabDocument.getUndoManager().enableOneShot(false);
            sciNotesCaret.protectHighlights(false);
            sciNotesCaret.updateHighlights();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyLocation() == 4 && keyEvent.getKeyCode() == 127 && keyEvent.getKeyChar() != '\u007f') {
            keyEvent.setKeyCode(110);
            this.ctrlHit = false;
        } else if (this.mousePoint != null && keyEvent.getKeyCode() == 17) {
            this.ctrlHit = true;
            this.preventConcernedKeywordListener(this.viewToModel(this.mousePoint), keyEvent, 2);
        } else {
            this.ctrlHit = false;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.mousePoint != null && keyEvent.getKeyCode() == 17) {
            this.ctrlHit = false;
            this.preventConcernedKeywordListener(this.viewToModel(this.mousePoint), keyEvent, 2);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void setDocument(Document document) {
        super.setDocument(document);
        if (document instanceof ScilabDocument) {
            ((ScilabDocument)document).getUndoManager().discardAllEdits();
            this.initialize((ScilabDocument)document);
        }
    }

    @Override
    public void setName(String string) {
        this.setNameInSuper(string);
        this.setShortNameAndTitle(string);
        ScilabEditorPane scilabEditorPane = this.getOtherPaneInSplit();
        if (scilabEditorPane != null) {
            scilabEditorPane.setNameInSuper(string);
            scilabEditorPane.setShortNameAndTitle(string);
        }
    }

    private void setNameInSuper(String string) {
        super.setName(string);
    }

    private void setShortNameAndTitle(String string) {
        if (string != null) {
            File file = new File(string);
            this.setShortName(file.getName());
            this.title = this.shortName + " (" + file.getAbsolutePath() + ")" + TIRET + SciNotesMessages.SCILAB_EDITOR;
        }
    }

    public void setTitle(String string) {
        this.title = string + TIRET + SciNotesMessages.SCILAB_EDITOR;
    }

    public String getTitle() {
        return this.title;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void init(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScilabEditorPane.this.requestFocus();
                if (ScilabEditorPane.this.getCaret() != null) {
                    ScilabEditorPane.this.setCaretPosition(n);
                }
            }
        });
    }

    public void close() {
        FocusListener[] focusListenerArray = this.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            this.removeFocusListener(focusListenerArray[i]);
        }
        if (this.getCaret() instanceof SciNotesCaret) {
            ((SciNotesCaret)((Object)this.getCaret())).clean();
            super.setCaret(null);
            if (this.selectionTimer != null && this.selectionTimer.isRunning()) {
                this.selectionTimer.stop();
                this.selectionTimer = null;
            }
            if (this.matcherTimer != null && this.matcherTimer.isRunning()) {
                this.matcherTimer.stop();
                this.matcherTimer = null;
            }
        }
    }

    public void updateInfosWhenFocused() {
        ScilabDocument scilabDocument = (ScilabDocument)this.getDocument();
        scilabDocument.setFocused(true);
        SciNotes.setEditor(this.editor);
        focused = this;
        scilabDocument.getUndoManager().enableUndoRedoButtons();
        if (this.editor != null) {
            if (this.checkExternalModif() && this.lastExternalModification < this.getLastModification()) {
                this.editor.getInfoBar().setText(SciNotesMessages.EXTERNAL_MODIFICATION_INFO);
                if (ScilabModalDialog.show((SimpleTab)this.editor, (String)String.format(SciNotesMessages.ASK_TO_RELOAD, this.getShortName()), (String)SciNotesMessages.RELOAD, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.YES_OPTION) {
                    this.editor.reload(this.getEditor().getTabPane().indexOfComponent(this.getEditorComponent()));
                    this.editor.getTextPane().updateInfosWhenFocused();
                }
                this.lastExternalModification = this.getLastModification();
            } else {
                this.editor.getInfoBar().setText(this.getInfoBarText());
            }
        }
    }

    public boolean checkExternalModif() {
        String string = this.getName();
        if (string != null) {
            File file = new File(string);
            if (file != null && file.exists()) {
                return this.lastModified < file.lastModified();
            }
            return true;
        }
        return false;
    }

    public long getLastModification() {
        File file;
        String string = this.getName();
        if (string != null && (file = new File(string)) != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    public String getInfoBarText() {
        return this.infoBar;
    }

    public void setInfoBarText(String string) {
        this.infoBar = string;
        if (this.editor != null) {
            this.editor.getInfoBar().setText(this.getInfoBarText());
        }
    }

    public void setReadOnly(boolean bl) {
        this.readonly = bl;
        this.setEditable(!bl);
        this.setDragEnabled(!bl);
        this.infoBar = bl ? SciNotesMessages.READ_ONLY_MODE : "";
    }

    public void setBinary(boolean bl) {
        this.binary = bl;
        this.setEditable(!bl);
        this.setDragEnabled(!bl);
        if (bl) {
            this.infoBar = SciNotesMessages.BINARY_FILE_MODE;
            this.disableAll();
        } else {
            this.infoBar = "";
        }
    }

    public void copyProps(ScilabEditorPane scilabEditorPane) {
        scilabEditorPane.lastModified = this.lastModified;
        scilabEditorPane.highlightEnable = this.highlightEnable;
        scilabEditorPane.matchingKeywordsEnable = this.matchingKeywordsEnable;
        scilabEditorPane.matchingOpenersEnable = this.matchingOpenersEnable;
        scilabEditorPane.suppressCom = this.suppressCom;
        scilabEditorPane.setName(this.getName());
        scilabEditorPane.setShortName(this.getShortName());
        scilabEditorPane.setTitle(this.getTitle().substring(0, this.getTitle().lastIndexOf(TIRET)));
        scilabEditorPane.setEditable(this.isEditable());
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
        ScilabEditorPane scilabEditorPane = this.getOtherPaneInSplit();
        if (scilabEditorPane != null) {
            scilabEditorPane.lastModified = l;
        }
    }

    public SciNotesLineNumberPanel getXln() {
        return this.xln;
    }

    public SciNotes getEditor() {
        return this.editor;
    }

    public void setEditor(SciNotes sciNotes) {
        this.editor = sciNotes;
    }

    public void disableAll() {
        this.indent = null;
        this.tab = null;
        this.com = null;
        this.trailingWhite = null;
        this.editor = null;
        this.lexer = null;
        this.helpOnTyping = null;
        this.xln = null;
        this.rightTextPane = null;
        this.edComponent = null;
        this.enableMatchingKeywords(false);
        this.enableMatchingOpeners(false);
        if (this.matchLR != null) {
            this.matchLR.desactivateMouseOver();
            this.matchLR = null;
        }
        if (this.matchRL != null) {
            this.matchRL.desactivateMouseOver();
            this.matchRL = null;
        }
        this.kwListeners = null;
    }

    public void destroy() {
        this.close();
        this.disableAll();
    }

    public EditorComponent getEditorComponent() {
        return this.edComponent;
    }

    public void setEditorComponent(EditorComponent editorComponent) {
        this.edComponent = editorComponent;
    }

    public void setSplitPane(JSplitPane jSplitPane) {
        this.edComponent.setSplitPane(jSplitPane);
    }

    public JSplitPane getSplitPane() {
        return this.edComponent.getSplitPane();
    }

    public void updateTitle() {
        int n;
        if (this.editor != null && (n = this.editor.getTextPaneIndex(this)) != -1) {
            this.editor.updateTabTitle(n);
        }
    }

    public void setMustAdjustVisibility(boolean bl) {
        ((ScilabCaret)this.getCaret()).setMustAdjustVisibility(bl);
    }

    public boolean getMustAdjustVisibility() {
        return ((ScilabCaret)this.getCaret()).getMustAdjustVisibility();
    }

    public void scrollTextToPos(int n) {
        this.scrollTextToPos(n, true, false);
    }

    public void scrollTextToPos(final int n, final boolean bl, final boolean bl2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        ScilabEditorPane.this.setCaretPosition(n);
                    }
                    JScrollBar jScrollBar = ScilabEditorPane.this.getScrollPane().getVerticalScrollBar();
                    Rectangle rectangle = ScilabEditorPane.this.modelToView(n);
                    if (bl2) {
                        int n3 = jScrollBar.getValue();
                        int n2 = jScrollBar.getHeight();
                        if (rectangle.y < n3 || rectangle.y > n3 + n2) {
                            jScrollBar.setValue(Math.max(0, rectangle.y - n2 / 2));
                        }
                    } else {
                        if (rectangle.y > jScrollBar.getMaximum()) {
                            jScrollBar.setMaximum(rectangle.y);
                        }
                        jScrollBar.setValue(rectangle.y);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public void scrollTextToLineNumber(int n, boolean bl) {
        this.scrollTextToLineNumber(n, bl, true, false);
    }

    public void scrollTextToLineNumber(int n, final boolean bl, final boolean bl2, final boolean bl3) {
        Element element = this.getDocument().getDefaultRootElement();
        if (n >= 1 && n <= element.getElementCount()) {
            final int n2 = element.getElement(n - 1).getStartOffset();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScilabEditorPane.this.scrollTextToPos(n2, bl2, bl3);
                    if (bl) {
                        ScilabEditorPane.this.saveHighlightContourColor = ScilabEditorPane.this.highlightContourColor;
                        ScilabEditorPane.this.highlightContourColor = null;
                        ScilabEditorPane.this.saveHighlightColor = ScilabEditorPane.this.highlightColor;
                        ScilabEditorPane.this.highlightColor = Color.YELLOW;
                        ScilabEditorPane.this.saveHighlightEnable = ScilabEditorPane.this.highlightEnable;
                        ScilabEditorPane.this.hasBeenSaved = true;
                        ScilabEditorPane.this.enableHighlightedLine(false);
                        ScilabEditorPane.this.enableHighlightedLine(true);
                    }
                }
            });
        }
    }

    public void scrollTextToLineNumberInWhereami(int n, String string, boolean bl) {
        this.scrollTextToLineNumberInWhereami(n, string, bl, true, false);
    }

    public void scrollTextToLineNumberInWhereami(int n, String string, boolean bl, boolean bl2, boolean bl3) {
        if (string != null) {
            Element element = this.getDocument().getDefaultRootElement();
            int n2 = element.getElementCount();
            for (int i = 0; i < n2; ++i) {
                ScilabDocument.ScilabLeafElement scilabLeafElement = (ScilabDocument.ScilabLeafElement)element.getElement(i);
                if (!scilabLeafElement.getFunctionName().equals(string)) continue;
                n += i;
                break;
            }
        }
        this.scrollTextToLineNumber(n, bl, bl2, bl3);
    }

    public int getWhiteWidth() {
        View view = ((ScilabDocument)this.getDocument()).getView();
        if (view != null) {
            if (view instanceof ScilabView) {
                return ((ScilabView)view).getWhiteWidth();
            }
            return ((ScilabPlainView)view).getWhiteWidth();
        }
        return 0;
    }

    public void resetFont() {
        Font font = ((ScilabEditorKit)this.getEditorKit()).getStylePreferences().getBaseFont();
        this.setFont(font);
        this.xln.updateFont(font);
    }

    public void resetFont(String string, int n) {
        ((ScilabEditorKit)this.getEditorKit()).getStylePreferences().genFont(string, n);
    }

    public void resetAttribute(String string, int n) {
        ((ScilabEditorKit)this.getEditorKit()).getStylePreferences().genAttribute(string, n);
    }

    public void resetColor(String string, Color color) {
        ((ScilabEditorKit)this.getEditorKit()).getStylePreferences().genColors(string, color);
    }

    public void suppressCommentsInExecutingCode(boolean bl) {
        this.suppressCom = bl;
    }

    public String getCodeToExecute() {
        String string;
        block12: {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            if (((SciNotesCaret)((Object)this.getCaret())).isEmptySelection()) {
                try {
                    if (n == n2) {
                        string = this.getDocument().getText(0, n);
                        n = 0;
                        break block12;
                    }
                    string = this.getSelectedText();
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
            } else {
                string = this.getSelectedText();
            }
        }
        if (this.suppressCom) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            ScilabLexer.ScilabTokens scilabTokens = ScilabLexer.getScilabTokens(string);
            List<Integer> list = scilabTokens.getTokenType();
            List<Integer> list2 = scilabTokens.getTokenPos();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                String string2 = string.substring(n, list2.get(i));
                if ("\n".equals(string2)) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                } else if (!ScilabLexerConstants.isComment(list.get(i))) {
                    stringBuffer.append(string2);
                }
                n = list2.get(i);
            }
            if (stringBuffer.length() != 0) {
                arrayList.add(stringBuffer.toString());
            }
            stringBuffer.setLength(0);
            Pattern pattern = Pattern.compile("[ \t]*");
            for (String string3 : arrayList) {
                if (pattern.matcher(string3).matches()) continue;
                stringBuffer.append(string3).append("\n");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void addKeywordListener(KeywordListener keywordListener) {
        this.kwListeners.add(KeywordListener.class, keywordListener);
    }

    public void removeKeywordListener(KeywordListener keywordListener) {
        this.kwListeners.remove(KeywordListener.class, keywordListener);
    }

    public KeywordListener[] getKeywordListeners() {
        return (KeywordListener[])this.kwListeners.getListeners(KeywordListener.class);
    }

    public void setHighlightedLineColor(Color color) {
        this.highlightColor = color;
    }

    public void setHighlightedContourColor(Color color) {
        this.highlightContourColor = color;
    }

    public void activateHelpOnTyping() {
        boolean bl = HelpOnTypingManager.getInstance().isActive();
        if (bl && this.helpOnTyping == null) {
            this.helpOnTyping = HelpOnTypingManager.getInstance();
            this.addKeyListener(this.helpOnTyping);
        } else if (!bl && this.helpOnTyping != null) {
            this.removeKeyListener(this.helpOnTyping);
            this.helpOnTyping = null;
        }
    }

    public void enableHighlightedLine(boolean bl) {
        if (bl && !this.highlightEnable) {
            try {
                this.highlightCL = this.getHighlighter().addHighlight(0, 0, this);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.highlightEnable = true;
        }
        if (!bl && this.highlightEnable) {
            this.getHighlighter().removeHighlight(this.highlightCL);
            this.highlightEnable = false;
        }
        this.repaint();
    }

    public void enableMatchingKeywords(boolean bl) {
        this.matchingKeywordsEnable = bl;
    }

    public void enableMatchingOpeners(boolean bl) {
        this.matchingOpenersEnable = bl;
    }

    public MatchingBlockManager getMatchingBlockManager(boolean bl) {
        if (bl) {
            return this.matchLR;
        }
        return this.matchRL;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.hasBeenSaved) {
            this.removeHighlightForLine();
        }
        if (this.hasFocus()) {
            String string = this.getSelectedText();
            if (string != null && string.length() != 0) {
                if (this.selectionTimer == null) {
                    this.selectionTimer = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                String string = ScilabEditorPane.this.getSelectedText();
                                if (string != null && string.length() != 0) {
                                    int n = ScilabEditorPane.this.lexer.getKeyword(ScilabEditorPane.this.getSelectionStart(), false);
                                    int n2 = ((ScilabEditorPane)ScilabEditorPane.this).lexer.start + ScilabEditorPane.this.lexer.yychar();
                                    if (ScilabLexerConstants.isSearchable(n) && ScilabEditorPane.this.getSelectionStart() == n2 && ScilabEditorPane.this.getSelectionEnd() == n2 + ScilabEditorPane.this.lexer.yylength()) {
                                        ScilabEditorPane.this.highlightWords(n, SearchManager.generatePattern(string, false, true, false), false);
                                    } else {
                                        ScilabEditorPane.this.highlightWords(string, false);
                                    }
                                    if (ScilabEditorPane.this.highlightedWords.size() > 1 && ScilabEditorPane.this.editor != null && ScilabEditorPane.this.editor.getInfoBar() != null) {
                                        ScilabEditorPane.this.editor.getInfoBar().setText(String.format(SciNotesMessages.OCCURENCES_FOUND, Integer.toString(ScilabEditorPane.this.highlightedWords.size())));
                                    }
                                    ScilabEditorPane.this.removeHighlightOnPosition(ScilabEditorPane.this.getSelectionStart());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ScilabEditorPane.this.selectionTimer = null;
                        }
                    });
                    this.selectionTimer.setRepeats(false);
                    this.selectionTimer.start();
                } else {
                    this.selectionTimer.restart();
                }
            } else {
                this.removeHighlightedWords();
            }
        }
        if (this.highlightEnable) {
            this.repaint();
        }
        if (this.matchingKeywordsEnable || this.matchingOpenersEnable) {
            if (this.matcherTimer == null) {
                this.matcherTimer = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ScilabEditorPane.this.getCaretPosition();
                        int n2 = ScilabEditorPane.this.lexer.getKeyword(n, false);
                        ScilabEditorPane.this.matchLR.searchMatchingBlock(false, n2, ((ScilabEditorPane)ScilabEditorPane.this).lexer.start + ScilabEditorPane.this.lexer.yychar());
                        n2 = ScilabEditorPane.this.lexer.getKeyword(n, true);
                        ScilabEditorPane.this.matchRL.searchMatchingBlock(false, n2, ((ScilabEditorPane)ScilabEditorPane.this).lexer.start + ScilabEditorPane.this.lexer.yychar() + ScilabEditorPane.this.lexer.yylength());
                        ScilabEditorPane.this.matcherTimer = null;
                    }
                });
                this.matcherTimer.setRepeats(false);
                this.matcherTimer.start();
            } else {
                this.matcherTimer.restart();
                this.matchLR.update();
                this.matchRL.update();
            }
        }
        if (!this.readonly && !this.binary && this.editor != null) {
            this.editor.getInfoBar().setText(((ScilabDocument)this.getDocument()).getCurrentFunction(this.getCaretPosition()));
        }
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
        if (this.highlightEnable) {
            try {
                Rectangle rectangle = this.modelToView(this.getCaretPosition());
                if (this.highlightColor != null) {
                    graphics.setColor(this.highlightColor);
                    graphics.fillRect(0, rectangle.y, this.getWidth(), rectangle.height);
                }
                if (this.highlightContourColor != null) {
                    graphics.setColor(this.highlightContourColor);
                    graphics.drawLine(0, rectangle.y - 1, this.getWidth(), rectangle.y - 1);
                    graphics.drawLine(0, rectangle.y + rectangle.height, this.getWidth(), rectangle.y + rectangle.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public TrailingWhiteManager getTrailingWhiteManager() {
        return this.trailingWhite;
    }

    public IndentManager getIndentManager() {
        return this.indent;
    }

    public TabManager getTabManager() {
        return this.tab;
    }

    public CommentManager getCommentManager() {
        return this.com;
    }

    public KeywordEvent getKeywordEvent(int n) {
        int n2 = this.lexer.getKeyword(n, true);
        return new KeywordEvent(this, null, n2, this.lexer.start + this.lexer.yychar(), this.lexer.yylength());
    }

    public KeywordEvent getKeywordEvent() {
        return this.getKeywordEvent(this.getCaretPosition());
    }

    public KeywordEvent getKeywordEvent(boolean bl, boolean bl2) {
        int n = bl ? this.lexer.getKeyword(this.getCaretPosition(), bl2) : this.lexer.getKeyword(this.viewToModel(this.mousePoint), bl2);
        return new KeywordEvent(this, null, n, this.lexer.start + this.lexer.yychar(), this.lexer.yylength());
    }

    public String getHelpableKeyword(boolean bl) {
        int n = bl ? this.getCaretPosition() : this.viewToModel(this.mousePoint);
        int n2 = this.lexer.getKeyword(n, true);
        if (!ScilabLexerConstants.isHelpable(n2)) {
            n2 = this.lexer.getKeyword(n + 1, true);
        }
        if (ScilabLexerConstants.isHelpable(n2)) {
            try {
                return this.getDocument().getText(this.lexer.start + this.lexer.yychar(), this.lexer.yylength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void preventConcernedKeywordListener(int n, EventObject eventObject, int n2) {
        KeywordEvent keywordEvent = null;
        Object[] objectArray = this.kwListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != KeywordListener.class || n2 != ((KeywordListener)objectArray[i + 1]).getType()) continue;
            if (keywordEvent == null) {
                int n3 = this.lexer.getKeyword(n, true);
                keywordEvent = new KeywordEvent(this, eventObject, n3, this.lexer.start + this.lexer.yychar(), this.lexer.yylength());
            }
            ((KeywordListener)objectArray[i + 1]).caughtKeyword(keywordEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.preventConcernedKeywordListener(this.getCaretPosition(), mouseEvent, 1);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mousePoint = mouseEvent.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.hasBeenSaved) {
            this.removeHighlightForLine();
        }
        this.removeHighlightedWords();
        if (this.highlightEnable) {
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mousePoint = mouseEvent.getPoint();
        this.preventConcernedKeywordListener(this.viewToModel(this.mousePoint), mouseEvent, 2);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.hasBeenSaved) {
            this.removeHighlightForLine();
        }
        this.removeHighlightedWords();
        if (this.highlightEnable) {
            this.repaint();
        }
    }

    public Point getMousePoint() {
        return this.mousePoint;
    }

    public void setOtherPaneInSplit(ScilabEditorPane scilabEditorPane) {
        if (scilabEditorPane == null) {
            this.rightTextPane.rightTextPane = null;
        }
        this.rightTextPane = scilabEditorPane;
    }

    public ScilabEditorPane getOtherPaneInSplit() {
        return this.rightTextPane;
    }

    public ScilabEditorPane getCurrent() {
        if (focused == this.rightTextPane) {
            return this.rightTextPane;
        }
        return this;
    }

    public ScilabScrollPane getScrollPane() {
        return (ScilabScrollPane)SwingUtilities.getAncestorOfClass(ScilabScrollPane.class, this);
    }

    public static ScilabEditorPane getFocusedPane() {
        return focused;
    }

    public static void clean() {
        focused = null;
    }

    @Override
    public String toString() {
        return this.shortName;
    }

    public boolean copyColumnSelectionInClipBoard() {
        return ((SciNotesCaret)((Object)this.getCaret())).copyPositionsInClipboard();
    }

    public boolean removeColumnSelection() {
        return ((SciNotesCaret)((Object)this.getCaret())).removePositions();
    }

    @Override
    public String getSelectedText() {
        if (this.getCaret() instanceof SciNotesCaret) {
            String string = ((SciNotesCaret)((Object)this.getCaret())).getSelectedText();
            if (string == null) {
                return super.getSelectedText();
            }
            return string;
        }
        return null;
    }

    @Override
    public int getCaretPosition() {
        if (this.getCaret() != null) {
            return super.getCaretPosition();
        }
        return 0;
    }

    public int[] isNearColumnSelection(int n) {
        if (!(this.getCaret() instanceof SciNotesCaret) || ((SciNotesCaret)((Object)this.getCaret())).isEmptySelection()) {
            return null;
        }
        Element element = this.getDocument().getDefaultRootElement();
        int[][] nArray = ((SciNotesCaret)((Object)this.getCaret())).getSelectedPositions();
        int n2 = element.getElementIndex(n);
        int n3 = element.getElementIndex(nArray[0][0]);
        int n4 = element.getElementIndex(nArray[nArray.length - 1][0]);
        if (n2 >= n3 && n2 <= n4) {
            return nArray[n2 - n3];
        }
        return null;
    }

    @Override
    public void setCaret(Caret caret) {
        if (!(caret instanceof ScilabCaret)) {
            SciNotesCaret sciNotesCaret = new SciNotesCaret(this);
            this.setCaretColor(this.getCaretColor());
            SwingUtilities.invokeLater(new Runnable((Caret)((Object)sciNotesCaret)){
                final /* synthetic */ Caret val$caret;
                {
                    this.val$caret = caret;
                }

                @Override
                public void run() {
                    int n = 500;
                    Object object = UIManager.get("TextComponent.caretBlinkRate");
                    if (object != null && object instanceof Integer) {
                        Integer n2 = (Integer)object;
                        n = n2;
                    }
                    this.val$caret.setBlinkRate(n);
                    this.val$caret.setVisible(true);
                }
            });
            super.setCaret((Caret)((Object)sciNotesCaret));
        } else {
            super.setCaret(caret);
        }
    }

    @Override
    public void select(int n, int n2) {
        this.removeHighlightOnPosition(n);
        int n3 = this.getDocument().getLength();
        if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        super.setCaretPosition(n);
        super.moveCaretPosition(n2);
    }

    private void removeHighlightForLine() {
        this.highlightContourColor = this.saveHighlightContourColor;
        this.highlightColor = this.saveHighlightColor;
        this.enableHighlightedLine(false);
        if (this.saveHighlightEnable) {
            this.enableHighlightedLine(true);
        }
        this.hasBeenSaved = false;
    }

    public void removeHighlightOnPosition(int n) {
        Object object = this.highlightedWords.get(n);
        if (object != null) {
            this.getHighlighter().removeHighlight(object);
            this.highlightedWords.remove(object);
        }
    }

    public void highlightWords(String string, boolean bl) {
        if (string != null && string.length() != 0) {
            this.highlightWords(SearchManager.generatePattern(string, bl, false, false), false);
        }
    }

    public void highlightWords(Pattern pattern, boolean bl) {
        this.highlightWords(-1, pattern, bl);
    }

    public void highlightWords(int n, Pattern pattern, boolean bl) {
        if (pattern != null) {
            this.removeHighlightedWords();
            int n2 = -1;
            String string = ((ScilabDocument)this.getDocument()).getText();
            Matcher matcher = pattern.matcher(string);
            Highlighter highlighter = this.getHighlighter();
            List<Integer[]> list = SearchManager.findToken((ScilabDocument)this.getDocument(), n, this.lexer, pattern);
            if (list != null) {
                ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
                for (Integer[] integerArray : list) {
                    try {
                        this.highlightedWords.put(integerArray[0], highlighter.addHighlight(integerArray[0], integerArray[1], HIGHLIGHTER));
                        Rectangle rectangle = this.modelToView(integerArray[0]);
                        if (rectangle == null || arrayList.size() != 0 && ((Rectangle)arrayList.get((int)(arrayList.size() - 1))).y == rectangle.y) continue;
                        arrayList.add(rectangle);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ScilabScrollPane scilabScrollPane = this.getScrollPane();
                if (scilabScrollPane != null) {
                    scilabScrollPane.putMarks(arrayList);
                }
                if (bl && list.size() != 0) {
                    this.scrollTextToPos(list.get(0)[0], false, true);
                }
            }
        }
    }

    public void removeHighlightedWords() {
        Highlighter highlighter = this.getHighlighter();
        for (Object object : this.highlightedWords.values()) {
            highlighter.removeHighlight(object);
        }
        this.highlightedWords.clear();
        ScilabScrollPane scilabScrollPane = this.getScrollPane();
        if (scilabScrollPane != null) {
            scilabScrollPane.removeMarks();
        }
    }

    private void initialize(ScilabDocument scilabDocument) {
        NavigatorWindow navigatorWindow;
        this.indent = new IndentManager(scilabDocument);
        this.tab = new TabManager(scilabDocument, this.indent);
        this.tab.setDefaultTabulation();
        this.com = new CommentManager(scilabDocument);
        this.trailingWhite = new TrailingWhiteManager(scilabDocument);
        if (this.matchingKeywordsEnable || this.matchingOpenersEnable) {
            this.matchLR = new MatchingBlockManager(scilabDocument, this, true, this.getHighlighter());
            this.matchLR.setDefaults();
            this.matchRL = new MatchingBlockManager(scilabDocument, this, false, this.getHighlighter());
            this.matchRL.setDefaults();
        }
        this.lexer = scilabDocument.createLexer();
        this.xln = new SciNotesLineNumberPanel(this);
        scilabDocument.addDocumentListener(this.xln);
        scilabDocument.addDocumentListener(scilabDocument);
        this.getScrollPane().setRowHeaderView(this.xln);
        scilabDocument.setEditorPane(this);
        if (this.editor != null && (navigatorWindow = this.editor.getNavigator()) != null) {
            navigatorWindow.addEditorPane(this);
        }
        this.resetFont();
    }
}

