/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.View;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.scilab.modules.console.utils.ScilabLaTeXViewer;
import org.scilab.modules.scinotes.CompoundUndoManager;
import org.scilab.modules.scinotes.FunctionScanner;
import org.scilab.modules.scinotes.KeywordEvent;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexer;
import org.scilab.modules.scinotes.ScilabLexerConstants;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class ScilabDocument
extends PlainDocument
implements DocumentListener {
    private static final long serialVersionUID = -1227880612912063687L;
    public static final String EOLMAC = "\r";
    public static final String EOLWIN = "\r\n";
    public static final String EOLUNIX = "\n";
    private static final int GAPBUFFERCAPACITY = 2;
    private static final String LINE_SEPARATOR = "line.separator";
    private static final int INITFUNCTIONSNUMBER = 128;
    private View view;
    private List<String> saved = new Vector<String>();
    private FunctionScanner funScanner;
    private ScilabLexer lexerBlockComment;
    private Set<String> functions = new HashSet<String>(128);
    private boolean contentModified = false;
    private boolean contentModifiedSinceBackup;
    private boolean alphaOrder;
    private String encoding;
    private boolean updater = true;
    private boolean binary;
    private boolean autoIndent;
    private boolean shouldMergeEdits;
    private boolean undoManagerEnabled;
    private CompoundUndoManager undo;
    private ScilabEditorPane pane;
    private boolean focused;
    private String eolStyle;

    public ScilabDocument() {
        this(true);
    }

    public ScilabDocument(boolean bl) {
        super(new GapContent(2));
        this.lexerBlockComment = this.createLexer();
        if (bl) {
            this.setAsynchronousLoadPriority(2);
            this.autoIndent = SciNotesOptions.getSciNotesDisplay().automaticIndent;
            this.encoding = Charset.forName(SciNotesOptions.getSciNotesPreferences().encoding).toString();
            this.eolStyle = SciNotesOptions.getSciNotesPreferences().eol;
            this.undo = new CompoundUndoManager(this);
            this.addUndoableEditListener(this.undo);
            this.undoManagerEnabled = true;
            this.contentModifiedSinceBackup = false;
        }
    }

    public void setEditorPane(ScilabEditorPane scilabEditorPane) {
        this.pane = scilabEditorPane;
    }

    public ScilabEditorPane getEditorPane() {
        return this.pane;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    public ScilabLexer createLexer(boolean bl) {
        return new ScilabLexer(this, bl);
    }

    public ScilabLexer createLexer() {
        return new ScilabLexer(this, true);
    }

    public Set<String> getFunctionsInDoc() {
        return this.functions;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setBinary(boolean bl) {
        this.binary = bl;
    }

    public boolean getBinary() {
        return this.binary;
    }

    public void setEOL(String string) {
        this.eolStyle = string;
    }

    public String getEOL() {
        return this.eolStyle;
    }

    public String getDefaultEOL() {
        return System.getProperty(LINE_SEPARATOR);
    }

    public boolean isUpdater() {
        return this.updater;
    }

    public boolean getAutoIndent() {
        return this.autoIndent;
    }

    public void setAutoIndent(boolean bl) {
        this.autoIndent = bl;
    }

    public void setUpdater(boolean bl) {
        this.updater = bl;
    }

    public String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public void addEOL() {
        if (SciNotesOptions.getSciNotesPreferences().addLineTermination) {
            int n = this.getLength();
            if (this.getLength() >= 1) {
                try {
                    String string = this.getText(n - 1, 1);
                    if (!string.equals(EOLUNIX)) {
                        this.insertString(n, EOLUNIX, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            } else {
                try {
                    this.insertString(n, EOLUNIX, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            }
        }
    }

    public void mergeEditsBegin() {
        this.undo.endCompoundEdit();
        this.undo.startCompoundEdit();
    }

    public void mergeEditsEnd() {
        this.undo.endCompoundEdit();
    }

    public CompoundUndoManager getUndoManager() {
        return this.undo;
    }

    public void disableUndoManager() {
        if (this.undoManagerEnabled) {
            this.removeUndoableEditListener(this.undo);
            this.undoManagerEnabled = false;
        }
    }

    public void enableUndoManager() {
        if (!this.undoManagerEnabled) {
            this.addUndoableEditListener(this.undo);
            this.undoManagerEnabled = true;
        }
    }

    public boolean isContentModified() {
        return this.contentModified;
    }

    public boolean isContentModifiedSinceBackup() {
        return this.contentModifiedSinceBackup;
    }

    public void setContentModifiedSinceBackup(boolean bl) {
        this.contentModifiedSinceBackup = bl;
    }

    public void setContentModified(boolean bl) {
        this.contentModified = bl;
        if (this.pane != null && !bl) {
            this.undo.setReference();
            this.pane.updateTitle();
        } else {
            this.contentModifiedSinceBackup = true;
        }
    }

    public void dump() {
        this.readLock();
        try {
            Element element = this.getDefaultRootElement();
            for (int i = 0; i != element.getElementCount(); ++i) {
                Element element2 = element.getElement(i);
                int n = element2.getStartOffset();
                int n2 = element2.getEndOffset();
                System.err.println("line " + i + " from: " + n + " to: " + n2 + ":|" + this.getText(n, n2 - n) + "|");
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        this.readUnlock();
    }

    public int searchFunctionByName(String string) {
        Element element = this.getDefaultRootElement();
        for (int i = 0; i < element.getElementCount(); ++i) {
            ScilabLeafElement scilabLeafElement;
            Element element2 = element.getElement(i);
            if (!(element2 instanceof ScilabLeafElement) || !(scilabLeafElement = (ScilabLeafElement)element2).isFunction() || !scilabLeafElement.getFunctionInfo().functionName.equals(string)) continue;
            return element2.getStartOffset();
        }
        return -1;
    }

    public List<FunctionScanner.FunctionInfo> getFunctionInfo() {
        ArrayList<FunctionScanner.FunctionInfo> arrayList = new ArrayList<FunctionScanner.FunctionInfo>();
        Element element = this.getDefaultRootElement();
        for (int i = 0; i < element.getElementCount(); ++i) {
            ScilabLeafElement scilabLeafElement;
            Element element2 = element.getElement(i);
            if (!(element2 instanceof ScilabLeafElement) || !(scilabLeafElement = (ScilabLeafElement)element2).isFunction()) continue;
            arrayList.add(scilabLeafElement.getFunctionInfo());
        }
        return arrayList;
    }

    public void setAlphaOrderInTree(boolean bl) {
        this.alphaOrder = bl;
    }

    public synchronized void fillTreeFuns(DefaultMutableTreeNode defaultMutableTreeNode) {
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        if (!this.alphaOrder) {
            block10: for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                if (!(element2 instanceof ScilabLeafElement)) continue;
                int n2 = ((ScilabLeafElement)element2).getType();
                switch (n2) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(element2));
                        continue block10;
                    }
                    case 2: {
                        continue block10;
                    }
                }
            }
        } else {
            TreeSet<DefaultMutableTreeNode> treeSet = new TreeSet<DefaultMutableTreeNode>(new Comparator<DefaultMutableTreeNode>(){

                @Override
                public int compare(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
                    ScilabLeafElement scilabLeafElement = (ScilabLeafElement)defaultMutableTreeNode.getUserObject();
                    ScilabLeafElement scilabLeafElement2 = (ScilabLeafElement)defaultMutableTreeNode2.getUserObject();
                    int n = scilabLeafElement.getFunctionName().compareTo(scilabLeafElement2.getFunctionName());
                    if (n != 0) {
                        return n;
                    }
                    return scilabLeafElement.getStartOffset() - scilabLeafElement2.getStartOffset();
                }

                public boolean equals(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
                    return false;
                }
            });
            block11: for (int i = 0; i < n; ++i) {
                Element element3 = element.getElement(i);
                if (!(element3 instanceof ScilabLeafElement)) continue;
                int n3 = ((ScilabLeafElement)element3).getType();
                switch (n3) {
                    case 0: {
                        continue block11;
                    }
                    case 1: {
                        treeSet.add(new DefaultMutableTreeNode(element3));
                        continue block11;
                    }
                    case 2: {
                        continue block11;
                    }
                }
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                defaultMutableTreeNode.add((MutableTreeNode)iterator.next());
            }
        }
    }

    public synchronized void fillTreeAnchors(DefaultMutableTreeNode defaultMutableTreeNode) {
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        if (!this.alphaOrder) {
            for (int i = 0; i < n; ++i) {
                ScilabLeafElement scilabLeafElement = (ScilabLeafElement)element.getElement(i);
                if (!scilabLeafElement.isAnchor()) continue;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(scilabLeafElement));
            }
        } else {
            TreeSet<DefaultMutableTreeNode> treeSet = new TreeSet<DefaultMutableTreeNode>(new Comparator<DefaultMutableTreeNode>(){

                @Override
                public int compare(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
                    ScilabLeafElement scilabLeafElement = (ScilabLeafElement)defaultMutableTreeNode.getUserObject();
                    ScilabLeafElement scilabLeafElement2 = (ScilabLeafElement)defaultMutableTreeNode2.getUserObject();
                    int n = scilabLeafElement.getAnchorName().compareTo(scilabLeafElement2.getAnchorName());
                    if (n != 0) {
                        return n;
                    }
                    return scilabLeafElement.getStartOffset() - scilabLeafElement2.getStartOffset();
                }

                public boolean equals(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
                    return false;
                }
            });
            for (int i = 0; i < n; ++i) {
                ScilabLeafElement scilabLeafElement = (ScilabLeafElement)element.getElement(i);
                if (!scilabLeafElement.isAnchor()) continue;
                treeSet.add(new DefaultMutableTreeNode(scilabLeafElement));
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                defaultMutableTreeNode.add((MutableTreeNode)iterator.next());
            }
        }
    }

    public String getFirstFunctionName() {
        Element element = this.getDefaultRootElement();
        for (int i = 0; i < element.getElementCount(); ++i) {
            ScilabLeafElement scilabLeafElement;
            Element element2 = element.getElement(i);
            if (!(element2 instanceof ScilabLeafElement) || !(scilabLeafElement = (ScilabLeafElement)element2).isFunction()) continue;
            return scilabLeafElement.getFunctionInfo().functionName;
        }
        return null;
    }

    public int nextAnchorFrom(int n) {
        ScilabLeafElement scilabLeafElement;
        int n2;
        Element element = this.getDefaultRootElement();
        for (n2 = n + 1; n2 < element.getElementCount(); ++n2) {
            scilabLeafElement = (ScilabLeafElement)element.getElement(n2);
            if (!scilabLeafElement.isAnchor()) continue;
            return n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            scilabLeafElement = (ScilabLeafElement)element.getElement(n2);
            if (!scilabLeafElement.isAnchor()) continue;
            return n2;
        }
        return -1;
    }

    public int previousAnchorFrom(int n) {
        ScilabLeafElement scilabLeafElement;
        int n2;
        Element element = this.getDefaultRootElement();
        for (n2 = n - 1; n2 >= 0; --n2) {
            scilabLeafElement = (ScilabLeafElement)element.getElement(n2);
            if (!scilabLeafElement.isAnchor()) continue;
            return n2;
        }
        for (n2 = element.getElementCount() - 1; n2 > n; --n2) {
            scilabLeafElement = (ScilabLeafElement)element.getElement(n2);
            if (!scilabLeafElement.isAnchor()) continue;
            return n2;
        }
        return -1;
    }

    public List<Anchor> getAnchorsBetween(int n, int n2) {
        Element element = this.getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2);
        ArrayList<Anchor> arrayList = new ArrayList<Anchor>();
        for (int i = n3; i <= n4; ++i) {
            ScilabLeafElement scilabLeafElement = (ScilabLeafElement)element.getElement(i);
            if (!scilabLeafElement.isAnchor()) continue;
            arrayList.add(new Anchor(i, scilabLeafElement.getAnchorName()));
        }
        return arrayList;
    }

    public List<String>[] getInOutArgs(int n) {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        int n3 = 0;
        while (n2 != -1) {
            ScilabLeafElement scilabLeafElement = (ScilabLeafElement)element.getElement(n2--);
            switch (scilabLeafElement.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (n3 == 0) {
                        FunctionScanner.FunctionInfo functionInfo = scilabLeafElement.getFunctionInfo();
                        return new List[]{functionInfo.returnValues, functionInfo.argsValues};
                    }
                    ++n3;
                    break;
                }
                case 2: {
                    --n3;
                    break;
                }
            }
        }
        return null;
    }

    public String getCurrentFunction(int n) {
        int n2;
        Element element = this.getDefaultRootElement();
        int n3 = n2 = element.getElementIndex(n);
        int n4 = 0;
        while (n2 != -1) {
            ScilabLeafElement scilabLeafElement = (ScilabLeafElement)element.getElement(n2--);
            switch (scilabLeafElement.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (n4 == 0) {
                        String string = scilabLeafElement.getFunctionInfo().functionName;
                        if (string == null) {
                            string = SciNotesMessages.UNKNOWN_FUNCTION;
                        }
                        return String.format(SciNotesMessages.POSFUN_IN_DOC, n3 + 1, n - element.getElement(n3).getStartOffset(), string, n3 - n2);
                    }
                    ++n4;
                    break;
                }
                case 2: {
                    --n4;
                    break;
                }
            }
        }
        return String.format(SciNotesMessages.POS_IN_DOC, n3 + 1, n - element.getElement(n3).getStartOffset());
    }

    public void lock() {
        super.writeLock();
    }

    public void unlock() {
        super.writeUnlock();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleEvent(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleEvent(documentEvent);
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        super.insertUpdate(defaultDocumentEvent, null);
    }

    private void handleEvent(DocumentEvent documentEvent) {
        int n;
        Object object;
        if (!this.contentModified) {
            this.contentModified = true;
            if (this.pane != null) {
                this.pane.updateTitle();
            }
        }
        this.contentModifiedSinceBackup = true;
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(this.getDefaultRootElement());
        if (elementChange != null) {
            object = elementChange.getChildrenAdded();
            Element[] elementArray = elementChange.getChildrenRemoved();
            if (object != null && ((Object)object).length > 0 || elementArray != null && elementArray.length > 0) {
                String string;
                int n2;
                for (n2 = 0; n2 < elementArray.length; ++n2) {
                    string = ((ScilabLeafElement)elementArray[n2]).getFunctionName();
                    if (string == null || string.length() == 0) continue;
                    this.functions.remove(string);
                }
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    ((ScilabLeafElement)object[n2]).resetType();
                    ((ScilabLeafElement)object[n2]).resetTypeWhenBroken();
                    string = ((ScilabLeafElement)object[n2]).getFunctionName();
                    if (string == null || string.length() == 0) continue;
                    this.functions.add(string);
                }
            }
        } else {
            object = this.getDefaultRootElement();
            int n3 = object.getElementIndex(documentEvent.getOffset());
            ScilabLeafElement scilabLeafElement = (ScilabLeafElement)object.getElement(n3);
            boolean bl = scilabLeafElement.isBroken();
            n = scilabLeafElement.isBrokenString();
            boolean bl2 = scilabLeafElement.isBlockComment();
            if (scilabLeafElement.resetType() == 1 || n != scilabLeafElement.isBrokenString() || bl2 != scilabLeafElement.isBlockComment() || bl != scilabLeafElement.isBroken() || n3 > 0 && ((ScilabLeafElement)object.getElement(n3 - 1)).isBroken()) {
                this.pane.repaint();
            }
        }
        if (this.pane != null && ScilabLexerConstants.isLaTeX(((KeywordEvent)(object = this.pane.getKeywordEvent())).getType())) {
            try {
                int n4 = ((KeywordEvent)object).getStart();
                int n5 = n4 + ((KeywordEvent)object).getLength();
                String string = this.getText(n4, ((KeywordEvent)object).getLength());
                n = this.pane.getScrollPane().getHeight() + this.pane.getScrollPane().getVerticalScrollBar().getValue();
                ScilabLaTeXViewer.displayExpressionIfVisible((JTextComponent)this.pane, (int)n, (String)string, (int)n4, (int)n5);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.funScanner = new FunctionScanner(this);
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element element = this.createLeafElement(branchElement, null, 0, 1);
        branchElement.replace(0, 0, new Element[]{element});
        return branchElement;
    }

    @Override
    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new ScilabLeafElement(element, attributeSet, n, n2);
    }

    public class Anchor {
        private int line;
        private String name;

        public Anchor(int n, String string) {
            this.line = n;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public int getLine() {
            return this.line;
        }
    }

    public class ScilabLeafElement
    extends AbstractDocument.LeafElement {
        private static final long serialVersionUID = 4389590345677765643L;
        public static final int NOTHING = 0;
        public static final int FUN = 1;
        public static final int ENDFUN = 2;
        public static final int BROKEN = 4;
        private boolean visible;
        private int previousType;
        private int type;
        private FunctionScanner.FunctionInfo info;
        private boolean broken;
        private boolean brokenString;
        private boolean blockComment;
        private boolean anchor;
        private String anchorName;

        public ScilabLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(ScilabDocument.this, element, attributeSet, n, n2);
            this.visible = true;
            this.type = ScilabDocument.this.funScanner.getLineType(n, n2);
            if ((this.type & 4) == 4) {
                this.broken = true;
                this.type -= 4;
            }
            if (this.type == 1) {
                this.info = ScilabDocument.this.funScanner.getFunctionInfo();
            }
        }

        public int resetType() {
            String string = "";
            if (this.type == 1) {
                string = this.info.functionName;
            }
            this.previousType = this.type;
            this.type = ScilabDocument.this.funScanner.getLineType(this.getStartOffset(), this.getEndOffset());
            if ((this.type & 4) == 4) {
                this.broken = true;
                this.type -= 4;
            } else {
                this.broken = false;
            }
            this.broken = ScilabDocument.this.lexerBlockComment.isLineFinishedByBlockComment(this.getStartOffset(), this.getEndOffset());
            if (this.type == 1) {
                this.info = ScilabDocument.this.funScanner.getFunctionInfo();
                if (this.info.functionName != null) {
                    if (!this.info.functionName.equals(string)) {
                        ScilabDocument.this.functions.remove(string);
                        ScilabDocument.this.functions.add(this.info.functionName);
                    }
                } else {
                    ScilabDocument.this.functions.remove(string);
                }
            }
            this.resetTypeWhenBroken();
            return this.type;
        }

        public boolean needLineNumberRepaint() {
            return this.type == 1 || this.type == 2 || this.type != this.previousType;
        }

        public void resetTypeWhenBroken() {
            int n = this.getStartOffset();
            if (n != 0) {
                Element element = this.getParentElement();
                ScilabLeafElement scilabLeafElement = (ScilabLeafElement)element.getElement(element.getElementIndex(n - 1));
                if (scilabLeafElement.broken) {
                    scilabLeafElement.resetType();
                }
            }
        }

        public int getType() {
            return this.type;
        }

        public FunctionScanner.FunctionInfo getFunctionInfo() {
            return this.info;
        }

        public boolean isFunction() {
            return this.type == 1;
        }

        public boolean isEndfunction() {
            return this.type == 2;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public void setBroken(boolean bl) {
            this.broken = bl;
        }

        public boolean isBrokenString() {
            return this.brokenString;
        }

        public void setBrokenString(boolean bl) {
            this.brokenString = bl;
            if (bl) {
                this.broken = true;
            }
        }

        public boolean isBlockComment() {
            return this.blockComment;
        }

        public void setBlockComment(boolean bl) {
            this.blockComment = bl;
            if (bl) {
                this.broken = true;
            }
        }

        public String getFunctionName() {
            if (this.type == 1) {
                return this.info.functionName;
            }
            return "";
        }

        public boolean isAnchor() {
            return this.anchor;
        }

        public void setAnchor(String string) {
            if (string == null) {
                this.anchor = false;
                return;
            }
            this.anchor = true;
            this.anchorName = string;
        }

        public String getAnchorName() {
            if (this.anchor) {
                return this.anchorName;
            }
            return "";
        }

        @Override
        public String toString() {
            if (this.anchor) {
                if (this.type == 1) {
                    return "function: " + this.info.functionName + " & anchor: " + this.anchorName;
                }
                return this.anchorName;
            }
            return this.info.functionName;
        }
    }
}

